/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.infrastructure;

import cn.com.pg.paas.monitor.infrastructure.ApiHealthMetric;
import cn.com.pg.paas.monitor.infrastructure.LoggerUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthEndpoint;

public class ApiHealthUtil {
    @Autowired
    private HealthEndpoint healthEndpoint;
    @Autowired
    private ApiHealthMetric apiMetric;
    @Autowired
    private LoggerUtil loggerUtil;

    public HashMap<String, Object> getApiHealth() throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Health health = this.healthEndpoint.health();
        Set<String> unhealthyAgg = this.apiMetric.attentionAggHealth(health);
        List<String> attentionUnHealthItems = this.apiMetric.appStatus(unhealthyAgg);
        map.put("status", attentionUnHealthItems.size() == 0 ? 200 : 500);
        this.loggerUtil.debug(ApiHealthUtil.class, health.getStatus());
        map.put("result", this.apiMetric.myEndpoint(unhealthyAgg));
        return map;
    }
}

