/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.infrastructure;

import cn.com.pg.paas.monitor.domain.properties.StreamApiProperties;
import cn.com.pg.paas.monitor.infrastructure.JsonUtil;
import cn.com.pg.paas.monitor.infrastructure.LoggerUtil;
import cn.com.pg.paas.monitor.infrastructure.SignUtil;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HttpUtil {
    @Autowired
    private StreamApiProperties streamApiProperties;
    @Autowired
    private SignUtil signUtil;
    @Autowired
    private LoggerUtil loggerUtil;
    @Autowired
    private JsonUtil jsonUtil;

    public String restPost(String url, Object params) {
        String result = "";
        String subscriptionKey = this.streamApiProperties.getSubscriptionKey();
        Map<String, Object> header = this.signUtil.createParam();
        header.put("body", this.jsonUtil.toJson(params));
        try {
            header.put("sign", this.signUtil.sign(header));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            this.loggerUtil.error(HttpUtil.class, e);
        }
        header.remove("body");
        String jsonObj = this.jsonUtil.toJson(params);
        HttpResponse response = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/json;");
        headers.put("Ocp-Apim-Subscription-Key", subscriptionKey);
        try {
            response = Unirest.post((String)url.toString()).headers(headers).queryString(header).body(jsonObj).asString();
        }
        catch (UnirestException e) {
            this.loggerUtil.error(HttpUtil.class, (Object)e);
            return "restPost error";
        }
        Object body = response.getBody();
        return body.toString();
    }
}

