/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.infrastructure;

import cn.com.pg.paas.monitor.SysOperationLog;
import cn.com.pg.paas.monitor.domain.entity.ApiLogExtend;
import cn.com.pg.paas.monitor.domain.entity.ApiLogObject;
import cn.com.pg.paas.monitor.domain.enums.MonitorType;
import cn.com.pg.paas.monitor.domain.services.ICustomApiMetric;
import cn.com.pg.paas.monitor.infrastructure.JsonUtil;
import cn.com.pg.paas.monitor.infrastructure.LoggerUtil;
import cn.com.pg.paas.monitor.infrastructure.ServiceInfoUtil;
import cn.com.pg.paas.monitor.infrastructure.StreamingUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class LogPoint {
    @Autowired
    private LoggerUtil loggerUtil;
    @Autowired
    private JsonUtil jsonUtil;
    @Autowired
    private ServiceInfoUtil serviceInfoUtil;
    @Autowired
    private ICustomApiMetric customApiMetric;
    @Autowired
    private StreamingUtil streamingUtil;
    @Value(value="${spring.application.name}")
    private String applicationName;

    @Pointcut(value="@annotation(cn.com.pg.paas.monitor.SysOperationLog)")
    public void controllerAspect() {
    }

    public ApiLogObject getMethodInfo(JoinPoint joinPoint) throws Exception {
        ApiLogObject object = new ApiLogObject();
        object.setApp_name(this.applicationName);
        HashMap<String, Object> dimension = new HashMap<String, Object>();
        object.setHost(this.serviceInfoUtil.getIpAdress() + ":" + this.serviceInfoUtil.getPort());
        String targetName = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] args = joinPoint.getArgs();
        Class<?> targetClass = Class.forName(targetName);
        Method[] methods = targetClass.getMethods();
        object.setApi_name(methodName);
        for (Method method : methods) {
            Class<?>[] classes;
            if (!method.getName().equals(methodName) || (classes = method.getParameterTypes()).length != args.length) continue;
            dimension.put("desc", method.getAnnotation(SysOperationLog.class).desc());
            break;
        }
        dimension.put("monitorType", (Object)MonitorType.API_METRIC);
        object.setDimension(dimension);
        return object;
    }

    @Around(value="controllerAspect()")
    public Object controlllerFilter(ProceedingJoinPoint point) throws Throwable {
        ApiLogObject object = new ApiLogObject();
        HttpServletRequest request = null;
        Object result = null;
        object = this.getMethodInfo((JoinPoint)point);
        object.setError_code(0);
        object.setCall_time(System.currentTimeMillis());
        try {
            result = point.proceed();
        }
        catch (Exception ex) {
            object.setError_code(-1);
            throw ex;
        }
        finally {
            long endTime = System.currentTimeMillis();
            object.setResponse_time(endTime - object.getCall_time());
            Map<String, Object> dimension = object.getDimension();
            if (RequestContextHolder.getRequestAttributes() != null) {
                request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                object.setApi_name(request.getRequestURI());
            }
            object.setDimension(dimension);
            ApiLogExtend extend = this.customApiMetric.getCustomMetric(this.jsonUtil.toJson(result), request, null, null, null);
            try {
                this.loggerUtil.debug(LogPoint.class, object);
                this.streamingUtil.sendEventhub(object);
            }
            catch (Exception e) {
                this.loggerUtil.error(LogPoint.class, e);
            }
        }
        return result;
    }
}

