/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.infrastructure;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ServiceInfoUtil {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInfoUtil.class);
    @Value(value="${spring.application.name}")
    private String appName;
    @Value(value="${HOSTNAME:UNKOWN}")
    private String podName;
    @Value(value="${platform:UNKOWN}")
    private String platform;

    public int getPort() {
        return 8080;
    }

    public String getIpAdress() {
        String ip = "";
        try {
            InetAddress address = InetAddress.getLocalHost();
            ip = address.getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return ip;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getPodName() {
        return this.podName;
    }

    public void setPodName(String podName) {
        this.podName = podName;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String toString() {
        return "ServiceInfoUtil{appName='" + this.appName + '\'' + ", podName='" + this.podName + '\'' + ", platform='" + this.platform + '\'' + '}';
    }
}

