/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.infrastructure;

import cn.com.pg.paas.monitor.domain.properties.StreamApiProperties;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SignUtil {
    @Autowired
    private StreamApiProperties streamApiProperties;

    private String getTimestamp() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(currentTime);
    }

    public Map<String, Object> createParam() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("timestamp", this.getTimestamp());
        params.put("api_key", this.streamApiProperties.getApiKey());
        params.put("nonce_str", UUID.randomUUID().toString());
        return params;
    }

    public String sign(Map<String, Object> params) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String exampleSecret = this.streamApiProperties.getSecret();
        ArrayList<String> paramList = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            paramList.add(entry.getKey() + "=" + entry.getValue());
        }
        Collections.sort(paramList);
        StringBuilder sb = new StringBuilder();
        sb.append(exampleSecret);
        for (String paramStr : paramList) {
            sb.append(paramStr);
            sb.append("&");
        }
        sb.replace(sb.length() - 1, sb.length(), exampleSecret);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] bytes = messageDigest.digest(sb.toString().getBytes("UTF-8"));
        return Hex.encodeHexString((byte[])bytes).toUpperCase();
    }
}

