/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.infrastructure;

import cn.com.pg.paas.monitor.domain.entity.ApiLogObject;
import cn.com.pg.paas.monitor.domain.enums.SendType;
import cn.com.pg.paas.monitor.domain.properties.StreamApiProperties;
import cn.com.pg.paas.monitor.infrastructure.HttpUtil;
import cn.com.pg.paas.monitor.infrastructure.JsonUtil;
import cn.com.pg.paas.monitor.infrastructure.LoggerUtil;
import cn.com.pg.paas.stream.framework.StreamTemplate;
import java.util.HashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.annotation.Async;

public class StreamingUtil
implements ApplicationContextAware {
    @Value(value="${spring.application.name}")
    private String applicationName;
    private ApplicationContext applicationContext = null;
    @Value(value="${monitor.eventhub-type:STREAM_API}")
    private String eventhubType;
    @Value(value="${monitor.open:true}")
    private boolean isOpen;
    @Autowired
    private StreamApiProperties streamApiProperties;
    @Autowired
    private LoggerUtil loggerUtil;
    @Autowired
    private JsonUtil jsonUtil;
    @Autowired
    private HttpUtil httpUtil;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.applicationContext == null) {
            this.applicationContext = applicationContext;
        }
    }

    public void setOpen(boolean open) {
        this.isOpen = open;
    }

    public String getEventhubType() {
        return this.eventhubType;
    }

    public void setEventhubType(String eventhubType) {
        this.eventhubType = eventhubType;
    }

    @Async(value="sendEventHubExecutor")
    public String sendEventhub(ApiLogObject object) {
        if (!this.isOpen) {
            String msg = "API Metric Send Event isOpen Is" + this.isOpen + "!";
            return msg;
        }
        SendType sendType = SendType.valueOf(this.eventhubType);
        this.loggerUtil.debug(StreamingUtil.class, "pre sendEventhub");
        String result = null;
        boolean issuccess = false;
        StringBuilder url = new StringBuilder();
        try {
            this.streamApiProperties.setEventTypeId(this.streamApiProperties.getApiMetricEventTypeId());
            url.append(this.streamApiProperties.getUrl()).append(this.streamApiProperties.getEventTypeId());
            if (sendType == SendType.STREAM_API) {
                result = this.httpUtil.restPost(url.toString(), object) + " STREAM_API EventTypeId:%s " + this.streamApiProperties.getEventTypeId();
            } else if (sendType == SendType.STREAM_SDK) {
                StreamTemplate streamTemplate = (StreamTemplate)this.applicationContext.getBean(StreamTemplate.class);
                issuccess = streamTemplate.send(this.streamApiProperties.getEventTypeId(), (Object)this.jsonUtil.toJson(object));
                result = String.format("{\u2018result\u2019: '%s',\u2018message\u2019: \u2018EventTypeId:%s send STREAM_SDK %s \u2019}", issuccess, this.streamApiProperties.getEventTypeId(), issuccess);
            }
            this.loggerUtil.debug(StreamingUtil.class, String.format("after sendEventhub API Metric Execution result\uff1a%s\uff0cExecution parameters\uff1a%s", result, this.jsonUtil.toJson(object)));
        }
        catch (Exception ex) {
            this.loggerUtil.error(StreamingUtil.class, ex);
        }
        return result;
    }

    @Async(value="sendEventHubExecutor")
    public String sendKpiEventhub(HashMap<String, Object> dimension) {
        String result = null;
        String appName = "app_name";
        StringBuilder url = new StringBuilder();
        try {
            if (!this.isOpen) {
                String msg = "KPI Metric Send Event isOpen Is" + this.isOpen + "!";
                return msg;
            }
            SendType sendType = SendType.valueOf(this.eventhubType);
            if (!dimension.containsKey(appName)) {
                dimension.put("app_name", this.applicationName);
            }
            this.loggerUtil.debug(StreamingUtil.class, " pre sendEventhub ");
            this.streamApiProperties.setEventTypeId(this.streamApiProperties.getKpiMetricEventTypeId());
            url.append(this.streamApiProperties.getUrl()).append(this.streamApiProperties.getEventTypeId());
            if (sendType == SendType.STREAM_API) {
                result = this.httpUtil.restPost(url.toString(), dimension) + " STREAM_API EventTypeId:%s " + this.streamApiProperties.getEventTypeId();
            } else if (sendType == SendType.STREAM_SDK) {
                StreamTemplate streamTemplate = (StreamTemplate)this.applicationContext.getBean(StreamTemplate.class);
                boolean issuccess = streamTemplate.send(this.streamApiProperties.getEventTypeId(), (Object)this.jsonUtil.toJson(dimension));
                result = String.format("{\u2018result\u2019: '%s',\u2018message\u2019: \u2018EventTypeId:%s send STREAM_SDK %s \u2019}", issuccess, this.streamApiProperties.getEventTypeId(), issuccess);
            }
            this.loggerUtil.debug(StreamingUtil.class, String.format("after sendEventhub KPI Metric Execution result\uff1a%s\uff0cExecution parameters\uff1a%s", result, this.jsonUtil.toJson(dimension)));
        }
        catch (Exception ex) {
            this.loggerUtil.error(StreamingUtil.class, ex);
        }
        return result;
    }
}

