/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.infrastructure.monitor;

import cn.com.pg.paas.monitor.domain.entity.ApiLogExtend;
import cn.com.pg.paas.monitor.domain.entity.ApiLogObject;
import cn.com.pg.paas.monitor.domain.enums.MonitorType;
import cn.com.pg.paas.monitor.domain.services.ICustomApiMetric;
import cn.com.pg.paas.monitor.infrastructure.ServiceInfoUtil;
import cn.com.pg.paas.monitor.infrastructure.StreamingUtil;
import cn.com.pg.paas.monitor.infrastructure.monitor.HttpServletResponseCopier;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

public class ApiMetricFilter
extends OncePerRequestFilter
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(ApiMetricFilter.class);
    @Autowired
    private StreamingUtil streamingUtil;
    @Autowired
    private ServiceInfoUtil serviceInfoUtil;
    @Autowired
    private ICustomApiMetric customApiMetric;
    private int order = Integer.MAX_VALUE;

    public int getOrder() {
        return this.order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        long beginTime = System.currentTimeMillis();
        if (response.getCharacterEncoding() == null) {
            response.setCharacterEncoding("UTF-8");
        }
        try {
            if (this.customApiMetric.getClass().getTypeName().equals("cn.com.pg.paas.monitor.infrastructure.CustomMetric")) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                response = new HttpServletResponseCopier((HttpServletResponse)response);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        finally {
            this.getApiMetric(request, (HttpServletResponse)response, beginTime);
        }
    }

    private void getApiMetric(HttpServletRequest request, HttpServletResponse response, long beginTime) {
        String apiKey;
        String xff;
        String responseBody = "";
        long endTime = System.currentTimeMillis();
        long interval = endTime - beginTime;
        ApiLogObject apiLogObject = new ApiLogObject();
        apiLogObject.setCall_time(beginTime);
        apiLogObject.setApp_name(this.serviceInfoUtil.getAppName());
        apiLogObject.setApi_name(request.getRequestURI());
        apiLogObject.setApi_name_with_method(request.getMethod().toUpperCase() + " " + request.getRequestURI());
        apiLogObject.setResponse_time(interval);
        apiLogObject.setHttp_status_code(response.getStatus());
        apiLogObject.setPod_name(this.serviceInfoUtil.getPodName());
        apiLogObject.setPlatform(this.serviceInfoUtil.getPlatform());
        apiLogObject.setHttp_method(request.getMethod().toUpperCase());
        apiLogObject.setQuery_string(request.getQueryString());
        String userAgent = request.getHeader("user-agent");
        if (StringUtils.isNotBlank((CharSequence)userAgent)) {
            apiLogObject.setUser_agent(userAgent);
        }
        if (StringUtils.isNotBlank((CharSequence)(xff = request.getHeader("x-forwarded-for")))) {
            apiLogObject.setX_forwarded_for(xff);
        }
        if (StringUtils.isNotBlank((CharSequence)(apiKey = request.getParameter("api_key")))) {
            apiLogObject.setApi_key(apiKey);
        } else {
            String apiKeyInHeader = request.getHeader("apiKey");
            if (StringUtils.isNotBlank((CharSequence)apiKeyInHeader)) {
                apiLogObject.setApi_key(apiKeyInHeader);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        apiLogObject.setHost(this.serviceInfoUtil.getIpAdress() + ":" + this.serviceInfoUtil.getPort());
        if (response instanceof HttpServletResponseCopier) {
            HttpServletResponseCopier copier = (HttpServletResponseCopier)response;
            responseBody = new String(copier.getCopy());
        }
        if (StringUtils.isNotBlank((CharSequence)responseBody)) {
            try {
                ApiLogExtend apiLogExtend = this.customApiMetric.getCustomMetric(responseBody, request, response, null, null);
                if (apiLogExtend != null) {
                    if (apiLogExtend.getError_code() != -1) {
                        apiLogObject.setError_code(apiLogExtend.getError_code());
                    }
                    if (apiLogExtend.getDimension() != null) {
                        map.putAll(apiLogExtend.getDimension());
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        map.put("monitorType", (Object)MonitorType.API_METRIC);
        apiLogObject.setDimension(map);
        this.streamingUtil.sendEventhub(apiLogObject);
    }
}

