/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.appmanage.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.am.domain.AmAppapiDomain;
import com.qjsoft.laser.controller.facade.am.domain.AmAppapiReDomain;
import com.qjsoft.laser.controller.facade.am.repository.AppapiServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/appapi"})
public class AppapiCon
extends SpringmvcController {
    private static String CODE = "am.appapi.con";
    @Autowired
    private AppapiServiceRepository appapiServiceRepository;

    protected String getContext() {
        return "appapi";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmAppapiDomain amAppapi) {
        if (null == amAppapi) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appapiServiceRepository.saveAppapi(amAppapi);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String appapiId, ModelMap modelMap) {
        modelMap.put((Object)"appapiReBean", (Object)this.getAppapi(appapiId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmAppapiDomain amAppapi) {
        if (null == amAppapi) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appapiServiceRepository.updateAppapi(amAppapi);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String appapiId) {
        if (StringUtils.isBlank((String)appapiId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appapiServiceRepository.deleteAppapi(Integer.valueOf(appapiId));
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, String appapiId, String dataState, String oldDataState) {
        if (StringUtils.isBlank((String)appapiId) || StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appapiServiceRepository.updateAppapiState(Integer.valueOf(appapiId), Integer.valueOf(dataState), Integer.valueOf(oldDataState));
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String appapiId, ModelMap modelMap) {
        modelMap.put((Object)"appapiReBean", (Object)this.getAppapi(appapiId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getAppapi(String appapiId) {
        String rs = "{}";
        if (StringUtils.isBlank((String)appapiId)) {
            this.logger.error(CODE + ".getAppapi", (Object)"appapiId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.appapiServiceRepository.getAppapi(Integer.valueOf(appapiId)));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public SupQueryResult<AmAppapiReDomain> listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.appapiServiceRepository.queryAppapiPage(param);
    }

    @RequestMapping(value={"getApiAll.json"})
    @ResponseBody
    public AmAppapiReDomain listQueryAll(HttpServletRequest request, String appapiId) {
        if (StringUtils.isBlank((String)appapiId)) {
            this.logger.error(CODE + ".getAppapi", (Object)"appapiId is null");
        }
        return this.appapiServiceRepository.getAppapiAll(Integer.valueOf(appapiId));
    }

    @RequestMapping(value={"generateSdk"})
    @ResponseBody
    public HtmlJsonReBean generateSdk(HttpServletRequest request, String appapicodes) {
        String str = "";
        return new HtmlJsonReBean((Object)str);
    }

    @RequestMapping(value={"preciseQuery.json"})
    @ResponseBody
    public SupQueryResult<AmAppapiReDomain> preciseQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        return this.appapiServiceRepository.queryAppapiPage(param);
    }
}

