/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.appmanage.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.am.domain.AmDataparamDomain;
import com.qjsoft.laser.controller.facade.am.repository.DataparamServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/dataparam"})
public class DataparamCon
extends SpringmvcController {
    private static String CODE = "am.dataparam.con";
    @Autowired
    private DataparamServiceRepository dataparamServiceRepository;

    protected String getContext() {
        return "dataparam";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmDataparamDomain amDataparamDomain) {
        if (null == amDataparamDomain) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.dataparamServiceRepository.saveDataparam(amDataparamDomain);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, Integer dataparamId, ModelMap modelMap) {
        modelMap.put((Object)"dataparamReBean", (Object)this.getDataparam(dataparamId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmDataparamDomain amDataparamDomain) {
        if (null == amDataparamDomain) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.dataparamServiceRepository.updateDataparam(amDataparamDomain);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, Integer dataparamId) {
        if (StringUtils.isBlank((Integer)dataparamId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.dataparamServiceRepository.deleteDataparam(dataparamId);
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, Integer dataparamId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)dataparamId) || StringUtils.isBlank((Integer)dataState) || StringUtils.isBlank((Integer)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.dataparamServiceRepository.updateDataparamState(dataparamId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, Integer dataparamId, ModelMap modelMap) {
        modelMap.put((Object)"dataparamReBean", (Object)this.getDataparam(dataparamId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getDataparam(Integer dataparamId) {
        String rs = "{}";
        if (StringUtils.isBlank((Integer)dataparamId)) {
            this.logger.error(CODE + ".getDataparam", (Object)"dataparamId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.dataparamServiceRepository.getDataparam(dataparamId));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.dataparamServiceRepository.queryDataparamPage(param);
    }
}

