/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.appmanage.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.am.domain.AmPerrorDomain;
import com.qjsoft.laser.controller.facade.am.domain.AmPerrorReDomain;
import com.qjsoft.laser.controller.facade.am.repository.PinfoServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/perror"})
public class PerrorCon
extends SpringmvcController {
    private static String CODE = "am.perror.con";
    @Autowired
    private PinfoServiceRepository pinfoServiceRepository;

    protected String getContext() {
        return "perror";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmPerrorDomain amPerrorDomain) {
        if (null == amPerrorDomain) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pinfoServiceRepository.savePerror(amPerrorDomain);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String errorId, ModelMap modelMap) {
        modelMap.put((Object)"perrorReBean", (Object)this.getPerror(errorId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmPerrorDomain amPerrorDomain) {
        if (null == amPerrorDomain) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pinfoServiceRepository.updatePerror(amPerrorDomain);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, Integer errorId) {
        if (StringUtils.isBlank((Integer)errorId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pinfoServiceRepository.deletePerror(errorId);
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, Integer errorId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)errorId) || StringUtils.isBlank((Integer)dataState) || StringUtils.isBlank((Integer)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pinfoServiceRepository.updatePerrorState(errorId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String errorId, ModelMap modelMap) {
        modelMap.put((Object)"perrorReBean", (Object)this.getPerror(errorId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getPerror(String errorId) {
        String rs = "{}";
        if (StringUtils.isBlank((String)errorId)) {
            this.logger.error(CODE + ".getPerror", (Object)"errorId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)errorId);
        }
        return rs;
    }

    @RequestMapping(value={"getPerror.json"})
    @ResponseBody
    public AmPerrorReDomain getPerrorFor(Integer errorId) {
        if (StringUtils.isBlank((Integer)errorId)) {
            this.logger.error(CODE + ".getPerrorFor", (Object)"param is null");
            return null;
        }
        return this.pinfoServiceRepository.getPerror(errorId);
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pinfoServiceRepository.queryPerrorPage(param);
    }

    @RequestMapping(value={"queryPerrorLoadCache.json"}, name="Perror\u52a0\u8f7dCACHE")
    @ResponseBody
    public HtmlJsonReBean queryPerrorLoadCache() {
        return this.pinfoServiceRepository.queryPinfoLoadCache();
    }
}

