/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.at.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionEnrollDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionEnrollReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionReDomain;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionEnrollServiceRepository;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionServiceRepository;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionUserginfoServiceRepository;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctiondtServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/at/auctionEnroll"}, name="\u7ade\u4ef7\u62a5\u540d")
public class AuctionEnrollCon
extends SpringmvcController {
    private static String CODE = "at.auctionEnroll.con";
    @Autowired
    private AtAuctionEnrollServiceRepository atAuctionEnrollServiceRepository;
    @Autowired
    private AtAuctiondtServiceRepository atAuctiondtServiceRepository;
    @Autowired
    private AtAuctionServiceRepository atAuctionServiceRepository;
    @Autowired
    private AtAuctionUserginfoServiceRepository atAuctionUserginfoServiceRepository;

    protected String getContext() {
        return "auctionEnroll";
    }

    @RequestMapping(value={"saveAuctionEnroll.json"}, name="\u589e\u52a0\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean saveAuctionEnroll(HttpServletRequest request, AtAuctionEnrollDomain atAuctionEnrollDomain) {
        if (null == atAuctionEnrollDomain) {
            this.logger.error(CODE + ".saveAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean("error", "session is null");
        }
        String tenantCode = userSession.getTenantCode();
        String memberBcode = userSession.getUserPcode();
        String memberBname = userSession.getUserRelname();
        String auctionCode = atAuctionEnrollDomain.getAuctionCode();
        if (StringUtils.isEmpty((String)auctionCode)) {
            return new HtmlJsonReBean("error", "auctionCode is null");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(tenantCode, auctionCode);
        if (null == atAuctionReDomain) {
            return new HtmlJsonReBean("error", "auction is null");
        }
        Date date = new Date();
        Date auctionADate = atAuctionReDomain.getAuctionAdate();
        Date auctionAGDate = atAuctionReDomain.getAuctionAgdate();
        if ("0".equals(atAuctionEnrollDomain.getAuctionEnrollType())) {
            if (date.compareTo(auctionAGDate) > 0) {
                return new HtmlJsonReBean("error", "\u770b\u8d27\u65f6\u95f4\u5df2\u622a\u6b62");
            }
        } else if (date.compareTo(auctionADate) > 0) {
            return new HtmlJsonReBean("error", "\u7ade\u4ef7\u65f6\u95f4\u5df2\u622a\u6b62");
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)atAuctionEnrollDomain, (Object)atAuctionReDomain);
        }
        catch (Exception e) {
            // empty catch block
        }
        atAuctionEnrollDomain.setTenantCode(tenantCode);
        atAuctionEnrollDomain.setMemberBcode(memberBcode);
        atAuctionEnrollDomain.setMemberBname(memberBname);
        return this.atAuctionEnrollServiceRepository.saveatAuctionEnroll(atAuctionEnrollDomain);
    }

    @RequestMapping(value={"getAuctionEnroll.json"}, name="\u83b7\u53d6\u7ade\u4ef7\u62a5\u540d\u4fe1\u606f")
    @ResponseBody
    public AtAuctionEnrollReDomain getAuctionEnroll(Integer auctionEnrollfileId) {
        if (StringUtils.isBlank((Integer)auctionEnrollfileId)) {
            this.logger.error(CODE + ".getAuctionEnroll", (Object)"param is null");
            return null;
        }
        return this.atAuctionEnrollServiceRepository.getatAuctionEnroll(auctionEnrollfileId);
    }

    @RequestMapping(value={"updateAuctionEnroll.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnroll(HttpServletRequest request, AtAuctionEnrollDomain atAuctionEnrollDomain) {
        if (null == atAuctionEnrollDomain) {
            this.logger.error(CODE + ".updateAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        atAuctionEnrollDomain.setTenantCode(this.getTenantCode(request));
        return this.atAuctionEnrollServiceRepository.updateatAuctionEnroll(atAuctionEnrollDomain);
    }

    @RequestMapping(value={"deleteAuctionEnroll.json"}, name="\u5220\u9664\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionEnroll(Integer auctionEnrollfileId) {
        if (StringUtils.isBlank((Integer)auctionEnrollfileId)) {
            this.logger.error(CODE + ".deleteAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionEnrollServiceRepository.deleteatAuctionEnroll(auctionEnrollfileId);
    }

    @RequestMapping(value={"queryAuctionEnrollPage.json"}, name="\u67e5\u8be2\u7ade\u4ef7\u62a5\u540d\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"updateAuctionEnrollState.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u62a5\u540d\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollState(String auctionEnrollfileId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionEnrollfileId)) {
            this.logger.error(CODE + ".updateAuctionEnrollState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionEnrollServiceRepository.updateatAuctionEnrollState(Integer.valueOf(auctionEnrollfileId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryAuctionEnrollForAt.json"}, name="\u770b\u8d27\u62a5\u540d\u5206\u9875\u5217\u8868-\u516c\u544a")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollForAt(HttpServletRequest request, String auctionCode) {
        if (null == auctionCode) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionCode", auctionCode);
        param.put("auctionType", "01");
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"queryAuctionBiddingEnrollForAt.json"}, name="\u7ade\u4ef7\u62a5\u540d\u5206\u9875\u5217\u8868-\u516c\u544a")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionBiddingEnrollForAt(HttpServletRequest request, String auctionCode) {
        if (null == auctionCode) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionCode", auctionCode);
        param.put("auctionType", "01");
        param.put("auctionEnrollType", "1");
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"saveAuctionEnrollByStr.json"}, name="\u589e\u52a0\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean saveAuctionEnrollByStr(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        AtAuctionEnrollDomain atAuctionEnrollDomain = (AtAuctionEnrollDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, AtAuctionEnrollDomain.class);
        if (null == atAuctionEnrollDomain) {
            this.logger.error(CODE + ".saveAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean("error", "session is null");
        }
        String tenantCode = userSession.getTenantCode();
        String memberBcode = userSession.getUserPcode();
        String memberBname = userSession.getUserRelname();
        String auctionCode = atAuctionEnrollDomain.getAuctionCode();
        Integer ruleDpType = atAuctionEnrollDomain.getAuctionruleDptype();
        if (StringUtils.isEmpty((String)auctionCode)) {
            return new HtmlJsonReBean("error", "auctionCode is null");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(tenantCode, auctionCode);
        if (null == atAuctionReDomain) {
            return new HtmlJsonReBean("error", "auction is null");
        }
        Date date = new Date();
        Date auctionADate = atAuctionReDomain.getAuctionAdate();
        Date auctionAGDate = atAuctionReDomain.getAuctionAgdate();
        if ("0".equals(atAuctionEnrollDomain.getAuctionEnrollType())) {
            if (date.compareTo(auctionAGDate) > 0) {
                return new HtmlJsonReBean("error", "\u770b\u8d27\u65f6\u95f4\u5df2\u622a\u6b62");
            }
        } else if (date.compareTo(auctionADate) > 0) {
            return new HtmlJsonReBean("error", "\u7ade\u4ef7\u65f6\u95f4\u5df2\u622a\u6b62");
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)atAuctionEnrollDomain, (Object)atAuctionReDomain);
        }
        catch (Exception e) {
            // empty catch block
        }
        atAuctionEnrollDomain.setTenantCode(tenantCode);
        atAuctionEnrollDomain.setMemberBcode(memberBcode);
        atAuctionEnrollDomain.setMemberBname(memberBname);
        atAuctionEnrollDomain.setAuctionruleDptype(ruleDpType);
        return this.atAuctionEnrollServiceRepository.saveatAuctionEnroll(atAuctionEnrollDomain);
    }

    @RequestMapping(value={"queryAuctionEnrollForPaas.json"}, name="\u770b\u8d27\u62a5\u540d\u5206\u9875\u5217\u8868-\u5e73\u53f0\u62a5\u540d\u5ba1\u6838")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollForPaas(HttpServletRequest request, String auctionCode) {
        if (null == auctionCode) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionCode", auctionCode);
        param.put("auctionType", "01");
        param.put("auctionEnrollType", "0");
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"updateAuctionEnrollAuditQstate.json"}, name="\u5ba1\u6838\u8d44\u8d28")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditQstate(HttpServletRequest request, String auctionEnrollfileId, Integer dataState, Integer oldDataState, String auctionAuremark) {
        if (StringUtils.isBlank((String)auctionEnrollfileId)) {
            this.logger.error(CODE + ".updateAuctionEnrollState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionAuremark", auctionAuremark);
        map.put("userCode", userSession.getUserPcode());
        map.put("userName", userSession.getUserName());
        return this.atAuctionEnrollServiceRepository.updateAuctionEnrollAuditQstateNew(Integer.valueOf(auctionEnrollfileId), dataState, oldDataState, map);
    }

    @RequestMapping(value={"updateAuctionEnrollAuditDstateByTrans.json"}, name="\u5ba1\u6838\u4fdd\u8bc1\u91d1\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditDstateByTrans(HttpServletRequest request, String auctionEnrollfileId, Integer dataState, Integer oldDataState, String auctionAuremark, String auctionDtId, String phone) {
        String tenantCode;
        String userCode;
        if (StringUtils.isEmpty((String)auctionEnrollfileId) || null == dataState || null == oldDataState || StringUtils.isEmpty((String)auctionDtId) || StringUtils.isEmpty((String)phone)) {
            return new HtmlJsonReBean("error", "param is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean("error", "session is null");
        }
        String userName = userSession.getUserName();
        HtmlJsonReBean htmlJsonReBean = this.atAuctionEnrollServiceRepository.updateAuctionEnrollAuditByTransLoad(auctionEnrollfileId, dataState, oldDataState, auctionAuremark, auctionDtId, phone, userName, userCode = userSession.getUserPcode(), tenantCode = this.getTenantCode(request));
        if (null == htmlJsonReBean.getDataObj()) {
            return new HtmlJsonReBean("error", "\u5ba1\u6838\u5931\u8d25");
        }
        return new HtmlJsonReBean((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"updateAuctionEnrollAuditByReturn.json"}, name="\u5ba1\u6838\u4fdd\u8bc1\u91d1\u91ca\u653e")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditByReturn(HttpServletRequest request, String auctionDtId) {
        return this.updateAuctionEnrollAuditByReturCom(request, auctionDtId, null);
    }

    @RequestMapping(value={"updateAuctionEnrollAuditByReturnFail.json"}, name="\u5ba1\u6838\u4fdd\u8bc1\u91d1\u91ca\u653e\u5931\u8d25")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditByReturnFail(HttpServletRequest request, String auctionDtId) {
        return this.updateAuctionEnrollAuditByReturCom(request, auctionDtId, "returnFail");
    }

    private HtmlJsonReBean updateAuctionEnrollAuditByReturCom(HttpServletRequest request, String auctionDtId, String phone) {
        if (StringUtils.isEmpty((String)auctionDtId) || StringUtils.isEmpty((String)auctionDtId)) {
            return new HtmlJsonReBean("error", "param is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean("error", "session is null");
        }
        String userName = userSession.getUserName();
        String userCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        return this.atAuctionEnrollServiceRepository.updateAuctionEnrollAuditByReturn(auctionDtId, phone, userName, userCode, tenantCode);
    }

    @RequestMapping(value={"updateAuctionEnrollAuditDstateFail.json"}, name="\u5ba1\u6838\u4fdd\u8bc1\u91d1\u5931\u8d25")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditDstateFail(HttpServletRequest request, String auctionEnrollfileId, Integer dataState, Integer oldDataState, String auctionAuremark) {
        if (StringUtils.isEmpty((String)auctionEnrollfileId) || null == dataState || null == oldDataState) {
            return new HtmlJsonReBean("error", "param is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        String userName = userSession.getUserName();
        String userCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        return this.atAuctionEnrollServiceRepository.updateAuctionEnrollAuditByTransLoad(auctionEnrollfileId, dataState, oldDataState, auctionAuremark, auctionAuremark, null, userName, userCode, tenantCode);
    }

    @RequestMapping(value={"getAuctionEnrollForPaasAt.json"}, name="\u7ade\u4ef7\u5ba1\u6838\u9875\u9762")
    @ResponseBody
    public AtAuctionEnrollReDomain getAuctionEnrollForPaasAt(String auctionEnrollId) {
        if (null == auctionEnrollId) {
            return null;
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = this.atAuctionEnrollServiceRepository.getatAuctionEnroll(Integer.valueOf(auctionEnrollId));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionCode", atAuctionEnrollReDomain.getAuctionCode());
        map.put("memberBcode", atAuctionEnrollReDomain.getMemberBcode());
        map.put("tenantCode", atAuctionEnrollReDomain.getTenantCode());
        atAuctionEnrollReDomain.setAtAuctiondtReDomainList(this.atAuctiondtServiceRepository.queryAuctiondtPage(map).getList());
        return atAuctionEnrollReDomain;
    }

    @RequestMapping(value={"queryAuctionEnrollForAtPaas.json"}, name="\u770b\u8d27\u62a5\u540d\u5206\u9875\u5217\u8868-\u516c\u544a\u7ed9\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollForAtPaas(HttpServletRequest request, String auctionCode) {
        if (null == auctionCode) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionCode", auctionCode);
        param.put("auctionType", "01");
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"checkEnrollAndDt.json"}, name="\u68c0\u67e5\u662f\u5426\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean checkEnrollAndDt(HttpServletRequest request, String auctionCode) {
        UserSession userSession = this.getUserSession(request);
        String tenantCode = userSession.getTenantCode();
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        map.put("memberBcode", userSession.getUserPcode());
        SupQueryResult atAuctionEnrollResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(map);
        SupQueryResult atAuctiondtResult = this.atAuctiondtServiceRepository.queryAuctiondtPage(map);
        boolean checkEnroll = false;
        boolean checkDt = false;
        if (ListUtil.isNotEmpty((Collection)atAuctionEnrollResult.getList())) {
            checkEnroll = true;
        }
        if (ListUtil.isNotEmpty((Collection)atAuctiondtResult.getList())) {
            checkDt = true;
        }
        return new HtmlJsonReBean((Object)("checkEnroll:" + checkEnroll + "," + "checkDt:" + checkDt));
    }

    @RequestMapping(value={"getEnrollTypeAndDt.json"}, name="\u83b7\u53d6\u7528\u6237\u62a5\u540dcheck\u4fe1\u606f")
    @ResponseBody
    public AtAuctionEnrollReDomain checkEnrollTypeAndDt(HttpServletRequest request, String auctionCode, String auctionEnrollType) {
        UserSession userSession = this.getUserSession(request);
        String tenantCode = userSession.getTenantCode();
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        map.put("memberBcode", userSession.getUserPcode());
        map.put("auctionEnrollType", auctionEnrollType);
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = new AtAuctionEnrollReDomain();
        atAuctionEnrollReDomain.setCheckDt(false);
        atAuctionEnrollReDomain.setCheckEnroll(false);
        SupQueryResult atAuctionEnrollResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(map);
        SupQueryResult atAuctiondtResult = this.atAuctiondtServiceRepository.queryAuctiondtPage(map);
        if (ListUtil.isNotEmpty((Collection)atAuctionEnrollResult.getList())) {
            atAuctionEnrollReDomain = this.atAuctionEnrollServiceRepository.getatAuctionEnroll(((AtAuctionEnrollReDomain)atAuctionEnrollResult.getList().get(0)).getAuctionEnrollId());
            atAuctionEnrollReDomain.setCheckEnroll(true);
        }
        if (ListUtil.isNotEmpty((Collection)atAuctiondtResult.getList())) {
            atAuctionEnrollReDomain.setCheckDt(true);
        }
        return atAuctionEnrollReDomain;
    }

    @RequestMapping(value={"queryAuctionEnrollForPaasAt.json"}, name="\u5e73\u53f0\u62a5\u540d\u5ba1\u6838\u5217\u8868\u9875\u9762")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollForPaasAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionType", "01");
        param.put("auctionEnrollType", "1");
        param.put("tenantCode", this.getTenantCode(request));
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"queryMyAuctionEnroll.json"}, name="\u6211\u7684\u7ade\u4ef7")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryMyAuctionEnroll(HttpServletRequest request) {
        UserSession userSession;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (userSession = this.getUserSession(request))) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("auctionType", "01");
        param.put("memberBcode", userSession.getUserPcode());
        param.put("auctionEnrollType", "1");
        param.put("tenantCode", tenantCode);
        SupQueryResult atAuctionEnrollResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
        if (ListUtil.isEmpty((Collection)atAuctionEnrollResult.getList())) {
            return null;
        }
        for (AtAuctionEnrollReDomain atAuctionEnrollReDomain : atAuctionEnrollResult.getList()) {
            HashMap<String, String> mapp = new HashMap<String, String>();
            String memberBcode = atAuctionEnrollReDomain.getMemberBcode();
            String auctionCode = atAuctionEnrollReDomain.getAuctionCode();
            mapp.put("memberBcode", memberBcode);
            mapp.put("auctionCode", auctionCode);
            mapp.put("tenantCode", tenantCode);
            SupQueryResult atAuctiondtResult = this.atAuctiondtServiceRepository.queryAuctiondtPage(mapp);
            SupQueryResult atAuctionUserginfoResult = this.atAuctionUserginfoServiceRepository.queryatAuctionUserginfoPage(mapp);
            if (ListUtil.isEmpty((Collection)atAuctiondtResult.getList())) {
                atAuctionEnrollReDomain.setReadyTopay(Integer.valueOf(0));
                continue;
            }
            if (atAuctionUserginfoResult.getList().size() == atAuctiondtResult.getList().size()) {
                atAuctionEnrollReDomain.setReadyTopay(Integer.valueOf(1));
                continue;
            }
            atAuctionEnrollReDomain.setReadyTopay(Integer.valueOf(2));
        }
        return atAuctionEnrollResult;
    }

    @RequestMapping(value={"queryMyAuctionEnrollReadToPay.json"}, name="\u67e5\u8be2\u6211\u7684\u7ade\u4ef7\u62a5\u540d\u4ea4\u4fdd\u72b6\u6001")
    @ResponseBody
    public List<AtAuctionEnrollReDomain> queryMyAuctionEnrollReadToPay(HttpServletRequest request, String readyTopay) {
        UserSession userSession;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (userSession = this.getUserSession(request))) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("memberBcode", userSession.getUserPcode());
        param.put("tenantCode", tenantCode);
        ArrayList<AtAuctionEnrollReDomain> atAuctionEnrollReDomains = new ArrayList<AtAuctionEnrollReDomain>();
        SupQueryResult atAuctionEnrollResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
        if (ListUtil.isEmpty((Collection)atAuctionEnrollResult.getList())) {
            return null;
        }
        for (AtAuctionEnrollReDomain atAuctionEnrollReDomain : atAuctionEnrollResult.getList()) {
            HashMap<String, String> mapp = new HashMap<String, String>();
            String memberBcode = atAuctionEnrollReDomain.getMemberBcode();
            String auctionCode = atAuctionEnrollReDomain.getAuctionCode();
            mapp.put("memberBcode", memberBcode);
            mapp.put("auctionCode", auctionCode);
            mapp.put("tenantCode", tenantCode);
            SupQueryResult atAuctiondtResult = this.atAuctiondtServiceRepository.queryAuctiondtPage(mapp);
            SupQueryResult atAuctionUserginfoResult = this.atAuctionUserginfoServiceRepository.queryatAuctionUserginfoPage(mapp);
            boolean flag = false;
            switch (readyTopay) {
                case "0": {
                    if (!ListUtil.isNotEmpty((Collection)atAuctiondtResult.getList())) break;
                    flag = true;
                    break;
                }
                case "1": {
                    if (atAuctionUserginfoResult.getList().size() == atAuctiondtResult.getList().size()) break;
                    flag = true;
                    break;
                }
                case "2": {
                    if (!ListUtil.isEmpty((Collection)atAuctiondtResult.getList()) && atAuctionUserginfoResult.getList().size() != atAuctiondtResult.getList().size()) break;
                    flag = true;
                }
            }
            if (flag) continue;
            atAuctionEnrollReDomains.add(atAuctionEnrollReDomain);
        }
        return atAuctionEnrollReDomains;
    }

    @RequestMapping(value={"queryAuctionEnrollItemByMem.json"}, name="\u67e5\u8be2\u6211\u7684\u5355\u54c1\u8d2d\u4e70\u62a5\u540d\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollItemByMem(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        String memberBcode = userSession.getUserPcode();
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberBcode", memberBcode);
        param.put("auctionEnrollType", "2");
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }
}

