/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.at.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionGinfoReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionGoodsDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionWinDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionWinReDomain;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionPriceServiceRepository;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionServiceRepository;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionWinServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/at/auctionWin"}, name="\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c")
public class AuctionWinCon
extends SpringmvcController {
    private static String CODE = "at.auctionWin.con";
    @Autowired
    private AtAuctionWinServiceRepository atAuctionWinServiceRepository;
    @Autowired
    private AtAuctionServiceRepository atAuctionServiceRepository;
    @Autowired
    private AtAuctionPriceServiceRepository atAuctionPriceServiceRepository;

    protected String getContext() {
        return "auctionWin";
    }

    @RequestMapping(value={"queryAuctionWinCommission.json"}, name="\u67e5\u8be2\u4f63\u91d1\u6536\u53d6 \u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionWinReDomain> queryAuctionWinCommissionPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionWinServiceRepository.queryatAuctionWinPage(param);
    }

    @RequestMapping(value={"saveAuctionWin.json"}, name="\u589e\u52a0\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c")
    @ResponseBody
    public HtmlJsonReBean saveAuctionWin(HttpServletRequest request, AtAuctionWinDomain atAuctionWinDomain) {
        if (null == atAuctionWinDomain) {
            this.logger.error(CODE + ".saveAuctionWin", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        atAuctionWinDomain.setTenantCode(this.getTenantCode(request));
        return this.atAuctionWinServiceRepository.saveatAuctionWin(atAuctionWinDomain);
    }

    @RequestMapping(value={"getAuctionWin.json"}, name="\u83b7\u53d6\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c\u4fe1\u606f")
    @ResponseBody
    public AtAuctionWinReDomain getAuctionWin(Integer auctionWinId) {
        if (StringUtils.isBlank((Integer)auctionWinId)) {
            this.logger.error(CODE + ".getAuctionWin", (Object)"param is null");
            return null;
        }
        return this.atAuctionWinServiceRepository.getatAuctionWin(auctionWinId);
    }

    @RequestMapping(value={"updateAuctionWin.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c")
    @ResponseBody
    public HtmlJsonReBean updateAuctionWin(HttpServletRequest request, AtAuctionWinDomain atAuctionWinDomain) {
        if (null == atAuctionWinDomain) {
            this.logger.error(CODE + ".updateAuctionWin", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        atAuctionWinDomain.setTenantCode(this.getTenantCode(request));
        return this.atAuctionWinServiceRepository.updateatAuctionWin(atAuctionWinDomain);
    }

    @RequestMapping(value={"deleteAuctionWin.json"}, name="\u5220\u9664\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionWin(Integer auctionWinId) {
        if (StringUtils.isBlank((Integer)auctionWinId)) {
            this.logger.error(CODE + ".deleteAuctionWin", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionWinServiceRepository.deleteatAuctionWin(auctionWinId);
    }

    @RequestMapping(value={"queryAuctionWinPage.json"}, name="\u67e5\u8be2\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionWinReDomain> queryAuctionWinPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionWinServiceRepository.queryatAuctionWinPage(param);
    }

    @RequestMapping(value={"updateAuctionWinState.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionWinState(String auctionWinId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionWinId)) {
            this.logger.error(CODE + ".updateAuctionWinState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionWinServiceRepository.updateatAuctionWinState(Integer.valueOf(auctionWinId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"getAuctionWinByCode.json"}, name="\u83b7\u53d6\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c\u901a\u77e5\u4e66\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean getAuctionWinByCode(HttpServletRequest request, String auctionCode) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "session is null");
        }
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".getAuctionWin", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(tenantCode, auctionCode);
        if (null == atAuctionReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u573a\u6b21\u4fe1\u606f\u4e3a\u7a7a");
        }
        Map map = this.assemMapParam(request);
        map.put("auctionCode", auctionCode);
        map.put("memberBcode", userSession.getUserPcode());
        map.put("order", true);
        return this.getHtmlJsonReBean(request, auctionCode, tenantCode, atAuctionReDomain, map);
    }

    @RequestMapping(value={"getAuctionWinByCodePlatform.json"}, name="\u5e73\u53f0\u83b7\u53d6\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c\u901a\u77e5\u4e66\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean getAuctionWinByCodePlatform(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".getAuctionWin", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(tenantCode, auctionCode);
        if (null == atAuctionReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u573a\u6b21\u4fe1\u606f\u4e3a\u7a7a");
        }
        Map map = this.assemMapParam(request);
        map.put("auctionCode", auctionCode);
        map.put("order", true);
        return this.getHtmlJsonReBean(request, auctionCode, tenantCode, atAuctionReDomain, map);
    }

    private HtmlJsonReBean getHtmlJsonReBean(HttpServletRequest request, String auctionCode, String tenantCode, AtAuctionReDomain atAuctionReDomain, Map<String, Object> map) {
        SupQueryResult atAuctionWinResult = this.atAuctionWinServiceRepository.queryatAuctionWinPage(map);
        if (ListUtil.isEmpty((Collection)atAuctionWinResult.getList())) {
            return new HtmlJsonReBean((Object)"\u6682\u65e0\u4e2d\u6807\u4fe1\u606f");
        }
        AtAuctionWinReDomain atAuctionWinReDomain = (AtAuctionWinReDomain)atAuctionWinResult.getList().get(0);
        ArrayList atAuctionGinfoReDomainList = new ArrayList();
        ArrayList<AtAuctionGoodsDomain> atAuctionGoodsDomainList = new ArrayList<AtAuctionGoodsDomain>();
        SupQueryResult ocContractGoodsResult = null;
        for (AtAuctionWinReDomain atAuctionWinReDomain1 : atAuctionWinResult.getList()) {
            AtAuctionGinfoReDomain atAuctionGinfoReDomain = this.atAuctionServiceRepository.getatAuctionGinfoByCode(tenantCode, atAuctionWinReDomain1.getAuctionGinfoCode());
            if (null == atAuctionGinfoReDomain) continue;
            map = new HashMap<String, Object>();
            map.put("contractNbillcode", auctionCode);
            map.put("contractNbbillcode", atAuctionGinfoReDomain.getAuctionGinfoCode());
            map.put("tenantCode", this.getTenantCode(request));
            SupQueryResult ocContractReDomainSupQueryResult = this.atAuctionWinServiceRepository.queryContractPageReDomain(map);
            if (ListUtil.isEmpty((Collection)ocContractReDomainSupQueryResult.getList())) {
                return new HtmlJsonReBean((Object)"\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38");
            }
            BigDecimal ownPremium = atAuctionGinfoReDomain.getAuctionGinfoPrice().subtract(atAuctionGinfoReDomain.getPricesetNprice());
            if (!ListUtil.isNotEmpty((Collection)atAuctionGinfoReDomain.getAtAuctionGoodsDomain())) continue;
            for (AtAuctionGoodsDomain atAuctionGoodsDomain : atAuctionGinfoReDomain.getAtAuctionGoodsDomain()) {
                BigDecimal supplyweight = atAuctionGoodsDomain.getGoodsSupplyweight();
                BigDecimal finalPremium = ownPremium.add(atAuctionGoodsDomain.getPricesetNprice());
                atAuctionGoodsDomain.setFinalPremium(finalPremium);
                atAuctionGoodsDomain.setSumPremium(finalPremium.multiply(supplyweight));
                for (OcContractReDomain ocContractReDomain : ocContractReDomainSupQueryResult.getList()) {
                    map = new HashMap<String, Object>();
                    map.put("contractBillcode", ocContractReDomain.getContractBillcode());
                    map.put("tenantCode", this.getTenantCode(request));
                    ocContractGoodsResult = this.atAuctionWinServiceRepository.queryContractGoodsPage(map);
                    if (ListUtil.isEmpty((Collection)ocContractGoodsResult.getList())) {
                        return new HtmlJsonReBean((Object)"\u8ba2\u5355\u5546\u54c1\u4fe1\u606f\u5f02\u5e38");
                    }
                    for (OcContractGoodsReDomain ocContractGoodsReDomain : ocContractGoodsResult.getList()) {
                        if (!ocContractGoodsReDomain.getGoodsCode().equals(atAuctionGoodsDomain.getGoodsCode())) continue;
                        atAuctionGoodsDomain.setGoodsContract(ocContractReDomain.getContractBillcode());
                    }
                }
                atAuctionGoodsDomainList.add(atAuctionGoodsDomain);
            }
        }
        atAuctionWinReDomain.setAtAuctionGinfoReDomainList(atAuctionGinfoReDomainList);
        atAuctionWinReDomain.setMemberContact(atAuctionReDomain.getMemberContact());
        atAuctionWinReDomain.setMemberContactPhone(atAuctionReDomain.getMemberContactPhone());
        atAuctionWinReDomain.setWarehouseName(atAuctionReDomain.getWarehouseName());
        atAuctionWinReDomain.setWarehouseCode(atAuctionReDomain.getWarehouseCode());
        atAuctionWinReDomain.setAtAuctionGoodsDomainList(atAuctionGoodsDomainList);
        return new HtmlJsonReBean((Object)atAuctionWinReDomain);
    }
}

