/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.cmchannel.controller.thread;

import com.qjsoft.laser.controller.springmvc.thread.BlockingPolicyWithReport;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolFactory {
    public static final int CPUS = 4;
    public static final int SERVER_POOL_CORE_SIZE_DEFAULT = 4;
    public static final int SERVER_POOL_MAX_SIZE_DEFAULT = 50;
    public static final int SERVER_POOL_KEEP_ALIVE_TIME_DEFAULT = 1800000;
    public static final int SERVER_POOL_QUEUE_SIZE_DEFAULT = 10240;
    private static Map<String, ThreadPoolExecutor> storeToDepartThreadPoolMap = new HashMap<String, ThreadPoolExecutor>();

    public static ThreadPoolExecutor createStoreToDepartThreadPoo() {
        return ThreadPoolFactory.createThreadPoolExecutor(storeToDepartThreadPoolMap, "SYN_STORE_TO_DEPART_POOL_");
    }

    public static ThreadPoolExecutor createPriceThreadPool() {
        return ThreadPoolFactory.createThreadPoolExecutor(storeToDepartThreadPoolMap, "SYN_PRICE_POOL_");
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(Map<String, ThreadPoolExecutor> executorMap, String poolName) {
        ThreadPoolExecutor newThreadPool;
        ThreadPoolExecutor threadPoolExecutor = executorMap.get(poolName);
        if (threadPoolExecutor == null && (threadPoolExecutor = executorMap.put(poolName, newThreadPool = new ThreadPoolExecutor(16, 100, 1800000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10240), ThreadPoolFactory.createThreadFactory(poolName), (RejectedExecutionHandler)new BlockingPolicyWithReport()))) == null) {
            threadPoolExecutor = newThreadPool;
        }
        return threadPoolExecutor;
    }

    private static ThreadFactory createThreadFactory(final String threadName) {
        return new ThreadFactory(){
            private AtomicInteger number = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, threadName + "-" + this.number.getAndIncrement());
            }
        };
    }
}

