/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.common.authservice;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.service.HtmlIBaseService;
import com.qjsoft.laser.controller.core.auth.AuthBean;
import com.qjsoft.laser.controller.core.auth.AuthCheck;
import com.qjsoft.laser.controller.core.auth.MenuBean;
import com.qjsoft.laser.controller.core.auth.MenuInfoBean;
import com.qjsoft.laser.controller.core.auth.Permisson;
import com.qjsoft.laser.controller.core.auth.PermissonList;
import com.qjsoft.laser.controller.core.auth.ResBean;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.supper.ObjectService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthServiceImpl
extends ObjectService {
    private static final String sys_code = "AuthServiceImpl";
    @Autowired
    private HtmlIBaseService htmlIBaseService;

    public List<MenuInfoBean> getUserPerMenuTree(Map<String, String> userperMap, String proappCode, String tenantCode) {
        return this.getPerMenuTreeByuser(userperMap, proappCode, tenantCode, true, true);
    }

    public List<MenuInfoBean> getUserInfoPerMenuTree(Map<String, String> userperMap, String proappCode, String tenantCode) {
        return this.getPerMenuTreeByuser(userperMap, proappCode, tenantCode, false, true);
    }

    public List<MenuInfoBean> getPerMenuTree(String proappCode, String tenantCode) {
        return this.getPerMenuTreeByuser(null, proappCode, tenantCode, false, false);
    }

    private List<MenuInfoBean> getPerMenuTreeByuser(Map<String, String> userperMap, String proappCode, String tenantCode, boolean show, boolean op) {
        List<MenuInfoBean> menuList = this.navQuery(proappCode, tenantCode);
        if (null == menuList || menuList.isEmpty()) {
            return null;
        }
        ArrayList<MenuInfoBean> treemenu = new ArrayList<MenuInfoBean>();
        for (MenuInfoBean menuInfoBean : menuList) {
            MenuInfoBean menuInfoBeanre = new MenuInfoBean();
            try {
                BeanUtils.copyAllPropertys((Object)menuInfoBeanre, (Object)menuInfoBean);
            }
            catch (Exception e) {
                // empty catch block
            }
            List<MenuInfoBean> menuchildList = this.makeMenu(menuInfoBean.getProappMenuCode(), proappCode, tenantCode);
            if (ListUtil.isEmpty(menuchildList)) {
                treemenu.add(menuInfoBeanre);
                continue;
            }
            List<MenuInfoBean> menuchildReList = this.makePerOp(menuchildList, userperMap, show, op);
            if (null == menuchildReList || menuchildReList.isEmpty()) continue;
            menuInfoBeanre.setChildren(menuchildReList);
            treemenu.add(menuInfoBeanre);
        }
        if (null == treemenu || treemenu.isEmpty()) {
            return null;
        }
        return treemenu;
    }

    private List<MenuInfoBean> makePerOp(List<MenuInfoBean> menuchildList, Map<String, String> userperMap, boolean show, boolean op) {
        if (null == menuchildList || menuchildList.isEmpty()) {
            return null;
        }
        ArrayList<MenuInfoBean> menuRelist = new ArrayList<MenuInfoBean>();
        boolean flag = true;
        for (MenuInfoBean menuInfoBean : menuchildList) {
            Permisson permisson;
            String perStr;
            flag = true;
            MenuInfoBean menuInfoBeanre = new MenuInfoBean();
            try {
                BeanUtils.copyAllPropertys((Object)menuInfoBeanre, (Object)menuInfoBean);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (null != menuInfoBean.getChildren() && !menuInfoBean.getChildren().isEmpty()) {
                List<MenuInfoBean> menuRechilelist = this.makePerOp(menuInfoBean.getChildren(), userperMap, show, op);
                if (null != menuRechilelist && !menuRechilelist.isEmpty()) {
                    menuInfoBeanre.setChildren(menuRechilelist);
                    menuRelist.add(menuInfoBeanre);
                    flag = false;
                } else {
                    menuInfoBeanre.setChildren(null);
                }
            }
            if (!flag) continue;
            String permissionCode = menuInfoBeanre.getPermissionCode();
            if (!show && StringUtils.isBlank((String)permissionCode) || StringUtils.isNotBlank((String)permissionCode) && (StringUtils.isBlank((String)(perStr = SupDisUtil.getMap((String)"UpPermission-permission", (String)(permissionCode + "-" + "00000000")))) || null == (permisson = (Permisson)JsonUtil.buildNormalBinder().getJsonToObject(perStr, Permisson.class)) || !show && !PermissonList.sort_user.equals(permisson.getPermissionSort()) && (null == menuInfoBeanre.getChildren() || menuInfoBeanre.getChildren().isEmpty()) || PermissonList.sort_user.equals(permisson.getPermissionSort()) && (op && (StringUtils.isBlank((String)menuInfoBeanre.getMenuCode()) || null == userperMap || userperMap.isEmpty()) || StringUtils.isNotBlank((String)menuInfoBeanre.getMenuCode()) && null != userperMap && !userperMap.isEmpty() && StringUtils.isBlank((String)userperMap.get(menuInfoBeanre.getMenuCode()))))) continue;
            menuRelist.add(menuInfoBeanre);
        }
        return menuRelist;
    }

    public AuthBean checkPer(AuthCheck authCheck) {
        if (null == authCheck) {
            this.logger.error("AuthServiceImpl.check1", (Object)"authCheck is null");
            return null;
        }
        String rootperlistKey = authCheck.getUrl();
        String perlistKey = rootperlistKey + "-" + authCheck.getMethod() + "-" + "00000000";
        String perlistStr = SupDisUtil.getMap((String)"UpPermissionList-permissionList", (String)perlistKey);
        if (StringUtils.isBlank((String)perlistStr)) {
            perlistKey = rootperlistKey + "-*-" + "00000000";
            perlistStr = SupDisUtil.getMap((String)"UpPermissionList-permissionList", (String)perlistKey);
        }
        if (StringUtils.isBlank((String)perlistStr)) {
            perlistStr = this.matchRestfulURI(authCheck);
        }
        AuthBean authBean = new AuthBean();
        authBean.setFlag(AuthBean.anthFlag_ok);
        if (StringUtils.isBlank((String)perlistStr)) {
            this.logger.error("AuthServiceImpl.check2", (Object)(perlistKey + ":perlistStr is null"));
            authBean.setFlag(AuthBean.anthFlag_nr);
        } else {
            PermissonList permissonList = (PermissonList)JsonUtil.buildNormalBinder().getJsonToObject(perlistStr, PermissonList.class);
            if (null == permissonList) {
                authBean.setFlag(AuthBean.anthFlag_nr);
                this.logger.error("AuthServiceImpl.check3", (Object)(perlistKey + ":permissonList is null :" + perlistStr));
            } else {
                authBean.setPermissonList(permissonList);
                String perStr = SupDisUtil.getMap((String)"UpPermission-permission", (String)(permissonList.getPermissionCode() + "-" + "00000000"));
                Permisson permisson = null;
                UserSession userSession = authCheck.getUserSession();
                if (StringUtils.isBlank((String)perStr)) {
                    authBean.setFlag(AuthBean.anthFlag_nr);
                    this.logger.error("AuthServiceImpl.check", (Object)(perlistKey + ":perStr is null"));
                } else {
                    permisson = (Permisson)JsonUtil.buildNormalBinder().getJsonToObject(perStr, Permisson.class);
                    if (null == permisson) {
                        authBean.setFlag(AuthBean.anthFlag_nr);
                        this.logger.error("AuthServiceImpl.check4", (Object)(perlistKey + ":permisson is null :" + perStr));
                    }
                }
                if (PermissonList.sort_public.equals(permissonList.getPermissionListSort())) {
                    authBean.setFlag(AuthBean.anthFlag_ok);
                } else if (PermissonList.sort_user.equals(permissonList.getPermissionListSort()) || PermissonList.sort_login.equals(permissonList.getPermissionListSort())) {
                    if (StringUtils.isBlankLoop((String[])new String[]{authCheck.getToken(), authCheck.getProappCode(), authCheck.getTenantCode()})) {
                        authBean.setFlag(AuthBean.anthFlag_nl);
                    } else if (null == userSession) {
                        authBean.setFlag(AuthBean.anthFlag_nl);
                    } else if (PermissonList.sort_user.equals(permissonList.getPermissionListSort())) {
                        ResBean resBean = this.getResbean(permissonList, permisson);
                        authBean.setResBean(resBean);
                        if (null == authBean.getResBean() || StringUtils.isBlank((String)authBean.getResBean().getMenuCode())) {
                            authBean.setFlag(AuthBean.anthFlag_nr);
                            this.logger.error("AuthServiceImpl.check.user.nr", (Object)(perlistKey + ":getMenuCode is null"));
                        } else {
                            HashMap perMap = userSession.getMap();
                            if (null == perMap) {
                                perMap = new HashMap();
                            }
                            if (null != userSession.getOneUserSessionBean() && null != userSession.getOneUserSessionBean().getMap() && !userSession.getOneUserSessionBean().getMap().isEmpty()) {
                                perMap.putAll(userSession.getOneUserSessionBean().getMap());
                            }
                            if (null != userSession.getTwoUserSessionBean() && null != userSession.getTwoUserSessionBean().getMap() && !userSession.getTwoUserSessionBean().getMap().isEmpty()) {
                                perMap.putAll(userSession.getTwoUserSessionBean().getMap());
                            }
                            if (null == perMap || perMap.isEmpty()) {
                                authBean.setFlag(AuthBean.anthFlag_np);
                                this.logger.error("AuthServiceImpl.check.user.npnull", (Object)(perlistKey + ":map is null"));
                            } else {
                                String menuCodeStr = authBean.getResBean().getMenuCode();
                                String[] menuCodes = menuCodeStr.split("\\,");
                                boolean flag = false;
                                for (String menuCode : menuCodes) {
                                    if (!StringUtils.isNotBlank((String)((String)perMap.get(menuCode)))) continue;
                                    flag = true;
                                }
                                if (!flag) {
                                    authBean.setFlag(AuthBean.anthFlag_np);
                                    this.logger.error("AuthServiceImpl.check.user.np", (Object)(perlistKey + ":menuCode is " + authBean.getResBean().getMenuCode() + " == " + ((Object)perMap).toString()));
                                }
                            }
                        }
                    }
                }
            }
        }
        return authBean;
    }

    private ResBean getResbean(PermissonList permissonList, Permisson permisson) {
        if (null == permissonList || null == permisson) {
            return null;
        }
        ResBean resBean = new ResBean();
        resBean.setUrlPath(permissonList.getPermissionListJspath());
        if (StringUtils.isBlank((String)resBean.getUrlPath())) {
            resBean.setUrlPath(permisson.getPermissionJspath());
        }
        resBean.setMenuName(permisson.getPermissionName());
        String menuListStr = SupDisUtil.getMap((String)"UpMenu-permissionCode", (String)(permisson.getPermissionCode() + "-" + "00000000"));
        if (StringUtils.isNotBlank((String)menuListStr)) {
            String menuCode = menuListStr.split("\\,")[0];
            String menuStr = SupDisUtil.getMap((String)"UpMenu-menuCode", (String)(menuCode + "-" + "00000000"));
            if (StringUtils.isBlank((String)menuStr)) {
                return null;
            }
            MenuBean menuBean = (MenuBean)JsonUtil.buildNormalBinder().getJsonToObject(menuStr, MenuBean.class);
            if (null != menuBean) {
                MenuBean parentmenuBean;
                String parentmenuStr;
                if (StringUtils.isBlank((String)resBean.getUrlPath())) {
                    resBean.setUrlPath(menuBean.getMenuJspath());
                }
                resBean.setMenuName(menuBean.getMenuName());
                resBean.setMenuCode(menuBean.getMenuCode());
                String menuParentCode = menuBean.getMenuParentCode();
                if (StringUtils.isNotBlank((String)menuParentCode) && StringUtils.isNotBlank((String)(parentmenuStr = SupDisUtil.getMap((String)"UpMenu-menuCode-menuCode", (String)(menuParentCode + "-" + "00000000")))) && (parentmenuBean = (MenuBean)JsonUtil.buildNormalBinder().getJsonToObject(parentmenuStr, MenuBean.class)) != null) {
                    resBean.setMenuParentCode(parentmenuBean.getMenuCode());
                    resBean.setMenuParentName(parentmenuBean.getMenuName());
                }
                return resBean;
            }
            this.logger.error("AuthServiceImpl.check5", (Object)(permisson.getPermissionCode() + ":menuStr is null "));
        }
        return null;
    }

    private String matchRestfulURI(AuthCheck authCheck) {
        String perlistTempKey;
        String perlistStr = null;
        String[] urls = authCheck.getUrl().split("\\/");
        String url = authCheck.getUrl() + "/";
        for (int i = urls.length - 1; i > 0 && StringUtils.isBlank((String)(perlistStr = SupDisUtil.getMap((String)"UpPermissionList-permissionList", (String)(perlistTempKey = (url = url.replace("/" + urls[i] + "/", "/*/")).substring(0, url.length() - 1) + "-*-" + "UpPermissionList-permissionList")))); --i) {
        }
        return perlistStr;
    }

    public List<MenuInfoBean> navQuery(String proappCode, String tenantCode) {
        List menuList = null;
        menuList = SupDisUtil.getListJson((String)("TmProappMenuListOne--" + proappCode + "-" + tenantCode), MenuInfoBean.class);
        return menuList;
    }

    public List<MenuInfoBean> makeMenu(String menuParentCode, String proappCode, String tenantCode) {
        List menuList = null;
        menuList = SupDisUtil.getListJson((String)("TmProappMenuListChild--" + menuParentCode + "-" + proappCode + "-" + tenantCode), MenuInfoBean.class);
        return menuList;
    }

    public List<MenuBean> loadModleMenu(String menuParentCode, String cachechildKey, String api) {
        this.logger.info("AuthServiceImpl.loadModleMenu", (Object)("===\u52a0\u8f7d" + api + ".start===="));
        String field = ServletMain.getAppName() + "-" + menuParentCode;
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>(api);
        pmap.putParam("appmanageIcode", ServletMain.getAppName());
        pmap.putParam("menuParentCode", menuParentCode);
        List menuList = (List)this.htmlIBaseService.senReList(pmap, MenuBean.class);
        SupDisUtil.setMap((String)cachechildKey, (String)field, (String)JsonUtil.buildNormalBinder().toJson((Object)menuList));
        this.logger.info("AuthServiceImpl.loadModleMenu", (Object)("===\u52a0\u8f7d" + api + ".end===="));
        return menuList;
    }
}

