/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.common.util;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;

public class ExportExcelUtlis {
    public static void exportExcel(HSSFSheet sheet, HSSFRow row, String[] headers, List<Object[]> dataset, String pattern, int index) throws IOException {
        Iterator<Object[]> it = dataset.iterator();
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            Object[] obj = it.next();
            for (short i = 0; i < obj.length; i = (short)(i + 1)) {
                HSSFCell cell = row.createCell(i);
                Object value = obj[i];
                String textValue = null;
                if (!"".equals(value) && value != null) {
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                        continue;
                    }
                    if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        cell.setCellValue((double)fValue);
                        continue;
                    }
                    if (value instanceof Double) {
                        double dValue = (Double)value;
                        cell.setCellValue(dValue);
                        continue;
                    }
                    if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                        continue;
                    }
                    if (value instanceof Date) {
                        Date date = (Date)value;
                        if (null == pattern || pattern.equals("")) {
                            pattern = "yyyy-MM-dd";
                        }
                        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                        textValue = sdf.format(date);
                        cell.setCellValue(textValue);
                        continue;
                    }
                    textValue = value.toString();
                    cell.setCellValue(textValue);
                    continue;
                }
                cell.setCellValue("");
            }
        }
        sheet.setDefaultRowHeight((short)512);
        sheet.setDefaultColumnWidth(17);
    }

    public static byte[] InputStreamByteArray(String filePath) throws IOException {
        FileInputStream in = new FileInputStream(filePath);
        byte[] data = ExportExcelUtlis.toByteArray(in);
        ((InputStream)in).close();
        return data;
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
        return out.toByteArray();
    }
}

