/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.ct.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.ct.controller.CustclueCon;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustclueDomain;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustclueReDomain;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustcluelistDomain;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustcluelistReDomain;
import com.qjsoft.laser.controller.facade.ct.repository.CtCustclueServiceRepository;
import com.qjsoft.laser.controller.facade.msc.domain.MscMschannelReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserReDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UmUconfigServiceRepository;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ct/custclueSa"}, name="\u5ba2\u6237\u7ebf\u7d22\u5c0f\u533a\u4e1a\u52a1\u5458\u7aef")
public class CustclueSaCon
extends CustclueCon {
    @Autowired
    private CtCustclueServiceRepository ctCustclueServiceRepository;
    private static final String CODE = "ct.custclueSa.con";
    private static final String SA_MTYPE = "4";
    @Autowired
    private UmUconfigServiceRepository umUconfigServiceRepository;

    @RequestMapping(value={"saveCustclue.json"}, name="\u589e\u52a0\u5ba2\u6237\u7ebf\u7d22")
    @ResponseBody
    public HtmlJsonReBean saveCustclueSa(HttpServletRequest request, String ctCustclueStr) {
        UserSession userSession = this.getUserSession(request);
        if (EmptyUtil.isEmpty((Object)userSession) || StringUtils.isBlank((String)ctCustclueStr)) {
            this.logger.error("ct.custclueSa.con.saveCustclue", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CtCustclueDomain ctCustclueDomain = (CtCustclueDomain)JsonUtil.buildNormalBinder().getJsonToObject(ctCustclueStr, CtCustclueDomain.class);
        ctCustclueDomain.setTenantCode(this.getTenantCode(request));
        return this.saveCustclue(userSession, ctCustclueDomain);
    }

    @RequestMapping(value={"getCustclue.json"}, name="\u83b7\u53d6\u5ba2\u6237\u7ebf\u7d22\u4fe1\u606f")
    @ResponseBody
    public CtCustclueReDomain getCustclueSa(Integer custclueId) {
        if (StringUtils.isBlank((Integer)custclueId)) {
            this.logger.error("ct.custclueSa.con.getCustclue", (Object)"param is null");
            return null;
        }
        return this.getCustclue(custclueId);
    }

    @RequestMapping(value={"updateCustclue.json"}, name="\u66f4\u65b0\u5ba2\u6237\u7ebf\u7d22")
    @ResponseBody
    public HtmlJsonReBean updateCustclueSa(HttpServletRequest request, String ctCustclueStr) {
        if (StringUtils.isBlank((String)ctCustclueStr)) {
            this.logger.error("ct.custclueSa.con.updateCustclue", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CtCustclueDomain ctCustclueDomain = (CtCustclueDomain)JsonUtil.buildNormalBinder().getJsonToObject(ctCustclueStr, CtCustclueDomain.class);
        ctCustclueDomain.setTenantCode(this.getTenantCode(request));
        return this.updateCustclue(ctCustclueDomain, request);
    }

    @RequestMapping(value={"deleteCustclue.json"}, name="\u5220\u9664\u5ba2\u6237\u7ebf\u7d22")
    @ResponseBody
    public HtmlJsonReBean deleteCustclueSa(Integer custclueId) {
        if (StringUtils.isBlank((Integer)custclueId)) {
            this.logger.error("ct.custclueSa.con.deleteCustclue", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.deleteCustclue(custclueId);
    }

    @RequestMapping(value={"queryCustcluePage.json"}, name="\u67e5\u8be2\u7ebf\u7d22\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CtCustclueReDomain> queryCustcluePageSa(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (EmptyUtil.isEmpty((Object)userSession)) {
            this.logger.error("ct.custclueSa.con.queryCustcluePage", (Object)"session  is null");
            return new SupQueryResult();
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryCustcluePage(param);
    }

    @RequestMapping(value={"updateCustclueState.json"}, name="\u66f4\u65b0\u5ba2\u6237\u7ebf\u7d22\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateCustclueStateSa(String custclueId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)custclueId)) {
            this.logger.error("ct.custclueSa.con.updateCustclueState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateCustclueState(custclueId, dataState, oldDataState);
    }

    @RequestMapping(value={"queryMschannelPage.json"}, name="\u67e5\u8be2\u5927\u533a\u5c0f\u533a\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<MscMschannelReDomain> queryMschannelPageSa(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == this.getUserSession(request) || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error("ct.custclueSa.con.queryMschannelPage", (Object)"UserSession or userPcode is null");
            return new SupQueryResult();
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("tenantCode", userSession.getTenantCode());
            param.put("memberMcode", userSession.getUserPcode());
        }
        return this.queryMschannelPage(param);
    }

    @RequestMapping(value={"saveCustcluelist.json"}, name="\u589e\u52a0\u7ebf\u7d22\u8ddf\u8e2a\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean saveCustcluelistSa(HttpServletRequest request, String ctCustcluelistStr) {
        UserSession userSession = this.getUserSession(request);
        if (EmptyUtil.isEmpty((Object)userSession) || StringUtils.isBlank((String)ctCustcluelistStr)) {
            this.logger.error("ct.custclueSa.con.saveCustcluelist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CtCustcluelistDomain ctCustcluelistDomain = (CtCustcluelistDomain)JsonUtil.buildNormalBinder().getJsonToObject(ctCustcluelistStr, CtCustcluelistDomain.class);
        ctCustcluelistDomain.setTenantCode(this.getTenantCode(request));
        ctCustcluelistDomain.setCustcluelistMtype(SA_MTYPE);
        return this.saveCustcluelist(userSession, ctCustcluelistDomain);
    }

    @RequestMapping(value={"queryCustcluelistPage.json"}, name="\u67e5\u8be2\u7ebf\u7d22\u8ddf\u8e2a\u6d41\u6c34\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CtCustcluelistReDomain> queryCustcluelistPageSa(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (EmptyUtil.isEmpty((Object)userSession) || StringUtils.isBlank((String)userSession.getTenantCode())) {
            this.logger.error("ct.custclueSa.con.queryCustcluelistPage", (Object)"tenantCode is null");
            return new SupQueryResult();
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryCustcluelistPage(param);
    }

    @RequestMapping(value={"queryUserPage.json"}, name="\u67e5\u8be2\u7ecf\u9500\u5546\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserinfoReDomainBean> queryUserPageSa(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == this.getUserSession(request) || StringUtils.isBlank((String)userSession.getTenantCode())) {
            this.logger.error("ct.custclueSa.con.queryUserPage", (Object)"UserSession or tenantCode is null");
            return new SupQueryResult();
        }
        Map param = this.assemMapParam(request);
        if (MapUtil.isEmpty((Map)param)) {
            this.logger.error("ct.custclueSa.con.queryUserPage", (Object)"UserSession or tenantCode is null");
            return new SupQueryResult();
        }
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("tenantCode", userSession.getTenantCode());
        param.put("userinfoQuality", "dealer");
        return this.queryUserInfoMschannelPage(param);
    }

    @RequestMapping(value={"payoutToEmp.json"}, name="\u6d3e\u53d1\u7ed9\u7ecf\u9500\u5546")
    @ResponseBody
    public HtmlJsonReBean payoutToEmpSa(HttpServletRequest request) {
        Map parma = this.assemMapParam(request);
        if (MapUtil.isEmpty((Map)parma) || EmptyUtil.isEmpty(parma.get("custclueIds")) || EmptyUtil.isEmpty(parma.get("memberPcode")) || EmptyUtil.isEmpty(parma.get("memberPname"))) {
            this.logger.error("ct.custclueSa.con.payoutToEmpSa", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        ArrayList<Integer> result = new ArrayList<Integer>();
        String[] custclueIds = parma.get("custclueIds").toString().split(",");
        CtCustclueReDomain custclue = null;
        for (int i = 0; i < custclueIds.length; ++i) {
            custclue = this.ctCustclueServiceRepository.getCustclue(Integer.valueOf(Integer.parseInt(custclueIds[i])));
            if (EmptyUtil.isEmpty((Object)custclue)) {
                result.add(custclue.getCustclueId());
                continue;
            }
            if (StringUtils.isEmpty((String)custclue.getAreaCode())) {
                result.add(custclue.getCustclueId());
                continue;
            }
            SupQueryResult myChargeArea = this.umUconfigServiceRepository.isMyChargeArea(String.valueOf(parma.get("memberPcode")), custclue.getTenantCode(), custclue.getAreaCode());
            if (EmptyUtil.isEmpty((Object)myChargeArea) || ListUtil.isEmpty((Collection)myChargeArea.getList())) {
                result.add(custclue.getCustclueId());
                continue;
            }
            custclue.setMemberPcode(String.valueOf(parma.get("memberPcode")));
            custclue.setMemberPname(String.valueOf(parma.get("memberPname")));
            custclue.setMemberUname(null);
            custclue.setMemberUcode(null);
            custclue.setMemberCode(null);
            custclue.setMemberName(null);
            custclue.setDataState(Integer.valueOf(3));
            htmlJsonReBean = this.doDistributionRegion(custclue);
            if (htmlJsonReBean != null && htmlJsonReBean.isSuccess()) continue;
            result.add(custclue.getCustclueId());
        }
        if (ListUtil.isNotEmpty(result)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5730\u533a\u4e0d\u5339\u914d,\u65e0\u6cd5\u6d3e\u53d1\u7ed9\u5f53\u524d\u5ba2\u6237", result);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryUserInfoParentPage.json"}, name="\u67e5\u8be2\u5e97\u957f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserinfoReDomainBean> queryUserInfoParentPage(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (EmptyUtil.isEmpty((Object)userSession) || StringUtils.isBlank((String)userSession.getTenantCode())) {
            this.logger.error("ct.custclueSa.con.queryUserInfoParentPage", (Object)"UserSession or tenantCode is null");
            return new SupQueryResult();
        }
        Map param = this.assemMapParam(request);
        if (MapUtil.isEmpty((Map)param) || EmptyUtil.isEmpty(param.get("memberPcode"))) {
            this.logger.error("ct.custclueSa.con.queryUserInfoParentPage", (Object)"queryParmam or memberPcode is null");
            return new SupQueryResult();
        }
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("tenantCode", userSession.getTenantCode());
        param.put("userinfoParentCode", param.get("memberPcode"));
        return this.queryUserInfoParentPage(param);
    }

    @RequestMapping(value={"queryUserPageByChannel.json"}, name="\u67e5\u8be2\u5458\u5de5\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserReDomainBean> queryUserPage(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (EmptyUtil.isEmpty((Object)userSession) || StringUtils.isBlank((String)userSession.getTenantCode())) {
            this.logger.error("ct.custclueSa.con.queryUserPage", (Object)"UserSession or tenantCode is null");
            return new SupQueryResult();
        }
        Map param = this.assemMapParam(request);
        if (EmptyUtil.isEmpty(param.get("memberCode"))) {
            param.put("userPcode", userSession.getUserPcode());
        } else {
            param.put("userPcode", param.get("memberCode") + "," + userSession.getUserPcode());
        }
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("tenantCode", userSession.getTenantCode());
        return this.queryUserPage(param);
    }
}

