/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dis.domain.DisChannelDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisChannelReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisChannelServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/channel"}, name="\u6e20\u9053\u5b9a\u4e49")
public class ChannelCon
extends SpringmvcController {
    private static String CODE = "dis.channel.con";
    @Autowired
    private DisChannelServiceRepository disChannelServiceRepository;

    protected String getContext() {
        return "channel";
    }

    @RequestMapping(value={"updateChannel.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean updateChannel(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateChannelMain(this.getTenantCode(request), disChannelDomain);
    }

    @RequestMapping(value={"updateChannelFromZx.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49-\u76f4\u9500")
    @ResponseBody
    public HtmlJsonReBean updateChannelFromZx(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateChannelMain(this.getTenantCode(request), disChannelDomain);
    }

    private HtmlJsonReBean updateChannelMain(String tenantCode, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disChannelDomain.setTenantCode(tenantCode);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("channelName", disChannelDomain.getChannelName());
        SupQueryResult supQueryResult = this.disChannelServiceRepository.queryChannelPage(map);
        if (null != supQueryResult && null != supQueryResult.getList() && supQueryResult.getList().size() > 0 && !((DisChannelReDomain)supQueryResult.getList().get(0)).getChannelId().equals(disChannelDomain.getChannelId())) {
            this.logger.error(CODE + ".updateChannel", (Object)"\u6e20\u9053\u540d\u79f0\u5df2\u5b58\u5728\uff0c \u8bf7\u91cd\u65b0\u586b\u5199");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6e20\u9053\u540d\u79f0\u5df2\u5b58\u5728\uff0c \u8bf7\u91cd\u65b0\u586b\u5199");
        }
        return this.disChannelServiceRepository.updateChannel(disChannelDomain);
    }

    @RequestMapping(value={"enableChannel.json"}, name="\u542f\u7528\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean enableChannel(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".enableChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), 0, -1);
    }

    @RequestMapping(value={"disconChannel.json"}, name="\u505c\u7528\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean disconChannel(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".disconChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), -1, 0);
    }

    @RequestMapping(value={"enableChannelFromZx.json"}, name="\u542f\u7528\u6e20\u9053-\u76f4\u9500")
    @ResponseBody
    public HtmlJsonReBean enableChannelFromZx(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".enableChannelZx", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), 0, -1);
    }

    @RequestMapping(value={"disconChannelFromZx.json"}, name="\u505c\u7528\u6e20\u9053-\u76f4\u9500")
    @ResponseBody
    public HtmlJsonReBean disconChannelFromZx(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".disconChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), -1, 0);
    }

    private HtmlJsonReBean updateDateStateMain(Integer id, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)id)) {
            this.logger.error(CODE + ".updateDateStateMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disChannelServiceRepository.updateChannelState(Integer.valueOf(id), dataState, oldDataState);
    }

    @RequestMapping(value={"queryChannelPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPage(HttpServletRequest request) {
        return this.queryMain(request);
    }

    @RequestMapping(value={"queryChannelFromConfigPage.json"}, name="\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868 - \u6e20\u9053\u53d1\u5e03\u8bbe\u7f6e\u9875\u9762")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelFromConfigPage(HttpServletRequest request) {
        return this.queryMain(request);
    }

    @RequestMapping(value={"queryChannelPageFromZx.json"}, name="\u67e5\u8be2\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868-\u76f4\u9500")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPageFromZx(HttpServletRequest request) {
        return this.queryMain(request);
    }

    @RequestMapping(value={"queryChannelFromConfigPageZx.json"}, name="\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868 - \u6e20\u9053\u53d1\u5e03\u8bbe\u7f6e\u9875\u9762-\u76f4\u9500")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelFromConfigPageFromZx(HttpServletRequest request) {
        return this.queryMain(request);
    }

    private SupQueryResult<DisChannelReDomain> queryMain(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"saveChannel.json"}, name="\u589e\u52a0\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveChannel(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".saveChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disChannelDomain.setTenantCode(this.getTenantCode(request));
        return this.disChannelServiceRepository.saveChannel(disChannelDomain);
    }

    @RequestMapping(value={"updateChannelState.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateChannelState(String channelId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".updateChannelState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disChannelServiceRepository.updateChannelState(Integer.valueOf(channelId), dataState, oldDataState);
    }

    @RequestMapping(value={"deleteChannel.json"}, name="\u5220\u9664\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean deleteChannel(Integer channelId) {
        if (StringUtils.isBlank((Integer)channelId)) {
            this.logger.error(CODE + ".deleteChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disChannelServiceRepository.deleteChannel(channelId);
    }

    @RequestMapping(value={"getChannel.json"}, name="\u83b7\u53d6\u6e20\u9053\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisChannelReDomain getChannel(Integer channelId) {
        if (StringUtils.isBlank((Integer)channelId)) {
            this.logger.error(CODE + ".getChannel", (Object)"param is null");
            return null;
        }
        return this.disChannelServiceRepository.getChannel(channelId);
    }
}

