/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dis.domain.DisChannelReDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDictionaryDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDictionaryReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisChannelServiceRepository;
import com.qjsoft.laser.controller.facade.dis.repository.DisDictionaryServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/dictionary"}, name="\u6e20\u9053\u5546\u54c1\u6570\u636e\u5b57\u5178")
public class DictionaryCon
extends SpringmvcController {
    private static String CODE = "dis.dictionary.con";
    @Autowired
    private DisDictionaryServiceRepository disDictionaryServiceRepository;
    @Autowired
    private DisChannelServiceRepository disChannelServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;

    protected String getContext() {
        return "dictionary";
    }

    @RequestMapping(value={"saveDictionary.json"}, name="\u589e\u52a0\u6e20\u9053\u5546\u54c1\u6570\u636e\u5b57\u5178")
    @ResponseBody
    public HtmlJsonReBean saveDictionary(HttpServletRequest request, DisDictionaryDomain disDictionaryDomain) {
        if (null == disDictionaryDomain) {
            this.logger.error(CODE + ".saveDictionary", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveDictionary", (Object)"Usersession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "Usersession is null");
        }
        disDictionaryDomain.setTenantCode(this.getTenantCode(request));
        return this.disDictionaryServiceRepository.saveDictionary(disDictionaryDomain);
    }

    @RequestMapping(value={"getDictionary.json"}, name="\u83b7\u53d6\u6e20\u9053\u5546\u54c1\u6570\u636e\u5b57\u5178\u4fe1\u606f")
    @ResponseBody
    public DisDictionaryReDomain getDictionary(Integer dictionaryId) {
        if (StringUtils.isBlank((Integer)dictionaryId)) {
            this.logger.error(CODE + ".getDictionary", (Object)"param is null");
            return null;
        }
        return this.disDictionaryServiceRepository.getDictionary(dictionaryId);
    }

    @RequestMapping(value={"updateDictionary.json"}, name="\u66f4\u65b0\u6e20\u9053\u5546\u54c1\u6570\u636e\u5b57\u5178")
    @ResponseBody
    public HtmlJsonReBean updateDictionary(HttpServletRequest request, DisDictionaryDomain disDictionaryDomain) {
        if (null == disDictionaryDomain) {
            this.logger.error(CODE + ".updateDictionary", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disDictionaryDomain.setTenantCode(this.getTenantCode(request));
        return this.disDictionaryServiceRepository.updateDictionary(disDictionaryDomain);
    }

    @RequestMapping(value={"deleteDictionary.json"}, name="\u5220\u9664\u6e20\u9053\u5546\u54c1\u6570\u636e\u5b57\u5178")
    @ResponseBody
    public HtmlJsonReBean deleteDictionary(Integer dictionaryId) {
        if (StringUtils.isBlank((Integer)dictionaryId)) {
            this.logger.error(CODE + ".deleteDictionary", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDictionaryServiceRepository.deleteDictionary(dictionaryId);
    }

    @RequestMapping(value={"queryDictionaryPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u5546\u54c1\u6570\u636e\u5b57\u5178\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisDictionaryReDomain> queryDictionaryPage(HttpServletRequest request) {
        SupQueryResult disDictionaryReDomainSupQueryResult;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("dictionaryGoods", "userinfoCode");
        }
        if (null == (disDictionaryReDomainSupQueryResult = this.disDictionaryServiceRepository.queryDictionaryPage(param)) || ListUtil.isEmpty((Collection)disDictionaryReDomainSupQueryResult.getList())) {
            return null;
        }
        for (DisDictionaryReDomain disDictionaryReDomain : disDictionaryReDomainSupQueryResult.getList()) {
            DisChannelReDomain channelByCode;
            if (!"UmUserinfo".equals(disDictionaryReDomain.getDictionaryType()) || null == (channelByCode = this.disChannelServiceRepository.getChannelByCode(disDictionaryReDomain.getTenantCode(), disDictionaryReDomain.getChannelCode()))) continue;
            disDictionaryReDomain.setChannelName(channelByCode.getChannelName());
        }
        return disDictionaryReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateDictionaryState.json"}, name="\u66f4\u65b0\u6e20\u9053\u5546\u54c1\u6570\u636e\u5b57\u5178\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateDictionaryState(String dictionaryId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)dictionaryId)) {
            this.logger.error(CODE + ".updateDictionaryState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDictionaryServiceRepository.updateDictionaryState(Integer.valueOf(dictionaryId), dataState, oldDataState);
    }
}

