/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.dis.controller.ResComCon;
import com.qjsoft.laser.controller.dis.controller.RsClassBean;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceConfDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceConfReDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisChannelServiceRepository;
import com.qjsoft.laser.controller.facade.dis.repository.DisDpriceServiceRepository;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/dprice"}, name="\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
public class DpriceCon
extends ResComCon {
    private static String CODE = "dis.dprice.con";
    @Autowired
    private DisDpriceServiceRepository disDpriceServiceRepository;
    @Autowired
    private DisChannelServiceRepository disChannelServiceRepository;

    @Override
    protected String getContext() {
        return "dprice";
    }

    @RequestMapping(value={"saveDprice.json"}, name="\u589e\u52a0\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveDprice(HttpServletRequest request, DisDpriceDomain disDpriceDomain) {
        if (null == disDpriceDomain) {
            this.logger.error(CODE + ".saveDprice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disDpriceDomain.setTenantCode(this.getTenantCode(request));
        this.copyChannel(disDpriceDomain, disDpriceDomain.getChannelCode(), disDpriceDomain.getTenantCode());
        return this.disDpriceServiceRepository.saveDprice(disDpriceDomain);
    }

    @RequestMapping(value={"saveDpriceAndConf.json"}, name="\u589e\u52a0\u6e20\u9053\u4ef7\u683c\u660e\u7ec6\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveDpriceAndConf(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".saveDprice", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveDprice", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        DisDpriceDomain disDpriceDomain = (DisDpriceDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, DisDpriceDomain.class);
        disDpriceDomain.setTenantCode(this.getTenantCode(request));
        this.copyChannel(disDpriceDomain, disDpriceDomain.getChannelCode(), disDpriceDomain.getTenantCode());
        if (ListUtil.isNotEmpty((Collection)disDpriceDomain.getDisDpriceConfList())) {
            for (DisDpriceConfDomain disDpriceConfDomain : disDpriceDomain.getDisDpriceConfList()) {
                disDpriceConfDomain.setTenantCode(this.getTenantCode(request));
            }
        }
        return this.disDpriceServiceRepository.saveDprice(disDpriceDomain);
    }

    @RequestMapping(value={"saveBatchDpriceAndConf.json"}, name="\u6279\u91cf\u589e\u52a0\u6e20\u9053\u4ef7\u683c\u660e\u7ec6\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveBatchDpriceAndConf(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveDprice", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        List disDpriceDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, DisDpriceDomain.class);
        if (ListUtil.isEmpty((Collection)disDpriceDomainList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> brandMap = new HashMap<String, String>();
        HashMap<String, RsClassBean> classtreeMap = new HashMap<String, RsClassBean>();
        for (DisDpriceDomain disDpriceDomain : disDpriceDomainList) {
            disDpriceDomain.setTenantCode(this.getTenantCode(request));
            this.copyChannel(disDpriceDomain, disDpriceDomain.getChannelCode(), disDpriceDomain.getTenantCode());
            if (!ListUtil.isNotEmpty((Collection)disDpriceDomain.getDisDpriceConfList())) continue;
            ArrayList<DisDpriceConfDomain> otherdisDpriceConfList = new ArrayList<DisDpriceConfDomain>();
            for (DisDpriceConfDomain disDpriceConfDomain : disDpriceDomain.getDisDpriceConfList()) {
                disDpriceConfDomain.setTenantCode(this.getTenantCode(request));
                this.makeCode(disDpriceConfDomain, disDpriceDomain, brandMap, classtreeMap, otherdisDpriceConfList);
            }
            if (!ListUtil.isNotEmpty(otherdisDpriceConfList)) continue;
            disDpriceDomain.getDisDpriceConfList().addAll(otherdisDpriceConfList);
        }
        return this.disDpriceServiceRepository.saveDpriceBatch(disDpriceDomainList);
    }

    private void setClass(DisDpriceConfDomain disDpriceConfDomain, List<DisDpriceConfDomain> otherdisDpriceConfList, List<RsClassBean> rsClassBeanList) {
        if (null == disDpriceConfDomain || null == otherdisDpriceConfList || ListUtil.isEmpty(rsClassBeanList)) {
            return;
        }
        for (int i = 0; i < rsClassBeanList.size(); ++i) {
            if (ListUtil.isEmpty(rsClassBeanList.get(i).getChildList())) {
                if (i == 0) {
                    disDpriceConfDomain.setDpriceConfValue(rsClassBeanList.get(i).getClasstreeCode());
                    disDpriceConfDomain.setDpriceConfValuen(rsClassBeanList.get(i).getClasstreeName());
                    continue;
                }
                DisDpriceConfDomain newDisDpriceConfDomain = new DisDpriceConfDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)newDisDpriceConfDomain, (Object)disDpriceConfDomain);
                    newDisDpriceConfDomain.setDpriceConfValue(rsClassBeanList.get(i).getClasstreeCode());
                    newDisDpriceConfDomain.setDpriceConfValuen(rsClassBeanList.get(i).getClasstreeName());
                    otherdisDpriceConfList.add(newDisDpriceConfDomain);
                }
                catch (Exception exception) {}
                continue;
            }
            this.setClass(disDpriceConfDomain, otherdisDpriceConfList, rsClassBeanList.get(i).getChildList());
        }
    }

    private void makeCode(DisDpriceConfDomain disDpriceConfDomain, DisDpriceDomain disDpriceDomain, Map<String, String> brandMap, Map<String, RsClassBean> classtreeMap, List<DisDpriceConfDomain> otherdisDpriceConfList) {
        if (null == disDpriceConfDomain || null == disDpriceDomain) {
            return;
        }
        disDpriceConfDomain.setTenantCode(disDpriceDomain.getTenantCode());
        if ("classtreeCode".equals(disDpriceConfDomain.getDpriceConfType())) {
            if (StringUtils.isBlank((String)disDpriceConfDomain.getDpriceConfValue()) && StringUtils.isNotBlank((String)disDpriceConfDomain.getDpriceConfValuen())) {
                RsClassBean rsClassBean;
                if (MapUtil.isEmpty(classtreeMap)) {
                    this.getRsClasstree(null, disDpriceDomain.getChannelCode(), disDpriceDomain.getTenantCode(), classtreeMap);
                }
                if (null != (rsClassBean = classtreeMap.get(disDpriceConfDomain.getDpriceConfDes() + "-" + disDpriceConfDomain.getDpriceConfValue()))) {
                    if (ListUtil.isEmpty(rsClassBean.getChildList())) {
                        disDpriceConfDomain.setDpriceConfValue(rsClassBean.getClasstreeCode());
                    } else {
                        this.setClass(disDpriceConfDomain, otherdisDpriceConfList, rsClassBean.getChildList());
                    }
                }
            }
        } else if ("brandCode".equals(disDpriceConfDomain.getDpriceConfType())) {
            if (StringUtils.isBlank((String)disDpriceConfDomain.getDpriceConfValue()) && StringUtils.isNotBlank((String)disDpriceConfDomain.getDpriceConfValuen())) {
                if (MapUtil.isEmpty(brandMap)) {
                    this.getRsBrandAll(disDpriceDomain.getChannelCode(), disDpriceDomain.getTenantCode(), brandMap);
                }
                disDpriceConfDomain.setDpriceConfValue(brandMap.get(disDpriceConfDomain.getDpriceConfValuen()));
            }
        } else if ("warehouseCode".equals(disDpriceConfDomain.getDpriceConfType())) {
            // empty if block
        }
    }

    @RequestMapping(value={"getDprice.json"}, name="\u83b7\u53d6\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisDpriceReDomain getDprice(Integer dpriceConfId) {
        if (StringUtils.isBlank((Integer)dpriceConfId)) {
            this.logger.error(CODE + ".getDprice", (Object)"param is null");
            return null;
        }
        DisDpriceReDomain dprice = this.disDpriceServiceRepository.getDprice(dpriceConfId);
        return dprice;
    }

    @RequestMapping(value={"updateDprice.json"}, name="\u66f4\u65b0\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean updateDprice(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".saveDprice", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveDprice", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        DisDpriceDomain disDpriceDomain = (DisDpriceDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, DisDpriceDomain.class);
        return this.disDpriceServiceRepository.updateDprice(disDpriceDomain);
    }

    @RequestMapping(value={"deleteDprice.json"}, name="\u5220\u9664\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean deleteDprice(Integer dpriceConfId) {
        if (StringUtils.isBlank((Integer)dpriceConfId)) {
            this.logger.error(CODE + ".deleteDprice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceServiceRepository.deleteDprice(dpriceConfId);
    }

    @RequestMapping(value={"queryDpricePage.json"}, name="\u67e5\u8be2\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisDpriceReDomain> queryDpricePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult disDpriceReDomainSupQueryResult = this.disDpriceServiceRepository.queryDpricePage(param);
        return disDpriceReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateDpriceState.json"}, name="\u66f4\u65b0\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateDpriceState(String dpriceConfId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)dpriceConfId)) {
            this.logger.error(CODE + ".updateDpriceState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceServiceRepository.updateDpriceState(Integer.valueOf(dpriceConfId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryDpricePageBySS.json"}, name="\u67e5\u8be2\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisDpriceReDomain> queryDpricePageBySS(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null != param.get("channelSort") && "3".equals(param.get("channelSort"))) {
            param.remove("channelSort");
            param.put("channelType", "1");
        }
        return this.disDpriceServiceRepository.queryDpricePage(param);
    }

    @RequestMapping(value={"saveDisDpriceConfByJson.json"}, name="\u5e93\u5b58\u9002\u7528\u8303\u56f4\u589e\u52a0\u4ed3\u5e93")
    @ResponseBody
    public HtmlJsonReBean saveDisDpriceConfByJson(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        List disDpriceConfDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, DisDpriceConfDomain.class);
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        if (ListUtil.isNotEmpty((Collection)disDpriceConfDomainList)) {
            for (DisDpriceConfDomain disDpriceConfDomain : disDpriceConfDomainList) {
                disDpriceConfDomain.setTenantCode(tenantCode);
            }
            return this.disDpriceServiceRepository.saveDpriceConfBatch(disDpriceConfDomainList);
        }
        return new HtmlJsonReBean((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"getDpriceAndConf.json"}, name="\u83b7\u53d6\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisDpriceReDomain getDpriceAndConf(Integer dpriceId) {
        if (StringUtils.isBlank((Integer)dpriceId)) {
            this.logger.error(CODE + ".getDprice", (Object)"param is null");
            return null;
        }
        return this.disDpriceServiceRepository.getDprice(dpriceId);
    }

    @RequestMapping(value={"deleteDpriceById.json"}, name="\u5220\u9664\u6e20\u9053\u4ef7\u683c")
    @ResponseBody
    public HtmlJsonReBean deleteDpriceById(Integer dpriceId) {
        if (StringUtils.isBlank((Integer)dpriceId)) {
            this.logger.error(CODE + ".deleteDprice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceServiceRepository.deleteDprice(dpriceId);
    }

    @RequestMapping(value={"updateStopDpriceByCode.json"}, name="\u505c\u7528\u6e20\u9053\u4ef7\u683c\uff08\u516c\u7528\uff09")
    @ResponseBody
    public HtmlJsonReBean updateStopDpriceByCode(HttpServletRequest request, String dpriceConfbakCode) {
        if (StringUtils.isBlank((String)dpriceConfbakCode)) {
            this.logger.error(CODE + ".updateStopDpriceById", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceServiceRepository.updateDpriceStateByCode(this.getTenantCode(request), dpriceConfbakCode, Integer.valueOf(3), Integer.valueOf(2));
    }

    @RequestMapping(value={"deleteDpriceConfByPriceCode.json"}, name="\u5220\u9664\u6e20\u9053\u4ef7\u683c")
    @ResponseBody
    public HtmlJsonReBean deleteDpriceConfByPriceCode(HttpServletRequest request, String dpriceCode) {
        if (StringUtils.isBlank((String)dpriceCode)) {
            this.logger.error(CODE + ".deleteDpriceConfByPriceCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceServiceRepository.deleteDpriceConfByPriceCode(this.getTenantCode(request), dpriceCode);
    }

    @RequestMapping(value={"getDpriceConf.json"}, name="\u83b7\u53d6\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisDpriceConfReDomain getDpriceConf(Integer dpriceConfId) {
        if (StringUtils.isBlank((Integer)dpriceConfId)) {
            this.logger.error(CODE + ".getDprice", (Object)"param is null");
            return null;
        }
        return this.disDpriceServiceRepository.getDpriceConf(dpriceConfId);
    }

    @RequestMapping(value={"updateDpriceConf.json"}, name="\u66f4\u65b0\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean updateDpriceConf(HttpServletRequest request, DisDpriceConfDomain disDpriceConfDomain) {
        if (null == disDpriceConfDomain) {
            return new HtmlJsonReBean("error", "param is null");
        }
        disDpriceConfDomain.setTenantCode(this.getTenantCode(request));
        return this.disDpriceServiceRepository.updateDpriceConf(disDpriceConfDomain);
    }

    @RequestMapping(value={"deleteDpriceConf.json"}, name="\u5220\u9664\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean deleteDpriceConf(Integer dpriceConfId) {
        if (StringUtils.isBlank((Integer)dpriceConfId)) {
            this.logger.error(CODE + ".deleteDprice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceServiceRepository.deleteDpriceConf(dpriceConfId);
    }

    @RequestMapping(value={"deleteBatchDpricesConf.json"}, name="\u6279\u91cf\u5220\u9664\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean deleteBatchDpricesConf(String dpriceConfIdList) {
        if (StringUtils.isBlank((String)dpriceConfIdList)) {
            this.logger.error(CODE + ".deleteDpriceConf", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> dpriceConfIdList1 = this.getDpriceConfIdList(dpriceConfIdList);
        return this.disDpriceServiceRepository.deleteBatchDpriceConf(dpriceConfIdList1);
    }

    protected List<Integer> getDpriceConfIdList(String goodsIdStr) {
        String[] idStr = goodsIdStr.split(",");
        ArrayList<Integer> getDpriceConfIdList = new ArrayList<Integer>();
        for (String id : idStr) {
            getDpriceConfIdList.add(Integer.parseInt(id));
        }
        return getDpriceConfIdList;
    }

    @RequestMapping(value={"queryDpriceConfPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisDpriceConfReDomain> queryDpriceConfPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.disDpriceServiceRepository.queryDpriceConfPage(param);
    }
}

