/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dis.domain.DisContractDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisContractReDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisRefundReDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisStatementContractReDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisStatementDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisStatementReDomain;
import com.qjsoft.laser.controller.facade.dis.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisContractServiceRepository;
import com.qjsoft.laser.controller.facade.dis.repository.DisRefundServiceRepository;
import com.qjsoft.laser.controller.facade.dis.repository.DisStatementServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcRefundServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/statement"}, name="\u5bf9\u8d26\u670d\u52a1")
public class StatementCon
extends SpringmvcController {
    private static String CODE = "dis.statement.con";
    @Autowired
    private DisStatementServiceRepository disStatementServiceRepository;
    @Autowired
    private DisContractServiceRepository disContractServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    OcRefundServiceRepository ocRefundServiceRepository;
    @Autowired
    DisRefundServiceRepository disRefundServiceRepository;

    protected String getContext() {
        return "statement";
    }

    @RequestMapping(value={"saveStatement.json"}, name="\u589e\u52a0\u5bf9\u8d26\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveStatement(HttpServletRequest request, DisStatementDomain disStatementDomain) {
        if (null == disStatementDomain) {
            this.logger.error(CODE + ".saveStatement", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disStatementDomain.setTenantCode(this.getTenantCode(request));
        return this.disStatementServiceRepository.saveStatement(disStatementDomain);
    }

    @RequestMapping(value={"getStatement.json"}, name="\u83b7\u53d6\u5bf9\u8d26\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public DisStatementReDomain getStatement(Integer statementId) {
        if (StringUtils.isBlank((Integer)statementId)) {
            this.logger.error(CODE + ".getStatement", (Object)"param is null");
            return null;
        }
        return this.disStatementServiceRepository.getStatement(statementId);
    }

    @RequestMapping(value={"updateStatement.json"}, name="\u66f4\u65b0\u5bf9\u8d26\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateStatement(HttpServletRequest request, DisStatementDomain disStatementDomain) {
        if (null == disStatementDomain) {
            this.logger.error(CODE + ".updateStatement", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disStatementDomain.setTenantCode(this.getTenantCode(request));
        return this.disStatementServiceRepository.updateStatement(disStatementDomain);
    }

    @RequestMapping(value={"deleteStatement.json"}, name="\u5220\u9664\u5bf9\u8d26\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteStatement(Integer statementId) {
        if (StringUtils.isBlank((Integer)statementId)) {
            this.logger.error(CODE + ".deleteStatement", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disStatementServiceRepository.deleteStatement(statementId);
    }

    @RequestMapping(value={"queryStatementPage.json"}, name="\u67e5\u8be2\u5bf9\u8d26\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisStatementReDomain> queryStatementPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.disStatementServiceRepository.queryStatementPage(param);
    }

    @RequestMapping(value={"updateStatementState.json"}, name="\u66f4\u65b0\u5bf9\u8d26\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateStatementState(String statementId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)statementId)) {
            this.logger.error(CODE + ".updateStatementState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disStatementServiceRepository.updateStatementState(Integer.valueOf(statementId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryStatementContractPage.json"}, name="\u67e5\u8be2\u5bf9\u8d26\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisStatementContractReDomain> queryStatementContractPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.disStatementServiceRepository.queryStatementContractPage(param);
    }

    @RequestMapping(value={"queryStatementContractReconciliationPage.json"}, name="\u67e5\u8be2\u5bf9\u8d26\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisStatementContractReDomain> queryStatementContractReconciliationPage(HttpServletRequest request) {
        SupQueryResult disStatementContractReDomainSupQueryResult;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (disStatementContractReDomainSupQueryResult = this.disStatementServiceRepository.queryStatementContractPage(param)) || ListUtil.isEmpty((Collection)disStatementContractReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryStatementContractReconciliationPage.disStatementContractReDomainSupQueryResult.null");
            return disStatementContractReDomainSupQueryResult;
        }
        List disStatementContractReDomainSupQueryResultList = disStatementContractReDomainSupQueryResult.getList();
        for (DisStatementContractReDomain disStatementContractReDomain : disStatementContractReDomainSupQueryResultList) {
            DisContractReDomain contractDomain = this.disContractServiceRepository.getContractByNbCode(this.getTenantCode(request), disStatementContractReDomain.getStatementDiscode(), disStatementContractReDomain.getChannelCode());
            if (null == contractDomain) continue;
            disStatementContractReDomain.setDisContractDomain((DisContractDomain)contractDomain);
            String conJson = JsonUtil.buildNonDefaultBinder().toJson((Object)this.ocContractServiceRepository.getByNbCode(disStatementContractReDomain.getStatementContractCode(), contractDomain.getChannelCode(), contractDomain.getTenantCode()));
            OcContractReDomain contractModelByCodes = (OcContractReDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(conJson, OcContractReDomain.class);
            if (null == contractModelByCodes) {
                this.logger.error(CODE + ".queryStatementContractReconciliationPage.StatementContractCode==" + disStatementContractReDomain.getStatementContractCode());
                continue;
            }
            List<OcContractReDomain> ocContractReDomains = this.create(contractModelByCodes, "0");
            OcContractReDomain ocContractReDomain = ocContractReDomains.get(0);
            disStatementContractReDomain.setOcContractReDomain(ocContractReDomain);
            HashMap<String, String> orderParmMap = new HashMap<String, String>();
            orderParmMap.put("contractNbillcode", contractDomain.getContractNbillcode());
            orderParmMap.put("tenantCode", contractDomain.getTenantCode());
            SupQueryResult disRefundReDomainSupQueryResult = this.disRefundServiceRepository.queryRefundPage(orderParmMap);
            if (null != disRefundReDomainSupQueryResult && ListUtil.isNotEmpty((Collection)disRefundReDomainSupQueryResult.getList())) {
                disStatementContractReDomain.setRefundType(((DisRefundReDomain)disRefundReDomainSupQueryResult.getList().get(0)).getRefundType());
            }
            orderParmMap.put("contractState", "4");
            orderParmMap.put("dataState", "4");
            SupQueryResult ocRefundReDomainSupQueryResult = this.ocRefundServiceRepository.queryRefundReDomainPage(orderParmMap);
            if (null == ocRefundReDomainSupQueryResult || ListUtil.isEmpty((Collection)ocRefundReDomainSupQueryResult.getList())) continue;
            List<OcRefundReDomain> ocRefund = this.createOcRefund(ocRefundReDomainSupQueryResult.getList(), "0");
            disStatementContractReDomain.setRefundErpCode(ocRefund.get(0).getErpCode());
            disStatementContractReDomain.setRefundMoney(ocRefund.get(0).getRefundMoney());
        }
        disStatementContractReDomainSupQueryResult.setList(disStatementContractReDomainSupQueryResultList);
        return disStatementContractReDomainSupQueryResult;
    }

    protected List<OcContractReDomain> create(OcContractReDomain ocContractReDomain, String erpFlag) {
        if (null == ocContractReDomain) {
            return null;
        }
        String nostr = ocContractReDomain.getContractBillcode();
        Map<String, Map<String, Object>> erpMap = this.queryErp(nostr);
        ArrayList<OcContractReDomain> relist = new ArrayList<OcContractReDomain>();
        if (MapUtil.isNotEmpty(erpMap)) {
            Map<String, Object> valueMap = erpMap.get(ocContractReDomain.getContractBillcode());
            if (MapUtil.isNotEmpty(valueMap)) {
                Object erpAmt = valueMap.get("erpAmt");
                if (null == erpAmt) {
                    erpAmt = "0";
                }
                ocContractReDomain.setErpAmt(new BigDecimal(erpAmt.toString()));
                ocContractReDomain.setErpCode((String)valueMap.get("erpCode"));
                ocContractReDomain.setErpDate((String)valueMap.get("erpDate"));
                if (!"2".equals(erpFlag)) {
                    relist.add(ocContractReDomain);
                }
            } else {
                this.logger.info(CODE + ".queryErp.valueMap.null", (Object)("valueMap:" + valueMap));
                if (!"1".equals(erpFlag)) {
                    relist.add(ocContractReDomain);
                }
            }
        } else {
            this.logger.info(CODE + ".queryErp.null", (Object)("erpMap:" + erpMap));
            if (!"1".equals(erpFlag)) {
                relist.add(ocContractReDomain);
            }
        }
        return relist;
    }

    private List<OcRefundReDomain> createOcRefund(List<OcRefundReDomain> list, String erpFlag) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        String nostr = this.getListToString(list);
        Map<String, Map<String, Object>> erpMap = this.queryErp(nostr);
        ArrayList<OcRefundReDomain> relist = new ArrayList<OcRefundReDomain>();
        for (OcRefundReDomain ocRefundReDomain : list) {
            if (MapUtil.isNotEmpty(erpMap)) {
                Map<String, Object> valueMap = erpMap.get(ocRefundReDomain.getRefundCode());
                if (MapUtil.isNotEmpty(valueMap)) {
                    Object erpAmt = valueMap.get("erpAmt");
                    if (null == erpAmt) {
                        erpAmt = "0";
                    }
                    ocRefundReDomain.setErpAmt(new BigDecimal(erpAmt.toString()));
                    ocRefundReDomain.setErpCode((String)valueMap.get("erpCode"));
                    ocRefundReDomain.setErpDate((String)valueMap.get("erpDate"));
                    if ("2".equals(erpFlag)) continue;
                    relist.add(ocRefundReDomain);
                    continue;
                }
                this.logger.info(CODE + ".queryErp.valueMap.null", (Object)("valueMap:" + valueMap));
                if ("1".equals(erpFlag)) continue;
                relist.add(ocRefundReDomain);
                continue;
            }
            this.logger.info(CODE + ".queryErp.null", (Object)("erpMap:" + erpMap));
            if ("1".equals(erpFlag)) continue;
            relist.add(ocRefundReDomain);
        }
        return relist;
    }

    private String getListToString(List<OcRefundReDomain> list) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        String noStr = "";
        for (OcRefundReDomain ocRefundReDomain : list) {
            if (StringUtils.isNotBlank((String)noStr)) {
                noStr = noStr + ",";
            }
            noStr = noStr + ocRefundReDomain.getRefundCode();
        }
        return noStr;
    }

    private Map<String, Map<String, Object>> queryErp(String nostr) {
        if (StringUtils.isBlank((String)nostr)) {
            return null;
        }
        return this.ocContractServiceRepository.queryOrderErpFlag(nostr);
    }
}

