/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.facade.oc.repository;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.send.SupperFacade;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.GoodsBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcCflowReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSettlDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcPackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OrderDomain;
import com.qjsoft.laser.controller.facade.oc.domain.PackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.SkuDomain;
import com.qjsoft.laser.controller.facade.oc.domain.TypeBean;
import com.qjsoft.laser.controller.facade.oc.enumc.ContractSettlType;
import com.qjsoft.laser.controller.facade.oc.enumc.ContractType;
import com.qjsoft.laser.controller.facade.pm.domain.PmCalcDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmContractGoodsDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmInfoBean;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.upm.repository.UpmUpointsServiceRepository;
import com.qjsoft.laser.controller.facade.ur.domain.UrOrderUserDomain;
import com.qjsoft.laser.controller.facade.ur.repository.UrUserrightsServiceRepository;
import com.qjsoft.laser.controller.facade.wl.repository.WlFreightTemServiceRepository;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class OcServiceRepository
extends SupperFacade {
    @Autowired
    private UpmUpointsServiceRepository upmUpointsServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private WlFreightTemServiceRepository wlFreightTemServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private PmPromotionServiceRepository pmPromotionServiceRepository;
    @Autowired
    private UrUserrightsServiceRepository urUserrightsServiceRepository;
    private static String CODE = "oc.OcServiceRepository";
    String CACHE_KEY_CFLOW = "ocProtCflow";

    public TypeBean getOcSetting(String shoppingType, String tenantCode) {
        String memo;
        OcCflowReDomain ocCflowReDomain;
        TypeBean typeBean = null;
        String json = SupDisUtil.getMap((String)this.CACHE_KEY_CFLOW, (String)(shoppingType + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            json = SupDisUtil.getMap((String)this.CACHE_KEY_CFLOW, (String)(shoppingType + "-" + "00000000"));
        }
        if (StringUtils.isNotBlank((String)json) && null != (ocCflowReDomain = (OcCflowReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OcCflowReDomain.class)) && StringUtils.isNotBlank((String)(memo = ocCflowReDomain.getMemo()))) {
            typeBean = (TypeBean)JsonUtil.buildNormalBinder().getJsonToObject(memo, TypeBean.class);
        }
        return typeBean;
    }

    public boolean checkFreight(TypeBean typeBean) {
        if (null == typeBean) {
            return true;
        }
        return StringUtils.isBlank((String)typeBean.getFreight()) || "0".equals(typeBean.getFreight());
    }

    public boolean checkPm(TypeBean typeBean) {
        if (null == typeBean) {
            return true;
        }
        return StringUtils.isBlank((String)typeBean.getPmpay()) || "0".equals(typeBean.getPmpay());
    }

    public boolean checkIntpay(TypeBean typeBean) {
        if (null == typeBean) {
            return true;
        }
        return StringUtils.isBlank((String)typeBean.getIntpay()) || "0".equals(typeBean.getIntpay());
    }

    public HtmlJsonReBean createOcOrder(List<OrderDomain> orderDomainList, String contractType, UserSession userSession, String proappCode, String oauthEnvCode) {
        if (ListUtil.isEmpty(orderDomainList) || null == userSession) {
            this.logger.error(CODE + ".createOcOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<OcContractDomain> ocContractDomainList = new ArrayList<OcContractDomain>();
        ArrayList<Integer> shoppingGoodsIdList = new ArrayList<Integer>();
        String tenantCode = userSession.getTenantCode();
        for (OrderDomain orderDomain : orderDomainList) {
            OcContractDomain contractDomain;
            try {
                contractDomain = this.makeContractDomain(orderDomain, contractType, userSession, proappCode);
                if (null == contractDomain) {
                    this.logger.error(CODE + ".createOcOrder.contractDomain");
                    return new HtmlJsonReBean((Object)(CODE + ".saveContract.contractDomain"));
                }
                contractDomain.setPackageList(this.makePackageDomainList(orderDomain.getPackageList(), contractDomain, shoppingGoodsIdList, orderDomain.getGiftSkuIdList(), oauthEnvCode));
            }
            catch (Exception e) {
                this.logger.error(CODE + ".createOcOrder.ex", (Throwable)e);
                return new HtmlJsonReBean(CODE + ".saveContract.ex", e.getMessage());
            }
            HtmlJsonReBean htmlJsonReBean = this.calculateContract(contractDomain);
            if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
                return htmlJsonReBean;
            }
            ocContractDomainList.add(contractDomain);
        }
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        HashMap<String, String> result = new HashMap<String, String>();
        if (ocContractDomainList.size() > 1) {
            htmlJsonReBean = this.sendBatchContractByDel(ocContractDomainList, shoppingGoodsIdList);
            result.put("contractBbillcode", htmlJsonReBean.getDataObj().toString());
        } else {
            htmlJsonReBean = this.sendContractByDel((OcContractDomain)ocContractDomainList.get(0), shoppingGoodsIdList);
            result.put("contractBillcode", htmlJsonReBean.getDataObj().toString());
        }
        this.sendOrderBigData(ocContractDomainList, tenantCode);
        htmlJsonReBean.setDataObj(result);
        return htmlJsonReBean;
    }

    public void sendOrderBigData(List<OcContractDomain> ocContractDomainList, String tenantCode) {
        if (null == ocContractDomainList || ocContractDomainList.size() == 0) {
            return;
        }
        String bigdataFlag = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-bigdata-bigdataflag"));
        if (StringUtils.isBlank((String)bigdataFlag) || !"true".equals(bigdataFlag)) {
            return;
        }
        for (OcContractDomain ocContractDomain : ocContractDomainList) {
            ocContractDomain.setPackageList(null);
            ocContractDomain.setOcContractSettlList(null);
            String value = "{\"paasLabel\":\"orderPayment\",\"message\":" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain) + "}";
            PostParamMap pmap = new PostParamMap("kafka.adapter.sendProducerInfo");
            pmap.putParam("topic", (Object)"paas_business");
            pmap.putParam("value", (Object)value);
            this.htmlIBaseService.sendMesReBeanInAsync(pmap);
        }
    }

    public HtmlJsonReBean sendBatchContractByDel(List<OcContractDomain> ocContractDomainList, List<Integer> shoppingGoodsIdList) {
        PostParamMap pmap = new PostParamMap("oc.shopping.sendBatchContractByDel");
        pmap.putParamToJson("ocContractDomainList", ocContractDomainList);
        pmap.putParamToJson("shoppingGoodsIdList", shoppingGoodsIdList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public List<OcPackageDomain> makePackageDomainList(List<PackageDomain> packageList, OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList, List<SkuDomain> giftSkuIdList, String oauthEnvCode) throws Exception {
        if (ListUtil.isEmpty(packageList)) {
            throw new Exception("\u5305\u88f9\u4fe1\u606f\u4e3a\u7a7a");
        }
        ArrayList<OcPackageDomain> packageDomainList = new ArrayList<OcPackageDomain>();
        for (PackageDomain packageDomain : packageList) {
            OcPackageDomain ocPackageDomain = this.makePackageDomain(packageDomain, ocContractDomain, giftSkuIdList, oauthEnvCode);
            packageDomainList.add(ocPackageDomain);
            if (null == shoppingGoodsIdList || null == packageDomain.getShoppingGoodsIdList()) continue;
            shoppingGoodsIdList.addAll(packageDomain.getShoppingGoodsIdList());
        }
        return packageDomainList;
    }

    private OcPackageDomain makePackageDomain(PackageDomain packageDomain, OcContractDomain ocContractDomain, List<SkuDomain> giftSkuIdList, String oauthEnvCode) throws Exception {
        HtmlJsonReBean htmlJsonReBean;
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)packageDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".makePackageDomain.ex", (Throwable)e);
            return null;
        }
        BigDecimal contractInMoney = ocContractDomain.getContractInmoney();
        BigDecimal goodsPmoney = BigDecimal.ZERO;
        Map<String, OcContractSettlDomain> smap = this.getListToMap(ocContractDomain.getOcContractSettlList());
        if (null != smap && null != smap.get(ContractSettlType.INT.getCode()) && null != (htmlJsonReBean = this.upmUpointsServiceRepository.deductible(contractInMoney, ocContractDomain.getTenantCode(), ocContractDomain.getMemberBcode(), "0")) && null != htmlJsonReBean.getDataObj()) {
            Map upmMap = (Map)htmlJsonReBean.getDataObj();
            BigDecimal disamount = (BigDecimal)upmMap.get("disamount");
            OcContractSettlDomain intmoney = smap.get(ContractSettlType.INT.getCode());
            if (null != intmoney) {
                if (disamount.compareTo(intmoney.getContractSettlPmoney()) != 0) {
                    throw new Exception("\u79ef\u5206\u4e0d\u4e00\u81f4[" + disamount + "][" + intmoney.getContractSettlPmoney() + "];");
                }
                goodsPmoney = disamount;
            }
        }
        if (ListUtil.isEmpty(packageDomain.getContractGoodsList())) {
            List<OcContractGoodsDomain> goodsList = this.makeContractGoodsDomainList(packageDomain.getShoppingGoodsIdList(), packageDomain.getSkuIdList(), ocContractDomain, giftSkuIdList);
            ocPackageDomain.setContractGoodsList(goodsList);
        } else {
            ocPackageDomain.setContractGoodsList(packageDomain.getContractGoodsList());
        }
        if (null != smap && null != smap.get(ContractSettlType.UR.getCode())) {
            String sysRecode;
            OcContractSettlDomain urMoney = smap.get(ContractSettlType.UR.getCode());
            goodsPmoney = goodsPmoney.add(urMoney.getContractSettlPmoney());
            UrOrderUserDomain urOrderUserDomain = new UrOrderUserDomain();
            urOrderUserDomain.setTenantCode(ocContractDomain.getTenantCode());
            urOrderUserDomain.setUserCode(ocContractDomain.getMemberCode());
            urOrderUserDomain.setDiscountPrice(urMoney.getContractSettlPmoney());
            ArrayList<RsSkuDomain> rsSkuList = new ArrayList<RsSkuDomain>();
            RsSkuDomain rsSkuDomain = null;
            for (int i = 0; i < ocPackageDomain.getContractGoodsList().size(); ++i) {
                OcContractGoodsDomain ocContractGoodsDomain = ocPackageDomain.getContractGoodsList().get(i);
                rsSkuDomain = new RsSkuDomain();
                rsSkuDomain.setSkuCode(ocContractGoodsDomain.getSkuCode());
                rsSkuDomain.setPricesetAsprice(ocContractGoodsDomain.getPricesetAsprice());
                rsSkuDomain.setPricesetRefrice(ocContractGoodsDomain.getPricesetRefrice());
                rsSkuDomain.setPricesetNprice(ocContractGoodsDomain.getPricesetNprice());
                rsSkuDomain.setGoodsNum(ocContractGoodsDomain.getGoodsCamount());
                rsSkuList.add(rsSkuDomain);
            }
            HtmlJsonReBean htmlJsonReBean2 = this.urUserrightsServiceRepository.commitOrder(urOrderUserDomain, rsSkuList);
            if (null != htmlJsonReBean2 && null != htmlJsonReBean2.getSysRecode() && null != (sysRecode = htmlJsonReBean2.getSysRecode()) && "error".equals(sysRecode)) {
                throw new Exception("\u6743\u76ca\u8ba1\u7b97\u4e0d\u4e00\u81f4;");
            }
        }
        OcContractSettlDomain pmOcContractSettlDomain = null;
        if (null != smap && null != smap.get(ContractSettlType.PM.getCode())) {
            pmOcContractSettlDomain = smap.get(ContractSettlType.PM.getCode());
        }
        List<PmCalcDomain> pmCalcDomainList = this.calculate(ocPackageDomain.getContractGoodsList(), goodsPmoney, pmOcContractSettlDomain, oauthEnvCode);
        if (null != smap && (null != smap.get(ContractSettlType.PM.getCode()) || null != smap.get(ContractSettlType.COP.getCode()))) {
            PmInfoBean pmInfoBean;
            ArrayList<com.qjsoft.laser.controller.facade.pm.domain.OcContractSettlDomain> pmContractSettlList = new ArrayList<com.qjsoft.laser.controller.facade.pm.domain.OcContractSettlDomain>();
            com.qjsoft.laser.controller.facade.pm.domain.OcContractSettlDomain pmContractSettlDomain = null;
            OcContractSettlDomain ocContractSettlDomain = smap.get(ContractSettlType.PM.getCode());
            if (null != ocContractSettlDomain) {
                pmContractSettlDomain = new com.qjsoft.laser.controller.facade.pm.domain.OcContractSettlDomain();
                BeanUtils.copyAllPropertys((Object)pmContractSettlDomain, (Object)ocContractSettlDomain);
                pmContractSettlList.add(pmContractSettlDomain);
            }
            if (null != (ocContractSettlDomain = smap.get(ContractSettlType.COP.getCode()))) {
                pmContractSettlDomain = new com.qjsoft.laser.controller.facade.pm.domain.OcContractSettlDomain();
                BeanUtils.copyAllPropertys((Object)pmContractSettlDomain, (Object)ocContractSettlDomain);
                pmContractSettlList.add(pmContractSettlDomain);
            }
            if (null == (pmInfoBean = this.pmPromotionServiceRepository.checkPm(pmCalcDomainList, pmContractSettlList)) || !"true".equals(pmInfoBean.getFlag())) {
                throw new Exception(pmInfoBean.getMsg());
            }
            this.setPmoney(ocPackageDomain.getContractGoodsList(), pmInfoBean);
        }
        this.makePack(ocContractDomain, ocPackageDomain);
        return ocPackageDomain;
    }

    private void setPmoney(List<OcContractGoodsDomain> goodsList, PmInfoBean pmInfoBean) {
        if (ListUtil.isEmpty(goodsList) || null == pmInfoBean || ListUtil.isEmpty((Collection)pmInfoBean.getPmContractGoodsDomainList())) {
            return;
        }
        HashMap<String, PmContractGoodsDomain> pmmap = new HashMap<String, PmContractGoodsDomain>();
        for (PmContractGoodsDomain pmContractGoodsDomain : pmInfoBean.getPmContractGoodsDomainList()) {
            pmmap.put(pmContractGoodsDomain.getSkuCode(), pmContractGoodsDomain);
        }
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            PmContractGoodsDomain pmContractGoodsDomain = (PmContractGoodsDomain)pmmap.get(ocContractGoodsDomain.getSkuCode());
            if (null == pmContractGoodsDomain) continue;
            ocContractGoodsDomain.setContractGoodsPrice(pmContractGoodsDomain.getContractGoodsPrice());
            ocContractGoodsDomain.setContractGoodsMoney(pmContractGoodsDomain.getContractGoodsMoney());
        }
    }

    private List<PmCalcDomain> calculate(List<OcContractGoodsDomain> goodsList, BigDecimal goodsPmoney, OcContractSettlDomain ocContractSettlDomain, String oauthEnvCode) {
        if (ListUtil.isEmpty(goodsList)) {
            return null;
        }
        BigDecimal sumgoodsPmoney = BigDecimal.ZERO;
        BigDecimal onegoodsPmoney = BigDecimal.ZERO;
        BigDecimal goodsInmoney = BigDecimal.ZERO;
        BigDecimal goodsMoney = BigDecimal.ZERO;
        BigDecimal sumgoodsMoney = BigDecimal.ZERO;
        Map<String, List<String>> pmMap = null;
        if (null != ocContractSettlDomain) {
            pmMap = ocContractSettlDomain.getPmMap();
        }
        HashMap<String, PmContractGoodsDomain> pmgoodsMap = new HashMap<String, PmContractGoodsDomain>();
        String memberBcode = null;
        String tenantCode = null;
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            tenantCode = ocContractGoodsDomain.getTenantCode();
            memberBcode = ocContractGoodsDomain.getMemberBcode();
            goodsInmoney = ocContractGoodsDomain.getContractGoodsInmoney();
            if (null == goodsInmoney) {
                goodsInmoney = BigDecimal.ZERO;
            }
            if (null == (goodsMoney = ocContractGoodsDomain.getContractGoodsMoney())) {
                goodsMoney = BigDecimal.ZERO;
            }
            sumgoodsMoney.add(goodsMoney);
            PmContractGoodsDomain pmContractGoodsDomain = new PmContractGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pmContractGoodsDomain, (Object)ocContractGoodsDomain);
            }
            catch (Exception exception) {
                // empty catch block
            }
            pmgoodsMap.put(ocContractGoodsDomain.getSkuCode(), pmContractGoodsDomain);
        }
        ArrayList<PmCalcDomain> pmCalcDomainList = new ArrayList<PmCalcDomain>();
        if (null != pmgoodsMap && !pmgoodsMap.isEmpty()) {
            ArrayList pmContractGoodsDomainList;
            PmCalcDomain pmCalcDomain;
            if (null != pmMap && !pmMap.isEmpty()) {
                for (String key : pmMap.keySet()) {
                    pmCalcDomain = new PmCalcDomain();
                    pmCalcDomainList.add(pmCalcDomain);
                    pmCalcDomain.setMemberBcode(memberBcode);
                    pmCalcDomain.setOauthEnvCode(oauthEnvCode);
                    pmCalcDomain.setTenantCode(tenantCode);
                    pmCalcDomain.setPromotionCode(key);
                    List<String> pmlist = pmMap.get(key);
                    pmContractGoodsDomainList = new ArrayList();
                    for (String skuCode : pmlist) {
                        pmContractGoodsDomainList.add(pmgoodsMap.remove(skuCode));
                    }
                    pmCalcDomain.setPmContractGoodsDomainList(pmContractGoodsDomainList);
                }
            }
            pmCalcDomain = new PmCalcDomain();
            pmCalcDomainList.add(pmCalcDomain);
            pmCalcDomain.setMemberBcode(memberBcode);
            pmCalcDomain.setOauthEnvCode(oauthEnvCode);
            pmCalcDomain.setTenantCode(tenantCode);
            pmCalcDomain.setPromotionCode("");
            pmContractGoodsDomainList = new ArrayList();
            for (String key : pmgoodsMap.keySet()) {
                pmContractGoodsDomainList.add(pmgoodsMap.get(key));
            }
            pmCalcDomain.setPmContractGoodsDomainList(pmContractGoodsDomainList);
        }
        if (null == goodsPmoney || BigDecimal.ZERO.compareTo(goodsPmoney) == 0) {
            return pmCalcDomainList;
        }
        int len = goodsList.size();
        int i = 0;
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            ++i;
            goodsInmoney = ocContractGoodsDomain.getContractGoodsInmoney();
            if (null == goodsInmoney) {
                goodsInmoney = BigDecimal.ZERO;
            }
            if (null == (goodsMoney = ocContractGoodsDomain.getContractGoodsMoney())) {
                goodsMoney = BigDecimal.ZERO;
            }
            if (sumgoodsMoney != BigDecimal.ZERO) {
                onegoodsPmoney = goodsMoney.divide(sumgoodsMoney).multiply(goodsPmoney);
            }
            sumgoodsPmoney = sumgoodsPmoney.add(onegoodsPmoney);
            ocContractGoodsDomain.setContractGoodsMoney(goodsMoney.subtract(onegoodsPmoney));
            if (i != len) continue;
            goodsMoney = ocContractGoodsDomain.getContractGoodsMoney();
            if (null == goodsMoney) {
                goodsMoney = BigDecimal.ZERO;
            }
            ocContractGoodsDomain.setContractGoodsMoney(goodsMoney.add(goodsPmoney.subtract(sumgoodsPmoney)));
        }
        return pmCalcDomainList;
    }

    public OcShoppingGoodsReDomain getShoppingGoods(Integer shoppingGoodsId) {
        PostParamMap pmap = new PostParamMap("oc.shopping.getShoppingGoods");
        pmap.putParam("shoppingGoodsId", (Object)shoppingGoodsId);
        return (OcShoppingGoodsReDomain)this.htmlIBaseService.senReObject(pmap, OcShoppingGoodsReDomain.class);
    }

    public List<OcContractGoodsDomain> makeContractGoodsDomainList(List<Integer> shoppingGoodsIdList, List<SkuDomain> skuIdList, OcContractDomain ocContractDomain, List<SkuDomain> giftSkuIdList) throws Exception {
        RsSkuReDomain rsSkuReDomain;
        RsResourceGoodsReDomain rsResourceGoodsReDomain;
        HashMap<String, String> map;
        OcContractGoodsDomain contractGoodsDomain;
        if (ListUtil.isEmpty(shoppingGoodsIdList) && ListUtil.isEmpty(skuIdList)) {
            this.logger.info(CODE + ".makeContractGoodsDomainList.shoppingGoodsIdList.empty", (Object)"\u8d2d\u7269\u8f66\u53c2\u6570\u4e3a\u7a7a");
            throw new Exception("\u8d2d\u7269\u8f66\u6570\u636e\u4e3a\u7a7a");
        }
        boolean shop = true;
        shop = !ListUtil.isEmpty(shoppingGoodsIdList);
        ArrayList<OcContractGoodsDomain> contractGoodsDomainList = new ArrayList<OcContractGoodsDomain>();
        if (shop) {
            for (Integer id : shoppingGoodsIdList) {
                contractGoodsDomain = new OcContractGoodsDomain();
                OcShoppingGoodsReDomain ocShoppingGoodsReDomain = this.getShoppingGoods(id);
                if (ocShoppingGoodsReDomain == null) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.shoppingGoodsId", (Object)("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728  " + id));
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (!ocShoppingGoodsReDomain.getMemberBcode().equals(ocContractDomain.getMemberBcode())) {
                    this.logger.error(CODE, (Object)String.format("\u8d2d\u7269\u8f66\u8d2d\u4e70\u4eba\u4e0e\u767b\u5f55\u8d26\u53f7\u4e0d\u4e00\u81f4\uff0cshoppingGoodsId=%s,\u6240\u6709\u8005\u8d26\u53f7=%s,\u767b\u5f55\u8d26\u53f7=%s", id, ocShoppingGoodsReDomain.getMemberBcode(), ocContractDomain.getMemberBcode()));
                    throw new Exception("\u8d2d\u7269\u8f66\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                }
                if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                    ocContractDomain.setMemberCode(ocShoppingGoodsReDomain.getMemberCode());
                    ocContractDomain.setMemberName(ocShoppingGoodsReDomain.getMemberName());
                }
                if (null == ocShoppingGoodsReDomain.getGoodsSupplynum() || ocShoppingGoodsReDomain.getGoodsSupplynum().subtract(ocShoppingGoodsReDomain.getGoodsCamount()).intValue() < 0) {
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
                }
                map = new HashMap();
                map.put("goodsCode", ocShoppingGoodsReDomain.getGoodsCode());
                map.put("tenantCode", ocShoppingGoodsReDomain.getTenantCode());
                rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(CODE + ".rsResourceGoodsReDomain.goodsCode", (Object)"\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728  ");
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsResourceGoodsReDomain);
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)ocShoppingGoodsReDomain);
                ocContractDomain.setChannelCode(rsResourceGoodsReDomain.getChannelCode());
                ocContractDomain.setChannelName(rsResourceGoodsReDomain.getChannelName());
                ocContractDomain.setMschannelCode(rsResourceGoodsReDomain.getMschannelCode());
                ocContractDomain.setMschannelName(rsResourceGoodsReDomain.getMschannelName());
                contractGoodsDomain.setMemberBcode(ocContractDomain.getMemberBcode());
                contractGoodsDomain.setMemberBname(ocContractDomain.getMemberBname());
                contractGoodsDomain.setGoodsCamount(ocShoppingGoodsReDomain.getGoodsCamount());
                contractGoodsDomain.setGoodsCweight(ocShoppingGoodsReDomain.getGoodsCweight());
                contractGoodsDomain.setGoodsNum(ocShoppingGoodsReDomain.getGoodsCamount());
                contractGoodsDomain.setGoodsCamount(ocShoppingGoodsReDomain.getGoodsCamount());
                contractGoodsDomain.setGoodsWeight(ocShoppingGoodsReDomain.getGoodsCweight());
                if (null == ocShoppingGoodsReDomain.getPricesetRefrice()) {
                    ocShoppingGoodsReDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                contractGoodsDomain.setContractGoodsPefprice(ocShoppingGoodsReDomain.getPricesetRefrice());
                this.makeGoods(contractGoodsDomain);
                contractGoodsDomainList.add(contractGoodsDomain);
            }
        } else {
            for (SkuDomain skuDomain : skuIdList) {
                contractGoodsDomain = new OcContractGoodsDomain();
                rsSkuReDomain = null;
                if (null != skuDomain.getSkuId()) {
                    rsSkuReDomain = this.rsSkuServiceRepository.getSku(skuDomain.getSkuId());
                } else if (StringUtils.isNotBlank((String)skuDomain.getSkuCode())) {
                    map = new HashMap<String, String>();
                    map.put("skuCode", skuDomain.getSkuCode());
                    map.put("tenantCode", ocContractDomain.getTenantCode());
                    rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(map);
                }
                if (null == rsSkuReDomain) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuCode", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuCode()));
                    throw new Exception("\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    throw new Exception("\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u5e93\u5b58\u4e0d\u8db3");
                }
                map = new HashMap();
                map.put("goodsCode", rsSkuReDomain.getGoodsCode());
                map.put("tenantCode", rsSkuReDomain.getTenantCode());
                rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuId", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    throw new Exception("\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                    ocContractDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode());
                    ocContractDomain.setMemberName(rsResourceGoodsReDomain.getMemberName());
                }
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsResourceGoodsReDomain);
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsSkuReDomain);
                ocContractDomain.setChannelCode(rsResourceGoodsReDomain.getChannelCode());
                ocContractDomain.setChannelName(rsResourceGoodsReDomain.getChannelName());
                ocContractDomain.setMschannelCode(rsResourceGoodsReDomain.getMschannelCode());
                ocContractDomain.setMschannelName(rsResourceGoodsReDomain.getMschannelName());
                contractGoodsDomain.setMemberBcode(ocContractDomain.getMemberBcode());
                contractGoodsDomain.setMemberBname(ocContractDomain.getMemberBname());
                contractGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                contractGoodsDomain.setGoodsCamount(skuDomain.getGoodsNum());
                contractGoodsDomain.setGoodsCweight(null == skuDomain.getGoodsWeght() ? BigDecimal.ZERO : skuDomain.getGoodsWeght());
                contractGoodsDomain.setGoodsNum(skuDomain.getGoodsNum());
                contractGoodsDomain.setGoodsWeight(skuDomain.getGoodsWeght());
                if (null == rsSkuReDomain.getPricesetRefrice()) {
                    rsSkuReDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                contractGoodsDomain.setContractGoodsPefprice(rsSkuReDomain.getPricesetRefrice());
                this.makeGoods(contractGoodsDomain);
                contractGoodsDomainList.add(contractGoodsDomain);
            }
        }
        if (null != giftSkuIdList && giftSkuIdList.size() > 0) {
            for (SkuDomain skuDomain : giftSkuIdList) {
                contractGoodsDomain = new OcContractGoodsDomain();
                rsSkuReDomain = null;
                if (null != skuDomain.getSkuId()) {
                    rsSkuReDomain = this.rsSkuServiceRepository.getSku(skuDomain.getSkuId());
                } else if (StringUtils.isNotBlank((String)skuDomain.getSkuCode())) {
                    map = new HashMap();
                    map.put("skuCode", skuDomain.getSkuCode());
                    map.put("tenantCode", ocContractDomain.getTenantCode());
                    rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(map);
                }
                if (null == rsSkuReDomain) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuId", (Object)("\u8d60\u54c1\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    throw new Exception("\u8d60\u54c1\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    throw new Exception("\u8d60\u54c1\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u5e93\u5b58\u4e0d\u8db3");
                }
                map = new HashMap();
                map.put("goodsCode", rsSkuReDomain.getGoodsCode());
                map.put("tenantCode", rsSkuReDomain.getTenantCode());
                rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuId", (Object)("\u8d60\u54c1\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    throw new Exception("\u8d60\u54c1\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                    ocContractDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode());
                    ocContractDomain.setMemberName(rsResourceGoodsReDomain.getMemberName());
                }
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsResourceGoodsReDomain);
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsSkuReDomain);
                contractGoodsDomain.setMemberBcode(ocContractDomain.getMemberBcode());
                contractGoodsDomain.setMemberBname(ocContractDomain.getMemberBname());
                contractGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                contractGoodsDomain.setGoodsCamount(skuDomain.getGoodsNum());
                contractGoodsDomain.setGoodsCweight(null == skuDomain.getGoodsWeght() ? BigDecimal.ZERO : skuDomain.getGoodsWeght());
                contractGoodsDomain.setGoodsNum(skuDomain.getGoodsNum());
                contractGoodsDomain.setGoodsWeight(skuDomain.getGoodsWeght());
                contractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsPefmoney(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsPefprice(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsAppraise(0);
                contractGoodsDomain.setRefundFlag(0);
                contractGoodsDomainList.add(contractGoodsDomain);
            }
        }
        if (ListUtil.isEmpty(contractGoodsDomainList)) {
            this.logger.info(CODE + ".makeContractGoodsDomainList.contractGoodsDomainList.empty", (Object)"\u8d2d\u7269\u8f66\u4e3a\u7a7a");
            throw new Exception("\u8d2d\u7269\u8f66\u4e3a\u7a7a");
        }
        return contractGoodsDomainList;
    }

    public HtmlJsonReBean sendContractByDel(OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList) {
        PostParamMap pmap = new PostParamMap("oc.shopping.sendContractByDel");
        pmap.putParamToJson("ocContractDomain", (Object)ocContractDomain);
        pmap.putParamToJson("shoppingGoodsIdList", shoppingGoodsIdList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean calculateContract(OcContractDomain contractDomain) {
        BigDecimal goodsNum = BigDecimal.ZERO;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal contractInmoney = BigDecimal.ZERO;
        BigDecimal contractMoney = BigDecimal.ZERO;
        BigDecimal dataBnum = BigDecimal.ZERO;
        BigDecimal dataBweight = BigDecimal.ZERO;
        BigDecimal goodsLogmoney = BigDecimal.ZERO;
        BigDecimal pefMoney = BigDecimal.ZERO;
        String goodsPmbillno = "";
        for (OcPackageDomain ocPackageDomain : contractDomain.getPackageList()) {
            if (null == ocPackageDomain.getGoodsNum()) {
                ocPackageDomain.setGoodsNum(BigDecimal.ZERO);
            }
            goodsNum = goodsNum.add(ocPackageDomain.getGoodsNum());
            if (null == ocPackageDomain.getGoodsWeight()) {
                ocPackageDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            goodsWeight = goodsWeight.add(ocPackageDomain.getGoodsWeight());
            if (null == ocPackageDomain.getGoodsMoney()) {
                ocPackageDomain.setGoodsMoney(BigDecimal.ZERO);
            }
            contractInmoney = contractInmoney.add(ocPackageDomain.getGoodsMoney());
            goodsLogmoney = goodsLogmoney.add(new BigDecimal(ocPackageDomain.getPackageFare()));
            if (null == ocPackageDomain.getGoodsPmoney()) {
                ocPackageDomain.setGoodsPmoney(BigDecimal.ZERO);
            }
            contractMoney = contractMoney.add(ocPackageDomain.getGoodsPmoney());
            if (null == ocPackageDomain.getPricesetRefrice()) {
                ocPackageDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            pefMoney = pefMoney.add(ocPackageDomain.getPricesetRefrice());
            if (!StringUtils.isNotBlank((String)ocPackageDomain.getGoodsPmbillno())) continue;
            goodsPmbillno = goodsPmbillno + ";" + ocPackageDomain.getGoodsPmbillno();
        }
        if (StringUtils.isNotBlank((String)goodsPmbillno)) {
            goodsPmbillno = goodsPmbillno.substring(1);
        }
        dataBnum = goodsNum;
        dataBweight = goodsWeight;
        List<OcContractSettlDomain> ocContractSettlDomainList = contractDomain.getOcContractSettlList();
        if (null == ocContractSettlDomainList) {
            ocContractSettlDomainList = new ArrayList<OcContractSettlDomain>();
        }
        contractDomain.setOcContractSettlList(ocContractSettlDomainList);
        contractDomain.setPricesetRefrice(pefMoney);
        contractDomain.setGoodsNum(goodsNum);
        contractDomain.setGoodsWeight(goodsWeight);
        contractDomain.setContractInmoney(contractInmoney);
        contractDomain.setContractMoney(contractMoney);
        contractDomain.setDataBnum(dataBnum);
        contractDomain.setDataBweight(dataBweight);
        contractDomain.setDataBmoney(contractMoney.add(pefMoney).add(goodsLogmoney));
        contractDomain.setGoodsLogmoney(goodsLogmoney);
        contractDomain.setGoodsPmoney(contractInmoney.subtract(contractMoney));
        contractDomain.setGoodsPmbillno(goodsPmbillno);
        return new HtmlJsonReBean();
    }

    private Map<String, OcContractSettlDomain> getListToMap(List<OcContractSettlDomain> ocContractSettlDomainList) {
        if (ListUtil.isEmpty(ocContractSettlDomainList)) {
            return null;
        }
        HashMap<String, OcContractSettlDomain> map = new HashMap<String, OcContractSettlDomain>();
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlDomainList) {
            map.put(ocContractSettlDomain.getContractSettlBlance(), ocContractSettlDomain);
        }
        for (ContractSettlType contractSettlType : ContractSettlType.values()) {
            OcContractSettlDomain ocContractSettlDomain = (OcContractSettlDomain)map.get(contractSettlType.getCode());
            if (null == ocContractSettlDomain) continue;
            ocContractSettlDomain.setContractSettlType(contractSettlType.getType());
        }
        return map;
    }

    public void makePack(OcContractDomain ocContractDomain, OcPackageDomain ocPackageDomain) throws Exception {
        if (null == ocPackageDomain || null == ocContractDomain) {
            return;
        }
        BigDecimal goodsMoney = BigDecimal.ZERO;
        BigDecimal goodsInmoney = BigDecimal.ZERO;
        BigDecimal goodsPef = BigDecimal.ZERO;
        BigDecimal packageGoodsWeight = BigDecimal.ZERO;
        BigDecimal packageGoodsNum = BigDecimal.ZERO;
        for (OcContractGoodsDomain ocContractGoodsDomain : ocPackageDomain.getContractGoodsList()) {
            if (null == ocContractGoodsDomain.getGoodsNum()) {
                ocContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            packageGoodsNum = packageGoodsNum.add(ocContractGoodsDomain.getGoodsNum());
            if (null == ocContractGoodsDomain.getContractGoodsInmoney()) {
                ocContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
            }
            goodsInmoney = goodsInmoney.add(ocContractGoodsDomain.getContractGoodsInmoney());
            if (null == ocContractGoodsDomain.getContractGoodsMoney()) {
                ocContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
            }
            goodsMoney = goodsMoney.add(ocContractGoodsDomain.getContractGoodsMoney());
            if (null == ocContractGoodsDomain.getContractGoodsPefinmoney()) {
                ocContractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
            }
            goodsPef = goodsPef.add(ocContractGoodsDomain.getContractGoodsPefinmoney());
            if (null == ocContractGoodsDomain.getGoodsWeight()) {
                ocContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            packageGoodsWeight = packageGoodsWeight.add(ocContractGoodsDomain.getGoodsWeight());
            if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                ocContractDomain.setMemberCode(ocContractGoodsDomain.getMemberCode());
                ocContractDomain.setMemberName(ocContractGoodsDomain.getMemberName());
            }
            if (!StringUtils.isBlank((String)ocPackageDomain.getMemberCode())) continue;
            ocPackageDomain.setMemberCode(ocContractGoodsDomain.getMemberCode());
            ocPackageDomain.setMemberName(ocContractGoodsDomain.getMemberName());
        }
        ocPackageDomain.setGoodsWeight(packageGoodsWeight);
        ocPackageDomain.setGoodsNum(packageGoodsNum);
        ocPackageDomain.setWarehouseName(ocContractDomain.getWarehouseName());
        ocPackageDomain.setMemberBcode(ocContractDomain.getMemberBcode());
        ocPackageDomain.setMemberBname(ocContractDomain.getMemberBname());
        BigDecimal freightFare = BigDecimal.ZERO;
        TypeBean typeBean = this.getOcSetting(ocContractDomain.getContractType(), ocContractDomain.getTenantCode());
        if (null == typeBean || this.checkFreight(typeBean)) {
            freightFare = this.getFreightFare(ocPackageDomain.getContractGoodsList(), ocContractDomain.getAreaCode());
        }
        if (null == freightFare) {
            freightFare = BigDecimal.ZERO;
        }
        ocPackageDomain.setPackageFare(freightFare.toString());
        ocPackageDomain.setGoodsMoney(goodsInmoney);
        ocPackageDomain.setPricesetRefrice(goodsPef);
        ocPackageDomain.setGoodsPmoney(goodsMoney);
    }

    public BigDecimal getFreightFare(List<OcContractGoodsDomain> ocContractGoodsDomainList, String areaCode) throws Exception {
        String freightExpCode;
        if (ListUtil.isEmpty(ocContractGoodsDomainList)) {
            throw new Exception("\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)areaCode)) {
            return BigDecimal.ZERO;
        }
        HashMap<String, String> skuParamMap = new HashMap<String, String>();
        HashMap<String, String> expParamMap = new HashMap<String, String>();
        HashMap<String, BigDecimal> quantityMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> weightMap = new HashMap<String, BigDecimal>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomainList) {
            RsSkuReDomain rsSkuReDomain;
            skuParamMap.clear();
            skuParamMap.put("skuCode", ocContractGoodsDomain.getSkuCode());
            if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getTenantCode())) {
                skuParamMap.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            }
            if ((rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(skuParamMap)) == null) {
                throw new Exception("\u5546\u54c1sku\u4fe1\u606f\u6709\u8bef" + ((Object)skuParamMap).toString());
            }
            freightExpCode = rsSkuReDomain.getFreightTemCode();
            if (StringUtils.isBlank((String)freightExpCode)) continue;
            BigDecimal cquantity = (BigDecimal)quantityMap.get(freightExpCode);
            if (cquantity == null) {
                cquantity = BigDecimal.ZERO;
            }
            cquantity = cquantity.add(ocContractGoodsDomain.getGoodsNum());
            quantityMap.put(freightExpCode, cquantity);
            BigDecimal cweight = (BigDecimal)weightMap.get(freightExpCode);
            if (cweight == null) {
                cweight = BigDecimal.ZERO;
            }
            if (ocContractGoodsDomain.getGoodsWeight() != null) {
                cweight = cweight.add(ocContractGoodsDomain.getGoodsWeight());
            }
            weightMap.put(freightExpCode, cweight);
        }
        BigDecimal freightFare = BigDecimal.ZERO;
        for (Map.Entry entry : quantityMap.entrySet()) {
            freightExpCode = (String)entry.getKey();
            expParamMap.clear();
            expParamMap.put("freightExpCode", freightExpCode);
            expParamMap.put("areaCode", areaCode);
            expParamMap.put("quantity", (String)entry.getValue());
            expParamMap.put("weight", (String)weightMap.get(freightExpCode));
            BigDecimal fare = this.wlFreightTemServiceRepository.getFreightFare(expParamMap);
            if (fare == null) continue;
            freightFare = freightFare.add(fare);
        }
        return freightFare;
    }

    public void makeGoods(OcContractGoodsDomain contractGoodsDomain) {
        if (null == contractGoodsDomain) {
            return;
        }
        if (null == contractGoodsDomain.getPricesetNprice()) {
            contractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
        }
        BigDecimal inmoney = contractGoodsDomain.getPricesetNprice().multiply(contractGoodsDomain.getGoodsNum());
        contractGoodsDomain.setContractGoodsInmoney(inmoney);
        if (null == contractGoodsDomain.getPricesetRefrice()) {
            contractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
        }
        BigDecimal refmoney = contractGoodsDomain.getPricesetRefrice().multiply(contractGoodsDomain.getGoodsNum());
        contractGoodsDomain.setContractGoodsPefinmoney(refmoney);
        contractGoodsDomain.setContractGoodsPefmoney(refmoney);
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal contractGoodsMoney = inmoney.subtract(discountAmount);
        if (null != contractGoodsDomain.getGoodsNum() && BigDecimal.ZERO.compareTo(contractGoodsDomain.getGoodsNum()) != 0) {
            contractGoodsDomain.setContractGoodsPrice(contractGoodsMoney.divide(contractGoodsDomain.getGoodsNum(), 2, 4));
        }
        contractGoodsDomain.setContractGoodsMoney(contractGoodsMoney);
        contractGoodsDomain.setContractGoodsAppraise(0);
        contractGoodsDomain.setRefundFlag(0);
    }

    public OcContractDomain makeContractDomain(OrderDomain orderDomain, String contractType, UserSession userSession, String proappCode) throws Exception {
        if (null == userSession || null == orderDomain) {
            this.logger.error("OcServiceRepository.saveContract", (Object)"UserSession is null");
            return null;
        }
        OcContractDomain contractDomain = new OcContractDomain();
        try {
            BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orderDomain);
        }
        catch (Exception e) {
            this.logger.error("OcServiceRepository.makeContractDomain.ex", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)contractDomain.getContractType())) {
            if (StringUtils.isBlank((String)contractType)) {
                contractType = ContractType.CON.getCode();
            }
            contractDomain.setContractType(contractType);
        }
        this.createPackageDomainListOnOrder_temp(orderDomain);
        contractDomain.setMemberBcode(userSession.getUserPcode());
        contractDomain.setMemberBname(userSession.showUserName());
        contractDomain.setTenantCode(userSession.getTenantCode());
        contractDomain.setAppmanageIcode(proappCode);
        return contractDomain;
    }

    private List<PackageDomain> createPackageDomainListOnOrder_temp(OrderDomain orderDomain) {
        PackageDomain packageDomain;
        List<PackageDomain> packageDomainList = orderDomain.getPackageList();
        if (packageDomainList == null) {
            packageDomainList = new ArrayList<PackageDomain>();
        }
        if (packageDomainList.isEmpty()) {
            packageDomain = new PackageDomain();
            packageDomainList.add(packageDomain);
            orderDomain.setPackageList(packageDomainList);
        } else {
            packageDomain = packageDomainList.get(0);
        }
        if (StringUtils.isNotBlank((String)orderDomain.getPackageMode())) {
            packageDomain.setPackageMode(orderDomain.getPackageMode());
        } else {
            packageDomain.setPackageMode("0");
        }
        packageDomain.setShoppingGoodsIdList(orderDomain.getShoppingGoodsIdList());
        packageDomain.setSkuIdList(orderDomain.getSkuIdList());
        return packageDomainList;
    }

    public OcShoppingDomain makeOcShoppingDomain(UserSession userSession, Integer skuId, BigDecimal goodsNum, BigDecimal goodsWeght, String shoppingType, String contractNbillcode) {
        RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSku(skuId);
        if (null == rsSkuReDomain) {
            return null;
        }
        return this.makeOcShoppingDomain(userSession, rsSkuReDomain, goodsNum, goodsWeght, shoppingType, contractNbillcode, null);
    }

    public List<OcShoppingDomain> makeOcShoppingDomainList(UserSession userSession, List<GoodsBean> skuCodeList) {
        if (ListUtil.isEmpty(skuCodeList) || null == userSession) {
            this.logger.error(CODE + ".makeOcShoppingDomainList", (Object)"param is null");
            return null;
        }
        ArrayList<OcShoppingDomain> ocShoppingDomainList = new ArrayList<OcShoppingDomain>();
        HashMap<String, String> map = new HashMap<String, String>();
        for (GoodsBean goodsBean : skuCodeList) {
            map.put("skuCode", goodsBean.getSkuCode());
            map.put("tenantCode", userSession.getTenantCode());
            RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(map);
            if (null == rsSkuReDomain) {
                return null;
            }
            OcShoppingDomain ocShoppingDomain = this.makeOcShoppingDomain(userSession, rsSkuReDomain, goodsBean.getGoodsNum(), goodsBean.getGoodsWeght(), goodsBean.getShoppingType(), goodsBean.getContractNbillcode(), goodsBean.getPricesetType());
            ocShoppingDomainList.add(ocShoppingDomain);
        }
        return ocShoppingDomainList;
    }

    public OcShoppingDomain makeOcShoppingDomain(UserSession userSession, String skuCode, BigDecimal goodsNum, BigDecimal goodsWeght, String shoppingType, String contractNbillcode, String pricesetType) {
        if (StringUtils.isBlank((String)skuCode) || null == userSession) {
            this.logger.error(CODE + ".saveShoppingSkuCode", (Object)"param is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", userSession.getTenantCode());
        RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(map);
        if (null == rsSkuReDomain) {
            return null;
        }
        return this.makeOcShoppingDomain(userSession, rsSkuReDomain, goodsNum, goodsWeght, shoppingType, contractNbillcode, pricesetType);
    }

    private OcShoppingDomain makeOcShoppingDomain(UserSession userSession, RsSkuReDomain rsSkuReDomain, BigDecimal goodsNum, BigDecimal goodsWeght, String shoppingType, String contractNbillcode, String pricesetType) {
        if (null == rsSkuReDomain) {
            return null;
        }
        if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
            this.logger.error(CODE + ".makeOcShoppingDomain.rsSkuReDomain", (Object)"GoodsSupplynum is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("goodsCode", rsSkuReDomain.getGoodsCode());
        map.put("tenantCode", rsSkuReDomain.getTenantCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
        if (null == rsResourceGoodsReDomain) {
            return null;
        }
        if (1 != rsResourceGoodsReDomain.getDataOpbillstate()) {
            return null;
        }
        OcShoppingDomain ocShoppingDomain = new OcShoppingDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingDomain, (Object)rsResourceGoodsReDomain);
            BeanUtils.copyAllPropertys((Object)ocShoppingDomain, (Object)rsSkuReDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".makeOcShoppingDomain.e", (Throwable)e);
            return null;
        }
        if (userSession.getUserPcode().equals(ocShoppingDomain.getMemberCode())) {
            this.logger.error(CODE + ".makeOcShoppingDomain.memberCode", (Object)"\u81ea\u5df1\u4e70\u81ea\u5df1");
            return null;
        }
        if (StringUtils.isNotBlank((String)shoppingType)) {
            ocShoppingDomain.setShoppingType(shoppingType);
        } else {
            ocShoppingDomain.setShoppingType(StringUtils.fillLeft((String)rsSkuReDomain.getGoodsType(), (char)'0', (int)2));
        }
        if (StringUtils.isNotBlank((String)pricesetType)) {
            ocShoppingDomain.setPricesetType(pricesetType);
        } else {
            ocShoppingDomain.setPricesetType(StringUtils.fillLeft((String)(StringUtils.isBlank((String)rsSkuReDomain.getGoodsPro()) ? "0" : rsSkuReDomain.getGoodsPro()), (char)'0', (int)2));
        }
        ocShoppingDomain.setMemberBcode(userSession.getUserPcode());
        ocShoppingDomain.setMemberBname(userSession.getMerberCompname());
        ocShoppingDomain.setTenantCode(rsSkuReDomain.getTenantCode());
        ocShoppingDomain.setGoodsOrigin(rsSkuReDomain.getGoodsOrigin());
        ocShoppingDomain.setContractNbillcode(contractNbillcode);
        OcShoppingGoodsDomain ocShoppingGoodsDomain = new OcShoppingGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingGoodsDomain, (Object)rsResourceGoodsReDomain);
            BeanUtils.copyAllPropertys((Object)ocShoppingGoodsDomain, (Object)rsSkuReDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".makeOcShoppingDomain.e1", (Throwable)e);
            return null;
        }
        if (null == goodsNum) {
            goodsNum = new BigDecimal(1);
        }
        if (null == goodsWeght) {
            goodsWeght = new BigDecimal(1);
        }
        ocShoppingDomain.setShoppingCamount(goodsNum);
        ocShoppingDomain.setShoppingCweight(goodsWeght);
        ocShoppingDomain.setGoodsMoney(ocShoppingDomain.getShoppingCamount().multiply(rsSkuReDomain.getPricesetNprice()));
        if (null == rsSkuReDomain.getPricesetRefrice()) {
            rsSkuReDomain.setPricesetRefrice(new BigDecimal("0"));
        }
        ocShoppingDomain.setPricesetRefrice(ocShoppingDomain.getShoppingCamount().multiply(rsSkuReDomain.getPricesetRefrice()));
        ocShoppingGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
        ocShoppingGoodsDomain.setGoodsCamount(goodsNum);
        ocShoppingGoodsDomain.setGoodsCweight(goodsWeght);
        ocShoppingGoodsDomain.setShoppingGoodsAmount(rsSkuReDomain.getGoodsHangnum());
        ocShoppingGoodsDomain.setShoppingGoodsWeight(rsSkuReDomain.getGoodsHangweight());
        ocShoppingGoodsDomain.setMemberBcode(ocShoppingDomain.getMemberBcode());
        ocShoppingGoodsDomain.setMemberBname(ocShoppingDomain.getMemberBname());
        ocShoppingGoodsDomain.setTenantCode(ocShoppingDomain.getTenantCode());
        ArrayList<OcShoppingGoodsDomain> goodslist = new ArrayList<OcShoppingGoodsDomain>();
        goodslist.add(ocShoppingGoodsDomain);
        ArrayList<OcPackageDomain> pageList = new ArrayList<OcPackageDomain>();
        OcPackageDomain ocPackage = new OcPackageDomain();
        ocPackage.setShoppingGoodsList(goodslist);
        pageList.add(ocPackage);
        ocShoppingDomain.setPackageList(pageList);
        return ocShoppingDomain;
    }

    public List<OcShoppingReDomain> queryToContractDomain(OcShoppingDomain ocShoppingDomain, String platMemberCode) {
        if (null == ocShoppingDomain) {
            return null;
        }
        ArrayList<OcShoppingReDomain> list = new ArrayList<OcShoppingReDomain>();
        OcShoppingReDomain ocShoppingReDomain = new OcShoppingReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingReDomain, (Object)ocShoppingDomain);
        }
        catch (Exception e) {
            return null;
        }
        list.add(ocShoppingReDomain);
        this.makePm(list, platMemberCode);
        return list;
    }

    public List<OcShoppingReDomain> queryToContractDomainList(List<OcShoppingDomain> ocShoppingDomainList, String platMemberCode) {
        if (ListUtil.isEmpty(ocShoppingDomainList)) {
            return null;
        }
        ArrayList<OcShoppingReDomain> list = new ArrayList<OcShoppingReDomain>();
        for (OcShoppingDomain ocShoppingDomain : ocShoppingDomainList) {
            OcShoppingReDomain ocShoppingReDomain = new OcShoppingReDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ocShoppingReDomain, (Object)ocShoppingDomain);
            }
            catch (Exception e) {
                return null;
            }
            list.add(ocShoppingReDomain);
        }
        this.makePm(list, platMemberCode);
        return list;
    }

    public void makePm(List<OcShoppingReDomain> ocShoppingReDomainList, String platMemberCode) {
        if (ListUtil.isEmpty(ocShoppingReDomainList)) {
            return;
        }
        TypeBean typeBean = null;
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            HtmlJsonReBean htmlJsonReBean;
            String tenantCode = ocShoppingReDomain.getTenantCode();
            typeBean = this.getOcSetting(ocShoppingReDomain.getShoppingType(), ocShoppingReDomain.getTenantCode());
            if (null != typeBean) {
                ocShoppingReDomain.setScontractBlance(typeBean.getBlance());
                ocShoppingReDomain.setScontractPmode(typeBean.getPmode());
                ocShoppingReDomain.setIntpay(typeBean.getIntpay());
                ocShoppingReDomain.setPmpay(typeBean.getPmpay());
                ocShoppingReDomain.setBlance(typeBean.getBlance());
                ocShoppingReDomain.setPmode(typeBean.getPmode());
                ocShoppingReDomain.setFreight(typeBean.getFreight());
                ocShoppingReDomain.setCoppay(typeBean.getCoppay());
                ocShoppingReDomain.setUrpay(typeBean.getUrpay());
            }
            BigDecimal contractMoney = BigDecimal.ZERO;
            HashMap pmCodeSkuMap = new HashMap();
            ArrayList<OcShoppingGoodsDomain> goodslist = new ArrayList<OcShoppingGoodsDomain>();
            List<OcPackageDomain> ocPackageDomainList = ocShoppingReDomain.getPackageList();
            if (null != ocPackageDomainList && ocPackageDomainList.size() > 0) {
                for (OcPackageDomain ocPackageDomain : ocPackageDomainList) {
                    goodslist.addAll(ocPackageDomain.getShoppingGoodsList());
                }
            }
            ArrayList<PmCalcDomain> calcDomainList = new ArrayList<PmCalcDomain>();
            if (null != goodslist && goodslist.size() > 0) {
                PmContractGoodsDomain pmContractGoodsDomain = null;
                for (OcShoppingGoodsDomain ocShoppingGoodsDomain : goodslist) {
                    String pmCode = ocShoppingGoodsDomain.getShoppingGoodsPm();
                    if (StringUtils.isBlank((String)pmCode)) {
                        pmCode = "";
                    }
                    ocShoppingReDomain.setGoodsOrigin(ocShoppingGoodsDomain.getGoodsOrigin());
                    contractMoney.add(ocShoppingGoodsDomain.getPricesetNprice().multiply(ocShoppingGoodsDomain.getGoodsCamount()));
                    ArrayList<PmContractGoodsDomain> skuInfoDomainList = (ArrayList<PmContractGoodsDomain>)pmCodeSkuMap.get(pmCode);
                    if (null == skuInfoDomainList) {
                        skuInfoDomainList = new ArrayList<PmContractGoodsDomain>();
                    }
                    pmContractGoodsDomain = new PmContractGoodsDomain();
                    try {
                        BeanUtils.copyAllPropertys((Object)pmContractGoodsDomain, (Object)ocShoppingGoodsDomain);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    skuInfoDomainList.add(pmContractGoodsDomain);
                    pmCodeSkuMap.put(pmCode, skuInfoDomainList);
                }
            }
            Set pmCodeSet = pmCodeSkuMap.keySet();
            for (String pmCode : pmCodeSet) {
                PmCalcDomain pmPromotionCalcDomain = new PmCalcDomain();
                pmPromotionCalcDomain.setPromotionCode(pmCode);
                pmPromotionCalcDomain.setPmContractGoodsDomainList((List)pmCodeSkuMap.get(pmCode));
                calcDomainList.add(pmPromotionCalcDomain);
            }
            if (null != calcDomainList && calcDomainList.size() > 0 && this.checkPm(typeBean)) {
                PmInfoBean pmInfoBean = this.pmPromotionServiceRepository.checkPm(calcDomainList, null);
                ocShoppingReDomain.setPmInfo(pmInfoBean.getPmMap());
            }
            if (!this.checkIntpay(typeBean) || null == (htmlJsonReBean = this.upmUpointsServiceRepository.deductible(contractMoney, tenantCode, platMemberCode, "0")) || null == htmlJsonReBean.getDataObj()) continue;
            Map upmMap = (Map)htmlJsonReBean.getDataObj();
            ocShoppingReDomain.setUpmMap(upmMap);
        }
    }
}

