/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.facade.sms.service.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.sms.service.AliyunSmsService;
import com.qjsoft.laser.controller.facade.sms.service.SMSSceneEnum;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.supper.ObjectService;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
@PropertySource(value={"classpath:/aliyunSmsConf.properties"})
public class AliyunSmsServiceImpl
extends ObjectService
implements AliyunSmsService,
EnvironmentAware {
    private static final String SMS_CACHE_KEY = "dealers:sms:cache:%s:%s";
    private Environment environment;
    protected String accessKeyId;
    protected String accessSecret;
    protected String signName = "iCar\u751f\u6001";
    protected String templateCode;
    protected String expires;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @PostConstruct
    public void init() {
        this.accessKeyId = this.environment.getProperty("aliyun.sms.access-key-id");
        this.accessSecret = this.environment.getProperty("aliyun.sms.access-key-secret");
        this.templateCode = this.environment.getProperty("aliyun.sms.template-code");
        this.expires = this.environment.getProperty("aliyun.sms.expires");
        this.logger.info("\u53d1\u9001\u77ed\u4fe1\u914d\u7f6e\u53c2\u6570\uff0caccessKeyI:" + this.accessKeyId + ",accessSecret:" + this.accessSecret + ",signName:" + this.signName + ",templateCode:" + this.templateCode + ",expires:" + this.expires);
    }

    @Override
    public HtmlJsonReBean sendSms(String userPhone, String scene) {
        if (!SMSSceneEnum.isContains(scene)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u573a\u666f\u4ee3\u7801\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((CharSequence)userPhone)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.accessKeyId, (String)this.accessSecret);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        String randomString = RandomUtil.randomString((String)"1234567890", (int)6);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)randomString);
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain("dysmsapi.aliyuncs.com");
        request.setSysVersion("2017-05-25");
        request.setSysAction("SendSms");
        request.putQueryParameter("RegionId", "cn-hangzhou");
        request.putQueryParameter("PhoneNumbers", userPhone);
        request.putQueryParameter("SignName", this.signName);
        request.putQueryParameter("TemplateCode", this.templateCode);
        request.putQueryParameter("TemplateParam", jsonObject.toString());
        try {
            this.logger.info("\u8bf7\u6c42\u963f\u91cc\u4e91\u53d1\u9001\u77ed\u4fe1\u5165\u53c2\uff1a" + request.toString());
            CommonResponse commonResponse = client.getCommonResponse(request);
            this.logger.info("\u8bf7\u6c42\u963f\u91cc\u4e91\u53d1\u9001\u77ed\u4fe1\u51fa\u53c2\uff1a" + commonResponse == null ? commonResponse.toString() : null);
            if (null == commonResponse || 200 != commonResponse.getHttpStatus()) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25");
            }
            String responseData = commonResponse.getData();
            JSONObject data = JSON.parseObject((String)responseData);
            if (null == data || !"OK".equals(data.getString("Code"))) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, null == data ? "\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25" : data.getString("Message"));
            }
            String key = String.format(SMS_CACHE_KEY, userPhone, scene);
            SupDisUtil.set((String)key, (String)randomString, (int)Integer.parseInt(this.expires));
            return new HtmlJsonReBean((Object)"\u53d1\u9001\u9a8c\u8bc1\u7801\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25\uff1a", (Throwable)e);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25");
        }
    }

    @Override
    public HtmlJsonReBean verifySms(String userPhone, String scene, String code) {
        if (!SMSSceneEnum.isContains(scene)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u573a\u666f\u4ee3\u7801\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((CharSequence)userPhone)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)code)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String key = String.format(SMS_CACHE_KEY, userPhone, scene);
        String captcha = SupDisUtil.getRemot((String)key);
        this.logger.info("\u624b\u673a\u53f7\uff1a" + userPhone + "\u7f13\u5b58\u9a8c\u8bc1\u7801" + captcha);
        if (StringUtils.isEmpty((CharSequence)captcha)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\u6216\u672a\u53d1\u9001");
        }
        if (!Objects.equals(captcha, code)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        SupDisUtil.set((String)key, (String)"");
        return new HtmlJsonReBean((Object)"\u9a8c\u8bc1\u6210\u529f");
    }

    @Override
    public String getSmsByCache(String userPhone, String scene) {
        if (!SMSSceneEnum.isContains(scene)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)userPhone)) {
            return null;
        }
        String key = String.format(SMS_CACHE_KEY, userPhone, scene);
        String captcha = SupDisUtil.getRemot((String)key);
        this.logger.info("\u624b\u673a\u53f7\uff1a" + userPhone + "\u7f13\u5b58\u9a8c\u8bc1\u7801" + captcha);
        return captcha;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setAccessSecret(String accessSecret) {
        this.accessSecret = accessSecret;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public void setExpires(String expires) {
        this.expires = expires;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getAccessSecret() {
        return this.accessSecret;
    }

    public String getSignName() {
        return this.signName;
    }

    public String getTemplateCode() {
        return this.templateCode;
    }

    public String getExpires() {
        return this.expires;
    }
}

