/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.facade.um.repository;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.send.SupperFacade;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.um.domain.UmQualityReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserRegBean;
import com.qjsoft.laser.controller.facade.um.repository.UmQualityServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class UserBaseServiceRepository
extends SupperFacade {
    private static String CODE = "UserBaseServiceRepository";
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private UmQualityServiceRepository umQualityServiceRepository;

    public String getQualityCode(String tenantCode, String qualityCode) {
        UmQualityReDomain umQualityReDomain = this.umQualityServiceRepository.getQualityByCode(tenantCode, qualityCode);
        if (umQualityReDomain == null || StringUtils.isBlank((String)umQualityReDomain.getQualityCode())) {
            umQualityReDomain = this.umQualityServiceRepository.getQualityByCode("00000000", qualityCode);
        }
        String qualityRole = null;
        if (null != umQualityReDomain && StringUtils.isNotBlank((String)umQualityReDomain.getQualityRole())) {
            qualityRole = umQualityReDomain.getQualityRole();
        }
        if (StringUtils.isBlank(qualityRole)) {
            this.logger.error(CODE + ".getQualityCode", (Object)"\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        return qualityRole;
    }

    public HtmlJsonReBean saveUmuser(UmUserRegBean umUserRegBean) {
        if (null == umUserRegBean || StringUtils.isBlank((String)umUserRegBean.getTenantCode())) {
            return new HtmlJsonReBean("error", "\u53c2\u6570\u5f02\u5e38");
        }
        if (StringUtils.isBlank((String)umUserRegBean.getUserinfoQuality())) {
            umUserRegBean.setUserinfoQuality("buy");
        }
        if (StringUtils.isBlank((Integer)umUserRegBean.getUserinfoType())) {
            umUserRegBean.setUserinfoType(1);
        }
        String qualityRole = this.getQualityCode(umUserRegBean.getTenantCode(), umUserRegBean.getUserinfoQuality());
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)umUserDomainBean, (Object)umUserRegBean);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".saveUmuser.e", (Throwable)e);
        }
        umUserDomainBean.setUserType(1);
        String compname = umUserRegBean.getUserRelname();
        if (StringUtils.isBlank((String)compname)) {
            compname = umUserRegBean.getUserName();
        }
        if (StringUtils.isBlank((String)compname)) {
            compname = umUserRegBean.getUserName();
        }
        if (StringUtils.isBlank((String)compname)) {
            compname = umUserRegBean.getUserPhone();
        }
        umUserDomainBean.setUserinfoCompname(compname);
        umUserDomainBean.setRoleCode(qualityRole);
        HtmlJsonReBean htmlJsonReBean = this.userServiceRepository.sendOpenUserinfo(umUserDomainBean);
        this.sendUserBigData(umUserDomainBean);
        return htmlJsonReBean;
    }

    public void sendUserBigData(UmUserDomainBean umUserDomainBean) {
        if (null == umUserDomainBean) {
            return;
        }
        String bigdataFlag = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(umUserDomainBean.getTenantCode() + "-bigdata-bigdataflag"));
        if (StringUtils.isBlank((String)bigdataFlag) || !"true".equals(bigdataFlag)) {
            return;
        }
        String value = "{\"paasLabel\":\"userInfo\",\"message\":" + JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean) + "}";
        PostParamMap pmap = new PostParamMap("kafka.adapter.sendProducerInfo");
        pmap.putParam("topic", (Object)"paas_business");
        pmap.putParam("value", (Object)value);
        this.htmlIBaseService.sendMesReBeanInAsync(pmap);
    }
}

