/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.fc.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.fc.domain.FcTrainuserDomain;
import com.qjsoft.laser.controller.facade.fc.domain.FcTrainuserEntryDomain;
import com.qjsoft.laser.controller.facade.fc.domain.FcTrainuserReDomain;
import com.qjsoft.laser.controller.facade.fc.repository.FcTrainuserServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OrderDomain;
import com.qjsoft.laser.controller.facade.oc.domain.PackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.TypeBean;
import com.qjsoft.laser.controller.facade.oc.repository.OcServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/fc/trainuser"}, name="\u57f9\u8bad\u8bb0\u5f55\u670d\u52a1")
public class TrainuserCon
extends SpringmvcController {
    private static String CODE = "fc.trainuser.con";
    @Autowired
    private FcTrainuserServiceRepository fcTrainuserServiceRepository;
    @Autowired
    private OcServiceRepository ocServiceRepository;

    protected String getContext() {
        return "trainuser";
    }

    @RequestMapping(value={"saveTrainuser.json"}, name="\u589e\u52a0\u57f9\u8bad\u8bb0\u5f55\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveTrainuser(HttpServletRequest request, FcTrainuserDomain fcTrainuserDomain) {
        if (null == fcTrainuserDomain) {
            this.logger.error(CODE + ".saveTrainuser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        fcTrainuserDomain.setTenantCode(this.getTenantCode(request));
        HtmlJsonReBean htmlJsonReBean = this.fcTrainuserServiceRepository.saveTrainuser(fcTrainuserDomain);
        String code = htmlJsonReBean.getDataObj().toString();
        HtmlJsonReBean htmlJsonReBean1 = new HtmlJsonReBean();
        if (null != code && "" != code) {
            htmlJsonReBean1 = this.saveOrder(request, fcTrainuserDomain, code);
        }
        return htmlJsonReBean1;
    }

    @RequestMapping(value={"getTrainuser.json"}, name="\u83b7\u53d6\u57f9\u8bad\u8bb0\u5f55\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public FcTrainuserReDomain getTrainuser(Integer trainuserId) {
        if (StringUtils.isBlank((Integer)trainuserId)) {
            this.logger.error(CODE + ".getTrainuser", (Object)"param is null");
            return null;
        }
        return this.fcTrainuserServiceRepository.getTrainuser(trainuserId);
    }

    @RequestMapping(value={"updateTrainuser.json"}, name="\u66f4\u65b0\u57f9\u8bad\u8bb0\u5f55\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateTrainuser(HttpServletRequest request, FcTrainuserDomain fcTrainuserDomain) {
        if (null == fcTrainuserDomain) {
            this.logger.error(CODE + ".updateTrainuser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        fcTrainuserDomain.setTenantCode(this.getTenantCode(request));
        return this.fcTrainuserServiceRepository.updateTrainuser(fcTrainuserDomain);
    }

    @RequestMapping(value={"deleteTrainuser.json"}, name="\u5220\u9664\u57f9\u8bad\u8bb0\u5f55\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteTrainuser(Integer trainuserId) {
        if (StringUtils.isBlank((Integer)trainuserId)) {
            this.logger.error(CODE + ".deleteTrainuser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.fcTrainuserServiceRepository.deleteTrainuser(trainuserId);
    }

    @RequestMapping(value={"queryTrainuserPage.json"}, name="\u67e5\u8be2\u57f9\u8bad\u8bb0\u5f55\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<FcTrainuserReDomain> queryTrainuserPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.fcTrainuserServiceRepository.queryTrainuserPage(param);
    }

    @RequestMapping(value={"updateTrainuserState.json"}, name="\u66f4\u65b0\u57f9\u8bad\u8bb0\u5f55\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateTrainuserState(String trainuserId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)trainuserId)) {
            this.logger.error(CODE + ".updateTrainuserState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.fcTrainuserServiceRepository.updateTrainuserState(Integer.valueOf(trainuserId), dataState, oldDataState);
    }

    private HtmlJsonReBean saveOrder(HttpServletRequest request, FcTrainuserDomain fcTrainuserDomain, String code) {
        if (null == fcTrainuserDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrderDomain orderDomain = new OrderDomain();
        String shoppingType = "11";
        HashMap<String, Object> map = new HashMap<String, Object>();
        TypeBean typeBean = this.ocServiceRepository.getOcSetting(shoppingType, fcTrainuserDomain.getTenantCode());
        if (null != typeBean) {
            orderDomain.setContractBlance(typeBean.getBlance());
            orderDomain.setContractPmode(typeBean.getPmode());
            map.put("contractBlance", typeBean.getBlance());
            map.put("contractPmode", typeBean.getPmode());
        }
        FcTrainuserEntryDomain fcTrainuserEntryDomain = fcTrainuserDomain.getFcTrainuserEntryDomain();
        orderDomain.setAreaCode(fcTrainuserEntryDomain.getAreaCode());
        orderDomain.setContractRemark(fcTrainuserDomain.getTrainuserMemo());
        orderDomain.setContractType(shoppingType);
        orderDomain.setGoodsReceiptArrdess(fcTrainuserEntryDomain.getAddressDetail());
        orderDomain.setGoodsReceiptMem(fcTrainuserDomain.getMemberBname());
        orderDomain.setGoodsReceiptPhone("");
        ArrayList<PackageDomain> packageList = new ArrayList<PackageDomain>();
        orderDomain.setPackageList(packageList);
        PackageDomain packageDomain = new PackageDomain();
        packageList.add(packageDomain);
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        packageDomain.setContractGoodsList(contractGoodsList);
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        contractGoodsList.add(ocContractGoodsDomain);
        ocContractGoodsDomain.setAppmanageIcode(this.getProappCode(request));
        ocContractGoodsDomain.setContractGoodsInmoney(fcTrainuserDomain.getTrainuserAamt());
        ocContractGoodsDomain.setContractGoodsMoney(fcTrainuserDomain.getTrainuserAamt());
        ocContractGoodsDomain.setContractGoodsPrice(fcTrainuserDomain.getTrainuserAamt());
        ocContractGoodsDomain.setGoodsCamount(new BigDecimal("1"));
        ocContractGoodsDomain.setGoodsNum(new BigDecimal("1"));
        ocContractGoodsDomain.setGoodsName(fcTrainuserDomain.getMemberBname() + fcTrainuserDomain.getTraintemName());
        ocContractGoodsDomain.setGoodsNo(code);
        ocContractGoodsDomain.setGoodsCode(code);
        ocContractGoodsDomain.setSkuCode(code);
        ocContractGoodsDomain.setSkuNo(code);
        ocContractGoodsDomain.setSkuName(fcTrainuserDomain.getMemberBname() + fcTrainuserDomain.getTraintemName());
        ocContractGoodsDomain.setMemberBcode(fcTrainuserDomain.getMemberBcode());
        ocContractGoodsDomain.setMemberBname(fcTrainuserDomain.getMemberBname());
        ocContractGoodsDomain.setMemberCode(fcTrainuserDomain.getMemberCode());
        ocContractGoodsDomain.setMemberName(fcTrainuserDomain.getMemberName());
        UserSession userSession = this.getUserSession(request);
        ArrayList<OrderDomain> orderDomainList = new ArrayList<OrderDomain>();
        orderDomainList.add(orderDomain);
        map.put("contractType", shoppingType);
        HtmlJsonReBean htmlJsonReBean = this.ocServiceRepository.createOcOrder(orderDomainList, shoppingType, userSession, this.getProappCode(request), this.getOauthEnvCode(request));
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        map.put("dataBmoney", fcTrainuserDomain.getTrainuserAamt());
        map.put("contractBillcode", htmlJsonReBean.getDataObj().toString());
        htmlJsonReBean.setDataObj(map);
        return htmlJsonReBean;
    }
}

