/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.fc.controller;

import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.sts20150401.Client;
import com.aliyun.sts20150401.models.AssumeRoleRequest;
import com.aliyun.sts20150401.models.AssumeRoleResponse;
import com.aliyun.sts20150401.models.AssumeRoleResponseBody;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/fc/aliOSS"}, name="\u4e0a\u4f20OSS\u670d\u52a1\u7aef\u7b7e\u540d\u76f4\u4f20")
public class AliOSSController
extends SpringmvcController {
    private static String CODE = "fc.aliOSS.con";
    String bucket = "rcyx-video";
    String region = "cn-shenzhen";
    String host = "http://" + this.bucket + ".oss-" + this.region + ".aliyuncs.com";
    String upload_dir = "peixun/";
    Long expire_time = 3600L;

    protected String getContext() {
        return "AliOSSController";
    }

    public static String generateExpiration(long seconds) {
        long now = System.currentTimeMillis();
        long expirationTimeMillis = now + seconds * 1000L;
        Date expirationDate = new Date(expirationTimeMillis);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter.format(expirationDate);
    }

    public static Client createStsClient() throws Exception {
        Config config = new Config().setAccessKeyId("LTAI5tD5qtoNZd4a95Df7kLa").setAccessKeySecret("5eVcH2FTgS5rLv4771XYPqN38KHGrv");
        config.endpoint = "sts.cn-shenzhen.aliyuncs.com";
        return new Client(config);
    }

    public static AssumeRoleResponseBody.AssumeRoleResponseBodyCredentials getCredential() throws Exception {
        Client client = AliOSSController.createStsClient();
        AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest().setRoleArn("acs:ram::1420916059166622:role/aliyunaccessingossroleforpeixun").setRoleSessionName("yourRoleSessionName");
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            AssumeRoleResponse response = client.assumeRoleWithOptions(assumeRoleRequest, runtime);
            return response.body.credentials;
        }
        catch (TeaException error) {
            System.out.println(error.getMessage());
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage());
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
        }
        return null;
    }

    @RequestMapping(value={"getPostSignatureForOssUpload.json"}, name="\u83b7\u53d6oss\u7b7e\u540d")
    @ResponseBody
    public ResponseEntity<Map<String, String>> getPostSignatureForOssUpload() throws Exception {
        this.logger.error(CODE + ".uploadGoodsFile", (Object)System.getenv("OSS_STS_ROLE_ARN"));
        this.logger.error(CODE + ".id:", (Object)System.getenv("OSS_ACCESS_KEY_ID"));
        this.logger.error(CODE + ".secret", (Object)System.getenv("OSS_ACCESS_KEY_SECRET"));
        AssumeRoleResponseBody.AssumeRoleResponseBodyCredentials sts_data = AliOSSController.getCredential();
        String accesskeyid = sts_data.accessKeyId;
        String accesskeysecret = sts_data.accessKeySecret;
        String securitytoken = sts_data.securityToken;
        System.out.println("sts accesskeyid:" + accesskeyid);
        System.out.println("sts accesskeysecret:" + accesskeysecret);
        System.out.println("sts securitytoken:" + securitytoken);
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String date = dateFormat.format(calendar.getTime());
        TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
        calendar.setTimeZone(utcTimeZone);
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateTimeFormat.setTimeZone(utcTimeZone);
        String x_oss_date = dateTimeFormat.format(calendar.getTime());
        String x_oss_credential = accesskeyid + "/" + date + "/" + this.region + "/oss/aliyun_v4_request";
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, Object> policy = new HashMap<String, Object>();
        policy.put("expiration", AliOSSController.generateExpiration(this.expire_time));
        ArrayList<Object> conditions = new ArrayList<Object>();
        HashMap<String, String> bucketCondition = new HashMap<String, String>();
        bucketCondition.put("bucket", this.bucket);
        conditions.add(bucketCondition);
        HashMap<String, String> securityTokenCondition = new HashMap<String, String>();
        securityTokenCondition.put("x-oss-security-token", securitytoken);
        conditions.add(securityTokenCondition);
        HashMap<String, String> signatureVersionCondition = new HashMap<String, String>();
        signatureVersionCondition.put("x-oss-signature-version", "OSS4-HMAC-SHA256");
        conditions.add(signatureVersionCondition);
        HashMap<String, String> credentialCondition = new HashMap<String, String>();
        credentialCondition.put("x-oss-credential", x_oss_credential);
        conditions.add(credentialCondition);
        HashMap<String, String> dateCondition = new HashMap<String, String>();
        dateCondition.put("x-oss-date", x_oss_date);
        conditions.add(dateCondition);
        conditions.add(Arrays.asList("content-length-range", 1, 0x80000000L));
        conditions.add(Arrays.asList("eq", "$success_action_status", "200"));
        conditions.add(Arrays.asList("starts-with", "$key", this.upload_dir));
        policy.put("conditions", conditions);
        String jsonPolicy = mapper.writeValueAsString(policy);
        String stringToSign = new String(Base64.encodeBase64((byte[])jsonPolicy.getBytes()));
        byte[] dateKey = AliOSSController.hmacsha256(("aliyun_v4" + accesskeysecret).getBytes(), date);
        byte[] dateRegionKey = AliOSSController.hmacsha256(dateKey, this.region);
        byte[] dateRegionServiceKey = AliOSSController.hmacsha256(dateRegionKey, "oss");
        byte[] signingKey = AliOSSController.hmacsha256(dateRegionServiceKey, "aliyun_v4_request");
        byte[] result = AliOSSController.hmacsha256(signingKey, stringToSign);
        String signature = BinaryUtil.toHex((byte[])result);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("version", "OSS4-HMAC-SHA256");
        response.put("policy", stringToSign);
        response.put("credential", x_oss_credential);
        response.put("ossdate", x_oss_date);
        response.put("signature", signature);
        response.put("token", securitytoken);
        response.put("dir", this.upload_dir);
        response.put("host", this.host);
        return ResponseEntity.ok(response);
    }

    public static byte[] hmacsha256(byte[] key, String data) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(secretKeySpec);
            byte[] hmacBytes = mac.doFinal(data.getBytes());
            return hmacBytes;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate HMAC-SHA256", e);
        }
    }
}

