/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.gt.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftFileReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftRelReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftSendReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftSpecDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftSpecReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftUserDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftUserReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftUserrelReDomain;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftFileServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftRelServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftSendServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftSendlistServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftSpecServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftUserServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftUserrelServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsFileDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsRelDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecValueDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsOtherServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/gt/gift"}, name="\u793c\u54c1\u670d\u52a1")
public class GiftCon
extends SpringmvcController {
    private static String CODE = "gt.gift.con";
    @Autowired
    private GtGiftServiceRepository gtGiftServiceRepository;
    @Autowired
    private GtGiftFileServiceRepository gtGiftFileServiceRepository;
    @Autowired
    private GtGiftRelServiceRepository gtGiftRelServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private RsGoodsOtherServiceRepository rsGoodsOtherServiceRepository;
    @Autowired
    private GtGiftSendlistServiceRepository gtGiftSendlistServiceRepository;
    @Autowired
    private GtGiftSendServiceRepository gtGiftSendServiceRepository;
    @Autowired
    private GtGiftUserrelServiceRepository gtGiftUserrelServiceRepository;
    @Autowired
    private GtGiftUserServiceRepository gtGiftUserServiceRepository;
    @Autowired
    private GtGiftSpecServiceRepository gtGiftSpecServiceRepository;

    protected String getContext() {
        return "gift";
    }

    @RequestMapping(value={"saveGift.json"}, name="\u589e\u52a0\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveGift(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveGift", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveGift", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        GtGiftDomain gtGiftDomain = (GtGiftDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, GtGiftDomain.class);
        if (null == gtGiftDomain.getGtGiftFileDomainList() || gtGiftDomain.getGtGiftFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveGift.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == gtGiftDomain.getGtGiftRelDomainList() || gtGiftDomain.getGtGiftRelDomainList().size() == 0) {
            this.logger.error(CODE + ".saveGift.relList", (Object)"relList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u5173\u8054\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List gtGiftRelDomainArr = gtGiftDomain.getGtGiftRelDomainList();
        if (null != gtGiftRelDomainArr && gtGiftRelDomainArr.size() > 0) {
            for (GtGiftRelReDomain gtGiftRelReDomain : gtGiftRelDomainArr) {
                if (null == gtGiftRelReDomain.getPricesetBaseprice() || gtGiftRelReDomain.getPricesetBaseprice().equals("") || 0 == gtGiftRelReDomain.getPricesetBaseprice().intValue()) {
                    gtGiftRelReDomain.setPricesetBaseprice(gtGiftRelReDomain.getPricesetNprice());
                }
                gtGiftRelReDomain.getPricesetBaseprice();
            }
        }
        if (null == gtGiftDomain.getGtGiftSpecDomainList() || gtGiftDomain.getGtGiftSpecDomainList().size() == 0) {
            this.logger.error(CODE + ".saveGift.relList", (Object)"getGtGiftSpecDomainList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        gtGiftDomain.setMemberCode(userSession.getUserPcode());
        gtGiftDomain.setMemberName(userSession.getUserName());
        gtGiftDomain.setTenantCode(this.getTenantCode(request));
        return this.gtGiftServiceRepository.saveGift(gtGiftDomain);
    }

    @RequestMapping(value={"getGift.json"}, name="\u83b7\u53d6\u793c\u54c1\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public GtGiftReDomain getGift(Integer giftId) {
        if (StringUtils.isBlank((Integer)giftId)) {
            this.logger.error(CODE + ".getGift", (Object)"param is null");
            return null;
        }
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGift(giftId);
        Map amap = this.getQueryMapParam("giftCode,tenantCode", new Object[]{gtGiftReDomain.getGiftCode(), gtGiftReDomain.getTenantCode()});
        gtGiftReDomain.setGtGiftFileDomainList(this.gtGiftFileServiceRepository.queryGiftFilePage(amap).getList());
        gtGiftReDomain.setGtGiftRelDomainList(this.gtGiftRelServiceRepository.queryGiftRelPage(amap).getList());
        List gtGiftSpecReDomainList = this.gtGiftSpecServiceRepository.queryGiftSpecPage(amap).getList();
        ArrayList<GtGiftSpecReDomain> gtGiftSpecDomainArr = new ArrayList<GtGiftSpecReDomain>();
        if (null != gtGiftSpecReDomainList && gtGiftSpecReDomainList.size() > 0) {
            for (GtGiftSpecReDomain gtGiftSpecDomain : gtGiftSpecReDomainList) {
                gtGiftSpecDomainArr.add(gtGiftSpecDomain);
            }
        }
        gtGiftReDomain.setGtGiftSpecDomainList(gtGiftSpecDomainArr);
        return gtGiftReDomain;
    }

    @RequestMapping(value={"getGiftReGoods.json"}, name="\u83b7\u53d6\u793c\u54c1\u670d\u52a1\u7684\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public List<GtGiftRelReDomain> getGiftReGoods(Integer giftId) {
        if (StringUtils.isBlank((Integer)giftId)) {
            this.logger.error(CODE + ".getGift", (Object)"param is null");
            return null;
        }
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGift(giftId);
        Map amap = this.getQueryMapParam("giftCode,tenantCode", new Object[]{gtGiftReDomain.getGiftCode(), gtGiftReDomain.getTenantCode()});
        List gtGiftRelReDomainList = this.gtGiftRelServiceRepository.queryGiftRelPage(amap).getList();
        return gtGiftRelReDomainList;
    }

    @RequestMapping(value={"updateGift.json"}, name="\u66f4\u65b0\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateGift(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateGift", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        GtGiftDomain gtGiftDomain = (GtGiftDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, GtGiftDomain.class);
        if (null == gtGiftDomain.getGtGiftFileDomainList() || gtGiftDomain.getGtGiftFileDomainList().size() == 0) {
            this.logger.error(CODE + ".updateGift.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == gtGiftDomain.getGtGiftRelDomainList() || gtGiftDomain.getGtGiftRelDomainList().size() == 0) {
            this.logger.error(CODE + ".updateGift.relList", (Object)"relList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u5173\u8054\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        gtGiftDomain.setMemberCode(userSession.getUserPcode());
        gtGiftDomain.setMemberName(userSession.getUserName());
        gtGiftDomain.setTenantCode(this.getTenantCode(request));
        return this.gtGiftServiceRepository.updateGift(gtGiftDomain);
    }

    @RequestMapping(value={"deleteGift.json"}, name="\u5220\u9664\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteGift(String giftId) {
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".deleteGift", (Object)"giftId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        String[] s = giftId.split(",");
        if (null != s && s.length > 0) {
            for (String gid : s) {
                GtGiftReDomain gtGiftReDomain = this.getGift(Integer.valueOf(gid));
                htmlJsonReBean = this.gtGiftServiceRepository.updateGiftState(Integer.valueOf(giftId), Integer.valueOf(-1), gtGiftReDomain.getDataState());
            }
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryGiftPage.json"}, name="\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("ntoDataState", -1);
        return this.gtGiftServiceRepository.queryGiftPage(param);
    }

    @RequestMapping(value={"queryGiftPageForUp.json"}, name="\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPageForUp(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("ntoDataState", -1);
        return this.gtGiftServiceRepository.queryGiftPage(param);
    }

    @RequestMapping(value={"queryGiftPageToB.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPageToB(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "2");
        param.put("sendState", 1);
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult gtGiftUserrelReDomainList = this.gtGiftUserServiceRepository.queryGiftUserPage(param);
        List gtGiftUserReDomainArr = gtGiftUserrelReDomainList.getList();
        ArrayList<GtGiftReDomain> gtGiftReDomainArr = new ArrayList<GtGiftReDomain>();
        if (null != gtGiftUserReDomainArr && gtGiftUserReDomainArr.size() > 0) {
            long time = 2592000000L;
            for (GtGiftUserReDomain gtGiftUserReDomain : gtGiftUserReDomainArr) {
                GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(this.getTenantCode(request), gtGiftUserReDomain.getGiftCode());
                long endTime = gtGiftUserReDomain.getGiftUserEnd().getTime() - new Date().getTime();
                if (endTime > 0L && endTime < time) {
                    gtGiftUserReDomain.setReminder("\u5373\u5c06\u8fc7\u671f");
                }
                gtGiftReDomain.setGtGiftUserDomain((GtGiftUserDomain)gtGiftUserReDomain);
                gtGiftReDomainArr.add(gtGiftReDomain);
            }
        }
        SupQueryResult gtGiftReDomainList = new SupQueryResult();
        if (null != gtGiftReDomainArr) {
            gtGiftReDomainList.setList(gtGiftReDomainArr);
            gtGiftReDomainList.setTotal(gtGiftUserrelReDomainList.getTotal());
            gtGiftReDomainList.setPageTools(gtGiftUserrelReDomainList.getPageTools());
        }
        return gtGiftReDomainList;
    }

    @RequestMapping(value={"queryGiftPageToB2.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u88682")
    @ResponseBody
    public SupQueryResult<GtGiftUserReDomain> queryGiftPageToB2(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "2");
        param.put("sendState", 1);
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult gtGiftUserrelReDomainList = this.gtGiftUserServiceRepository.queryGiftUserPage(param);
        List gtGiftUserReDomainArr = gtGiftUserrelReDomainList.getList();
        if (null != gtGiftUserReDomainArr && gtGiftUserReDomainArr.size() > 0) {
            long time = 2592000000L;
            for (GtGiftUserReDomain gtGiftUserReDomain : gtGiftUserReDomainArr) {
                long endTime = gtGiftUserReDomain.getGiftUserEnd().getTime() - new Date().getTime();
                if (endTime <= 0L || endTime >= time) continue;
                gtGiftUserReDomain.setReminder("\u5373\u5c06\u8fc7\u671f");
            }
        }
        return gtGiftUserrelReDomainList;
    }

    @RequestMapping(value={"queryGiftUnissued.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u672a\u53d1\u653e\u670d\u52a1")
    @ResponseBody
    public Long queryGiftUnissued(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "2");
        param.put("validState", "0");
        param.put("sendState", 1);
        param.put("dataState", 0);
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult gtGiftUserrelReDomainList = this.gtGiftUserServiceRepository.queryGiftUserPage(param);
        return gtGiftUserrelReDomainList.getTotal();
    }

    @RequestMapping(value={"queryGiftSendlistPageByGiftSendCodeToB.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u5305\u9886\u53d6\u7684\u8be6\u60c5\uff08\u67e5\u770b\u5458\u5de5\u9886\u53d6\u5217\u8868\uff09")
    @ResponseBody
    public GtGiftReDomain queryGiftSendlistPageByGiftSendCodeToB(String giftUserId) {
        if (null == giftUserId) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToB", (Object)"giftUserId is null");
            return null;
        }
        GtGiftUserReDomain gtGiftUserReDomain = this.gtGiftUserServiceRepository.getGiftUser(Integer.valueOf(giftUserId));
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
        HashMap<String, String> mapUserList = new HashMap<String, String>();
        if (null != gtGiftUserReDomain.getGiftSendCode()) {
            mapUserList.put("giftUserType", "1");
            mapUserList.put("giftSendCode", gtGiftUserReDomain.getGiftSendCode());
            SupQueryResult gtGiftUserReDomainList = this.gtGiftUserServiceRepository.queryGiftUserPage(mapUserList);
            List gtGiftUserReDomainArr = gtGiftUserReDomainList.getList();
            Integer claimedNum = 0;
            Integer unclaimedNum = 0;
            Integer someClaimedNum = 0;
            if (null != gtGiftUserReDomainArr && gtGiftUserReDomainArr.size() > 0) {
                ArrayList<GtGiftUserReDomain> gtGiftUserDomainArr = new ArrayList<GtGiftUserReDomain>();
                for (GtGiftUserReDomain gtGiftUserDomain : gtGiftUserReDomainArr) {
                    Integer n;
                    Integer n2;
                    if (gtGiftUserDomain.getDataState() == 0 || gtGiftUserDomain.getDataState() == 4) {
                        n2 = unclaimedNum;
                        n = unclaimedNum = Integer.valueOf(unclaimedNum + 1);
                    }
                    if (gtGiftUserDomain.getDataState() == 1) {
                        n2 = claimedNum;
                        n = claimedNum = Integer.valueOf(claimedNum + 1);
                    }
                    if (gtGiftUserDomain.getDataState() == 2) {
                        n2 = someClaimedNum;
                        n = someClaimedNum = Integer.valueOf(someClaimedNum + 1);
                    }
                    gtGiftUserDomainArr.add(gtGiftUserDomain);
                }
                gtGiftUserReDomain.setClaimedNum(claimedNum);
                gtGiftUserReDomain.setUnclaimedNum(unclaimedNum);
                gtGiftUserReDomain.setSomeClaimedNum(someClaimedNum);
                gtGiftReDomain.setGtGiftUserDomainList(gtGiftUserDomainArr);
            }
            gtGiftReDomain.setGtGiftUserDomain((GtGiftUserDomain)gtGiftUserReDomain);
            HtmlJsonReBean htmlJsonReBean = this.gtGiftUserrelServiceRepository.countGoodsByGiftCode(gtGiftUserReDomain.getGiftSendCode(), gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getMemberCode());
            Object countGoods = htmlJsonReBean.getDataObj();
            this.logger.error("gift--------", (Object)(countGoods + "----------" + gtGiftUserReDomain.getGiftSendCode() + "-*-*-*-*----" + gtGiftUserReDomain.getMemberCode()));
            gtGiftReDomain.setCountGoods(countGoods);
        }
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftPageToBNotState.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868\u8fc7\u6ee4\u72b6\u6001")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPageToBNotState(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "2");
        param.put("notSendDataState", 0);
        param.put("companyCode", userSession.getUserPcode());
        SupQueryResult giftUserList = this.gtGiftUserServiceRepository.queryGiftUserPage(param);
        List giftUserArr = giftUserList.getList();
        ArrayList<GtGiftReDomain> gtGiftReDomainArr = new ArrayList<GtGiftReDomain>();
        if (null != giftUserArr && giftUserArr.size() > 0) {
            for (GtGiftUserReDomain gtGiftUserReDomain : giftUserArr) {
                GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
                gtGiftReDomain.setGtGiftUserDomain((GtGiftUserDomain)gtGiftUserReDomain);
                gtGiftReDomainArr.add(gtGiftReDomain);
            }
        }
        SupQueryResult gtGiftReDomain = new SupQueryResult();
        if (null != gtGiftReDomainArr) {
            gtGiftReDomain.setList(gtGiftReDomainArr);
            gtGiftReDomain.setPageTools(giftUserList.getPageTools());
            gtGiftReDomain.setTotal(giftUserList.getTotal());
        }
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftPageToBNotState2.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868\u8fc7\u6ee4\u72b6\u60012")
    @ResponseBody
    public SupQueryResult<GtGiftUserReDomain> queryGiftPageToBNotState2(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "2");
        param.put("companyCode", userSession.getUserPcode());
        SupQueryResult gtGiftUserReDomainSupQueryResult = this.gtGiftUserServiceRepository.queryGiftUserPage(param);
        if (ListUtil.isNotEmpty((Collection)gtGiftUserReDomainSupQueryResult.getList())) {
            for (GtGiftUserReDomain gtGiftUserReDomain : gtGiftUserReDomainSupQueryResult.getList()) {
                GtGiftSendReDomain gtGiftSendReDomain;
                if (!StringUtils.isNotBlank((String)gtGiftUserReDomain.getGiftSendCode()) || null == (gtGiftSendReDomain = this.gtGiftSendServiceRepository.getGiftSendByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftSendCode())) || !gtGiftSendReDomain.getDataState().equals(1)) continue;
                gtGiftUserReDomain.setGrantNum(gtGiftSendReDomain.getEmployeeNum());
            }
        }
        return gtGiftUserReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryGiftUserByGiftUserCodeToB.json"}, name="wap\u7aef \u4f01\u4e1a\u67e5\u770b\u53d1\u653e\u8bb0\u5f55\u91cc\u9762\u7684\u793c\u5305\u8be6\u60c5")
    @ResponseBody
    public GtGiftReDomain queryGiftUserByGiftUserCodeToB(HttpServletRequest request, String giftUserCode) {
        GtGiftSendReDomain gtGiftSendReDomain;
        if (null == giftUserCode) {
            this.logger.error(CODE + ".queryGiftUserByGiftUserCodeToB", (Object)"giftUserCode is null");
            return null;
        }
        GtGiftUserReDomain gtGiftUserReDomain = this.gtGiftUserServiceRepository.getGiftUserByCode(this.getTenantCode(request), giftUserCode);
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(this.getTenantCode(request), gtGiftUserReDomain.getGiftCode());
        if (StringUtils.isNotBlank((String)gtGiftUserReDomain.getGiftSendCode()) && null != (gtGiftSendReDomain = this.gtGiftSendServiceRepository.getGiftSendByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftSendCode())) && gtGiftSendReDomain.getDataState().equals(1)) {
            gtGiftUserReDomain.setGrantNum(gtGiftSendReDomain.getEmployeeNum());
        }
        gtGiftReDomain.setGtGiftUserDomain((GtGiftUserDomain)gtGiftUserReDomain);
        if (StringUtils.isNotBlank((String)gtGiftUserReDomain.getGiftSendCode())) {
            HashMap<String, String> mapUserList = new HashMap<String, String>();
            mapUserList.put("giftUserType", "1");
            mapUserList.put("giftSendCode", gtGiftUserReDomain.getGiftSendCode());
            SupQueryResult gtGiftUserReDomainList = this.gtGiftUserServiceRepository.queryGiftUserPage(mapUserList);
            List gtGiftUserReDomainArr = gtGiftUserReDomainList.getList();
            ArrayList<GtGiftUserReDomain> gtGiftUserDomainArr = new ArrayList<GtGiftUserReDomain>();
            if (null != gtGiftUserReDomainArr && gtGiftUserReDomainArr.size() > 0) {
                for (GtGiftUserReDomain gtGiftUserDomain : gtGiftUserReDomainArr) {
                    gtGiftUserDomainArr.add(gtGiftUserDomain);
                }
            }
            gtGiftReDomain.setGtGiftUserDomainList(gtGiftUserDomainArr);
        }
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftSendlistPageByGiftSendCodeToC.json"}, name="wap\u7aef\u5458\u5de5\u67e5\u8be2\u793c\u5305\u9886\u53d6\u7684\u8be6\u60c5\uff08\u67e5\u770b\u5458\u5de5\u9886\u53d6\u5217\u8868\uff09")
    @ResponseBody
    public GtGiftReDomain queryGiftSendlistPageByGiftSendCodeToC(String giftSendId) {
        if (null == giftSendId) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToC", (Object)"giftSendId is null");
            return null;
        }
        GtGiftSendReDomain gtGiftSendReDomain = this.gtGiftSendServiceRepository.getGiftSend(Integer.valueOf(giftSendId));
        ArrayList<GtGiftSendReDomain> gtGiftSendDomainList = new ArrayList<GtGiftSendReDomain>();
        gtGiftSendDomainList.add(gtGiftSendReDomain);
        HashMap<String, GtGiftSendReDomain> maprel = new HashMap<String, GtGiftSendReDomain>();
        maprel.put("giftSendCode", gtGiftSendReDomain);
        List GtGiftRelReDomain2 = this.gtGiftRelServiceRepository.queryGiftRelPage(maprel).getList();
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftSendReDomain.getTenantCode(), gtGiftSendReDomain.getGiftCode());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("giftCode", gtGiftSendReDomain.getGiftCode());
        SupQueryResult gtGiftSendlistDomain = this.gtGiftSendlistServiceRepository.queryGiftSendlistPage(param);
        if (null == gtGiftSendlistDomain) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToC", (Object)"gtGiftSendlistDomain is null");
            return null;
        }
        List gtGiftSendlistDomainList = gtGiftSendlistDomain.getList();
        if (null == gtGiftSendlistDomainList || gtGiftSendlistDomainList.size() == 0) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToC", (Object)"gtGiftSendlistDomainList is null");
            return null;
        }
        gtGiftReDomain.setGtGiftSendlistDomainList(gtGiftSendlistDomainList);
        gtGiftReDomain.setGtGiftSendDomainList(gtGiftSendDomainList);
        gtGiftReDomain.setGtGiftRelDomainList(GtGiftRelReDomain2);
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftPageToC.json"}, name="wap\u7aef\u5458\u5de5\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPageToC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "1");
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult gtGiftUserReDomainList = this.gtGiftUserServiceRepository.queryGiftUserPage(param);
        List giftUserDomainArr = gtGiftUserReDomainList.getList();
        ArrayList<GtGiftReDomain> gtGiftReDomainList = new ArrayList<GtGiftReDomain>();
        long time = 2592000000L;
        if (null != giftUserDomainArr && giftUserDomainArr.size() > 0) {
            for (GtGiftUserReDomain gtGiftUserReDomain : giftUserDomainArr) {
                long endTime = gtGiftUserReDomain.getGiftUserEnd().getTime() - new Date().getTime();
                if (endTime > 0L && endTime < time) {
                    gtGiftUserReDomain.setReminder("\u5373\u5c06\u8fc7\u671f");
                }
                GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
                HashMap<String, String> fileMap = new HashMap<String, String>();
                fileMap.put("giftCode", gtGiftUserReDomain.getGiftCode());
                gtGiftReDomain.setGtGiftUserDomain((GtGiftUserDomain)gtGiftUserReDomain);
                gtGiftReDomainList.add(gtGiftReDomain);
            }
        }
        SupQueryResult gtGiftReDomain = new SupQueryResult();
        if (null != gtGiftReDomainList) {
            gtGiftReDomain.setList(gtGiftReDomainList);
            gtGiftReDomain.setTotal(gtGiftUserReDomainList.getTotal());
            gtGiftReDomain.setPageTools(gtGiftUserReDomainList.getPageTools());
        }
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftPageToC2.json"}, name="wap\u7aef\u5458\u5de5\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftUserReDomain> queryGiftPageToC2(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "1");
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult gtGiftUserReDomainList = this.gtGiftUserServiceRepository.queryGiftUserPage(param);
        List giftUserDomainArr = gtGiftUserReDomainList.getList();
        long time = 2592000000L;
        if (null != giftUserDomainArr && giftUserDomainArr.size() > 0) {
            long endTime;
            for (GtGiftUserReDomain gtGiftUserReDomain : giftUserDomainArr) {
                endTime = gtGiftUserReDomain.getGiftUserEnd().getTime() - new Date().getTime();
                if (endTime <= 0L || endTime >= time) continue;
                gtGiftUserReDomain.setReminder("\u5373\u5c06\u8fc7\u671f");
            }
            Iterator iterator = giftUserDomainArr.iterator();
            while (iterator.hasNext()) {
                GtGiftUserReDomain gtGiftUserReDomain;
                gtGiftUserReDomain = (GtGiftUserReDomain)iterator.next();
                endTime = gtGiftUserReDomain.getGiftUserEnd().getTime() - new Date().getTime();
                if (endTime > 0L) continue;
                iterator.remove();
            }
        }
        return gtGiftUserReDomainList;
    }

    @RequestMapping(value={"queryRelToC.json"}, name="wap\u5458\u5de5\u9886\u53d6\u793c\u54c1\u65f6\u663e\u793a\u7684\u5546\u54c1")
    @ResponseBody
    public GtGiftReDomain queryRelToC(HttpServletRequest request, String giftUserCode) {
        UserSession userSession = this.getUserSession(request);
        if (null == giftUserCode) {
            this.logger.error(CODE + ".queryRelToC", (Object)"giftUserCode is null");
            return new GtGiftReDomain();
        }
        GtGiftUserReDomain gtGiftUserReDomain = this.gtGiftUserServiceRepository.getGiftUserByCode(userSession.getTenantCode(), giftUserCode);
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
        Map amap = this.getQueryMapParam("giftCode,tenantCode", new Object[]{gtGiftReDomain.getGiftCode(), gtGiftReDomain.getTenantCode()});
        gtGiftReDomain.setGtGiftRelDomainList(this.gtGiftRelServiceRepository.queryGiftRelPage(amap).getList());
        this.makeUserRelNum(gtGiftReDomain, (GtGiftUserDomain)gtGiftUserReDomain);
        return gtGiftReDomain;
    }

    @RequestMapping(value={"getGiftByUser.json"}, name="\u7528\u6237\u67e5\u770b\u793c\u5305\u6d3b\u52a8")
    @ResponseBody
    public GtGiftReDomain getGiftByUser(HttpServletRequest request, String giftUserCode) throws Exception {
        if (StringUtils.isBlank((String)giftUserCode)) {
            this.logger.error(CODE + ".queryRelToC", (Object)"giftUserCode is null");
            return new GtGiftReDomain();
        }
        UserSession userSession = this.getUserSession(request);
        GtGiftUserReDomain gtGiftUserReDomain = this.gtGiftUserServiceRepository.getGiftUserByCode(userSession.getTenantCode(), giftUserCode);
        if (null == gtGiftUserReDomain || StringUtils.isBlank((String)gtGiftUserReDomain.getMemberBcode()) || StringUtils.isBlank((String)gtGiftUserReDomain.getGiftCode()) || !userSession.getUserPcode().equals(gtGiftUserReDomain.getMemberBcode())) {
            this.logger.error(CODE + ".getGiftByUser.gtGiftUserReDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)gtGiftUserReDomain));
            throw new Exception("\u53c2\u6570\u9519\u8bef");
        }
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
        this.makeUserRelNum(gtGiftReDomain, (GtGiftUserDomain)gtGiftUserReDomain);
        return gtGiftReDomain;
    }

    private void makeUserRelNum(GtGiftReDomain gtGiftReDomain, GtGiftUserDomain gtGiftUserReDomain) {
        BigDecimal userNum;
        String cType = gtGiftReDomain.getGiftChange();
        if ("1".equals(cType)) {
            BigDecimal userCnum = BigDecimal.ZERO;
            if (null != gtGiftUserReDomain.getGiftUserCnum()) {
                userCnum = gtGiftUserReDomain.getGiftUserCnum();
            }
            userNum = gtGiftUserReDomain.getGiftUserNum();
            BigDecimal num = gtGiftUserReDomain.getGiftCnum().multiply(userNum).subtract(userCnum);
            gtGiftUserReDomain.setUserRelNum(num);
        }
        if ("0".equals(cType)) {
            BigDecimal userAmt = BigDecimal.ZERO;
            if (null != gtGiftUserReDomain.getGiftUserCamt()) {
                userAmt = gtGiftUserReDomain.getGiftUserCamt();
            }
            userNum = gtGiftUserReDomain.getGiftUserNum();
            BigDecimal amt = gtGiftUserReDomain.getGiftCnum().multiply(userNum).subtract(userAmt);
            gtGiftUserReDomain.setUserRelNum(amt);
        }
        gtGiftReDomain.setGtGiftUserDomain(gtGiftUserReDomain);
    }

    @RequestMapping(value={"queryGiftUserRelToC.json"}, name="wap\u7aef\u5458\u5de5\u67e5\u770b\u793c\u5305\u8be6\u60c5")
    @ResponseBody
    public GtGiftReDomain queryGiftUserRelToC(HttpServletRequest request, String giftUserCode) {
        if (null == giftUserCode) {
            this.logger.error(CODE + ".queryGiftUserRelToC", (Object)"giftUserCode is null");
            return new GtGiftReDomain();
        }
        GtGiftUserReDomain gtGiftUserReDomain = this.gtGiftUserServiceRepository.getGiftUserByCode(this.getTenantCode(request), giftUserCode);
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
        Map fileMap = this.getQueryMapParam("giftCode,tenantCode", new Object[]{gtGiftReDomain.getGiftCode(), gtGiftReDomain.getTenantCode()});
        gtGiftReDomain.setGtGiftFileDomainList(this.gtGiftFileServiceRepository.queryGiftFilePage(fileMap).getList());
        Map amap = this.getQueryMapParam("giftSendCode,memberBcode,giftUserCode", new Object[]{gtGiftUserReDomain.getGiftSendCode(), gtGiftUserReDomain.getMemberBcode(), gtGiftUserReDomain.getGiftUserCode()});
        List gtGiftUserrelDomainArr = this.gtGiftUserrelServiceRepository.queryGiftUserrelPage(amap).getList();
        ArrayList<GtGiftUserrelReDomain> gtGiftUserrelDomainList = new ArrayList<GtGiftUserrelReDomain>();
        if (null != gtGiftUserrelDomainArr && gtGiftUserrelDomainArr.size() > 0) {
            for (GtGiftUserrelReDomain GtGiftUserrelReDomain2 : gtGiftUserrelDomainArr) {
                if (null == GtGiftUserrelReDomain2.getGiftUserrelNum()) continue;
                gtGiftUserrelDomainList.add(GtGiftUserrelReDomain2);
            }
        }
        gtGiftReDomain.setGtGiftUserrelDomainList(gtGiftUserrelDomainList);
        gtGiftReDomain.setGtGiftUserDomain((GtGiftUserDomain)gtGiftUserReDomain);
        return gtGiftReDomain;
    }

    @RequestMapping(value={"updateGiftState.json"}, name="\u66f4\u65b0\u793c\u54c1\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateGiftState(String giftId, Integer dataState, Integer oldDataState) {
        String[] id;
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String a : id = giftId.split(",")) {
            this.gtGiftServiceRepository.updateGiftState(Integer.valueOf(a), dataState, oldDataState);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateGiftPrice.json"}, name="\u66f4\u65b0\u793c\u54c1\u552e\u4ef7")
    @ResponseBody
    public HtmlJsonReBean updateGiftPrice(String giftId, BigDecimal pricesetNprice) {
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftPrice", (Object)"giftId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null == pricesetNprice) {
            this.logger.error(CODE + ".updateGiftPrice", (Object)"pricesetNprice is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.gtGiftServiceRepository.updateGiftPrice(Integer.valueOf(giftId), pricesetNprice);
    }

    private void makeChannel(RsResourceGoodsDomain rsResourceGoodsDomain, HttpServletRequest request) {
        String[] s;
        if (null == rsResourceGoodsDomain || null == request) {
            return;
        }
        String channelInfo = this.getChannel(request);
        if (StringUtils.isNotBlank((String)channelInfo) && null != (s = channelInfo.split(",")) && s.length > 1) {
            rsResourceGoodsDomain.setChannelCode(s[0]);
            rsResourceGoodsDomain.setChannelName(s[1]);
        }
    }

    @RequestMapping(value={"updateGiftShelfState.json"}, name="\u793c\u5305\u4e0a\u67b6\u64cd\u4f5c")
    @ResponseBody
    public HtmlJsonReBean updateGiftShelfState(HttpServletRequest request, String giftId) {
        String[] giftIdArray;
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftShelfState", (Object)"giftId is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (String gid : giftIdArray = giftId.split(",")) {
            GtGiftReDomain gtGiftReDomain = this.getGift(Integer.valueOf(gid));
            if (null == gtGiftReDomain) {
                this.logger.error(CODE + ".updateGiftShelfState", (Object)"gtGiftReDomain is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "gtGiftReDomain");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("goodsOrigin", "5");
            map.put("goodsNo", gtGiftReDomain.getGiftCode());
            map.put("tenantCode", gtGiftReDomain.getTenantCode());
            SupQueryResult rsList = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(map);
            if (null != rsList && null != rsList.getRows() && !rsList.getRows().isEmpty()) continue;
            RsResourceGoodsDomain rsResourceGoodsDomain = this.make(request, gtGiftReDomain);
            ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
            goodsList.add(rsResourceGoodsDomain);
            HtmlJsonReBean htmlJsonReBean1 = this.rsResourceGoodsServiceRepository.savePassResourceGoodsBatch(goodsList);
            String rs = htmlJsonReBean1.getErrorCode();
            if (StringUtils.isNotBlank((String)rs)) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u64cd\u4f5c\u5931\u8d25");
            }
            htmlJsonReBean = this.gtGiftServiceRepository.updateGiftStateByCode(gtGiftReDomain.getTenantCode(), gtGiftReDomain.getGiftCode(), Integer.valueOf(1), Integer.valueOf(2));
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateGiftLowerState.json"}, name="\u793c\u5305\u4e0b\u67b6\u64cd\u4f5c")
    @ResponseBody
    public HtmlJsonReBean updateGiftLowerState(HttpServletRequest request, String giftCode) {
        String[] giftCodeArray;
        if (StringUtils.isBlank((String)giftCode)) {
            this.logger.error(CODE + ".updateGiftLowerState", (Object)"giftCode is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (String gcode : giftCodeArray = giftCode.split(",")) {
            HtmlJsonReBean htmlJsonReBean1;
            String errorCode;
            HashMap<String, String> map = new HashMap<String, String>();
            String tenantCode = this.getTenantCode(request);
            map.put("goodsOrigin", "5");
            map.put("goodsNo", gcode);
            map.put("tenantCode", tenantCode);
            SupQueryResult rsResourceGoodsReDomainList = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(map);
            List list = rsResourceGoodsReDomainList.getList();
            HashMap<String, String> params = new HashMap<String, String>();
            if (null != list && list.size() != 0) {
                RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)list.get(0);
                params.put("goodsOrigin", "5");
                params.put("goodsCode", rsResourceGoodsReDomain.getGoodsCode());
                params.put("tenantCode", tenantCode);
            }
            if (StringUtils.isNotBlank((String)(errorCode = (htmlJsonReBean1 = this.rsResourceGoodsServiceRepository.delResourceGoodsByCode(params)).getErrorCode()))) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5220\u9664\u5546\u54c1\u5931\u8d25");
            }
            htmlJsonReBean = this.gtGiftServiceRepository.updateGiftStateByCode(tenantCode, gcode, Integer.valueOf(2), Integer.valueOf(1));
        }
        return htmlJsonReBean;
    }

    private RsResourceGoodsDomain make(HttpServletRequest request, GtGiftReDomain gtGiftReDomain) {
        List gtGiftRelReDomain;
        if (null == gtGiftReDomain || null == request) {
            return null;
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        rsResourceGoodsDomain.setGoodsName(gtGiftReDomain.getGiftName());
        rsResourceGoodsDomain.setGoodsNo(gtGiftReDomain.getGiftCode());
        rsResourceGoodsDomain.setPntreeCode(gtGiftReDomain.getPntreeCode());
        rsResourceGoodsDomain.setPntreeName(gtGiftReDomain.getPntreeName());
        rsResourceGoodsDomain.setClasstreeCode(gtGiftReDomain.getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(gtGiftReDomain.getClasstreeName());
        rsResourceGoodsDomain.setPricesetNprice(gtGiftReDomain.getPricesetNprice());
        rsResourceGoodsDomain.setPricesetMakeprice(gtGiftReDomain.getPricesetMakeprice());
        rsResourceGoodsDomain.setBrandCode(gtGiftReDomain.getBrandCode());
        rsResourceGoodsDomain.setBrandName(gtGiftReDomain.getBrandName());
        UserSession userSession = this.getUserSession(request);
        rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
        rsResourceGoodsDomain.setMemberName(userSession.getUserName());
        rsResourceGoodsDomain.setTenantCode(this.getTenantCode(request));
        rsResourceGoodsDomain.setGoodsOrigin("5");
        rsResourceGoodsDomain.setGoodsType("05");
        rsResourceGoodsDomain.setPricesetMakeshow("1");
        rsResourceGoodsDomain.setPartsnameNumunit("\u4e2a");
        rsResourceGoodsDomain.setGoodsWeight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsSupplyweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsAhweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsHangweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsHangnum(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsNum(new BigDecimal("9999"));
        rsResourceGoodsDomain.setGoodsAhnum(new BigDecimal("9999"));
        rsResourceGoodsDomain.setGoodsSupplynum(new BigDecimal("9999"));
        this.makeChannel(rsResourceGoodsDomain, request);
        List gtGiftFileReDomain = gtGiftReDomain.getGtGiftFileDomainList();
        if (!ListUtil.isEmpty((Collection)gtGiftFileReDomain)) {
            ArrayList<RsGoodsFileDomain> rsGoodsFileList = new ArrayList<RsGoodsFileDomain>();
            for (GtGiftFileReDomain gtGiftFile : gtGiftFileReDomain) {
                RsGoodsFileDomain rsGoodsFile = new RsGoodsFileDomain();
                rsGoodsFile.setGoodsFileName(gtGiftFile.getGiftFileFilename());
                rsGoodsFile.setAppmanageIcode(gtGiftFile.getAppmanageIcode());
                rsGoodsFile.setGoodsFileSort(gtGiftFile.getGiftFileSort());
                rsGoodsFile.setGoodsFileType(gtGiftFile.getGiftFileType());
                rsGoodsFile.setGoodsFilesortName(gtGiftFile.getGiftFilesortName());
                rsGoodsFile.setGoodsFileUrl(gtGiftFile.getGiftFileFileUrl());
                rsGoodsFile.setTenantCode(gtGiftFile.getTenantCode());
                rsGoodsFileList.add(rsGoodsFile);
            }
            rsResourceGoodsDomain.setRsGoodsFileDomainList(rsGoodsFileList);
        }
        if (ListUtil.isNotEmpty((Collection)(gtGiftRelReDomain = gtGiftReDomain.getGtGiftRelDomainList()))) {
            ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
            for (GtGiftRelReDomain gtGiftRel : gtGiftRelReDomain) {
                RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
                rsGoodsRelDomain.setGoodsRelGcode(gtGiftRel.getGoodsCode());
                rsGoodsRelDomain.setMemberCcode(gtGiftRel.getMemberCcode());
                rsGoodsRelDomain.setMemberCname(gtGiftRel.getMemberCname());
                rsGoodsRelDomain.setSkuCode(gtGiftRel.getSkuCode());
                rsGoodsRelDomain.setSkuName(gtGiftRel.getSkuName());
                rsGoodsRelDomain.setSkuNo(gtGiftRel.getSkuNo());
                rsGoodsRelDomain.setSkuShowno(gtGiftRel.getSkuShowno());
                rsGoodsRelDomain.setPricesetNprice(gtGiftRel.getPricesetNprice());
                rsGoodsRelDomain.setPricesetMakeprice(gtGiftRel.getPricesetMakeprice());
                rsGoodsRelDomain.setPricesetBaseprice(gtGiftRel.getPricesetBaseprice());
                rsGoodsRelDomain.setGoodsWeight(gtGiftRel.getGoodsWeight());
                rsGoodsRelDomain.setGoodsNum(gtGiftRel.getGoodsNum());
                rsGoodsRelDomain.setDataPic(gtGiftRel.getDataPic());
                rsGoodsRelDomain.setDataPicpath(gtGiftRel.getDataPicpath());
                rsGoodsRelDomain.setAppmanageIcode(gtGiftRel.getAppmanageIcode());
                rsGoodsRelDomainList.add(rsGoodsRelDomain);
            }
            rsResourceGoodsDomain.setRsGoodsRelDomainList(rsGoodsRelDomainList);
        }
        ArrayList<RsSpecValueDomain> RsSpecValueList = new ArrayList<RsSpecValueDomain>();
        GtGiftSpecDomain gtGiftSpecDomain = (GtGiftSpecDomain)gtGiftReDomain.getGtGiftSpecDomainList().get(0);
        RsSpecValueDomain rsSpecValue = new RsSpecValueDomain();
        rsSpecValue.setSpecCode(gtGiftSpecDomain.getSpecCode());
        rsSpecValue.setSpecName(gtGiftSpecDomain.getSpecName());
        rsSpecValue.setSpecGroupCode(gtGiftSpecDomain.getSpecGroupCode());
        rsSpecValue.setSpecValueBillno(gtGiftReDomain.getGiftCode());
        rsSpecValue.setSpecValueFlag(gtGiftSpecDomain.getSpecValueFlag());
        rsSpecValue.setSpecValueType(gtGiftSpecDomain.getSpecValueType());
        rsSpecValue.setSpecValueValue(gtGiftSpecDomain.getSpecValueValue());
        rsSpecValue.setTenantCode(gtGiftReDomain.getTenantCode());
        RsSpecValueList.add(rsSpecValue);
        rsResourceGoodsDomain.setRsSpecValueDomainList(RsSpecValueList);
        return rsResourceGoodsDomain;
    }
}

