/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.interceptor.bean;

import com.qjsoft.laser.controller.core.auth.AuthBean;
import com.qjsoft.laser.controller.core.auth.PermissonList;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.interceptor.bean.InterBean;
import com.qjsoft.laser.controller.interceptor.bean.LogLogDomainBean;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class LogLogHandler {
    public static LogLogDomainBean logControlStart(Map<String, Object> requestParamtersMap, InterBean interBean, AuthBean authBean) {
        return LogLogHandler.makeLog(requestParamtersMap, interBean, authBean, 0L, true);
    }

    public static LogLogDomainBean logControlEnd(Map<String, Object> requestParamtersMap, InterBean interBean, AuthBean authBean) {
        return LogLogHandler.makeLog(requestParamtersMap, interBean, authBean, 0L, false);
    }

    private static LogLogDomainBean makeLog(Map<String, Object> requestParamtersMap, InterBean interBean, AuthBean authBean, Long logType, boolean start) {
        if (null == interBean || null == authBean) {
            return null;
        }
        PermissonList permissonList = authBean.getPermissonList();
        if (null == permissonList) {
            return null;
        }
        UserSession userSession = authBean.getUserSession();
        if (logType == null) {
            logType = 0L;
        }
        Object logBillno = null;
        String msg = permissonList.getPermissionListName();
        msg = start ? msg + "\uff1a\u64cd\u4f5c\u5f00\u59cb" : msg + "\uff1a\u64cd\u4f5c\u7ed3\u675f";
        String no = "";
        no = start ? permissonList.getPermissionLogSno() : permissonList.getPermissionLogNno();
        if (StringUtils.isNotBlank((String)no)) {
            String[] s = no.split("\\.");
            HashMap<String, Object> objMap = new HashMap<String, Object>();
            String firstPropertyName = "";
            for (String propertyName : s) {
                Object obj;
                if (StringUtils.isBlank((String)firstPropertyName)) {
                    firstPropertyName = propertyName;
                }
                if ((obj = BeanUtils.newForceGetProperty(requestParamtersMap, (String)propertyName)) == null) continue;
                objMap.put(propertyName, obj);
            }
            if (MapUtil.isNotEmpty(objMap)) {
                logBillno = objMap.get(firstPropertyName);
                msg = msg + JsonUtil.buildNormalBinder().toJson(objMap);
            }
        }
        String logBillnoStr = logBillno == null ? "" : logBillno.toString();
        LogLogDomainBean oplog = new LogLogDomainBean();
        if (userSession != null) {
            oplog.setUserCode(userSession.getUserCode());
            oplog.setUserName(userSession.getUserRelname());
        }
        oplog.setLogIp(interBean.getIp());
        oplog.setLogUseragent(interBean.getOauthEnvCode());
        oplog.setLogHostname(interBean.getHostname());
        oplog.setTenantCode(userSession.getTenantCode());
        oplog.setAppmanageIcode(interBean.getProappCode());
        oplog.setLogBillno(logBillnoStr);
        oplog.setLogMessage(msg);
        oplog.setLogPermislistCode(permissonList.getPermissionListCode());
        oplog.setLogPermislistName(permissonList.getPermissionListName());
        oplog.setLogPermisCode(permissonList.getPermissionCode());
        oplog.setLogType(String.valueOf(logType));
        return oplog;
    }
}

