/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.log.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.log.domain.LogErrorLogDomain;
import com.qjsoft.laser.controller.facade.log.domain.LogErrorLogReDomain;
import com.qjsoft.laser.controller.facade.log.repository.LogErrorLogServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/log/logerror"}, name="\u5ba2\u6237\u7aef\u5f02\u5e38\u64cd\u4f5c")
public class LogerrorCon
extends SpringmvcController {
    private static String CODE = "log.logerror.con";
    @Autowired
    private LogErrorLogServiceRepository logErrorLogServiceRepository;

    protected String getContext() {
        return "logerror";
    }

    @RequestMapping(value={"saveLogerror.json"}, name="\u589e\u52a0\u5ba2\u6237\u7aef\u5f02\u5e38\u64cd\u4f5c")
    @ResponseBody
    public HtmlJsonReBean saveLogerror(HttpServletRequest request, LogErrorLogDomain logerrorDomain) {
        if (null == logerrorDomain) {
            this.logger.error(CODE + ".saveLogerror", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        logerrorDomain.setTenantCode(this.getTenantCode(request));
        return this.logErrorLogServiceRepository.saveErrorLog(logerrorDomain);
    }

    @RequestMapping(value={"getLogerror.json"}, name="\u83b7\u53d6\u5ba2\u6237\u7aef\u5f02\u5e38\u64cd\u4f5c\u4fe1\u606f")
    @ResponseBody
    public LogErrorLogReDomain getLogerror(Integer logErrorId) {
        if (StringUtils.isBlank((Integer)logErrorId)) {
            this.logger.error(CODE + ".getLogerror", (Object)"param is null");
            return null;
        }
        return this.logErrorLogServiceRepository.getErrorLog(logErrorId);
    }

    @RequestMapping(value={"updateLogerror.json"}, name="\u66f4\u65b0\u5ba2\u6237\u7aef\u5f02\u5e38\u64cd\u4f5c")
    @ResponseBody
    public HtmlJsonReBean updateLogerror(HttpServletRequest request, LogErrorLogDomain logerrorDomain) {
        if (null == logerrorDomain) {
            this.logger.error(CODE + ".updateLogerror", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        logerrorDomain.setTenantCode(this.getTenantCode(request));
        return this.logErrorLogServiceRepository.updateErrorLog(logerrorDomain);
    }

    @RequestMapping(value={"deleteLogerror.json"}, name="\u5220\u9664\u5ba2\u6237\u7aef\u5f02\u5e38\u64cd\u4f5c")
    @ResponseBody
    public HtmlJsonReBean deleteLogerror(Integer logErrorId) {
        if (StringUtils.isBlank((Integer)logErrorId)) {
            this.logger.error(CODE + ".deleteLogerror", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.logErrorLogServiceRepository.deleteErrorLog(logErrorId);
    }

    @RequestMapping(value={"queryLogerrorPage.json"}, name="\u67e5\u8be2\u5ba2\u6237\u7aef\u5f02\u5e38\u64cd\u4f5c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<LogErrorLogReDomain> queryLogerrorPage(HttpServletRequest request) {
        Map param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.logErrorLogServiceRepository.queryErrorLogPage(param);
    }

    @RequestMapping(value={"updateLogerrorState.json"}, name="\u66f4\u65b0\u5ba2\u6237\u7aef\u5f02\u5e38\u64cd\u4f5c\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateLogerrorState(String logErrorId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)logErrorId)) {
            this.logger.error(CODE + ".updateLogerrorState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.logErrorLogServiceRepository.updateErrorLogState(Integer.valueOf(logErrorId), dataState, oldDataState);
    }
}

