/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.lt.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.lt.domain.LtLtinfoReDomain;
import com.qjsoft.laser.controller.facade.lt.domain.LtLtuserDomain;
import com.qjsoft.laser.controller.facade.lt.domain.LtLtuserReDomain;
import com.qjsoft.laser.controller.facade.lt.repository.LtLtinfoServiceRepository;
import com.qjsoft.laser.controller.facade.lt.repository.LtLtuserServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSettlDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OrderDomain;
import com.qjsoft.laser.controller.facade.oc.domain.PackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.TypeBean;
import com.qjsoft.laser.controller.facade.oc.repository.OcServiceRepository;
import com.qjsoft.laser.controller.facade.upm.domain.UpmUpointsReDomain;
import com.qjsoft.laser.controller.facade.upm.repository.UpmUpointsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/lt/ltuser"}, name="\u7528\u6237\u62bd\u5956")
public class LtuserCon
extends SpringmvcController {
    private static String CODE = "lt.ltuser.con";
    @Autowired
    private LtLtuserServiceRepository ltLtuserServiceRepository;
    @Autowired
    private LtLtinfoServiceRepository ltLtinfoServiceRepository;
    @Autowired
    private UpmUpointsServiceRepository upmUpointsServiceRepository;
    @Autowired
    private OcServiceRepository ocServiceRepository;

    protected String getContext() {
        return "ltuser";
    }

    @RequestMapping(value={"saveLtuser.json"}, name="\u589e\u52a0\u7528\u6237\u62bd\u5956")
    @ResponseBody
    public HtmlJsonReBean saveLtuser(HttpServletRequest request, String ltinfoCode) {
        if (StringUtils.isBlank((String)ltinfoCode)) {
            this.logger.error(CODE + ".saveLtuser", (Object)"ltinfoCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        LtLtinfoReDomain ltLtinfoReDomain = this.ltLtinfoServiceRepository.getLtinfoByCode(this.getTenantCode(request), ltinfoCode);
        if (null == ltLtinfoReDomain) {
            this.logger.error(CODE + ".saveLtuser", (Object)"ltLtinfoReDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveOrder(request, ltLtinfoReDomain);
    }

    private HtmlJsonReBean saveOrder(HttpServletRequest request, LtLtinfoReDomain ltLtinfoReDomain) {
        if (null == ltLtinfoReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrderDomain orderDomain = new OrderDomain();
        String shoppingType = "09";
        HashMap<String, Object> map = new HashMap<String, Object>();
        TypeBean typeBean = this.ocServiceRepository.getOcSetting(shoppingType, ltLtinfoReDomain.getTenantCode());
        if (null != typeBean) {
            orderDomain.setContractBlance(typeBean.getBlance());
            orderDomain.setContractPmode(typeBean.getPmode());
            map.put("contractBlance", typeBean.getBlance());
            map.put("contractPmode", typeBean.getPmode());
        }
        orderDomain.setContractRemark(ltLtinfoReDomain.getLtinfoName());
        orderDomain.setContractType(shoppingType);
        orderDomain.setContractTypepro("01");
        orderDomain.setGoodsReceiptPhone("");
        orderDomain.setContractNbillcode(ltLtinfoReDomain.getLtinfoCode());
        ArrayList<PackageDomain> packageList = new ArrayList<PackageDomain>();
        orderDomain.setPackageList(packageList);
        PackageDomain packageDomain = new PackageDomain();
        packageList.add(packageDomain);
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        packageDomain.setContractGoodsList(contractGoodsList);
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        contractGoodsList.add(ocContractGoodsDomain);
        ocContractGoodsDomain.setAppmanageIcode(this.getProappCode(request));
        ocContractGoodsDomain.setContractGoodsInmoney(ltLtinfoReDomain.getLtinfoMoney());
        ocContractGoodsDomain.setContractGoodsMoney(ltLtinfoReDomain.getLtinfoMoney());
        ocContractGoodsDomain.setContractGoodsPrice(ltLtinfoReDomain.getLtinfoMoney());
        ocContractGoodsDomain.setPricesetNprice(ltLtinfoReDomain.getLtinfoMoney());
        ocContractGoodsDomain.setGoodsCamount(new BigDecimal("1"));
        ocContractGoodsDomain.setGoodsNum(new BigDecimal("1"));
        ocContractGoodsDomain.setGoodsName(ltLtinfoReDomain.getLtinfoName());
        ocContractGoodsDomain.setGoodsNo(ltLtinfoReDomain.getLtinfoCode());
        ocContractGoodsDomain.setGoodsCode(ltLtinfoReDomain.getLtinfoCode());
        ocContractGoodsDomain.setSkuCode(ltLtinfoReDomain.getLtinfoCode());
        ocContractGoodsDomain.setSkuNo(ltLtinfoReDomain.getLtinfoCode());
        ocContractGoodsDomain.setSkuName(ltLtinfoReDomain.getLtinfoName());
        ocContractGoodsDomain.setMemberBcode(userSession.getUserPcode());
        ocContractGoodsDomain.setMemberBname(userSession.getMerberCompname());
        ocContractGoodsDomain.setMemberCode(ltLtinfoReDomain.getMemberCode());
        ocContractGoodsDomain.setMemberName(ltLtinfoReDomain.getMemberName());
        ocContractGoodsDomain.setContractGoodsGtype("9");
        ocContractGoodsDomain.setTenantCode(userSession.getTenantCode());
        String nowChannel = this.getNowChannel(request);
        ocContractGoodsDomain.setChannelCode(nowChannel);
        UpmUpointsReDomain upointsReDomain = this.upmUpointsServiceRepository.getUpointsUserCode(userSession.getUserPcode(), nowChannel, userSession.getTenantCode(), "0");
        BigDecimal upointsNum = upointsReDomain.getUpointsNum();
        int compare = upointsNum.compareTo(ltLtinfoReDomain.getLtinfoMoney());
        if (compare >= 0) {
            OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
            ocContractSettlDomain.setContractSettlBlance("INT");
            ocContractSettlDomain.setContractSettlPmoney(ltLtinfoReDomain.getLtinfoMoney());
            ArrayList<OcContractSettlDomain> list = new ArrayList<OcContractSettlDomain>();
            list.add(ocContractSettlDomain);
            orderDomain.setOcContractSettlList(list);
        }
        ArrayList<OrderDomain> orderDomainList = new ArrayList<OrderDomain>();
        orderDomainList.add(orderDomain);
        map.put("contractType", shoppingType);
        this.logger.error(CODE + ".saveOrder.orderDomainList", (Object)JsonUtil.buildNonDefaultBinder().toJson(orderDomainList));
        HtmlJsonReBean htmlJsonReBean = this.ocServiceRepository.createOcOrder(orderDomainList, shoppingType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), null);
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        map.put("dataBmoney", ltLtinfoReDomain.getLtinfoMoney());
        map.put("contractBillcode", htmlJsonReBean.getDataObj());
        htmlJsonReBean.setDataObj(map);
        return htmlJsonReBean;
    }

    public boolean checkUserAuthority(LtLtinfoReDomain ltLtinfoReDomain, String userInfoCode) {
        if (1 == ltLtinfoReDomain.getLtinfoUser()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("fuzzy", false);
            params.put("ltinfoCode", ltLtinfoReDomain.getLtinfoCode());
            params.put("ltinfoUserOp", userInfoCode);
            params.put("tenantCode", ltLtinfoReDomain.getTenantCode());
        }
        return true;
    }

    @RequestMapping(value={"getLtuser.json"}, name="\u83b7\u53d6\u7528\u6237\u62bd\u5956\u4fe1\u606f")
    @ResponseBody
    public LtLtuserReDomain getLtuser(Integer ltuserId) {
        if (StringUtils.isBlank((Integer)ltuserId)) {
            this.logger.error(CODE + ".getLtuser", (Object)"param is null");
            return null;
        }
        return this.ltLtuserServiceRepository.getLtuser(ltuserId);
    }

    @RequestMapping(value={"updateLtuser.json"}, name="\u66f4\u65b0\u7528\u6237\u62bd\u5956")
    @ResponseBody
    public HtmlJsonReBean updateLtuser(HttpServletRequest request, LtLtuserDomain ltLtuserDomain) {
        if (null == ltLtuserDomain) {
            this.logger.error(CODE + ".updateLtuser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ltLtuserDomain.setTenantCode(this.getTenantCode(request));
        return this.ltLtuserServiceRepository.updateLtuser(ltLtuserDomain);
    }

    @RequestMapping(value={"deleteLtuser.json"}, name="\u5220\u9664\u7528\u6237\u62bd\u5956")
    @ResponseBody
    public HtmlJsonReBean deleteLtuser(Integer ltuserId) {
        if (StringUtils.isBlank((Integer)ltuserId)) {
            this.logger.error(CODE + ".deleteLtuser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ltLtuserServiceRepository.deleteLtuser(ltuserId);
    }

    @RequestMapping(value={"queryLtuserPage.json"}, name="\u67e5\u8be2\u7528\u6237\u62bd\u5956\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<LtLtuserReDomain> queryLtuserPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ltLtuserServiceRepository.queryLtuserPage(param);
    }

    @RequestMapping(value={"updateLtuserState.json"}, name="\u66f4\u65b0\u7528\u6237\u62bd\u5956\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateLtuserState(String ltuserId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)ltuserId)) {
            this.logger.error(CODE + ".updateLtuserState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ltLtuserServiceRepository.updateLtuserState(Integer.valueOf(ltuserId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"getLtuserInfo.json"}, name="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u8005\u62bd\u5956\u4fe1\u606f\uff08\u53ef\u62bd\u5956\u6b21\u6570\u3001\u6d3b\u52a8\u3001\u5956\u54c1\u4fe1\u606f\uff09")
    @ResponseBody
    public LtLtinfoReDomain getLtuserInfo(HttpServletRequest request, String ltinfoCode) {
        Map<String, String> param;
        LtLtinfoReDomain ltLtinfoReDomain;
        if (StringUtils.isNotBlank((String)ltinfoCode)) {
            ltLtinfoReDomain = this.ltLtinfoServiceRepository.getLtinfoByCode(this.getTenantCode(request), ltinfoCode);
        } else {
            param = this.assemMapParam(request);
            if (null == param) {
                param = new HashMap<String, Integer>();
                param.put("tenantCode", this.getTenantCode(request));
            }
            param.put("dataState", (String)((Object)Integer.valueOf(1)));
            SupQueryResult qltinfo = this.ltLtinfoServiceRepository.queryLtinfoPage(param);
            if (null == qltinfo || qltinfo.getList().isEmpty()) {
                this.logger.error(CODE + ".getLtuserInfo", (Object)"getLtuserInfo is null");
                return null;
            }
            ltLtinfoReDomain = (LtLtinfoReDomain)qltinfo.getList().get(0);
            ltLtinfoReDomain = this.ltLtinfoServiceRepository.getLtinfoByCode(this.getTenantCode(request), ltLtinfoReDomain.getLtinfoCode());
        }
        param = this.assemMapParam(request);
        if (null == param) {
            param = new HashMap();
            param.put("tenantCode", this.getTenantCode(request));
        }
        param.put("ltinfoCode", ltLtinfoReDomain.getLtinfoCode());
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getLtuserInfo", (Object)"userSession is null");
            return null;
        }
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult qlist = this.ltLtuserServiceRepository.queryLtuserPage(param);
        if (null != qlist && !qlist.getList().isEmpty()) {
            ltLtinfoReDomain.setLtuserNum(((LtLtuserReDomain)qlist.getList().get(0)).getLtuserNum());
        }
        return ltLtinfoReDomain;
    }
}

