/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mindex.controller;

import com.qjsoft.laser.controller.core.auth.AuthService;
import com.qjsoft.laser.controller.core.auth.MenuInfoBean;
import com.qjsoft.laser.controller.core.auth.UserInfo;
import com.qjsoft.laser.controller.mindex.bean.IndexBean;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/mi/mindex"})
public class MindexCon
extends SpringmvcController {
    @Autowired
    private AuthService authService;

    protected String getContext() {
        return "mindex";
    }

    @RequestMapping(value={"index.json"})
    @ResponseBody
    public IndexBean index(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        IndexBean indexBean = new IndexBean();
        List<MenuInfoBean> menuList = this.navQuery(proappCode, tenantCode);
        indexBean.setTopMenuList(menuList);
        if (null != menuList && !menuList.isEmpty()) {
            List<MenuInfoBean> childList = null;
            for (MenuInfoBean menuBean : menuList) {
                childList = this.makeMenu(menuBean.getProappMenuCode(), proappCode, tenantCode);
                menuBean.setChildren(childList);
            }
        }
        UserInfo userInfo = this.getUserInfo(request);
        indexBean.setUserInfo(userInfo);
        return indexBean;
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public List<MenuInfoBean> listQuery(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        return this.navQuery(proappCode, tenantCode);
    }

    @RequestMapping(value={"menuQuery.json"})
    @ResponseBody
    public List<MenuInfoBean> menuQuery(HttpServletRequest request, String menuParentCode) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        return this.makeMenu(menuParentCode, proappCode, tenantCode);
    }

    private List<MenuInfoBean> navQuery(String proappCode, String tenantCode) {
        return this.authService.navQuery(proappCode, tenantCode);
    }

    private List<MenuInfoBean> makeMenu(String menuParentCode, String proappCode, String tenantCode) {
        return this.authService.makeMenu(menuParentCode, proappCode, tenantCode);
    }
}

