/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mlogin.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.os.domain.OsOAuthEnvconfigReDomain;
import com.qjsoft.laser.controller.facade.os.domain.WeChartOpenIDBean;
import com.qjsoft.laser.controller.facade.os.repository.OsOAuthEnvconfigServiceRepository;
import com.qjsoft.laser.controller.facade.os.repository.OsOAuthThirdLoginRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ml/mgeneration"})
public class MGeneration
extends SpringmvcController {
    private static String CODE = "ml.mgeneration.con";
    @Autowired
    private OsOAuthEnvconfigServiceRepository osOAuthEnvconfigServiceRepository;
    @Autowired
    private OsOAuthThirdLoginRepository osOAuthThirdLoginRepository;

    @RequestMapping(value={"getAllDraft.json"}, name="\u83b7\u53d6\u6240\u6709\u8349\u7a3f")
    @ResponseBody
    public HtmlJsonReBean getAllDraft(HttpServletRequest request, String encryptedData, String iv, String code) {
        if (null == encryptedData || null == iv || null == code) {
            this.logger.error(CODE + ".getAllDraft", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6ca1\u6709\u83b7\u53d6\u5230\u8349\u7a3f\u6570\u636e");
        }
        String json = this.getMicroMessenger(request, code, false);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(CODE + ".getAllDraft", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6ca1\u6709\u83b7\u53d6\u5230\u8349\u7a3f\u6570\u636e");
        }
        return new HtmlJsonReBean((Object)json);
    }

    protected String getContext() {
        return "mgeneration";
    }

    private String getMicroMessenger(HttpServletRequest request, String authcode, boolean isMiniProgram) {
        HtmlJsonReBean htmlJsonReBean;
        Map<String, Object> map = this.getOAuthEnvconfig(request);
        if (null == map || map.isEmpty()) {
            return null;
        }
        String access_token = request.getParameter("access_token");
        if (StringUtils.isBlank((String)access_token)) {
            WeChartOpenIDBean weChartOpenIDBean = this.getMiniToken(request);
            if (null == weChartOpenIDBean || StringUtils.isBlank((String)weChartOpenIDBean.getAccess_token())) {
                this.logger.error(CODE + ".access_token is null");
                return null;
            }
            access_token = weChartOpenIDBean.getAccess_token();
        }
        if (null == (htmlJsonReBean = this.osOAuthThirdLoginRepository.microMessengerGetAllGeneration(access_token))) {
            this.logger.error(CODE + "getMicroMessenger is null");
            return null;
        }
        String json = (String)htmlJsonReBean.getDataObj();
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(CODE + ".getMicroMessenger.json is null");
            return null;
        }
        return json;
    }

    private Map<String, Object> getOAuthEnvconfig(HttpServletRequest request) {
        String proappCode;
        String oauthEnvCode;
        String tenantCode = this.getTenantCode(request);
        List nlist = this.osOAuthEnvconfigServiceRepository.queryOAuthEnvconfigByEnvCode(tenantCode, oauthEnvCode = this.getOauthEnvCode(request), proappCode = this.getProappCode(request));
        if (null == nlist || nlist.isEmpty()) {
            this.logger.error(CODE + ".getOAuthEnvconfig.nlist", (Object)(tenantCode + "-" + oauthEnvCode + "-" + proappCode));
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (OsOAuthEnvconfigReDomain osOAuthEnvconfigReDomain : nlist) {
            map.put(osOAuthEnvconfigReDomain.getOauthEnvconfigType(), osOAuthEnvconfigReDomain.getOauthEnvconfigValue());
        }
        this.logger.error(CODE + ".getOAuthEnvconfig.map", (Object)(tenantCode + "-" + oauthEnvCode + "-" + proappCode + ":" + ((Object)map).toString()));
        return map;
    }

    private WeChartOpenIDBean getMiniToken(HttpServletRequest request) {
        String tenantCode;
        String secret;
        Map<String, Object> map = this.getOAuthEnvconfig(request);
        if (null == map || map.isEmpty()) {
            return null;
        }
        String appid = (String)map.get("appid");
        HtmlJsonReBean htmlJsonReBean = this.osOAuthThirdLoginRepository.microMessengerPageLogin(appid, secret = (String)map.get("secret"), "client_credential", tenantCode = this.getTenantCode(request));
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            this.logger.error(CODE + ".getMiniToken.htmlJsonReBean", (Object)map.toString());
            return null;
        }
        String json = (String)htmlJsonReBean.getDataObj();
        WeChartOpenIDBean weChartOpenIDBean = (WeChartOpenIDBean)JsonUtil.buildNormalBinder().getJsonToObject(json, WeChartOpenIDBean.class);
        if (null == weChartOpenIDBean || StringUtils.isBlank((String)weChartOpenIDBean.getAccess_token())) {
            this.logger.error(CODE + ".getMiniToken.weChartOpenIDBean2");
            return null;
        }
        return weChartOpenIDBean;
    }
}

