/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mlogin.controller.task;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcRefundServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcShoppingServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.mlogin.controller.task.utils.DataFetcher;
import com.qjsoft.laser.controller.mlogin.controller.task.utils.DataProcessor;
import com.qjsoft.laser.controller.mlogin.controller.task.utils.PagedDataProcessor;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PublicLoginTaskService {
    private static final String CODE = "mlogin.PublicLoginTaskService";
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private OcRefundServiceRepository ocRefundServiceRepository;
    @Autowired
    private OcShoppingServiceRepository ocShoppingServiceRepository;
    @Autowired
    private PagedDataProcessor pagedDataProcessor;
    private static final int PAGE_SIZE = 100;

    @Async(value="taskExecutor")
    public void asyncTransferPublicUserData(String userPhone, final String userinfoCode, final String tenantCode, SupperLogUtil logger) {
        long currentTimeMillis = System.currentTimeMillis();
        logger.error("mlogin.PublicLoginTaskService.asyncTransferPublicUserData.\u5f02\u6b65\u4efb\u52a1\u5f00\u59cb\uff1a" + Thread.currentThread().getName());
        if (StringUtils.isBlank((String)userPhone) || StringUtils.isBlank((String)userinfoCode)) {
            logger.error("mlogin.PublicLoginTaskService.asyncTransferPublicUserData.param is null", (Object)(userPhone + "-" + userinfoCode));
            return;
        }
        HashMap<String, String> umParam = new HashMap<String, String>();
        umParam.put("userinfoPhone", userPhone);
        umParam.put("tenantCode", tenantCode);
        HtmlJsonReBean htmlJsonReBean = this.userServiceRepository.queryAllUserPhone(umParam);
        if (!htmlJsonReBean.isSuccess() || StringUtils.isBlank((String)htmlJsonReBean.getDataObj().toString())) {
            logger.error("mlogin.PublicLoginTaskService.asyncTransferPublicUserData.queryAllUserPhone.Error", (Object)JsonUtil.buildNormalBinder().toJson((Object)htmlJsonReBean));
            return;
        }
        final String userinfoCodes = htmlJsonReBean.getDataObj().toString();
        logger.error("mlogin.PublicLoginTaskService.asyncTransferPublicUserData.userinfoCodes", (Object)userinfoCodes);
        if (StringUtils.isBlank((String)userinfoCodes)) {
            logger.error("mlogin.PublicLoginTaskService.asyncTransferPublicUserData.queryAllUserPhone.Error", (Object)JsonUtil.buildNormalBinder().toJson((Object)htmlJsonReBean));
            return;
        }
        this.pagedDataProcessor.process(new DataFetcher<OcContractReDomain>(){

            @Override
            public SupQueryResult<OcContractReDomain> fetch(int page, int size) {
                return PublicLoginTaskService.this.fetchDataByPage(userinfoCodes, tenantCode, page, size);
            }
        }, new DataProcessor<OcContractReDomain>(){

            @Override
            public void process(List<OcContractReDomain> dataList) throws Exception {
                PublicLoginTaskService.this.processData(dataList, userinfoCode);
            }
        }, 100, logger);
        this.pagedDataProcessor.process(new DataFetcher<OcRefundReDomain>(){

            @Override
            public SupQueryResult<OcRefundReDomain> fetch(int page, int size) {
                return PublicLoginTaskService.this.fetchDataByOcRefundPage(userinfoCodes, tenantCode, page, size);
            }
        }, new DataProcessor<OcRefundReDomain>(){

            @Override
            public void process(List<OcRefundReDomain> dataList) throws Exception {
                PublicLoginTaskService.this.processDataOcRefund(dataList, userinfoCode);
            }
        }, 100, logger);
        this.pagedDataProcessor.process(new DataFetcher<OcShoppingReDomain>(){

            @Override
            public SupQueryResult<OcShoppingReDomain> fetch(int page, int size) {
                return PublicLoginTaskService.this.fetchDataByOcShoppingPage(userinfoCodes, tenantCode, page, size);
            }
        }, new DataProcessor<OcShoppingReDomain>(){

            @Override
            public void process(List<OcShoppingReDomain> dataList) throws Exception {
                PublicLoginTaskService.this.processDataOcShopping(dataList, userinfoCode);
            }
        }, 100, logger);
        this.pagedDataProcessor.process(new DataFetcher<OcShoppingGoodsReDomain>(){

            @Override
            public SupQueryResult<OcShoppingGoodsReDomain> fetch(int page, int size) {
                return PublicLoginTaskService.this.fetchDataByOcShoppingGoodsPage(userinfoCodes, tenantCode, page, size);
            }
        }, new DataProcessor<OcShoppingGoodsReDomain>(){

            @Override
            public void process(List<OcShoppingGoodsReDomain> dataList) throws Exception {
                PublicLoginTaskService.this.processDataOcShoppingGoods(dataList, userinfoCode);
            }
        }, 100, logger);
        logger.error("mlogin.PublicLoginTaskService.asyncTransferPublicUserData.\u5f02\u6b65\u4efb\u52a1\u7ed3\u675f\uff1a" + Thread.currentThread().getName() + " \u6267\u884c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - currentTimeMillis));
    }

    public SupQueryResult<OcContractReDomain> fetchDataByPage(String userinfoCode, String tenantCode, int pageNumber, int pageSize) {
        HashMap<String, Object> ocParam = new HashMap<String, Object>();
        ocParam.put("memberBcode", userinfoCode);
        ocParam.put("tenantCode", tenantCode);
        ocParam.put("appmanageIcode", "02333");
        ocParam.put("page", pageNumber);
        ocParam.put("rows", pageSize);
        return this.ocContractServiceRepository.queryContractPage(ocParam);
    }

    private void processData(List<OcContractReDomain> ocContractReDomains, String userinfoCode) throws Exception {
        if (ListUtil.isEmpty(ocContractReDomains)) {
            return;
        }
        ArrayList mapList = new ArrayList();
        for (OcContractReDomain ocContractReDomain : ocContractReDomains) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("contractBillcode", ocContractReDomain.getContractBillcode());
            item.put("tenantCode", ocContractReDomain.getTenantCode());
            item.put("memberBcode", userinfoCode);
            mapList.add(item);
        }
        if (mapList.size() != 0) {
            this.ocContractServiceRepository.updateContractBatch(mapList);
        }
    }

    public SupQueryResult<OcRefundReDomain> fetchDataByOcRefundPage(String userinfoCode, String tenantCode, int pageNumber, int pageSize) {
        HashMap<String, Object> ocParam = new HashMap<String, Object>();
        ocParam.put("memberBcode", userinfoCode);
        ocParam.put("tenantCode", tenantCode);
        ocParam.put("appmanageIcode", "02333");
        ocParam.put("page", pageNumber);
        ocParam.put("rows", pageSize);
        return this.ocRefundServiceRepository.queryRefundPage(ocParam);
    }

    private void processDataOcRefund(List<OcRefundReDomain> ocRefundReDomains, String userinfoCode) throws Exception {
        if (ListUtil.isEmpty(ocRefundReDomains)) {
            return;
        }
        for (OcRefundReDomain ocRefundReDomain : ocRefundReDomains) {
            ocRefundReDomain.setMemberBcode(userinfoCode);
            this.ocRefundServiceRepository.updateRefund((OcRefundDomain)ocRefundReDomain);
        }
    }

    public SupQueryResult<OcShoppingReDomain> fetchDataByOcShoppingPage(String userinfoCode, String tenantCode, int pageNumber, int pageSize) {
        HashMap<String, Object> ocParam = new HashMap<String, Object>();
        ocParam.put("memberBcode", userinfoCode);
        ocParam.put("tenantCode", tenantCode);
        ocParam.put("proappCode", "02333");
        ocParam.put("page", pageNumber);
        ocParam.put("rows", pageSize);
        return this.ocShoppingServiceRepository.queryShoppingPage(ocParam);
    }

    private void processDataOcShopping(List<OcShoppingReDomain> ocShoppingReDomains, String userinfoCode) throws Exception {
        if (ListUtil.isEmpty(ocShoppingReDomains)) {
            return;
        }
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomains) {
            ocShoppingReDomain.setMemberBcode(userinfoCode);
            this.ocShoppingServiceRepository.updateShopping((OcShoppingDomain)ocShoppingReDomain);
        }
    }

    public SupQueryResult<OcShoppingGoodsReDomain> fetchDataByOcShoppingGoodsPage(String userinfoCode, String tenantCode, int pageNumber, int pageSize) {
        HashMap<String, Object> ocParam = new HashMap<String, Object>();
        ocParam.put("memberBcode", userinfoCode);
        ocParam.put("tenantCode", tenantCode);
        ocParam.put("proappCode", "02333");
        ocParam.put("page", pageNumber);
        ocParam.put("rows", pageSize);
        return this.ocShoppingServiceRepository.queryShoppingGoodsPage(ocParam);
    }

    private void processDataOcShoppingGoods(List<OcShoppingGoodsReDomain> ocShoppingGoodsReDomains, String userinfoCode) throws Exception {
        if (ListUtil.isEmpty(ocShoppingGoodsReDomains)) {
            return;
        }
        for (OcShoppingGoodsReDomain ocShoppingGoodsReDomain : ocShoppingGoodsReDomains) {
            ocShoppingGoodsReDomain.setMemberBcode(userinfoCode);
            this.ocShoppingServiceRepository.updateShoppingGoods((OcShoppingGoodsDomain)ocShoppingGoodsReDomain);
        }
    }
}

