/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.org.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.org.domain.OrgDepartDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgDepartReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgDepartempDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgDepartempReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgEmployeeDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgEmployeeReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgGroupDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgGroupReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgGroupempDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgGroupempReDomain;
import com.qjsoft.laser.controller.facade.org.repository.OrgDepartServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgEmployeeServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgGroupServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/org/employee"}, name="\u5458\u5de5\u670d\u52a1")
public class orgEmployeeCon
extends SpringmvcController {
    private static String CODE = "org.employee.con";
    @Autowired
    private OrgEmployeeServiceRepository orgEmployeeServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private OrgDepartServiceRepository orgDepartServiceRepository;
    @Autowired
    private OrgGroupServiceRepository orgGroupServiceRepository;

    protected String getContext() {
        return "employee";
    }

    @RequestMapping(value={"queryEmployeePage.json"}, name="\u67e5\u8be2\u5458\u5de5\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgEmployeeReDomain> queryEmployeePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.orgEmployeeServiceRepository.queryEmployeePage(param);
    }

    @RequestMapping(value={"saveEmployee.json"}, name="\u589e\u52a0\u5458\u5de5\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveEmployee(HttpServletRequest request, OrgEmployeeDomain orgEmployeeDomain) {
        if (null == orgEmployeeDomain) {
            this.logger.error(CODE + ".saveEmployee", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        orgEmployeeDomain.setPositionCode("21312312");
        orgEmployeeDomain.setPositionName("\u9500\u552e\u5458");
        orgEmployeeDomain.setTenantCode(this.getTenantCode(request));
        return this.orgEmployeeServiceRepository.saveEmployee(orgEmployeeDomain);
    }

    @RequestMapping(value={"getEmployeePageByCode.json"}, name="\u67e5\u8be2Code\u5458\u5de5\u8be6\u60c5")
    @ResponseBody
    public OrgEmployeeReDomain getEmployeePageByCode(HttpServletRequest request, String employeeCode) {
        List groupempList;
        if (StringUtils.isBlank((String)employeeCode)) {
            this.logger.error(CODE + ".getEmployeePageByCode", (Object)"employeeCode is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        OrgEmployeeReDomain employeeReDomain = this.orgEmployeeServiceRepository.getEmployeeByCode(tenantCode, employeeCode);
        if (null == employeeReDomain) {
            this.logger.error(CODE + ".getEmployeePageByCode", (Object)"param is null");
            return null;
        }
        UmUserReDomainBean umUserReDomainBean = this.userServiceRepository.getUserByCode(employeeReDomain.getUserCode());
        if (null != umUserReDomainBean) {
            employeeReDomain.setUmUserReDomainBean(umUserReDomainBean);
        }
        HashMap<String, String> employeemap = new HashMap<String, String>();
        employeemap.put("employeeCode", employeeReDomain.getEmployeeCode());
        employeemap.put("tenantCode", tenantCode);
        List departempList = this.orgDepartServiceRepository.queryDepartempPage(employeemap).getList();
        if (null != departempList) {
            HashMap<String, String> departmap = new HashMap<String, String>();
            ArrayList<OrgDepartReDomain> orgdepartList = new ArrayList<OrgDepartReDomain>();
            for (OrgDepartempReDomain OrgDepartempReDomain2 : departempList) {
                departmap.put("departCode", OrgDepartempReDomain2.getDepartCode());
                departmap.put("tenantCode", tenantCode);
                List departList = this.orgDepartServiceRepository.queryDepartPage(departmap).getList();
                if (null == departList || departList.size() <= 0) {
                    this.logger.error(CODE + ".getEmployeePageByCode", (Object)"orgGroupReDomain is null");
                    return null;
                }
                OrgDepartReDomain orgDepartReDomain = (OrgDepartReDomain)departList.get(0);
                orgdepartList.add(orgDepartReDomain);
            }
            employeeReDomain.setDepartList(orgdepartList);
        }
        if (null != (groupempList = this.orgGroupServiceRepository.queryGroupempPage(employeemap).getList())) {
            HashMap<String, String> groupmap = new HashMap<String, String>();
            ArrayList<OrgGroupReDomain> orggroupeList = new ArrayList<OrgGroupReDomain>();
            for (OrgGroupempReDomain orgGroupempReDomain : groupempList) {
                groupmap.put("groupCode", orgGroupempReDomain.getGroupCode());
                groupmap.put("tenantCode", tenantCode);
                List groupList = this.orgGroupServiceRepository.queryGroupPage(groupmap).getList();
                if (null == groupList || groupList.size() <= 0) {
                    this.logger.error(CODE + ".getEmployeePageByCode", (Object)"orgGroupReDomain is null");
                    return null;
                }
                OrgGroupReDomain orgGroupReDomain = (OrgGroupReDomain)groupList.get(0);
                orggroupeList.add(orgGroupReDomain);
            }
            employeeReDomain.setGroupList(orggroupeList);
        }
        return employeeReDomain;
    }

    @RequestMapping(value={"updateEmployee.json"}, name="\u66f4\u65b0\u5458\u5de5\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateEmployee(HttpServletRequest request, OrgEmployeeDomain orgEmployeeDomain) {
        if (null == orgEmployeeDomain) {
            this.logger.error(CODE + ".updateEmployee", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        orgEmployeeDomain.setTenantCode(this.getTenantCode(request));
        return this.orgEmployeeServiceRepository.updateEmployee(orgEmployeeDomain);
    }

    @RequestMapping(value={"updateDepartempByCode.json"}, name="\u66f4\u65b0\u5458\u5de5\u90e8\u95e8")
    @ResponseBody
    public HtmlJsonReBean updateEmployeeByDepartempCode(HttpServletRequest request, String params) {
        if (StringUtils.isBlank((String)params)) {
            this.logger.error(CODE + ".params", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        OrgEmployeeDomain orgEmployeeDomain = (OrgEmployeeDomain)JsonUtil.buildNormalBinder().getJsonToObject(params, OrgEmployeeDomain.class);
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> departempmap = new HashMap<String, String>();
        departempmap.put("employeeCode", orgEmployeeDomain.getEmployeeCode());
        departempmap.put("tenantCode", tenantCode);
        List departempList = this.orgDepartServiceRepository.queryDepartempPage(departempmap).getList();
        if (null != departempList) {
            for (OrgDepartempReDomain departempReDomain : departempList) {
                this.orgDepartServiceRepository.deleteDepartempByCode(tenantCode, departempReDomain.getDepartempCode());
            }
        }
        List departList = orgEmployeeDomain.getOrgdepartList();
        ArrayList<OrgDepartempDomain> orgdepartList = new ArrayList<OrgDepartempDomain>();
        for (OrgDepartDomain orgDepartDomain : departList) {
            if (null == orgDepartDomain) {
                this.logger.error(CODE + ".updateEmployeeByDepartempCode", (Object)"orgDepartDomain is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            OrgDepartempDomain orgDepartempDomain = new OrgDepartempDomain();
            orgDepartempDomain.setDepartCode(orgDepartDomain.getDepartCode());
            orgDepartempDomain.setCompanyCode(orgEmployeeDomain.getCompanyCode());
            orgDepartempDomain.setEmployeeCode(orgEmployeeDomain.getEmployeeCode());
            orgDepartempDomain.setEmployeeName(orgEmployeeDomain.getEmployeeName());
            orgDepartempDomain.setPositionCode(orgEmployeeDomain.getPositionCode());
            orgDepartempDomain.setPositionName(orgEmployeeDomain.getPositionName());
            orgDepartempDomain.setUserinfoCode(orgEmployeeDomain.getUserinfoCode());
            orgDepartempDomain.setAppmanageIcode(orgEmployeeDomain.getAppmanageIcode());
            orgDepartempDomain.setTenantCode(tenantCode);
            orgdepartList.add(orgDepartempDomain);
        }
        return this.orgDepartServiceRepository.saveDepartempBatch(orgdepartList);
    }

    @RequestMapping(value={"updateGroupempByCode.json"}, name="\u66f4\u65b0\u5458\u5de5\u7fa4\u7ec4")
    @ResponseBody
    public HtmlJsonReBean updateGroupempByCode(HttpServletRequest request, String params) {
        if (StringUtils.isBlank((String)params)) {
            this.logger.error(CODE + ".params", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        OrgEmployeeDomain orgEmployeeDomain = (OrgEmployeeDomain)JsonUtil.buildNormalBinder().getJsonToObject(params, OrgEmployeeDomain.class);
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> groupempmap = new HashMap<String, String>();
        groupempmap.put("employeeCode", orgEmployeeDomain.getEmployeeCode());
        groupempmap.put("tenantCode", tenantCode);
        List groupempList = this.orgGroupServiceRepository.queryGroupempPage(groupempmap).getList();
        if (null != groupempList) {
            for (OrgGroupempReDomain orgGroupempReDomain : groupempList) {
                this.orgGroupServiceRepository.deleteGroupempByCode(tenantCode, orgGroupempReDomain.getGroupempCode());
            }
        }
        List groupList = orgEmployeeDomain.getOrggroupList();
        ArrayList<OrgGroupempDomain> orggroupempList = new ArrayList<OrgGroupempDomain>();
        for (OrgGroupDomain orgGroupDomain : groupList) {
            if (null == orgGroupDomain) {
                this.logger.error(CODE + ".updateGroupempByCode", (Object)"orgGroupDomain is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            OrgGroupempDomain orgGroupempDomain = new OrgGroupempDomain();
            orgGroupempDomain.setEmployeeCode(orgEmployeeDomain.getEmployeeCode());
            orgGroupempDomain.setEmployeeName(orgEmployeeDomain.getEmployeeName());
            orgGroupempDomain.setGroupCode(orgGroupDomain.getGroupCode());
            orgGroupempDomain.setCompanyCode(orgEmployeeDomain.getCompanyCode());
            orgGroupempDomain.setPositionCode(orgEmployeeDomain.getPositionCode());
            orgGroupempDomain.setPositionName(orgEmployeeDomain.getPositionName());
            orgGroupempDomain.setAppmanageIcode(orgEmployeeDomain.getAppmanageIcode());
            orgGroupempDomain.setTenantCode(tenantCode);
            orggroupempList.add(orgGroupempDomain);
        }
        return this.orgGroupServiceRepository.saveGroupempBatch(orggroupempList);
    }

    @RequestMapping(value={"deleteEmployee.json"}, name="\u5220\u9664\u5458\u5de5\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteEmployee(Integer employeeId) {
        if (StringUtils.isBlank((Integer)employeeId)) {
            this.logger.error(CODE + ".deleteEmployee", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.orgEmployeeServiceRepository.deleteEmployee(employeeId);
    }

    @RequestMapping(value={"queryEmployeePageByCompanyCode.json"}, name="\u6839\u636e\u516c\u53f8Code\u67e5\u8be2\u5458\u5de5\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgEmployeeReDomain> queryEmployeePageByCompanyCode(HttpServletRequest request, String companyCode) {
        if (StringUtils.isBlank((String)companyCode)) {
            this.logger.error(CODE + ".queryEmployeePageByCompanyCode", (Object)"companyCode is null");
            return null;
        }
        Map param = this.assemMapParam(request);
        param.put("companyCode", companyCode);
        param.put("order", true);
        param.put("fuzzy", true);
        return this.orgEmployeeServiceRepository.queryEmployeePage(param);
    }

    @RequestMapping(value={"queryEmployeePageByKH.json"}, name="\u5ba2\u6237\u5173\u7cfb\u67e5\u8be2\u5458\u5de5\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgEmployeeReDomain> queryEmployeePageByKH(HttpServletRequest request, String companyCode) {
        if (StringUtils.isBlank((String)companyCode)) {
            this.logger.error(CODE + ".queryEmployeePageByKH", (Object)"companyCode is null");
            return null;
        }
        Map param = this.assemMapParam(request);
        param.put("companyCode", companyCode);
        param.put("order", true);
        param.put("fuzzy", true);
        return this.orgEmployeeServiceRepository.queryEmployeePage(param);
    }

    @RequestMapping(value={"getEmployee.json"}, name="\u83b7\u53d6\u5458\u5de5\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OrgEmployeeReDomain getEmployee(Integer employeeId) {
        if (StringUtils.isBlank((Integer)employeeId)) {
            this.logger.error(CODE + ".getEmployee", (Object)"param is null");
            return null;
        }
        return this.orgEmployeeServiceRepository.getEmployee(employeeId);
    }

    @RequestMapping(value={"updateEmployeeState.json"}, name="\u66f4\u65b0\u5458\u5de5\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateEmployeeState(String employeeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)employeeId)) {
            this.logger.error(CODE + ".updateEmployeeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.orgEmployeeServiceRepository.updateEmployeeState(Integer.valueOf(employeeId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryEmployeeByUserCode.json"}, name="\u6839\u636eUserCode\u67e5\u627e\u672c\u516c\u53f8\u5458\u5de5\u548c\u804c\u4f4d")
    @ResponseBody
    public SupQueryResult<OrgEmployeeReDomain> queryEmployeeByUserCode(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        String userCode = userSession.getUserCode();
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> usermap = new HashMap<String, String>();
        usermap.put("userCode", userCode);
        usermap.put("tenantCode", tenantCode);
        List employeebyuser = this.orgEmployeeServiceRepository.queryEmployeePage(usermap).getList();
        if (null == employeebyuser || employeebyuser.size() <= 0) {
            this.logger.error(CODE + ".queryEmployeeByUserCode", (Object)"employeebyuser is null");
            return null;
        }
        OrgEmployeeReDomain orgEmployeeReDomain = (OrgEmployeeReDomain)employeebyuser.get(0);
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("companyCode", orgEmployeeReDomain.getCompanyCode());
            param.remove("userCode");
        }
        return this.orgEmployeeServiceRepository.queryEmployeePage(param);
    }

    @RequestMapping(value={"saveEmployeeBeltCheck.json"}, name="\u6dfb\u52a0\u5458\u5de5\u5e26\u6821\u9a8c")
    @ResponseBody
    public HtmlJsonReBean saveEmployeeBeltCheck(HttpServletRequest request, String userPhone, String employeeName, String positionCode, String positionName, String companyCode) {
        if (StringUtils.isBlank((String)userPhone) || StringUtils.isBlank((String)employeeName) || StringUtils.isBlank((String)positionCode) || StringUtils.isBlank((String)positionName) || StringUtils.isBlank((String)companyCode)) {
            this.logger.error(CODE + ".saveEmployeeBeltCheck", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> usermap = new HashMap<String, String>();
        usermap.put("userPhone", userPhone);
        usermap.put("tenantCode", tenantCode);
        List userList = this.userServiceRepository.queryUserPage(usermap).getList();
        if (null == userList || userList.size() <= 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u6b64\u7528\u6237");
        }
        UmUserReDomainBean umUserReDomainBean = (UmUserReDomainBean)userList.get(0);
        HashMap<String, String> employeemap = new HashMap<String, String>();
        employeemap.put("userCode", umUserReDomainBean.getUserCode());
        employeemap.put("tenantCode", tenantCode);
        List employee = this.orgEmployeeServiceRepository.queryEmployeePage(employeemap).getList();
        if (null == employee || employee.size() <= 0) {
            OrgEmployeeDomain orgEmployeeDomain = new OrgEmployeeDomain();
            orgEmployeeDomain.setCompanyCode(companyCode);
            orgEmployeeDomain.setEmployeeName(employeeName);
            orgEmployeeDomain.setEmployeePhone(userPhone);
            orgEmployeeDomain.setPositionCode(positionCode);
            orgEmployeeDomain.setPositionName(positionName);
            orgEmployeeDomain.setUserCode(umUserReDomainBean.getUserCode());
            orgEmployeeDomain.setUserinfoCode(umUserReDomainBean.getUserPcode());
            orgEmployeeDomain.setTenantCode(tenantCode);
            return this.orgEmployeeServiceRepository.saveEmployee(orgEmployeeDomain);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u7528\u6237\u5df2\u5b58\u5728\u5176\u4ed6\u7ec4\u7ec7");
    }

    @RequestMapping(value={"queryEmployeeUnassigned.json"}, name="\u67e5\u8be2\u516c\u53f8\u672a\u5206\u914d\u90e8\u95e8\u5458\u5de5")
    @ResponseBody
    public List<OrgEmployeeReDomain> queryEmployeeUnassigned(HttpServletRequest request, String userCode) {
        if (StringUtils.isBlank((String)userCode)) {
            this.logger.error(CODE + ".queryEmployeeUnassigned", (Object)"userCode is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> usermap = new HashMap<String, String>();
        usermap.put("userCode", userCode);
        usermap.put("tenantCode", tenantCode);
        List orgEmployee = this.orgEmployeeServiceRepository.queryEmployeePage(usermap).getList();
        if (null == orgEmployee || orgEmployee.size() <= 0) {
            this.logger.error(CODE + ".queryEmployeeUnassigned", (Object)"orgEmployee is null");
            return null;
        }
        OrgEmployeeReDomain orgEmployeeReDomain = (OrgEmployeeReDomain)orgEmployee.get(0);
        HashMap<String, String> orgEmployeemap = new HashMap<String, String>();
        orgEmployeemap.put("companyCode", orgEmployeeReDomain.getCompanyCode());
        orgEmployeemap.put("tenantCode", tenantCode);
        List orgEmployeeList = this.orgEmployeeServiceRepository.queryEmployeePage(orgEmployeemap).getList();
        if (null == orgEmployeeList || orgEmployeeList.size() <= 0) {
            this.logger.error(CODE + ".queryEmployeeUnassigned", (Object)"orgEmployeeList is null");
            return null;
        }
        HashMap<String, String> departempmap = new HashMap<String, String>();
        departempmap.put("companyCode", orgEmployeeReDomain.getCompanyCode());
        departempmap.put("tenantCode", tenantCode);
        List departempList = this.orgDepartServiceRepository.queryDepartempPage(departempmap).getList();
        if (null == departempList || departempList.size() <= 0) {
            this.logger.error(CODE + ".queryEmployeeUnassigned", (Object)"departempList is null");
            return null;
        }
        HashMap<String, String> employeecodemap = new HashMap<String, String>();
        for (OrgDepartempReDomain orgDepartempReDomain : departempList) {
            if (!StringUtils.isNotBlank((String)orgDepartempReDomain.getEmployeeCode())) continue;
            employeecodemap.put(orgDepartempReDomain.getEmployeeCode(), orgDepartempReDomain.getEmployeeCode());
        }
        ArrayList<OrgEmployeeReDomain> employeeList = new ArrayList<OrgEmployeeReDomain>();
        if (!employeecodemap.isEmpty()) {
            for (OrgEmployeeReDomain EmployeeReDomain : orgEmployeeList) {
                if (StringUtils.isNotBlank((String)((String)employeecodemap.get(EmployeeReDomain.getEmployeeCode())))) continue;
                employeeList.add(EmployeeReDomain);
            }
        }
        return employeeList;
    }

    @RequestMapping(value={"queryEmployeeUnassignedByC.json"}, name="\u67e5\u8be2\u516c\u53f8\u672a\u5206\u914d\u90e8\u95e8\u5458\u5de5")
    @ResponseBody
    public List<OrgEmployeeReDomain> queryEmployeeUnassignedByC(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        String userCode = userSession.getUserCode();
        if (StringUtils.isBlank((String)userCode)) {
            this.logger.error(CODE + ".queryEmployeeUnassignedByC", (Object)"userCode is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> usermap = new HashMap<String, String>();
        usermap.put("userCode", userCode);
        usermap.put("tenantCode", tenantCode);
        List orgEmployee = this.orgEmployeeServiceRepository.queryEmployeePage(usermap).getList();
        if (null == orgEmployee || orgEmployee.size() <= 0) {
            this.logger.error(CODE + ".queryEmployeeUnassignedByC", (Object)"orgEmployee is null");
            return null;
        }
        OrgEmployeeReDomain orgEmployeeReDomain = (OrgEmployeeReDomain)orgEmployee.get(0);
        HashMap<String, String> orgEmployeemap = new HashMap<String, String>();
        orgEmployeemap.put("companyCode", orgEmployeeReDomain.getCompanyCode());
        orgEmployeemap.put("tenantCode", tenantCode);
        List orgEmployeeList = this.orgEmployeeServiceRepository.queryEmployeePage(orgEmployeemap).getList();
        if (null == orgEmployeeList || orgEmployeeList.size() <= 0) {
            this.logger.error(CODE + ".queryEmployeeUnassignedByC", (Object)"orgEmployeeList is null");
            return null;
        }
        HashMap<String, String> departempmap = new HashMap<String, String>();
        departempmap.put("companyCode", orgEmployeeReDomain.getCompanyCode());
        departempmap.put("tenantCode", tenantCode);
        List departempList = this.orgDepartServiceRepository.queryDepartempPage(departempmap).getList();
        if (null == departempList || departempList.size() <= 0) {
            this.logger.error(CODE + ".queryEmployeeUnassignedByC", (Object)"departempList is null");
            return null;
        }
        HashMap<String, String> employeecodemap = new HashMap<String, String>();
        for (OrgDepartempReDomain orgDepartempReDomain : departempList) {
            if (!StringUtils.isNotBlank((String)orgDepartempReDomain.getEmployeeCode())) continue;
            employeecodemap.put(orgDepartempReDomain.getEmployeeCode(), orgDepartempReDomain.getEmployeeCode());
        }
        ArrayList<OrgEmployeeReDomain> employeeList = new ArrayList<OrgEmployeeReDomain>();
        if (!employeecodemap.isEmpty()) {
            for (OrgEmployeeReDomain EmployeeReDomain : orgEmployeeList) {
                if (StringUtils.isNotBlank((String)((String)employeecodemap.get(EmployeeReDomain.getEmployeeCode())))) continue;
                employeeList.add(EmployeeReDomain);
            }
        }
        return employeeList;
    }

    @RequestMapping(value={"queryEmployeePageByCompanyCodeByLP.json"}, name="\u6839\u636e\u516c\u53f8Code\u67e5\u8be2\u5458\u5de5\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgEmployeeReDomain> queryEmployeePageByCompanyCodeByLP(HttpServletRequest request, String companyCode) {
        if (StringUtils.isBlank((String)companyCode)) {
            this.logger.error(CODE + ".queryEmployeePageByCompanyCodeByLP", (Object)"companyCode is null");
            return null;
        }
        Map param = this.assemMapParam(request);
        param.put("companyCode", companyCode);
        param.put("order", true);
        param.put("fuzzy", true);
        return this.orgEmployeeServiceRepository.queryEmployeePage(param);
    }

    @RequestMapping(value={"saveEmployeeByUser.json"}, name="\u589e\u52a0\u5458\u5de5\u65f6\u589e\u52a0\u64cd\u4f5c\u5458")
    @ResponseBody
    public HtmlJsonReBean saveEmployeeByUser(HttpServletRequest request, OrgEmployeeDomain orgEmployeeDomain) {
        if (null == orgEmployeeDomain) {
            this.logger.error(CODE + ".saveEmployeeByUser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String userPcode = this.getMerchantCode(request);
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setUserName(orgEmployeeDomain.getEmployeePhone());
        umUserDomainBean.setUserPhone(orgEmployeeDomain.getEmployeePhone());
        umUserDomainBean.setUserType(Integer.valueOf(1));
        umUserDomainBean.setUserPcode(userPcode);
        HtmlJsonReBean htmlJsonReBean = this.userServiceRepository.saveUser(umUserDomainBean);
        UmUserDomainBean user = (UmUserDomainBean)htmlJsonReBean.getDataObj();
        String userCode = user.getUserCode();
        if (StringUtils.isBlank((String)userCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u589e\u52a0\u64cd\u4f5c\u5458\u5931\u8d25");
        }
        orgEmployeeDomain.setUserCode(userCode);
        orgEmployeeDomain.setUserinfoCode(userPcode);
        orgEmployeeDomain.setPositionCode("21312312");
        orgEmployeeDomain.setPositionName("\u9500\u552e\u5458");
        orgEmployeeDomain.setTenantCode(this.getTenantCode(request));
        return this.orgEmployeeServiceRepository.saveEmployee(orgEmployeeDomain);
    }
}

