/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.org.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.org.domain.OrgCompanyReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgDepartReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgEmployeeReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgGroupReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgPositionDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgPositionReDomain;
import com.qjsoft.laser.controller.facade.org.repository.OrgCompanyServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgDepartServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgEmployeeServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgGroupServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgPositionServiceRepository;
import com.qjsoft.laser.controller.org.controller.Thread.UpdatePositionNameThread;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/org/position"}, name="\u804c\u4f4d\u670d\u52a1")
public class orgPositionCon
extends SpringmvcController {
    private static String CODE = "org.position.con";
    @Autowired
    private OrgPositionServiceRepository orgPositionServiceRepository;
    @Autowired
    private OrgEmployeeServiceRepository orgEmployeeServiceRepository;
    @Autowired
    private OrgDepartServiceRepository orgDepartServiceRepository;
    @Autowired
    private OrgGroupServiceRepository orgGroupServiceRepository;
    @Autowired
    private OrgCompanyServiceRepository orgCompanyServiceRepository;

    protected String getContext() {
        return "position";
    }

    @RequestMapping(value={"queryPositionPage.json"}, name="\u67e5\u8be2\u804c\u4f4d\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryPositionPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.orgPositionServiceRepository.queryPositionPage(param);
    }

    @RequestMapping(value={"queryPositionPageCurrency.json"}, name="\u67e5\u8be2\u804c\u4f4d\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryPositionPageCurrency(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.orgPositionServiceRepository.queryPositionPage(param);
    }

    @RequestMapping(value={"queryCompanyPositionPage.json"}, name="\u67e5\u8be2\u516c\u53f8\u804c\u4f4d\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryCompanyPositionPage(HttpServletRequest request, String companyCode) {
        SupQueryResult orgPosition;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("positionType", "0");
            param.put("companyCode", companyCode);
        }
        if (null != (orgPosition = this.orgPositionServiceRepository.queryPositionPage(param)) && ListUtil.isNotEmpty((Collection)orgPosition.getList()) && orgPosition.getList().size() > 0) {
            for (OrgPositionReDomain pos : orgPosition.getList()) {
                OrgCompanyReDomain companyByCode = this.orgCompanyServiceRepository.getCompanyByCode(this.getTenantCode(request), pos.getCompanyCode());
                if (companyByCode == null) continue;
                pos.setCompanyName(companyByCode.getCompanyName());
                HashMap<String, String> map3 = new HashMap<String, String>();
                map3.put("tenantCode", this.getTenantCode(request));
                map3.put("positionCode", pos.getPositionCode());
                map3.put("companyCode", pos.getCompanyCode());
                SupQueryResult orgEmployee = this.orgEmployeeServiceRepository.queryEmployeePage(map3);
                if (null == orgEmployee || !ListUtil.isNotEmpty((Collection)orgEmployee.getList()) || orgEmployee.getList().size() <= 0) continue;
                pos.setMemo(String.valueOf(orgEmployee.getList().size()));
            }
        }
        return orgPosition;
    }

    @RequestMapping(value={"queryCompanyPositionPageChange.json"}, name="\u67e5\u8be2\u516c\u53f8\u804c\u4f4d\u5217\u8868(\u6539)")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryCompanyPositionPageChange(HttpServletRequest request, String userinfoCode) throws Exception {
        String tenantCode = this.getTenantCode(request);
        Map map = this.assemMapParam(request);
        if (null != map) {
            map.put("order", true);
            map.put("fuzzy", true);
        }
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        SupQueryResult supQueryResult = this.orgCompanyServiceRepository.queryCompanyPage(map);
        if (null == supQueryResult || supQueryResult.getList().size() <= 0) {
            this.logger.error(CODE + ".getCompanyByuserinfoCode", (Object)"supQueryResultList is null");
            throw new Exception("\u7528\u6237\u516c\u53f8\u4e0d\u5b58\u5728");
        }
        OrgCompanyReDomain orgCompany = (OrgCompanyReDomain)supQueryResult.getList().get(0);
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("positionType", "0");
            param.put("companyCode", orgCompany.getCompanyCode());
        }
        return this.orgPositionServiceRepository.queryPositionPage(param);
    }

    @RequestMapping(value={"queryCompanyPositionPageForB.json"}, name="B\u7aef\u67e5\u8be2\u516c\u53f8\u804c\u4f4d\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryCompanyPositionPageForB(HttpServletRequest request, String companyCode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("positionType", "0");
            param.put("companyCode", companyCode);
        }
        return this.orgPositionServiceRepository.queryPositionPage(param);
    }

    @RequestMapping(value={"queryDepartPositionPage.json"}, name="\u67e5\u8be2\u90e8\u95e8\u804c\u4f4d\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryDepartPositionPage(HttpServletRequest request, String companyCode) {
        return this.queryDepartPositionPageByCommon(request, companyCode);
    }

    @RequestMapping(value={"queryGroupPositionPage.json"}, name="\u67e5\u8be2\u7fa4\u7ec4\u804c\u4f4d\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryGroupPositionPage(HttpServletRequest request, String companyCode) {
        return this.queryGroupPositionPageByCommon(request, companyCode);
    }

    @RequestMapping(value={"updatePosition.json"}, name="\u66f4\u65b0\u804c\u4f4d\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePosition(HttpServletRequest request, OrgPositionDomain orgPositionDomain) {
        if (null == orgPositionDomain) {
            this.logger.error(CODE + ".updatePosition", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        orgPositionDomain.setTenantCode(this.getTenantCode(request));
        new UpdatePositionNameThread(orgPositionDomain, this.orgGroupServiceRepository, this.orgEmployeeServiceRepository, this.orgDepartServiceRepository).start();
        return this.orgPositionServiceRepository.updatePosition(orgPositionDomain);
    }

    @RequestMapping(value={"updatePositionState.json"}, name="\u66f4\u65b0\u804c\u4f4d\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePositionState(String positionId) {
        if (StringUtils.isBlank((String)positionId)) {
            this.logger.error(CODE + ".updatePositionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.orgPositionServiceRepository.updatePositionState(Integer.valueOf(positionId), Integer.valueOf(0), Integer.valueOf(-1));
    }

    @RequestMapping(value={"stoppedPositionState.json"}, name="\u505c\u7528\u804c\u4f4d")
    @ResponseBody
    public HtmlJsonReBean stoppedPositionState(String positionId) {
        if (StringUtils.isBlank((String)positionId)) {
            this.logger.error(CODE + ".stoppedPositionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.orgPositionServiceRepository.updatePositionState(Integer.valueOf(positionId), Integer.valueOf(-1), Integer.valueOf(0));
    }

    @RequestMapping(value={"savePosition.json"}, name="\u589e\u52a0\u804c\u4f4d\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePosition(HttpServletRequest request, OrgPositionDomain orgPositionDomain) {
        if (null == orgPositionDomain) {
            this.logger.error(CODE + ".savePosition", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        orgPositionDomain.setTenantCode(this.getTenantCode(request));
        return this.orgPositionServiceRepository.savePosition(orgPositionDomain);
    }

    @RequestMapping(value={"getPosition.json"}, name="\u83b7\u53d6\u804c\u4f4d\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OrgPositionReDomain getPosition(Integer positionId) {
        if (StringUtils.isBlank((Integer)positionId)) {
            this.logger.error(CODE + ".getPosition", (Object)"param is null");
            return null;
        }
        return this.orgPositionServiceRepository.getPosition(positionId);
    }

    @RequestMapping(value={"deletePosition.json"}, name="\u5220\u9664\u804c\u4f4d\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deletePosition(Integer positionId) {
        SupQueryResult orgGroupempReDomain;
        SupQueryResult orgDepartempReDomain;
        SupQueryResult orgEmployeeReDomain;
        if (StringUtils.isBlank((Integer)positionId)) {
            this.logger.error(CODE + ".deletePosition", (Object)"positionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgPositionReDomain orgPositionReDomain = this.orgPositionServiceRepository.getPosition(positionId);
        if (null == orgPositionReDomain) {
            this.logger.error(CODE + ".savePosition", (Object)"orgPositionReDomain is null");
            return null;
        }
        HashMap<String, String> positionmap = new HashMap<String, String>();
        positionmap.put("positionCode", orgPositionReDomain.getPositionCode());
        positionmap.put("companyCode", orgPositionReDomain.getCompanyCode());
        positionmap.put("tenantCode", orgPositionReDomain.getTenantCode());
        if (StringUtils.isNotBlank((String)orgPositionReDomain.getPositionType()) && "0".equals(orgPositionReDomain.getPositionType()) ? null != (orgEmployeeReDomain = this.orgEmployeeServiceRepository.queryEmployeePage(positionmap)) && ListUtil.isNotEmpty((Collection)orgEmployeeReDomain.getList()) : (StringUtils.isNotBlank((String)orgPositionReDomain.getPositionType()) && "1".equals(orgPositionReDomain.getPositionType()) ? null != (orgDepartempReDomain = this.orgDepartServiceRepository.queryDepartempPage(positionmap)) && ListUtil.isNotEmpty((Collection)orgDepartempReDomain.getList()) : StringUtils.isNotBlank((String)orgPositionReDomain.getPositionType()) && "2".equals(orgPositionReDomain.getPositionType()) && null != (orgGroupempReDomain = this.orgGroupServiceRepository.queryGroupempPage(positionmap)) && ListUtil.isNotEmpty((Collection)orgGroupempReDomain.getList()))) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u804c\u4f4d\u8fd8\u6709\u5458\u5de5");
        }
        return this.orgPositionServiceRepository.deletePosition(positionId);
    }

    @RequestMapping(value={"queryPositionByUserCode.json"}, name="\u6839\u636eUserCode\u67e5\u627e\u6240\u5c5e\u516c\u53f8\u804c\u4f4d")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryPositionByUserCode(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserCode())) {
            this.logger.error(CODE + ".queryPositionByUserCode", (Object)"userSession is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> usermap = new HashMap<String, String>();
        usermap.put("userCode", userSession.getUserCode());
        usermap.put("tenantCode", tenantCode);
        List employeebyuser = this.orgEmployeeServiceRepository.queryEmployeePage(usermap).getList();
        if (null == employeebyuser || employeebyuser.size() <= 0) {
            this.logger.error(CODE + ".queryPositionByUserCode", (Object)"employeebyuser is null");
            return null;
        }
        OrgEmployeeReDomain orgEmployeeReDomain = (OrgEmployeeReDomain)employeebyuser.get(0);
        HashMap<String, String> companyMap = new HashMap<String, String>();
        HashMap<String, String> companyCodemap = new HashMap<String, String>();
        companyMap.put("companyCode", orgEmployeeReDomain.getCompanyCode());
        companyMap.put("tenantCode", tenantCode);
        ArrayList<String> pList = new ArrayList<String>();
        SupQueryResult employeeList = this.orgEmployeeServiceRepository.queryEmployeePage(companyMap);
        if (null != employeeList && employeeList.getList().size() > 0) {
            for (OrgEmployeeReDomain orgEmployee : employeeList.getList()) {
                pList.add(orgEmployee.getPositionName());
            }
            if (pList.contains("\u603b\u7ecf\u7406")) {
                companyCodemap.put("companyCode", orgEmployeeReDomain.getCompanyCode());
                companyCodemap.put("positionName", "\u9500\u552e\u5458");
                companyCodemap.put("positionType", "0");
                companyCodemap.put("tenantCode", tenantCode);
                return this.orgPositionServiceRepository.queryPositionPage(companyCodemap);
            }
        }
        companyCodemap.put("companyCode", orgEmployeeReDomain.getCompanyCode());
        companyCodemap.put("positionType", "0");
        companyCodemap.put("tenantCode", tenantCode);
        return this.orgPositionServiceRepository.queryPositionPage(companyCodemap);
    }

    @RequestMapping(value={"queryDepartPositionPageByPC.json"}, name="PC\u67e5\u8be2\u516c\u53f8\u90e8\u95e8\u804c\u4f4d\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryDepartPositionPageByPC(HttpServletRequest request, String companyCode) {
        return this.queryDepartPositionPageByCommon(request, companyCode);
    }

    @RequestMapping(value={"queryGroupPositionPageByPC.json"}, name="PC\u67e5\u8be2\u516c\u53f8\u7fa4\u7ec4\u804c\u4f4d\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryGroupPositionPageByPC(HttpServletRequest request, String companyCode) {
        return this.queryGroupPositionPageByCommon(request, companyCode);
    }

    private SupQueryResult<OrgPositionReDomain> queryDepartPositionPageByCommon(HttpServletRequest request, String companyCode) {
        SupQueryResult orgPosition;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("positionType", "1");
            param.put("companyCode", companyCode);
        }
        if (null != (orgPosition = this.orgPositionServiceRepository.queryPositionPage(param)) && ListUtil.isNotEmpty((Collection)orgPosition.getList()) && orgPosition.getList().size() > 0) {
            for (OrgPositionReDomain pos : orgPosition.getList()) {
                OrgCompanyReDomain companyByCode = this.orgCompanyServiceRepository.getCompanyByCode(this.getTenantCode(request), pos.getCompanyCode());
                if (companyByCode == null) continue;
                pos.setCompanyName(companyByCode.getCompanyName());
                OrgDepartReDomain departByCode = this.orgDepartServiceRepository.getDepartByCode(this.getTenantCode(request), pos.getPositionShortcode());
                if (departByCode == null) continue;
                pos.setDepartName(departByCode.getDepartName());
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("tenantCode", this.getTenantCode(request));
                map1.put("positionCode", pos.getPositionCode());
                map1.put("departCode", pos.getPositionShortcode());
                map1.put("companyCode", companyCode);
                SupQueryResult orgDepartemp = this.orgDepartServiceRepository.queryDepartempPage(map1);
                if (null == orgDepartemp || !ListUtil.isNotEmpty((Collection)orgDepartemp.getList()) || orgDepartemp.getList().size() <= 0) continue;
                pos.setMemo(String.valueOf(orgDepartemp.getList().size()));
            }
        }
        return orgPosition;
    }

    private SupQueryResult<OrgPositionReDomain> queryGroupPositionPageByCommon(HttpServletRequest request, String companyCode) {
        SupQueryResult orgPosition;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("positionType", "2");
            param.put("companyCode", companyCode);
        }
        if (null != (orgPosition = this.orgPositionServiceRepository.queryPositionPage(param)) && ListUtil.isNotEmpty((Collection)orgPosition.getList()) && orgPosition.getList().size() > 0) {
            for (OrgPositionReDomain pos : orgPosition.getList()) {
                OrgCompanyReDomain companyByCode = this.orgCompanyServiceRepository.getCompanyByCode(this.getTenantCode(request), pos.getCompanyCode());
                if (companyByCode == null) continue;
                pos.setCompanyName(companyByCode.getCompanyName());
                OrgGroupReDomain groupByCode = this.orgGroupServiceRepository.getGroupByCode(this.getTenantCode(request), pos.getPositionShortcode());
                if (groupByCode == null) continue;
                pos.setGroupName(groupByCode.getGroupName());
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("tenantCode", this.getTenantCode(request));
                map1.put("positionCode", pos.getPositionCode());
                map1.put("groupCode", pos.getPositionShortcode());
                map1.put("companyCode", companyCode);
                SupQueryResult orgGroupemp = this.orgGroupServiceRepository.queryGroupempPage(map1);
                if (null == orgGroupemp || !ListUtil.isNotEmpty((Collection)orgGroupemp.getList()) || orgGroupemp.getList().size() <= 0) continue;
                pos.setMemo(String.valueOf(orgGroupemp.getList().size()));
            }
        }
        return orgPosition;
    }

    @RequestMapping(value={"updatePositions.json"}, name="\u804c\u4f4d\u6279\u91cf\u4fee\u6539")
    @ResponseBody
    public HtmlJsonReBean updatePositions(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsForMem", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsForMem", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List goodsList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, OrgPositionDomain.class);
        if (goodsList == null) {
            new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "goods is null");
        }
        for (OrgPositionDomain orgPositionDomain : goodsList) {
            orgPositionDomain.setTenantCode(tenantCode);
        }
        this.orgPositionServiceRepository.updatePositions(goodsList);
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"savePositions.json"}, name="\u804c\u4f4d\u6279\u91cf\u6dfb\u52a0")
    @ResponseBody
    public HtmlJsonReBean savePositions(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsForMem", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsForMem", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List goodsList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, OrgPositionDomain.class);
        if (goodsList == null) {
            new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "goods is null");
        }
        for (OrgPositionDomain orgPositionDomain : goodsList) {
            orgPositionDomain.setTenantCode(tenantCode);
        }
        this.orgPositionServiceRepository.savePositions(goodsList);
        return new HtmlJsonReBean();
    }
}

