/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pay.facade;

import com.qjsoft.laser.controller.common.bean.DisChannel;
import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.send.SupperFacade;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSettlDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSubReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSublistDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractSubServiceRepository;
import com.qjsoft.laser.controller.facade.pte.domain.PtePtfchannelReDomain;
import com.qjsoft.laser.controller.facade.pte.domain.PtePtradeDomain;
import com.qjsoft.laser.controller.facade.pte.domain.PtePtradeInfoDomain;
import com.qjsoft.laser.controller.facade.pte.domain.PtePtradeReDomain;
import com.qjsoft.laser.controller.facade.pte.repository.PtePtfchannelServiceRepository;
import com.qjsoft.laser.controller.facade.pte.repository.PtePtradeServiceRepository;
import com.qjsoft.laser.controller.facade.vd.domain.VdFaccountInfo;
import com.qjsoft.laser.controller.facade.vd.repository.VdFaccountServiceRepository;
import com.qjsoft.laser.controller.pay.bean.PayChannel;
import com.qjsoft.laser.controller.pay.bean.PayInfo;
import com.qjsoft.laser.controller.pay.bean.PteConstants;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PayServiceRepository
extends SupperFacade {
    public static final String SYS_CODE = "web.pay.PayServiceRepository";
    public static final String FCHANNELDR_PAY = "PAY";
    @Autowired
    private PtePtfchannelServiceRepository ptePtfchannelServiceRepository;
    @Autowired
    private PtePtradeServiceRepository ptePtradeServiceRepository;
    @Autowired
    private VdFaccountServiceRepository vdFaccountServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private OcContractSubServiceRepository ocContractSubServiceRepository;

    public PayInfo saveBatchPay(Map<String, Object> envmap, String memberBcode, String contractBbillcode, String fchannelPmodeCode, String tenantCode) {
        if (null == envmap || StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)contractBbillcode) || StringUtils.isBlank((String)fchannelPmodeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBbillcode", contractBbillcode);
        map.put("tenantCode", tenantCode);
        SupQueryResult qlist = this.ocContractServiceRepository.queryContractPage(map);
        if (null == qlist || null == qlist.getList() || qlist.getList().isEmpty()) {
            this.logger.error("web.pay.PayServiceRepository.saveBatchPay.null", (Object)(memberBcode + "=" + ((Object)map).toString()));
            return null;
        }
        List ocContractReDomainList = qlist.getList();
        String ptradeSeqno = "";
        BigDecimal dataAmount = BigDecimal.ZERO;
        BigDecimal contractAmount = BigDecimal.ZERO;
        BigDecimal pefAmount = BigDecimal.ZERO;
        ArrayList<PtePtradeInfoDomain> ptePtradeInfoDomainList = new ArrayList<PtePtradeInfoDomain>();
        for (OcContractReDomain ocContractReDomain : ocContractReDomainList) {
            ptradeSeqno = this.getPay(ocContractReDomain, memberBcode, fchannelPmodeCode);
            if (StringUtils.isNotBlank((String)ptradeSeqno)) {
                this.logger.error("web.pay.PayServiceRepository.saveBatchPay.ptradeSeqno", (Object)(ptradeSeqno + "=" + ((Object)map).toString()));
                return null;
            }
            if (null == ocContractReDomain.getContractMoney()) {
                ocContractReDomain.setContractMoney(BigDecimal.ZERO);
            }
            if (null == ocContractReDomain.getDataBmoney()) {
                ocContractReDomain.setDataBmoney(BigDecimal.ZERO);
            }
            if (null == ocContractReDomain.getPricesetRefrice()) {
                ocContractReDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            dataAmount = dataAmount.add(ocContractReDomain.getDataBmoney());
            contractAmount = contractAmount.add(ocContractReDomain.getContractMoney());
            pefAmount = pefAmount.add(ocContractReDomain.getPricesetRefrice());
            ptePtradeInfoDomainList.add(this.makePtePtradeInfoDomain(ocContractReDomain, fchannelPmodeCode));
        }
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        ptePtradeDomain.setPtePtradeInfoDomainList(ptePtradeInfoDomainList);
        ptePtradeDomain.setOrderOamount(dataAmount);
        ptePtradeDomain.setOrderAmount(dataAmount);
        ptePtradeDomain.setPtradeType("03");
        ptePtradeDomain.setPtradeBatchno(((OcContractReDomain)ocContractReDomainList.get(0)).getContractBbillcode());
        ptePtradeDomain.setAcquireSeqno(((OcContractReDomain)ocContractReDomainList.get(0)).getContractBbillcode());
        ptePtradeDomain.setPartnerCode(((OcContractReDomain)ocContractReDomainList.get(0)).getMemberCode());
        ptePtradeDomain.setBusinessOrderno(((OcContractReDomain)ocContractReDomainList.get(0)).getContractBbillcode());
        ptePtradeDomain.setBusinessOrder(((OcContractReDomain)ocContractReDomainList.get(0)).getContractBillcode());
        ptePtradeDomain.setPaymentMemo(((OcContractReDomain)ocContractReDomainList.get(0)).getContractBbillcode());
        ptePtradeDomain.setOpuserCode(((OcContractReDomain)ocContractReDomainList.get(0)).getMemberBcode());
        ptePtradeDomain.setOpuserName(((OcContractReDomain)ocContractReDomainList.get(0)).getMemberBname());
        ptePtradeDomain.setPtradpdeCode("PAYMENT");
        ptePtradeDomain.setTenantCode(((OcContractReDomain)ocContractReDomainList.get(0)).getTenantCode());
        ptePtradeDomain.setMerchantCode(((OcContractReDomain)ocContractReDomainList.get(0)).getMemberCode());
        ptePtradeDomain.setFchannelPmodeCode(fchannelPmodeCode);
        ptePtradeDomain.setExtension(JsonUtil.buildNormalBinder().toJson(envmap));
        ptePtradeDomain.setPaymentNotifyurl("oc.contractEngine.sendContracBatchPay");
        ptradeSeqno = this.ptePtradeServiceRepository.sendSavePtrade(ptePtradeDomain);
        PayInfo payInfo = new PayInfo();
        for (OcContractReDomain ocContractReDomain : ocContractReDomainList) {
            HashMap<String, String> contractTradeMap = new HashMap<String, String>();
            contractTradeMap.put("contractBillcode", ocContractReDomain.getContractBillcode());
            contractTradeMap.put("ptradeSeqno", ptradeSeqno);
            contractTradeMap.put("tenantCode", ocContractReDomain.getTenantCode());
            payInfo.setContractBlance(ocContractReDomain.getContractBlance());
            this.ocContractServiceRepository.updateContractPtradeSeqno(contractTradeMap);
        }
        payInfo.setPtradeSeqno(ptradeSeqno);
        payInfo.setContractBillcode(((OcContractReDomain)ocContractReDomainList.get(0)).getContractBillcode());
        payInfo.setContractBbillcode(contractBbillcode);
        payInfo.setFchannelPmodeCode(fchannelPmodeCode);
        payInfo.setMemberBcode(memberBcode);
        payInfo.setOrderMoney(dataAmount);
        payInfo.setContMoney(contractAmount);
        payInfo.setPreMoney(pefAmount);
        return payInfo;
    }

    private PtePtradeInfoDomain makePtePtradeInfoDomain(OcContractReDomain ocContractReDomain, String fchannelPmodeCode) {
        if (null == ocContractReDomain || StringUtils.isBlank((String)fchannelPmodeCode)) {
            return null;
        }
        PtePtradeInfoDomain ptePtradeInfoDomain = new PtePtradeInfoDomain();
        ptePtradeInfoDomain.setOrderOamount(ocContractReDomain.getContractMoney());
        ptePtradeInfoDomain.setOrderAmount(ocContractReDomain.getContractMoney());
        ptePtradeInfoDomain.setPartnerCode(ocContractReDomain.getMemberCode());
        ptePtradeInfoDomain.setBusinessOrderno(ocContractReDomain.getContractBbillcode());
        ptePtradeInfoDomain.setBusinessOrder(ocContractReDomain.getContractBillcode());
        ptePtradeInfoDomain.setPaymentMemo(ocContractReDomain.getContractBillcode());
        ptePtradeInfoDomain.setOpuserCode(ocContractReDomain.getMemberBcode());
        ptePtradeInfoDomain.setOpuserName(ocContractReDomain.getMemberBname());
        ptePtradeInfoDomain.setTenantCode(ocContractReDomain.getTenantCode());
        ptePtradeInfoDomain.setMerchantCode(ocContractReDomain.getMemberCode());
        ptePtradeInfoDomain.setFchannelPmodeCode(fchannelPmodeCode);
        return ptePtradeInfoDomain;
    }

    public PayInfo saveSubPay(Map<String, Object> envmap, String memberBcode, String contractBillcode, String contractSubCode, String fchannelPmodeCode, String tenantCode) {
        if (null == envmap || StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)contractSubCode) || StringUtils.isBlank((String)fchannelPmodeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OcContractSubReDomain ocContractSubReDomain = this.ocContractSubServiceRepository.getContractSubByCode(tenantCode, contractSubCode);
        String ptradeSeqno = this.makeSubPte(envmap, memberBcode, contractBillcode, fchannelPmodeCode, ocContractSubReDomain);
        if (StringUtils.isBlank((String)ptradeSeqno)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractOneByCode(map);
        PayInfo payInfo = new PayInfo();
        payInfo.setContractBlance(ocContractReDomain.getContractBlance());
        payInfo.setPtradeSeqno(ptradeSeqno);
        payInfo.setContractBillcode(contractSubCode);
        payInfo.setContractBbillcode(ocContractSubReDomain.getContractBillcode());
        payInfo.setFchannelPmodeCode(fchannelPmodeCode);
        payInfo.setMemberBcode(memberBcode);
        if (null == ocContractSubReDomain.getContractSubGmoney()) {
            ocContractSubReDomain.setContractSubGmoney(BigDecimal.ZERO);
        }
        payInfo.setOrderMoney(ocContractSubReDomain.getContractSubGmoney());
        payInfo.setContMoney(ocContractSubReDomain.getContractSubGmoney());
        payInfo.setPreMoney(BigDecimal.ZERO);
        return payInfo;
    }

    private String makeSubPte(Map<String, Object> envmap, String memberBcode, String contractBillcode, String fchannelPmodeCode, OcContractSubReDomain ocContractSubReDomain) {
        if (StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)fchannelPmodeCode)) {
            return null;
        }
        String ptradeSeqno = this.getSubPay(ocContractSubReDomain, memberBcode, fchannelPmodeCode);
        if (StringUtils.isBlank((String)ptradeSeqno)) {
            ptradeSeqno = this.saveSubToPay(envmap, fchannelPmodeCode, ocContractSubReDomain);
        }
        return ptradeSeqno;
    }

    private String getSubPay(OcContractSubReDomain ocContractSubReDomain, String memberBcode, String fchannelPmodeCode) {
        if (null == ocContractSubReDomain) {
            return null;
        }
        if (null == ocContractSubReDomain || !ocContractSubReDomain.getMemberBcode().equals(memberBcode)) {
            this.logger.error("web.pay.PayServiceRepository.getSubPay.null", (Object)memberBcode);
            return null;
        }
        if (ocContractSubReDomain.getDataState() != 0) {
            this.logger.error("web.pay.PayServiceRepository.getSubPay.contract.dataState", (Object)("\u8ba2\u5355\u5df2\u5904\u7406\uff0c\u4e0d\u80fd\u91cd\u590d\u652f\u4ed8\u3002\u72b6\u6001=" + ocContractSubReDomain.getDataState()));
            return null;
        }
        String tenantCode = ocContractSubReDomain.getTenantCode();
        String ptradeSeqno = ocContractSubReDomain.getPtradeSeqno();
        if (StringUtils.isNotBlank((String)ptradeSeqno)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("contractSubCode", ocContractSubReDomain.getContractSubCode());
            map.put("tenantCode", tenantCode);
            map.put("ptradeSeqno", ptradeSeqno);
            PtePtradeReDomain ptePtradeReDomain = this.ptePtradeServiceRepository.getPtradeByCode(map);
            if (null == ptePtradeReDomain) {
                ptradeSeqno = "";
            } else if (PteConstants.DATA_STATE_0 == ptePtradeReDomain.getDataState() || PteConstants.DATA_STATE_1 == ptePtradeReDomain.getDataState() || PteConstants.DATA_STATE_2 == ptePtradeReDomain.getDataState()) {
                if (!fchannelPmodeCode.equals(ptePtradeReDomain.getFchannelPmodeCode())) {
                    ptradeSeqno = "";
                }
            } else if (ocContractSubReDomain.getContractSubGmoney().subtract(ptePtradeReDomain.getOrderAmount()).intValue() != 0) {
                ptradeSeqno = "";
            }
        }
        return ptradeSeqno;
    }

    public PayInfo savePay(Map<String, Object> envmap, String memberBcode, String contractBillcode, String fchannelPmodeCode, String tenantCode) {
        if (null == envmap || StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)fchannelPmodeCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("web.pay.PayServiceRepository.savePay.param", (Object)(contractBillcode + ":" + fchannelPmodeCode));
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractOneByCode(map);
        if (null == ocContractReDomain.getDataState() || ocContractReDomain.getDataState() != 1) {
            this.logger.error("web.pay.PayServiceRepository.savePay.data", (Object)(contractBillcode + ":" + fchannelPmodeCode + ":" + ocContractReDomain.getDataState()));
            return null;
        }
        String ptradeSeqno = this.makePte(envmap, memberBcode, contractBillcode, fchannelPmodeCode, ocContractReDomain);
        if (StringUtils.isBlank((String)ptradeSeqno)) {
            this.logger.error("web.pay.PayServiceRepository.savePay.ptradeSeqno", (Object)(contractBillcode + ":" + fchannelPmodeCode));
            return null;
        }
        PayInfo payInfo = new PayInfo();
        payInfo.setContractBlance(ocContractReDomain.getContractBlance());
        payInfo.setPtradeSeqno(ptradeSeqno);
        payInfo.setContractBillcode(contractBillcode);
        payInfo.setContractBbillcode(ocContractReDomain.getContractBbillcode());
        payInfo.setFchannelPmodeCode(fchannelPmodeCode);
        payInfo.setMemberBcode(memberBcode);
        if (null == ocContractReDomain.getDataBmoney()) {
            ocContractReDomain.setDataBmoney(BigDecimal.ZERO);
        }
        if (null == ocContractReDomain.getPricesetRefrice()) {
            ocContractReDomain.setPricesetRefrice(BigDecimal.ZERO);
        }
        payInfo.setOrderMoney(ocContractReDomain.getDataBmoney());
        payInfo.setContMoney(ocContractReDomain.getContractMoney());
        payInfo.setLogMoney(ocContractReDomain.getGoodsLogmoney());
        payInfo.setPacgeMoney(ocContractReDomain.getContractPaymoney());
        payInfo.setPreMoney(ocContractReDomain.getPricesetRefrice());
        payInfo.setContractPaydate(ocContractReDomain.getContractPaydate());
        return payInfo;
    }

    private String getPay(OcContractReDomain ocContractReDomain, String memberBcode, String fchannelPmodeCode) {
        if (null == ocContractReDomain) {
            return null;
        }
        if (null == ocContractReDomain || !ocContractReDomain.getMemberBcode().equals(memberBcode)) {
            this.logger.error("web.pay.PayServiceRepository.savePay.null", (Object)memberBcode);
            return null;
        }
        if (ocContractReDomain.getDataState() != 1) {
            this.logger.error("web.pay.PayServiceRepository.savePay.contract.dataState", (Object)("\u8ba2\u5355\u5df2\u5904\u7406\uff0c\u4e0d\u80fd\u91cd\u590d\u652f\u4ed8\u3002\u72b6\u6001=" + ocContractReDomain.getDataState()));
            return null;
        }
        String tenantCode = ocContractReDomain.getTenantCode();
        String ptradeSeqno = ocContractReDomain.getPtradeSeqno();
        if (StringUtils.isNotBlank((String)ptradeSeqno)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("contractBillcode", ocContractReDomain.getContractBillcode());
            map.put("tenantCode", tenantCode);
            map.put("ptradeSeqno", ptradeSeqno);
            PtePtradeReDomain ptePtradeReDomain = this.ptePtradeServiceRepository.getPtradeByCode(map);
            if (null == ptePtradeReDomain) {
                ptradeSeqno = "";
            } else if (PteConstants.DATA_STATE_0 == ptePtradeReDomain.getDataState() || PteConstants.DATA_STATE_1 == ptePtradeReDomain.getDataState() || PteConstants.DATA_STATE_2 == ptePtradeReDomain.getDataState()) {
                if (!fchannelPmodeCode.equals(ptePtradeReDomain.getFchannelPmodeCode())) {
                    ptradeSeqno = "";
                }
                if (ocContractReDomain.getDataBmoney().subtract(ptePtradeReDomain.getOrderAmount()).intValue() != 0) {
                    ptradeSeqno = "";
                }
            }
        }
        return ptradeSeqno;
    }

    private String makePte(Map<String, Object> envmap, String memberBcode, String contractBillcode, String fchannelPmodeCode, OcContractReDomain ocContractReDomain) {
        if (StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)fchannelPmodeCode)) {
            return null;
        }
        String ptradeSeqno = this.getPay(ocContractReDomain, memberBcode, fchannelPmodeCode);
        if (StringUtils.isBlank((String)ptradeSeqno)) {
            ptradeSeqno = this.saveToPay(envmap, contractBillcode, fchannelPmodeCode, ocContractReDomain);
        }
        return ptradeSeqno;
    }

    private String saveSubToPay(Map<String, Object> envmap, String fchannelPmodeCode, OcContractSubReDomain ocContractSubReDomain) {
        if (null == envmap || null == ocContractSubReDomain || StringUtils.isBlank((String)fchannelPmodeCode)) {
            return null;
        }
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        ptePtradeDomain.setOrderOamount(ocContractSubReDomain.getContractSubGmoney());
        ptePtradeDomain.setOrderAmount(ocContractSubReDomain.getContractSubGmoney());
        ptePtradeDomain.setPtradeType("03");
        ptePtradeDomain.setBusinessType("P01");
        ptePtradeDomain.setAcquireSeqno(ocContractSubReDomain.getContractSubCode());
        ptePtradeDomain.setPartnerCode(ocContractSubReDomain.getMemberCode());
        ptePtradeDomain.setBusinessOrderno(ocContractSubReDomain.getContractSubCode());
        ptePtradeDomain.setBusinessOrder(ocContractSubReDomain.getContractBillcode());
        ptePtradeDomain.setPaymentMemo(ocContractSubReDomain.getContractBillcode());
        ptePtradeDomain.setOpuserCode(ocContractSubReDomain.getMemberBcode());
        ptePtradeDomain.setOpuserName(ocContractSubReDomain.getMemberBname());
        ptePtradeDomain.setPtradpdeCode("PAYMENT");
        ptePtradeDomain.setTenantCode(ocContractSubReDomain.getTenantCode());
        ptePtradeDomain.setMerchantCode(ocContractSubReDomain.getMemberCode());
        ptePtradeDomain.setFchannelPmodeCode(fchannelPmodeCode);
        ptePtradeDomain.setExtension(JsonUtil.buildNormalBinder().toJson(envmap));
        ptePtradeDomain.setPaymentNotifyurl("oc.contractEngine.sendContracSubPay");
        String ptradeSeqno = this.ptePtradeServiceRepository.sendSavePtrade(ptePtradeDomain);
        this.ocContractSubServiceRepository.updateContracSubPate(ocContractSubReDomain.getTenantCode(), ocContractSubReDomain.getContractSubCode(), ptradeSeqno);
        return ptradeSeqno;
    }

    private String saveToPay(Map<String, Object> envmap, String contractBillcode, String fchannelPmodeCode, OcContractReDomain ocContractReDomain) {
        if (null == envmap || null == ocContractReDomain || StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)fchannelPmodeCode)) {
            return null;
        }
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        ptePtradeDomain.setOrderOamount(ocContractReDomain.getDataBmoney());
        ptePtradeDomain.setOrderAmount(ocContractReDomain.getDataBmoney());
        ptePtradeDomain.setPtradeType("03");
        ptePtradeDomain.setBusinessType("P01");
        ptePtradeDomain.setAcquireSeqno(contractBillcode);
        ptePtradeDomain.setPartnerCode(ocContractReDomain.getMemberCode());
        ptePtradeDomain.setBusinessOrderno(contractBillcode);
        ptePtradeDomain.setBusinessOrder(ocContractReDomain.getContractBbillcode());
        ptePtradeDomain.setPaymentMemo(contractBillcode);
        ptePtradeDomain.setOpuserCode(ocContractReDomain.getMemberBcode());
        ptePtradeDomain.setOpuserName(ocContractReDomain.getMemberBname());
        ptePtradeDomain.setPtradpdeCode("PAYMENT");
        ptePtradeDomain.setTenantCode(ocContractReDomain.getTenantCode());
        ptePtradeDomain.setMerchantCode(ocContractReDomain.getMemberCode());
        ptePtradeDomain.setFchannelPmodeCode(fchannelPmodeCode);
        ptePtradeDomain.setExtension(JsonUtil.buildNormalBinder().toJson(envmap));
        ptePtradeDomain.setPaymentNotifyurl("oc.contractEngine.saveContracPay");
        String ptradeSeqno = this.ptePtradeServiceRepository.sendSavePtrade(ptePtradeDomain);
        HashMap<String, String> contractTradeMap = new HashMap<String, String>();
        contractTradeMap.put("contractBillcode", ocContractReDomain.getContractBillcode());
        contractTradeMap.put("ptradeSeqno", ptradeSeqno);
        contractTradeMap.put("tenantCode", ocContractReDomain.getTenantCode());
        this.ocContractServiceRepository.updateContractPtradeSeqno(contractTradeMap);
        return ptradeSeqno;
    }

    public Map<String, PtePtfchannelReDomain> queryChannel(String fchannelPmodeCode, String tenantCode, String fchannelDr, UserSession userSession, String tginfoCode, String channelCode, String proappCode) {
        List<PtePtfchannelReDomain> list = this.getPtfchannel(userSession, fchannelPmodeCode, tenantCode, fchannelDr, tginfoCode, channelCode, proappCode);
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        HashMap<String, PtePtfchannelReDomain> channelmap = new HashMap<String, PtePtfchannelReDomain>();
        for (PtePtfchannelReDomain ptePtfchannelReDomain : list) {
            channelmap.put(ptePtfchannelReDomain.getFchannelCode(), ptePtfchannelReDomain);
        }
        return channelmap;
    }

    public List<PtePtfchannelReDomain> getPtfchannel(UserSession userSession, String fchannelPmodeCode, String tenantCode, String fchannelDr, String tginfoCode, String channelCode, String proappCode) {
        DisChannel disChannel;
        if (null == userSession || StringUtils.isBlank((String)fchannelPmodeCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)fchannelDr)) {
            return null;
        }
        String memberCode = userSession.getUserPcode();
        List qlist = null;
        String mpmemberCode = "";
        if (StringUtils.isNotBlank((String)channelCode) && null != (disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class))) {
            mpmemberCode = "-" + disChannel.getMemberCode();
        }
        if (StringUtils.isNotBlank((String)memberCode) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + memberCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + memberCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
        }
        if (ListUtil.isEmpty(qlist) && StringUtils.isNotBlank((String)tginfoCode) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + tginfoCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + tginfoCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
        }
        if (ListUtil.isEmpty(qlist) && StringUtils.isNotBlank((String)channelCode) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + channelCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + channelCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
        }
        if (ListUtil.isEmpty(qlist) && StringUtils.isNotBlank((String)proappCode) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + proappCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + proappCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
        }
        if (ListUtil.isEmpty(qlist)) {
            String qtype;
            String dis;
            String type;
            String quality;
            String sort = userSession.getUserinfoSort();
            if (StringUtils.isNotBlank((String)sort) && ListUtil.isEmpty(qlist) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-sort-" + sort + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
                qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-sort-" + sort + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
            }
            if (StringUtils.isNotBlank((String)(quality = userSession.getUserinfoQuality())) && ListUtil.isEmpty((Collection)qlist)) {
                String[] quaS = quality.split(",");
                List qqlist = new ArrayList();
                for (String qua : quaS) {
                    qqlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-quality-" + qua + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
                    if (ListUtil.isEmpty(qqlist) && StringUtils.isNotBlank((String)mpmemberCode)) {
                        qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-quality-" + qua + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
                    }
                    if (!ListUtil.isNotEmpty(qqlist)) continue;
                    if (null == qlist) {
                        qlist = new ArrayList();
                    }
                    qlist.addAll(qqlist);
                }
            }
            if (StringUtils.isNotBlank((String)(type = userSession.getUserinfoType())) && ListUtil.isEmpty((Collection)qlist) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-type-" + type + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
                qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-type-" + type + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
            }
            if (StringUtils.isNotBlank((String)(dis = userSession.getUserinfoDischannelcode())) && ListUtil.isEmpty((Collection)qlist) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-dis-" + dis + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
                qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-dis-" + dis + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
            }
            if (StringUtils.isNotBlank((String)(qtype = userSession.getQualityQtypeCode())) && ListUtil.isEmpty((Collection)qlist) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-qtype-" + qtype + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
                qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-qtype-" + qtype + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
            }
        }
        if (ListUtil.isEmpty(qlist) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
        }
        if (ListUtil.isEmpty(qlist)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("fchannelPmodeCode", fchannelPmodeCode);
            map.put("tenantCode", tenantCode);
            map.put("fchannelDr", fchannelDr);
            qlist = this.ptePtfchannelServiceRepository.queryPtfchannelReList(map);
            if (null == qlist || qlist.isEmpty()) {
                this.logger.error("web.pay.PayServiceRepository.getPayChannel.null", (Object)((Object)map).toString());
                return null;
            }
        }
        return qlist;
    }

    public List<PayChannel> getPayChannel(UserSession userSession, String fchannelPmodeCode, String tenantCode, String fchannelDr, String tginfoCode, String channelCode, String proappCode, String userOcode) {
        List<PtePtfchannelReDomain> qlist;
        if (null == userSession || StringUtils.isBlank((String)fchannelPmodeCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)fchannelDr)) {
            return null;
        }
        String memberCode = userSession.getUserPcode();
        String type = memberCode.substring(0, 1);
        String faccountType = "101";
        if ("2".equals(type)) {
            faccountType = "201";
        }
        if (ListUtil.isEmpty(qlist = this.getPtfchannel(userSession, fchannelPmodeCode, tenantCode, fchannelDr, tginfoCode, channelCode, proappCode))) {
            this.logger.error("web.pay.PayServiceRepository.getPayChannel.qlist", (Object)(memberCode + "-" + fchannelPmodeCode + "-" + tenantCode + "-" + fchannelDr + "-" + tginfoCode + "-" + channelCode + "-" + proappCode));
            return null;
        }
        Map<String, VdFaccountInfo> account = this.getVd(memberCode, tenantCode, faccountType);
        ArrayList<PayChannel> channelList = new ArrayList<PayChannel>();
        for (PtePtfchannelReDomain ptePtfchannelReDomain : qlist) {
            String channelType;
            List<VdFaccountInfo> vdList;
            HashMap<String, Object> map;
            PayChannel payChannel;
            if ("BANK".equals(ptePtfchannelReDomain.getDicActorCode())) {
                payChannel = new PayChannel();
                try {
                    BeanUtils.copyAllPropertys((Object)payChannel, (Object)ptePtfchannelReDomain);
                    if ("1".equals(ptePtfchannelReDomain.getPtfchannelAmt())) {
                        map = new HashMap<String, Object>();
                        map.put("tenantCode", tenantCode);
                        map.put("memberCode", memberCode);
                        map.put("fchannelType", ptePtfchannelReDomain.getFchannelType());
                        vdList = this.queryAmt(map, ptePtfchannelReDomain.getPtfchannelAmtapi(), userOcode);
                        if (ListUtil.isNotEmpty(vdList)) {
                            BeanUtils.copyAllPropertys((Object)payChannel, (Object)vdList.get(0));
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error("web.pay.PayServiceRepository.getPayChannel.e", (Throwable)e);
                }
                channelList.add(payChannel);
                continue;
            }
            String fundType = ptePtfchannelReDomain.getFundType();
            if (StringUtils.isBlank((String)fundType)) {
                fundType = "01";
            }
            if (StringUtils.isBlank((String)(channelType = ptePtfchannelReDomain.getFchannelType()))) {
                channelType = "";
            }
            if (!faccountType.equals(channelType) && !fundType.equals("01") && type.equals(channelType.substring(0, 1))) {
                Map<String, VdFaccountInfo> naccount = this.getVd(memberCode, tenantCode, ptePtfchannelReDomain.getFchannelType());
                if (null == naccount || naccount.isEmpty()) {
                    this.logger.error("web.pay.PayServiceRepository.getPayChannel.naccount", (Object)(memberCode + ":" + tenantCode + ":" + ptePtfchannelReDomain.getFchannelType()));
                    continue;
                }
                account.putAll(naccount);
            } else if (!type.equals(channelType.substring(0, 1))) {
                this.logger.error("web.pay.PayServiceRepository.getPayChannel.type", (Object)(memberCode + ":" + tenantCode + ":" + ptePtfchannelReDomain.getFchannelType()));
                continue;
            }
            payChannel = new PayChannel();
            try {
                BeanUtils.copyAllPropertys((Object)payChannel, (Object)ptePtfchannelReDomain);
                VdFaccountInfo v = account.get(ptePtfchannelReDomain.getFchannelType());
                if (null != v) {
                    BeanUtils.copyAllPropertys((Object)payChannel, (Object)v);
                }
                if ("1".equals(ptePtfchannelReDomain.getPtfchannelAmt())) {
                    map = new HashMap();
                    map.put("tenantCode", tenantCode);
                    map.put("memberCode", memberCode);
                    map.put("fchannelType", ptePtfchannelReDomain.getFchannelType());
                    vdList = this.queryAmt(map, ptePtfchannelReDomain.getPtfchannelAmtapi(), memberCode);
                    if (ListUtil.isNotEmpty(vdList)) {
                        BeanUtils.copyAllPropertys((Object)payChannel, (Object)vdList.get(0));
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("web.pay.PayServiceRepository.getPayChannel.e1", (Throwable)e);
            }
            channelList.add(payChannel);
        }
        return channelList;
    }

    public List<VdFaccountInfo> queryAmt(Map<String, Object> map, String apiCode, String userOcode) {
        PostParamMap pmap = new PostParamMap(apiCode);
        pmap.putParam("userAccount", (Object)userOcode);
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.getForList(pmap, VdFaccountInfo.class);
    }

    private Map<String, VdFaccountInfo> getVd(String memberCode, String tenantCode, String faccountType) {
        List vdList = this.vdFaccountServiceRepository.queryOuterFaccount(memberCode, faccountType, tenantCode);
        HashMap<String, VdFaccountInfo> account = new HashMap<String, VdFaccountInfo>();
        if (null != vdList && !vdList.isEmpty()) {
            for (VdFaccountInfo v : vdList) {
                account.put(v.getFaccountType(), v);
            }
        }
        return account;
    }

    public HtmlJsonReBean saveContractSettlBatch(List<OcContractSettlDomain> ocContractSettlDomainList) {
        return this.ocContractServiceRepository.saveContractSettlBatch(ocContractSettlDomainList);
    }

    public Map<String, OcContractSettlDomain> queryContractSettl(String contractBillcode, String tenantCode) {
        List list = this.ocContractServiceRepository.queryContractSettlByContractCode(tenantCode, contractBillcode);
        if (ListUtil.isEmpty((Collection)list)) {
            return null;
        }
        HashMap<String, OcContractSettlDomain> map = new HashMap<String, OcContractSettlDomain>();
        for (OcContractSettlDomain ocContractSettlDomain : list) {
            map.put(ocContractSettlDomain.getContractSettlBlance(), ocContractSettlDomain);
        }
        return map;
    }

    public HtmlJsonReBean saveContractSublistBatch(List<OcContractSublistDomain> ocContractSublistDomainList) {
        return this.ocContractSubServiceRepository.saveContractSublistBatch(ocContractSublistDomainList);
    }

    public OcContractSubReDomain getContractSub(String tenantCode, String contractSubCode) {
        return this.ocContractSubServiceRepository.getContractSubByCode(tenantCode, contractSubCode);
    }
}

