/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pay.wft.util;

import com.qjsoft.laser.controller.pay.wft.SwiftpassConfig;
import com.qjsoft.laser.controller.pay.wft.util.MD5;
import com.qjsoft.laser.controller.pay.wft.util.RSAUtil;
import com.qjsoft.laser.controller.pay.wft.util.SignUtils;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static final Logger log = LoggerFactory.getLogger(SignUtil.class);

    public static String getSign(String signType, String preStr) {
        if ("RSA_1_256".equals(signType)) {
            try {
                return SignUtil.sign(preStr, "RSA_1_256", SwiftpassConfig.mchPrivateKey);
            }
            catch (Exception e1) {
                log.error("getSign\u5f02\u5e38\uff1a", (Throwable)e1);
            }
        } else {
            return MD5.sign(preStr, "&key=" + SwiftpassConfig.key, "utf-8");
        }
        return null;
    }

    public static boolean verifySign(String sign, String signType, Map<String, String> resultMap) throws Exception {
        if ("RSA_1_256".equals(signType)) {
            Map<String, String> Reparams = SignUtils.paraFilter(resultMap);
            StringBuilder Rebuf = new StringBuilder((Reparams.size() + 1) * 10);
            SignUtils.buildPayParams(Rebuf, Reparams, false);
            String RepreStr = Rebuf.toString();
            if (SignUtil.verifySign(RepreStr, sign, "RSA_1_256", SwiftpassConfig.platPublicKey)) {
                return true;
            }
        } else if ("MD5".equals(signType) && SignUtils.checkParam(resultMap, SwiftpassConfig.key)) {
            return true;
        }
        return false;
    }

    public static boolean verifySign(String preStr, String sign, String signType, String platPublicKey) throws Exception {
        RSAUtil.SignatureSuite suite = null;
        if ("RSA_1_1".equals(signType)) {
            suite = RSAUtil.SignatureSuite.SHA1;
        } else if ("RSA_1_256".equals(signType)) {
            suite = RSAUtil.SignatureSuite.SHA256;
        } else {
            throw new Exception("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u65b9\u5f0f");
        }
        boolean result = RSAUtil.verifySign(suite, preStr.getBytes("UTF8"), Base64.decodeBase64((byte[])sign.getBytes("UTF8")), platPublicKey);
        return result;
    }

    public static String sign(String preStr, String signType, String mchPrivateKey) throws Exception {
        RSAUtil.SignatureSuite suite = null;
        if ("RSA_1_1".equals(signType)) {
            suite = RSAUtil.SignatureSuite.SHA1;
        } else if ("RSA_1_256".equals(signType)) {
            suite = RSAUtil.SignatureSuite.SHA256;
        } else {
            throw new Exception("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u65b9\u5f0f");
        }
        byte[] signBuf = RSAUtil.sign(suite, preStr.getBytes("UTF8"), mchPrivateKey);
        return new String(Base64.encodeBase64((byte[])signBuf), "UTF8");
    }
}

