/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pay.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.pay.wft.service.GateWayService;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pte/payback"}, name="\u94f6\u884c\u901a\u77e5\u56de\u8c03")
public class PayBackCon
extends SpringmvcController {
    private static final Logger log = LoggerFactory.getLogger(PayBackCon.class);
    private static String CODE = "pte.payback.con";
    @Autowired
    private GateWayService gateWayService;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;

    protected String getContext() {
        return "payback";
    }

    @RequestMapping(value={"http/get/{fchannelCode}/{tenantCode}/{fchannelPmode}/{businessOrderno}"}, method={RequestMethod.GET}, name="\u652f\u4ed8\u4e0b\u5355\u901a\u77e5")
    public String getBankReturn(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="fchannelCode") String fchannelCode, @PathVariable(value="tenantCode") String tenantCode, @PathVariable(value="fchannelPmode") String fchannelPmode, @PathVariable(value="businessOrderno") String businessOrderno) {
        log.error("=========\u6267\u884c\u4e86getBankReturn\u65b9\u6cd5\uff1a===========");
        log.error("=========gateWayService.callBack.start===========");
        this.gateWayService.callBack(request, response);
        log.error("=========gateWayService.callBack.end===========");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", businessOrderno);
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractByCode(map);
        if (null == ocContractReDomain) {
            this.logger.error(CODE + ".getBankReturn.null", (Object)((Object)map).toString());
        }
        return this.createHtml(ocContractReDomain);
    }

    @RequestMapping(value={"order.json"}, name="\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u67e5\u8be2")
    @ResponseBody
    public HtmlJsonReBean getOrderPayState(HttpServletRequest request, HttpServletResponse response, String contractBillcode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", this.getTenantCode(request));
        map.put("contractBillcode", contractBillcode);
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractByCode(map);
        if (null == ocContractReDomain) {
            this.logger.error(CODE + ".getBankReturn.null", (Object)((Object)map).toString());
            return new HtmlJsonReBean(CODE + ".getBankReturn.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        Integer datastate = ocContractReDomain.getDataState();
        if (null == datastate || 2 != datastate) {
            return new HtmlJsonReBean(CODE + ".getBankReturn.datastate", "\u652f\u4ed8\u672a\u5b8c\u6210");
        }
        return new HtmlJsonReBean();
    }

    private String createHtml(OcContractReDomain ocContractReDomain) {
        Integer datastate = 0;
        String contractBillcode = "";
        String tenantCode = "";
        if (null != ocContractReDomain) {
            datastate = ocContractReDomain.getDataState();
            contractBillcode = ocContractReDomain.getContractBillcode();
            tenantCode = ocContractReDomain.getTenantCode();
        }
        String html = datastate + contractBillcode + tenantCode;
        return html;
    }

    @RequestMapping(value={"queryAuthCode.json"}, name="\u83b7\u53d6\u4f1a\u5355\u53f7\u7684\u9a8c\u8bc1\u7801")
    @ResponseBody
    public HtmlJsonReBean queryAuthCode(HttpServletRequest request, HttpServletResponse response) {
        this.logger.error(CODE + ".queryAuthCode.json", (Object)"============================================\u83b7\u53d6\u4f1a\u5355\u53f7\u7684\u9a8c\u8bc1\u7801============================================");
        Map param = this.assemMapParam(request);
        HashMap<String, String> map = new HashMap<String, String>();
        String tenantCode = this.getTenantCode(request);
        map.put("tenantCode", tenantCode);
        Map returnMap = this.ocContractServiceRepository.queryAuthCode(param, tenantCode);
        this.logger.error(CODE + ".queryAuthCode.json", (Object)("============================================str->" + JsonUtil.buildNonEmptyBinder().toJson((Object)returnMap) + "============================================"));
        if (returnMap.isEmpty()) {
            this.logger.error(CODE + ".queryAuthCode.null", (Object)((Object)map).toString());
            return new HtmlJsonReBean(CODE + ".queryAuthCode.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        return new HtmlJsonReBean((Object)returnMap);
    }

    @RequestMapping(value={"queryReceipt.json"}, name="\u5206\u9875\u83b7\u53d6\u56de\u5355")
    @ResponseBody
    public HtmlJsonReBean queryReceipt(HttpServletRequest request, HttpServletResponse response) {
        this.logger.error(CODE + ".queryReceipt.json", (Object)"============================================\u5206\u9875\u83b7\u53d6\u56de\u5355============================================");
        Map param = this.assemMapParam(request);
        HashMap<String, String> map = new HashMap<String, String>();
        String tenantCode = this.getTenantCode(request);
        map.put("tenantCode", tenantCode);
        Map returnMap = this.ocContractServiceRepository.queryReceipt(param, tenantCode);
        this.logger.error(CODE + ".queryReceipt.json", (Object)("============================================str->" + JsonUtil.buildNonEmptyBinder().toJson((Object)returnMap) + "============================================"));
        if (returnMap.isEmpty()) {
            this.logger.error(CODE + ".queryReceipt.null", (Object)((Object)map).toString());
            return new HtmlJsonReBean(CODE + ".queryReceipt.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        return new HtmlJsonReBean((Object)returnMap);
    }

    @RequestMapping(value={"queryPinganBank.json"}, name="\u56de\u8c03\u5e73\u5b89\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean queryPinganBank(HttpServletRequest request, HttpServletResponse response) {
        this.logger.error(CODE + ".queryPinganBank.json", (Object)"============================================\u56de\u8c03\u5e73\u5b89\u63a5\u53e3============================================");
        Map param = this.assemMapParam(request);
        HashMap<String, String> map = new HashMap<String, String>();
        String tenantCode = this.getTenantCode(request);
        map.put("tenantCode", tenantCode);
        String s = this.ocContractServiceRepository.queryPinganBank(param, tenantCode);
        if (s.isEmpty()) {
            this.logger.error(CODE + ".queryPinganBank.null", (Object)((Object)map).toString());
            return new HtmlJsonReBean(CODE + ".queryPinganBank.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        return new HtmlJsonReBean((Object)s);
    }
}

