/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pay.controller;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ijpay.core.enums.SignType;
import com.ijpay.core.enums.TradeType;
import com.ijpay.core.kit.HttpKit;
import com.ijpay.core.kit.IpKit;
import com.ijpay.core.kit.WxPayKit;
import com.ijpay.wxpay.WxPayApi;
import com.ijpay.wxpay.WxPayApiConfig;
import com.ijpay.wxpay.WxPayApiConfigKit;
import com.ijpay.wxpay.model.UnifiedOrderModel;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.cm.repository.CmFchannelConfigServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSettlDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSubReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSublistDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractSubServiceRepository;
import com.qjsoft.laser.controller.facade.pte.domain.BankHtmlForm;
import com.qjsoft.laser.controller.facade.pte.domain.PtePtfchannelReDomain;
import com.qjsoft.laser.controller.facade.pte.domain.PtePtradeParticipantDomain;
import com.qjsoft.laser.controller.facade.pte.domain.PtePtradeReDomain;
import com.qjsoft.laser.controller.facade.pte.domain.PtradeBean;
import com.qjsoft.laser.controller.facade.pte.repository.PtePtradeServiceRepository;
import com.qjsoft.laser.controller.facade.sms.service.AliyunSmsService;
import com.qjsoft.laser.controller.facade.sms.service.SMSSceneEnum;
import com.qjsoft.laser.controller.facade.um.domain.UmUserReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.pay.bean.PayChannel;
import com.qjsoft.laser.controller.pay.bean.PayCommit;
import com.qjsoft.laser.controller.pay.bean.PayInfo;
import com.qjsoft.laser.controller.pay.facade.PayServiceRepository;
import com.qjsoft.laser.controller.pay.utils.AjaxResult;
import com.qjsoft.laser.controller.pay.utils.DateUtil;
import com.qjsoft.laser.controller.pay.wft.service.GateWayService;
import com.qjsoft.laser.controller.pay.wft.util.SignUtil;
import com.qjsoft.laser.controller.pay.wft.util.XmlUtils;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.qjsoft.laser.controller.springmvc.bean.TmProappEnv;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.core.JsonReBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pte/pay"}, name="\u7528\u6237\u652f\u4ed8\u670d\u52a1")
public class PayCon
extends SpringmvcController {
    private static final Logger log = LoggerFactory.getLogger(PayCon.class);
    private static String CODE = "pte.pay.con";
    @Autowired
    private PtePtradeServiceRepository ptePtradeServiceRepository;
    @Autowired
    PayServiceRepository payServiceRepository;
    @Autowired
    UserServiceRepository userServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private OcContractSubServiceRepository ocContractSubServiceRepository;
    @Autowired
    private CmFchannelConfigServiceRepository cmFchannelConfigServiceRepository;
    @Autowired
    private GateWayService gateWayService;
    @Autowired
    private AliyunSmsService aliyunSmsService;
    private static final ExecutorService pool = Executors.newFixedThreadPool(100);

    protected String getContext() {
        return "pay";
    }

    @RequestMapping(value={"saveOrderSubToPay.json"}, name="\u5206\u6b21\u652f\u4ed8\u4e0b\u5355")
    @ResponseBody
    public PayInfo saveOrderSubToPay(HttpServletRequest request, String contractBillcode, String contractSubCode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)contractSubCode)) {
            this.logger.error(CODE + ".saveOrderSubToPay.contractBillcode", (Object)"contractBillcode contractSubCode is null");
            return null;
        }
        String oauthEnvCode = this.getOauthEnvCode(request);
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            this.logger.error(CODE + ".saveOrderSubToPay.oauthEnvCode", (Object)"oauthEnvCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveOrderSubToPay.userSession", (Object)"userSession is null");
            return null;
        }
        Map<String, Object> envmap = this.getEnvMap(request);
        this.logger.error("===============envmap===========", (Object)JSONObject.toJSONString(envmap));
        PayInfo payInfo = this.payServiceRepository.saveSubPay(envmap, userSession.getUserPcode(), contractBillcode, contractSubCode, oauthEnvCode, this.getTenantCode(request));
        if (null == payInfo) {
            return null;
        }
        List<PayChannel> payChannelList = this.payServiceRepository.getPayChannel(userSession, oauthEnvCode, this.getTenantCode(request), "PAY", this.getTginfoCode(request), this.getNowChannel(request), this.getProappCode(request), userSession.getUserOcode());
        payInfo.setPayChannelList(payChannelList);
        return payInfo;
    }

    @RequestMapping(value={"saveOrderToPay.json"}, name="\u652f\u4ed8\u4e0b\u5355")
    @ResponseBody
    public PayInfo saveOrderToPay(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".saveOrderToPay.contractBillcode", (Object)"contractBillcode is null");
            return null;
        }
        String oauthEnvCode = this.getOauthEnvCode(request);
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            this.logger.error(CODE + ".saveOrderToPay.oauthEnvCode", (Object)"oauthEnvCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveOrderToPay.userSession", (Object)"userSession is null");
            return null;
        }
        Map<String, Object> envmap = this.getEnvMap(request);
        PayInfo payInfo = this.payServiceRepository.savePay(envmap, userSession.getUserPcode(), contractBillcode, oauthEnvCode, this.getTenantCode(request));
        if (null == payInfo) {
            this.logger.error(CODE + ".saveOrderToPay.payInfo", (Object)"payInfo is null");
            return null;
        }
        List<PayChannel> payChannelList = this.payServiceRepository.getPayChannel(userSession, oauthEnvCode, this.getTenantCode(request), "PAY", this.getTginfoCode(request), this.getNowChannel(request), this.getProappCode(request), userSession.getUserOcode());
        payInfo.setPayChannelList(payChannelList);
        return payInfo;
    }

    private Map<String, Object> getEnvMap(HttpServletRequest request) {
        UserSession userSession;
        String userAgent;
        HashMap<String, Object> envmap = new HashMap<String, Object>();
        String proappCode = this.getProappCode(request);
        String oauthEnvCode = this.getOauthEnvCode(request);
        if ("app".equals(oauthEnvCode) && StringUtils.isNotBlank((String)(userAgent = request.getHeader("User-Agent")))) {
            if (userAgent.contains("qj-ios")) {
                oauthEnvCode = "ios";
            } else if (userAgent.contains("qj-android")) {
                oauthEnvCode = "android";
            }
        }
        envmap.put("client_ip", this.getClientIp(request));
        envmap.put("wap_type", this.getOauthEnvCode(request));
        envmap.put("wap_name", proappCode);
        TmProappEnv tmProappEnv = (TmProappEnv)SupDisUtil.getMapJson((String)"TmProappEnv-tenant-ProappCode", (String)(this.getTenantCode(request) + "-" + proappCode), TmProappEnv.class);
        if (null != tmProappEnv) {
            envmap.put("wap_url", tmProappEnv.getProappEnvDomain());
            if (StringUtils.isNotBlank((String)tmProappEnv.getProappEnvDes())) {
                envmap.put("wap_name", tmProappEnv.getProappEnvDes());
            }
        }
        if (null != (userSession = this.getUserSession(request))) {
            envmap.put("userOcode", userSession.getUserOcode());
            envmap.put("openId", userSession.getOpenId());
            String oauthEncCode = this.getOauthEnvCode(request);
            UmUserReDomainBean umUserReDomainBean = this.userServiceRepository.getUserByUserCode(userSession.getUserCode(), userSession.getTenantCode());
            if ("wechat".equals(oauthEncCode) && StringUtils.isBlank((String)userSession.getOpenId()) && null != umUserReDomainBean) {
                envmap.put("openId", umUserReDomainBean.getUserOpenid());
            }
            envmap.put("aliOpenId", umUserReDomainBean.getUserOcode());
        }
        this.logger.info("==========envmap===========", (Object)JSONObject.toJSONString(envmap));
        return envmap;
    }

    @RequestMapping(value={"saveOrderToBatchPay.json"}, name="\u6279\u91cf\u652f\u4ed8\u4e0b\u5355")
    @ResponseBody
    public PayInfo saveOrderToBatchPay(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            this.logger.error(CODE + ".saveOrderToBatchPay.contractBbillcode", (Object)"contractBbillcode is null");
            return null;
        }
        String oauthEnvCode = this.getOauthEnvCode(request);
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            this.logger.error(CODE + ".saveOrderToBatchPay.oauthEnvCode", (Object)"oauthEnvCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveOrderToBatchPay.userSession", (Object)"userSession is null");
            return null;
        }
        Map<String, Object> envmap = this.getEnvMap(request);
        PayInfo payInfo = this.payServiceRepository.saveBatchPay(envmap, userSession.getUserPcode(), contractBbillcode, oauthEnvCode, this.getTenantCode(request));
        if (null == payInfo) {
            return null;
        }
        List<PayChannel> payChannelList = this.payServiceRepository.getPayChannel(userSession, oauthEnvCode, this.getTenantCode(request), "PAY", this.getTginfoCode(request), this.getNowChannel(request), this.getProappCode(request), userSession.getUserOcode());
        payInfo.setPayChannelList(payChannelList);
        return payInfo;
    }

    @RequestMapping(value={"mockQj.json"}, name="\u652f\u4ed8mock\uff08\u5343\u5320\u652f\u4ed8\uff09")
    public void mockQj(HttpServletRequest request, HttpServletResponse response) {
        Map map = this.getQueryMapParams(request);
        Object out_trade_no = map.get("out_trade_no");
        Object tenantCode = map.get("tenantCode");
        Object notify_url = map.get("notify_url");
        Object return_url = map.get("return_url");
        if (null != notify_url) {
            String notify_urlStr = String.valueOf(notify_url);
            tenantCode = notify_urlStr.substring(notify_urlStr.length() - 9, notify_urlStr.length() - 1);
        }
        HashMap mapRead = new HashMap();
        mapRead.put("\u5546\u6237\u8d26\u6237", map.get("seller_account_name"));
        mapRead.put("\u8d39\u7528", map.get("total_fee"));
        mapRead.put("\u63cf\u8ff0", map.get("subject"));
        mapRead.put("\u5546\u6237ID", map.get("seller_id"));
        mapRead.put("\u5408\u4f5cID", map.get("partner"));
        mapRead.put("E-mail", map.get("seller_email"));
        mapRead.put("\u6d41\u6c34\u53f7", out_trade_no);
        StringBuffer html = new StringBuffer();
        html.append("<!DOCTYPE html>\n");
        html.append("<html>");
        html.append("<head>\n");
        html.append("<meta charset=\"utf-8\">\n");
        html.append("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, user-scalable=no\">\n");
        html.append("<title>\u5343\u5320\u652f\u4ed8</title>\n");
        html.append("</head>\n");
        html.append("<style type=\"text/css\">                \n");
        html.append("*{                                       \n");
        html.append("\tpadding:0;                             \n");
        html.append("\tmargin:0;                              \n");
        html.append("\tfont-family: '\u5fae\u8f6f\u96c5\u9ed1';               \n");
        html.append("\tfont-size:13px;                        \n");
        html.append("}\t                                       \n");
        html.append("ul li{                                   \n");
        html.append("\tlist-style: none;                      \n");
        html.append("}                                        \n");
        html.append(".t-box{                                  \n");
        html.append("      display: -moz-box;                 \n");
        html.append("      display:-webkit-box;               \n");
        html.append("      display: box;                      \n");
        html.append("  }                                      \n");
        html.append("  .t-box-flex1{                          \n");
        html.append("      -moz-box-flex:1;                   \n");
        html.append("      -webkit-box-flex:1;                \n");
        html.append("      box-flex:1;                        \n");
        html.append("      width:0%                           \n");
        html.append("   }                                     \n");
        html.append(".auto{                                   \n");
        html.append("\twidth:90%;                             \n");
        html.append("\tmargin:0 5%;                           \n");
        html.append("}                                        \n");
        html.append(".pay-ul {                                \n");
        html.append("\tmargin-top:30px;                       \n");
        html.append("}                                        \n");
        html.append(".pay-ul li{                              \n");
        html.append("\tmargin:12px 0;                         \n");
        html.append("}                                        \n");
        html.append(".pay-ul label{                           \n");
        html.append("\twidth:6rem;                            \n");
        html.append("\tdisplay:block;                         \n");
        html.append("\tline-height:35px;                      \n");
        html.append("\ttext-align: right;                     \n");
        html.append("}                                        \n");
        html.append(".pay-ul input{                           \n");
        html.append("\tpadding:8px 3px;                       \n");
        html.append("\twidth:100%;                            \n");
        html.append("\tborder:1px solid #e0e0e0;              \n");
        html.append("\tborder-radius:2px;                     \n");
        html.append("}                                        \n");
        html.append(".pay-ul .pay-btn {                       \n");
        html.append("\tmargin-top:20px;                       \n");
        html.append("}                                        \n");
        html.append(".pay-btn input{                          \n");
        html.append("\twidth:80%;                             \n");
        html.append("\tcursor: pointer;                       \n");
        html.append("\tborder:0;                              \n");
        html.append("\tborder-radius:3px;                     \n");
        html.append("\toutline: none                          \n");
        html.append("}                                        \n");
        html.append(".pay-btn input[type=\"submit\"]{         \n");
        html.append("\tcolor:#fff;                            \n");
        html.append("\tbackground:#e52222;                    \n");
        html.append("\tmargin:0 5% 0 15%;                     \n");
        html.append("}                                        \n");
        html.append(".pay-btn input[type=\"button\"]{         \n");
        html.append("\tcolor:#fff;                            \n");
        html.append("\tbackground:#999;                       \n");
        html.append("\tmargin:0 15% 0 5%;                     \n");
        html.append("}                                        \n");
        html.append("</style>                                 \n");
        html.append("<body>\n");
        html.append("<ul class=\"auto pay-ul\">\n");
        String htmlStr = null;
        for (Map.Entry entry : mapRead.entrySet()) {
            htmlStr = "<li class=\"t-box\">";
            htmlStr = htmlStr + "<label>" + (String)entry.getKey() + "\uff1a</label><div class=\"t-box-flex1\"><input type=\"text\" value=\"" + entry.getValue().toString() + "\" readonly=\"true\"/></div><br/>\n";
            htmlStr = htmlStr + "</li>";
            html.append(htmlStr);
        }
        HashMap<String, Long> mapModify = new HashMap<String, Long>();
        mapModify.put("\u8d44\u91d1\u6d41\u6c34\u53f7", System.currentTimeMillis());
        for (Map.Entry entry : mapModify.entrySet()) {
            htmlStr = "<li class=\"t-box\">";
            htmlStr = htmlStr + "<label>" + (String)entry.getKey() + "\uff1a</label><div class=\"t-box-flex1\"><input id=\"trade_no\" type=\"text\" value=\"" + entry.getValue().toString() + "\"/></div><br/>\n";
            htmlStr = htmlStr + "</li>";
            html.append(htmlStr);
        }
        html.append("<li class=\"t-box pay-btn\" >\n");
        html.append("<div class=\"t-box-flex1\"><input type=\"submit\" value=\"\u6210\u529f\" onclick=\"ajax('TRADE_SUCCESS');\"></div>\n");
        html.append("<div class=\"t-box-flex1\"><input type=\"button\" value=\"\u5931\u8d25\" onclick=\"ajax('TRADE_FAULURE');\"></div>\n");
        html.append("</li>\n");
        html.append("</ul>\n");
        html.append("</body>\n");
        html.append("<script>\n");
        html.append("var xhr = new XMLHttpRequest();\n");
        html.append("var formData = new FormData();\n");
        html.append("formData.append('out_trade_no', '#{out_trade_no}');\n".replace("#{out_trade_no}", out_trade_no.toString()));
        html.append("formData.append('notify_url', '#{notify_url}');\n".replace("#{notify_url}", notify_url.toString()));
        html.append("formData.append('tenantCode', '#{tenantCode}');\n".replace("#{tenantCode}", tenantCode.toString()));
        html.append("formData.append('exterface', 'trade_status_sync');\n");
        html.append("xhr.withCredentials = true;\n");
        html.append("function ajax(trade_status) {\n");
        html.append("formData.append('trade_status', trade_status);\n");
        html.append("formData.append('trade_no', document.getElementById('trade_no').value);\n");
        html.append("xhr.open('POST', '#{commitUrl}');\n".replace("#{commitUrl}", notify_url.toString()));
        html.append("xhr.send(formData);\n");
        html.append("xhr.onreadystatechange = function () {\n");
        html.append("if (xhr.readyState==4 && xhr.status==200) {\n");
        html.append("location.href = '#{return_url}';\n".replace("#{return_url}", return_url.toString()));
        html.append("} else {console.log(xhr.readyState + '--' + xhr.status); }\n");
        html.append("}\n");
        html.append("}\n");
        html.append("</script>\n");
        html.append("</html>");
        try {
            response.getWriter().print(html.toString());
        }
        catch (IOException e) {
            this.logger.error(CODE + ".mockQj.print.ex", (Throwable)e);
        }
    }

    @RequestMapping(value={"sendSMS.json"}, name="\u77ed\u4fe1\u53d1\u9001\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveContract(String userPhone, String scene) {
        if (StringUtils.isEmpty((String)userPhone)) {
            return new HtmlJsonReBean("error", "\u624b\u673a\u53f7\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u624b\u673a\u53f7\u662f\u5426\u6b63\u786e");
        }
        return this.aliyunSmsService.sendSms(userPhone, scene);
    }

    @RequestMapping(value={"paymentCompleteRecall.json"}, name="\u652f\u4ed8\u5b8c\u6210\u5c0f\u7a0b\u5e8f\u56de\u8c03")
    @ResponseBody
    public HtmlJsonReBean paymentCompleteRecall(HttpServletRequest request, String contractBillCode) {
        if (StringUtils.isBlank((String)contractBillCode)) {
            this.logger.error(CODE + ".paymentCompleteRecall.param", (Object)"param is null");
            return new HtmlJsonReBean("error", "\u8ba2\u5355\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> mp = new HashMap<String, String>();
        mp.put("contractSubCode", contractBillCode);
        mp.put("tenantCode", tenantCode);
        SupQueryResult order = this.ocContractSubServiceRepository.queryContractSubPage(mp);
        if (null == order || order.getList().size() == 0) {
            this.logger.error("========================\u6839\u636e\u8ba2\u5355\u53f7contractSubCode:" + contractBillCode + "\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u8ba2\u5355");
            return new HtmlJsonReBean("error", "\u8ba2\u5355\u672a\u627e\u5230");
        }
        UserSession userSession = this.getUserSession(request);
        String key = contractBillCode + ":" + userSession.getUserPcode() + ":ContractAppraise";
        SupDisUtil.set((String)key, (String)"1", (int)600);
        String remot = SupDisUtil.getRemot((String)key);
        log.info(key + "=" + remot + " \u7f13\u5b58\u6807\u5fd7");
        return new HtmlJsonReBean((Object)remot);
    }

    @RequestMapping(value={"paymentCommit.json"}, name="\u652f\u4ed8\u786e\u8ba4")
    @ResponseBody
    public HtmlJsonReBean paymentCommit(HttpServletRequest request, HttpServletResponse response, String payCommitStr, String ptradeSeqno, String paywd, String contractBlance, String smsCode) {
        HtmlJsonReBean htmlJsonReBean;
        if (StringUtils.isBlank((String)ptradeSeqno) || StringUtils.isBlank((String)payCommitStr)) {
            this.logger.error(CODE + ".paymentCommit.param", (Object)"param is null");
            return new HtmlJsonReBean(CODE + ".paymentCommit.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        String oauthEnvCode = this.getOauthEnvCode(request);
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            this.logger.error(CODE + ".paymentCommit.oauthEnvCode", (Object)"oauthEnvCode is null");
            return new HtmlJsonReBean(CODE + ".paymentCommit.oauthEnvCode", "\u6570\u636e\u4e3a\u7a7a");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".paymentCommit.userSession", (Object)"userSession is null");
            return new HtmlJsonReBean(CODE + ".paymentCommit.userSession", "\u6570\u636e\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> mp = new HashMap<String, String>();
        mp.put("ptradeSeqno", ptradeSeqno);
        mp.put("tenantCode", tenantCode);
        SupQueryResult order = this.ocContractServiceRepository.queryContractPage(mp);
        if (null == order || order.getList().size() == 0) {
            this.logger.error("========================\u6839\u636eptradeSeqno:" + ptradeSeqno + "\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u8ba2\u5355");
            return new HtmlJsonReBean(CODE + ".paymentCommit.order", "\u672a\u5339\u914d\u5230ptradeSeqno\u76f8\u5173\u7684\u8ba2\u5355");
        }
        OcContractReDomain ocContractReDomain = (OcContractReDomain)order.getList().get(0);
        if (!ocContractReDomain.getContractType().equals("02") && !ocContractReDomain.getContractType().equals("03") && HtmlJsonReBean.ERRORCODE.equals((htmlJsonReBean = this.aliyunSmsService.verifySms(userSession.getUserPhone(), SMSSceneEnum.CONTRACT_CREATE.getCode(), smsCode)).getErrorCode())) {
            return htmlJsonReBean;
        }
        log.info(userSession.getUserPhone() + " - \u77ed\u4fe1\u9a8c\u8bc1\u901a\u8fc7");
        List payCommitList = (List)JsonUtil.buildNormalBinder().getJsonToList(payCommitStr, PayCommit.class);
        if (null == payCommitList || payCommitList.isEmpty()) {
            this.logger.error("=========payCommitList is empty");
            return null;
        }
        this.logger.error("payCommitStr=========", (Object)payCommitStr);
        this.logger.error("ptradeSeqno=========", (Object)ptradeSeqno);
        this.logger.error("contractBlance=========", (Object)contractBlance);
        this.logger.error("paywd=========", (Object)paywd);
        HashMap<String, String> ptemap = new HashMap<String, String>();
        ptemap.put("ptradeSeqno", ptradeSeqno);
        ptemap.put("tenantCode", tenantCode);
        PtePtradeReDomain ptePtradeReDomain = this.ptePtradeServiceRepository.getPtradeByCode(ptemap);
        if (null == ptePtradeReDomain) {
            this.logger.error(CODE + ".paymentCommit.ptePtradeReDomain", (Object)((Object)ptemap).toString());
            return new HtmlJsonReBean(CODE + ".paymentCommit.ptePtradeReDomain", "\u652f\u4ed8\u6d41\u6c34\u4e00\u6b21");
        }
        String userPcode = userSession.getUserPcode();
        if (!userPcode.equals(ptePtradeReDomain.getOpuserCode())) {
            this.logger.error(CODE + ".paymentCommit.ptePtradeReDomain.userPcode", (Object)((Object)ptemap).toString());
            return new HtmlJsonReBean(CODE + ".paymentCommit.ptePtradeReDomain", "\u4e0d\u662f\u5f53\u524d\u767b\u5f55\u7528\u6237");
        }
        Map<String, PtePtfchannelReDomain> channelMap = this.payServiceRepository.queryChannel(oauthEnvCode, tenantCode, "PAY", userSession, this.getTginfoCode(request), this.getNowChannel(request), this.getProappCode(request));
        this.logger.error(CODE + "channelMap====================", (Object)JsonUtil.buildNormalBinder().toJson(channelMap));
        if (null == channelMap || channelMap.isEmpty()) {
            log.error("\u83b7\u53d6\u4ea4\u6613\u6e20\u9053\u5931\u8d25:{}", channelMap);
            return null;
        }
        String contractBillcode = ocContractReDomain.getContractBillcode();
        String payed = contractBillcode + ":" + userSession.getUserPcode() + ":ContractAppraise";
        String hasPayEd = SupDisUtil.getRemot((String)payed);
        if (StringUtils.isNotBlank((String)hasPayEd)) {
            return new HtmlJsonReBean(CODE + ".paymentCommit", "\u8ba2\u5355\u652f\u4ed8\u4e2d,\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
        }
        String hasPay = SupDisUtil.getRemot((String)("order:" + contractBillcode + ":pay"));
        log.info("\u83b7\u53d6\u8ba2\u5355" + contractBillcode + "\u4e0a\u6b21\u53d1\u8d77\u652f\u4ed8\u7684\u65f6\u95f4:{}", (Object)hasPay);
        if (!StringUtils.isBlank((String)hasPay)) {
            return new HtmlJsonReBean(CODE + ".paymentCommit", "\u8bf7\u52ff\u9891\u7e41\u652f\u4ed8");
        }
        String ddFlag = this.getDdFlag(tenantCode, "paymentCommitFlag", "paymentCommitCode");
        if (!StringUtils.isBlank((String)ddFlag)) {
            log.info("\u8bb0\u5f55\u8ba2\u5355" + contractBillcode + "\u53d1\u8d77\u652f\u4ed8\u7684\u65f6\u95f4:{}", (Object)ddFlag);
            SupDisUtil.set((String)("order:" + contractBillcode + ":pay"), (String)"1", (int)Integer.parseInt(ddFlag));
        }
        ArrayList<PtePtradeParticipantDomain> ptradeParticipantList = new ArrayList<PtePtradeParticipantDomain>();
        String fchannelMode = "0";
        boolean flag = true;
        BigDecimal orderMount = BigDecimal.ZERO;
        ArrayList<OcContractSettlDomain> settllist = new ArrayList<OcContractSettlDomain>();
        this.logger.error("payCommitList=========", (Object)payCommitList);
        for (PayCommit payCommit : payCommitList) {
            if (null == payCommit.getOrderAmount()) {
                payCommit.setOrderAmount(BigDecimal.ZERO);
            }
            if (BigDecimal.ZERO.compareTo(payCommit.getOrderAmount()) == 0) continue;
            orderMount = orderMount.add(payCommit.getOrderAmount());
            PtePtfchannelReDomain ptePtfchannelReDomain = channelMap.get(payCommit.getFchannelCode());
            this.logger.error("payCommit.getFchannelCode()=========", (Object)payCommit.getFchannelCode());
            if (null == ptePtfchannelReDomain) {
                log.error("===========ptePtfchannelReDomain,\u6570\u636e\u4e3a\u7a7a");
                return new HtmlJsonReBean(CODE + ".paymentCommit.ptePtfchannelReDomain", "\u6570\u636e\u4e3a\u7a7a");
            }
            PtePtradeParticipantDomain ptePtradeParticipantDomain = new PtePtradeParticipantDomain();
            try {
                String balance;
                BeanUtils.copyAllPropertys((Object)ptePtradeParticipantDomain, (Object)ptePtfchannelReDomain);
                BeanUtils.copyAllPropertys((Object)ptePtradeParticipantDomain, (Object)payCommit);
                ptePtradeParticipantDomain.setFchannelClassifyCode(ptePtfchannelReDomain.getFchannelType());
                ptePtradeParticipantDomain.setPtePtradeType("0");
                fchannelMode = ptePtfchannelReDomain.getFchannelModel();
                if ("BUY_B".equals(ptePtfchannelReDomain.getDicActorCode())) {
                    if (StringUtils.isBlank((String)payCommit.getFaccountId())) {
                        log.error("===========getFaccountId,\u8d26\u6237\u4fe1\u606f\u4e3a\u7a7a");
                        return new HtmlJsonReBean(CODE + ".paymentCommit.getFaccountId", "\u8d26\u6237\u4fe1\u606f\u4e3a\u7a7a");
                    }
                    if (StringUtils.isNotBlank((String)ptePtfchannelReDomain.getFundIntype())) {
                        ptePtradeParticipantDomain.setFundType(ptePtfchannelReDomain.getFundIntype());
                    }
                    ptePtradeParticipantDomain.setOpuserCode(userSession.getUserPcode());
                    balance = "VD";
                } else {
                    balance = "CAS";
                }
                settllist.add(this.make(payCommit, balance, ptradeSeqno));
            }
            catch (Exception e) {
                this.logger.error(CODE + ".paymentCommit.e", (Throwable)e);
                return new HtmlJsonReBean(CODE + ".paymentCommit.e", "\u6570\u636e\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)ptePtfchannelReDomain.getPtfchannelAmt())) {
                ptePtfchannelReDomain.setPtfchannelAmt("0");
            }
            if ("BANK".equals(ptePtfchannelReDomain.getDicActorCode()) && BigDecimal.ZERO.compareTo(payCommit.getOrderAmount()) == -1 && "0".equals(ptePtfchannelReDomain.getPtfchannelAmt())) {
                flag = false;
            }
            ptradeParticipantList.add(ptePtradeParticipantDomain);
        }
        if (ListUtil.isEmpty(ptradeParticipantList)) {
            return new HtmlJsonReBean(CODE + ".paymentCommit.ptradeParticipantList", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (flag) {
            if (StringUtils.isBlank((String)paywd)) {
                return new HtmlJsonReBean(CODE + ".paymentCommit.paywd", "\u5bc6\u7801\u4e3a\u7a7a");
            }
            Map map = this.userServiceRepository.queryCheckPaywd(userSession.getUserCode(), tenantCode, paywd, this.getProappCode(request));
            if (null == map || !((Boolean)map.get("flag")).booleanValue()) {
                String msg = null == map ? "\u5bc6\u7801\u4e0d\u6b63\u786e" : (String)map.get("message");
                return new HtmlJsonReBean(CODE + ".paymentCommit.paywd", msg);
            }
        }
        if (null != ptePtradeReDomain && null != ptePtradeReDomain.getOrderOamount() && ptePtradeReDomain.getOrderOamount().compareTo(orderMount) != 0) {
            return new HtmlJsonReBean(CODE + ".paymentCommit.mount", "\u91d1\u989d\u4e0d\u4e00\u81f4");
        }
        this.saveSettlList(settllist, ptePtradeReDomain.getBusinessOrderno(), tenantCode, ptePtradeReDomain, contractBlance);
        PtradeBean ptradeBean = new PtradeBean();
        ptradeBean.setPtradeSeqno(ptradeSeqno);
        ptradeBean.setPartList(ptradeParticipantList);
        ptradeBean.setTenantCode(tenantCode);
        ptradeBean.setFchannelMode(fchannelMode);
        BankHtmlForm bankHtmlForm = this.ptePtradeServiceRepository.sendParticipantByPtrade(ptradeBean);
        if (null != bankHtmlForm) {
            bankHtmlForm.setBusinessOrder(ptePtradeReDomain.getBusinessOrder());
        }
        return new HtmlJsonReBean((Object)bankHtmlForm);
    }

    @RequestMapping(value={"subPaymentCommit.json"}, name="\u652f\u4ed8\u786e\u8ba4")
    @ResponseBody
    public HtmlJsonReBean subPaymentCommit(HttpServletRequest request, HttpServletResponse response, String payCommitStr, String ptradeSeqno, String paywd, String contractBlance, String smsCode) {
        BigDecimal orderAmount;
        log.info("=================================   \u5c0f\u7a0b\u5e8f\u8c03\u7528\u652f\u4ed8\u63a5\u53e3  ======================================================");
        long start = System.nanoTime();
        if (StringUtils.isBlank((String)ptradeSeqno) || StringUtils.isBlank((String)payCommitStr)) {
            this.logger.error(CODE + ".paymentCommit.param", (Object)"param is null");
            return new HtmlJsonReBean(CODE + ".paymentCommit.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        String oauthEnvCode = this.getOauthEnvCode(request);
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            this.logger.error(CODE + ".paymentCommit.oauthEnvCode", (Object)"oauthEnvCode is null");
            return new HtmlJsonReBean(CODE + ".paymentCommit.oauthEnvCode", "\u6570\u636e\u4e3a\u7a7a");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".paymentCommit.userSession", (Object)"userSession is null");
            return new HtmlJsonReBean(CODE + ".paymentCommit.userSession", "\u6570\u636e\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> mp = new HashMap<String, String>();
        mp.put("ptradeSeqno", ptradeSeqno);
        mp.put("tenantCode", tenantCode);
        SupQueryResult order = this.ocContractSubServiceRepository.queryContractSubPage(mp);
        if (null == order || order.getList().size() == 0) {
            this.logger.error("========================\u6839\u636eptradeSeqno:" + ptradeSeqno + "\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u8ba2\u5355");
            return new HtmlJsonReBean(CODE + ".paymentCommit.order", "\u672a\u5339\u914d\u5230ptradeSeqno\u76f8\u5173\u7684\u8ba2\u5355");
        }
        List payCommitList = (List)JsonUtil.buildNormalBinder().getJsonToList(payCommitStr, PayCommit.class);
        if (null == payCommitList || payCommitList.isEmpty()) {
            this.logger.error("=========payCommitList is empty");
            return null;
        }
        this.logger.error("payCommitStr=========", (Object)payCommitStr);
        this.logger.error("ptradeSeqno=========", (Object)ptradeSeqno);
        this.logger.error("contractBlance=========", (Object)contractBlance);
        this.logger.error("paywd=========", (Object)paywd);
        HashMap<String, String> ptemap = new HashMap<String, String>();
        ptemap.put("ptradeSeqno", ptradeSeqno);
        ptemap.put("tenantCode", tenantCode);
        PtePtradeReDomain ptePtradeReDomain = this.ptePtradeServiceRepository.getPtradeByCode(ptemap);
        this.logger.error(CODE + ".paymentCommit.ptePtradeReDomain", (Object)JSONUtil.toJsonStr((Object)ptePtradeReDomain));
        if (null == ptePtradeReDomain) {
            this.logger.error(CODE + ".paymentCommit.ptePtradeReDomain", (Object)((Object)ptemap).toString());
            return new HtmlJsonReBean(CODE + ".paymentCommit.ptePtradeReDomain", "\u652f\u4ed8\u6d41\u6c34\u4e00\u6b21");
        }
        String userPcode = userSession.getUserPcode();
        if (!userPcode.equals(ptePtradeReDomain.getOpuserCode())) {
            this.logger.error(CODE + ".paymentCommit.ptePtradeReDomain.userPcode", (Object)((Object)ptemap).toString());
            return new HtmlJsonReBean(CODE + ".paymentCommit.ptePtradeReDomain", "\u4e0d\u662f\u5f53\u524d\u767b\u5f55\u7528\u6237");
        }
        Map<String, PtePtfchannelReDomain> channelMap = this.payServiceRepository.queryChannel(oauthEnvCode, tenantCode, "PAY", userSession, this.getTginfoCode(request), this.getNowChannel(request), this.getProappCode(request));
        this.logger.error(CODE + "channelMap====================", (Object)JsonUtil.buildNormalBinder().toJson(channelMap));
        if (null == channelMap || channelMap.isEmpty()) {
            log.error("\u83b7\u53d6\u4ea4\u6613\u6e20\u9053\u5931\u8d25:{}", channelMap);
            return null;
        }
        String contractBillcode = ((OcContractSubReDomain)order.getList().get(0)).getContractBillcode();
        String payed = contractBillcode + ":" + userSession.getUserPcode() + ":ContractAppraise";
        String hasPayEd = SupDisUtil.getRemot((String)payed);
        if (StringUtils.isNotBlank((String)hasPayEd)) {
            return new HtmlJsonReBean(CODE + ".paymentCommit", "\u8ba2\u5355\u652f\u4ed8\u4e2d,\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
        }
        String hasPay = SupDisUtil.getRemot((String)("order:" + contractBillcode + ":pay"));
        log.info("\u83b7\u53d6\u8ba2\u5355" + contractBillcode + "\u4e0a\u6b21\u53d1\u8d77\u652f\u4ed8\u7684\u65f6\u95f4:{}", (Object)hasPay);
        if (!StringUtils.isBlank((String)hasPay)) {
            return new HtmlJsonReBean(CODE + ".paymentCommit", "\u8bf7\u52ff\u9891\u7e41\u652f\u4ed8");
        }
        String ddFlag = this.getDdFlag(tenantCode, "paymentCommitFlag", "paymentCommitCode");
        if (!StringUtils.isBlank((String)ddFlag)) {
            log.info("\u8bb0\u5f55\u8ba2\u5355" + contractBillcode + "\u53d1\u8d77\u652f\u4ed8\u7684\u65f6\u95f4:{}", (Object)ddFlag);
            SupDisUtil.set((String)("order:" + contractBillcode + ":pay"), (String)"1", (int)Integer.parseInt(ddFlag));
        }
        if ((orderAmount = ((PayCommit)payCommitList.get(0)).getOrderAmount()).compareTo(((OcContractSubReDomain)order.getList().get(0)).getContractSubGmoney()) != 0) {
            log.info("\u5b50\u8ba2\u5355" + contractBillcode + "\u652f\u4ed8\u91d1\u989d\u4e0d\u4e00\u81f4,\u8bf7\u68c0\u67e5:{}", (Object)orderAmount);
            return new HtmlJsonReBean(CODE + ".paymentCommit", "\u652f\u4ed8\u91d1\u989d\u4e0d\u4e00\u81f4,\u8bf7\u68c0\u67e5\uff01");
        }
        ArrayList<PtePtradeParticipantDomain> ptradeParticipantList = new ArrayList<PtePtradeParticipantDomain>();
        String fchannelMode = "0";
        boolean flag = true;
        BigDecimal orderMount = BigDecimal.ZERO;
        ArrayList<OcContractSettlDomain> settllist = new ArrayList<OcContractSettlDomain>();
        this.logger.info("payCommitList=========", (Object)payCommitList);
        long forStart = System.nanoTime();
        for (PayCommit payCommit : payCommitList) {
            if (null == payCommit.getOrderAmount()) {
                payCommit.setOrderAmount(BigDecimal.ZERO);
            }
            if (BigDecimal.ZERO.compareTo(payCommit.getOrderAmount()) == 0) continue;
            orderMount = orderMount.add(payCommit.getOrderAmount());
            PtePtfchannelReDomain ptePtfchannelReDomain = channelMap.get(payCommit.getFchannelCode());
            this.logger.error("payCommit.getFchannelCode()=========", (Object)payCommit.getFchannelCode());
            if (null == ptePtfchannelReDomain) {
                log.error("===========ptePtfchannelReDomain,\u6570\u636e\u4e3a\u7a7a");
                return new HtmlJsonReBean(CODE + ".paymentCommit.ptePtfchannelReDomain", "\u6570\u636e\u4e3a\u7a7a");
            }
            PtePtradeParticipantDomain ptePtradeParticipantDomain = new PtePtradeParticipantDomain();
            try {
                String balance;
                BeanUtils.copyAllPropertys((Object)ptePtradeParticipantDomain, (Object)ptePtfchannelReDomain);
                BeanUtils.copyAllPropertys((Object)ptePtradeParticipantDomain, (Object)payCommit);
                ptePtradeParticipantDomain.setFchannelClassifyCode(ptePtfchannelReDomain.getFchannelType());
                ptePtradeParticipantDomain.setPtePtradeType("0");
                fchannelMode = ptePtfchannelReDomain.getFchannelModel();
                if ("BUY_B".equals(ptePtfchannelReDomain.getDicActorCode())) {
                    if (StringUtils.isBlank((String)payCommit.getFaccountId())) {
                        log.error("===========getFaccountId,\u8d26\u6237\u4fe1\u606f\u4e3a\u7a7a");
                        return new HtmlJsonReBean(CODE + ".paymentCommit.getFaccountId", "\u8d26\u6237\u4fe1\u606f\u4e3a\u7a7a");
                    }
                    if (StringUtils.isNotBlank((String)ptePtfchannelReDomain.getFundIntype())) {
                        ptePtradeParticipantDomain.setFundType(ptePtfchannelReDomain.getFundIntype());
                    }
                    ptePtradeParticipantDomain.setOpuserCode(userSession.getUserPcode());
                    balance = "VD";
                } else {
                    balance = "CAS";
                }
                settllist.add(this.make(payCommit, balance, ptradeSeqno));
            }
            catch (Exception e) {
                this.logger.error(CODE + ".paymentCommit.e", (Throwable)e);
                return new HtmlJsonReBean(CODE + ".paymentCommit.e", "\u6570\u636e\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)ptePtfchannelReDomain.getPtfchannelAmt())) {
                ptePtfchannelReDomain.setPtfchannelAmt("0");
            }
            if ("BANK".equals(ptePtfchannelReDomain.getDicActorCode()) && BigDecimal.ZERO.compareTo(payCommit.getOrderAmount()) == -1 && "0".equals(ptePtfchannelReDomain.getPtfchannelAmt())) {
                flag = false;
            }
            ptradeParticipantList.add(ptePtradeParticipantDomain);
        }
        long forEnd = (System.nanoTime() - forStart) / 1000000L;
        if (ListUtil.isEmpty(ptradeParticipantList)) {
            return new HtmlJsonReBean(CODE + ".paymentCommit.ptradeParticipantList", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (flag) {
            if (StringUtils.isBlank((String)paywd)) {
                return new HtmlJsonReBean(CODE + ".paymentCommit.paywd", "\u5bc6\u7801\u4e3a\u7a7a");
            }
            Map map = this.userServiceRepository.queryCheckPaywd(userSession.getUserCode(), tenantCode, paywd, this.getProappCode(request));
            if (null == map || !((Boolean)map.get("flag")).booleanValue()) {
                String msg = null == map ? "\u5bc6\u7801\u4e0d\u6b63\u786e" : (String)map.get("message");
                return new HtmlJsonReBean(CODE + ".paymentCommit.paywd", msg);
            }
        }
        if (null != ptePtradeReDomain && null != ptePtradeReDomain.getOrderOamount() && ptePtradeReDomain.getOrderOamount().compareTo(orderMount) != 0) {
            return new HtmlJsonReBean(CODE + ".paymentCommit.mount", "\u91d1\u989d\u4e0d\u4e00\u81f4");
        }
        long startsaveSettlList = System.nanoTime();
        this.saveSettlList(settllist, ptePtradeReDomain.getBusinessOrderno(), tenantCode, ptePtradeReDomain, contractBlance);
        long endsaveSettlList = (System.nanoTime() - startsaveSettlList) / 1000000L;
        PtradeBean ptradeBean = new PtradeBean();
        ptradeBean.setPtradeSeqno(ptradeSeqno);
        ptradeBean.setPartList(ptradeParticipantList);
        ptradeBean.setTenantCode(tenantCode);
        ptradeBean.setFchannelMode(fchannelMode);
        long bankHtmlFormStart = System.nanoTime();
        BankHtmlForm bankHtmlForm = this.ptePtradeServiceRepository.sendParticipantByPtrade(ptradeBean);
        long endbankHtmlForm = (System.nanoTime() - bankHtmlFormStart) / 1000000L;
        if (null != bankHtmlForm) {
            bankHtmlForm.setBusinessOrder(ptePtradeReDomain.getBusinessOrder());
        }
        long end = (System.nanoTime() - start) / 1000000L;
        log.info(" ptePtradeServiceRepository \u63a5\u53e3\u82b1\u8d39\u65f6\u95f4 \uff1a {}", (Object)endbankHtmlForm);
        log.info(" endsaveSettlList \u63a5\u53e3\u82b1\u8d39\u65f6\u95f4 \uff1a {}", (Object)endsaveSettlList);
        log.info(" forEnd \u63a5\u53e3\u82b1\u8d39\u65f6\u95f4 \uff1a {}", (Object)forEnd);
        this.logger.info(" \u63a5\u53e3\u603b\u65f6\u95f4 {} ms", (Object)end);
        log.info("==  \u8fd4\u56de\u7ed9\u5c0f\u7a0b\u5e8f\u7ed3\u679c  ==" + JSONObject.toJSONString((Object)bankHtmlForm));
        log.info("====================================================================================================================");
        return new HtmlJsonReBean((Object)bankHtmlForm);
    }

    private String getDdFlag(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            this.logger.error(CODE + ".getUrl", (Object)("tenantCode:" + tenantCode + "-flagSettingType:" + flagSettingType + "-flagSettingCode:" + flagSettingCode));
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        if (StringUtils.isBlank((String)value)) {
            this.logger.error(CODE + ".getUrl", (Object)("tenantCode:" + tenantCode + "-flagSettingType:" + flagSettingType + "-flagSettingCode:" + flagSettingCode));
        }
        return value;
    }

    @RequestMapping(value={"getTradeState.json"}, name="\u83b7\u53d6\u652f\u4ed8\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean getTradeState(HttpServletRequest request, HttpServletResponse response, String ptradeSeqno) {
        GateWayService gateWayService = new GateWayService();
        if (StringUtils.isBlank((String)ptradeSeqno)) {
            return new HtmlJsonReBean(JsonReBean.ERRORCODE, "out_trade_no\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ptradeSeqno", ptradeSeqno);
        PtePtradeReDomain ptePtradeReDomain = this.ptePtradeServiceRepository.getPtradeByCode(map);
        if (ptePtradeReDomain == null) {
            return new HtmlJsonReBean(JsonReBean.ERRORCODE, "\u4ea4\u6613\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (ptePtradeReDomain.getDataState() == 2) {
            return new HtmlJsonReBean((Object)2);
        }
        if (ptePtradeReDomain.getDataState() == 0) {
            return new HtmlJsonReBean((Object)0);
        }
        String trade_state = null;
        for (int i = 0; i < 3; ++i) {
            try {
                Map<String, String> result = gateWayService.query(ptradeSeqno);
                trade_state = result.get("trade_state");
                if (!"NOTPAY".equals(trade_state)) break;
                Thread.sleep(1000L);
                continue;
            }
            catch (Throwable e) {
                this.logger.error(e);
            }
        }
        if ("SUCCESS".equals(trade_state)) {
            return new HtmlJsonReBean((Object)2);
        }
        if ("NOTPAY".equals(trade_state)) {
            return new HtmlJsonReBean((Object)1);
        }
        return new HtmlJsonReBean((Object)0);
    }

    public static void main(String[] args) {
        PayCon payCon = new PayCon();
        HtmlJsonReBean htmlJsonReBean = payCon.getTradeState(null, null, "20210612000000001");
        System.out.printf(JSON.toJSONString((Object)htmlJsonReBean), new Object[0]);
    }

    @RequestMapping(value={"wftPayNotify.json"}, name="\u652f\u4ed8\u56de\u8c03")
    @ResponseBody
    public String wftPayNotify(HttpServletRequest request, HttpServletResponse response) {
        try {
            log.info("\u6536\u5230\u901a\u77e5...");
            request.setCharacterEncoding("utf-8");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-type", "text/html;charset=UTF-8");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            String FEATURE = null;
            try {
                FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
                dbf.setFeature(FEATURE, true);
                FEATURE = "http://xml.org/sax/features/external-general-entities";
                dbf.setFeature(FEATURE, false);
                FEATURE = "http://xml.org/sax/features/external-parameter-entities";
                dbf.setFeature(FEATURE, false);
                FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
                dbf.setFeature(FEATURE, false);
                dbf.setXIncludeAware(false);
                dbf.setExpandEntityReferences(false);
            }
            catch (Throwable e) {
                log.error("ParserConfigurationException was thrown. The feature " + FEATURE + "is probably not supported by your XML processor.");
            }
            String resString = XmlUtils.parseRequst(request);
            log.info("\u8bf7\u6c42\u7684\u5185\u5bb9\uff1a" + resString);
            String respString = "error";
            if (resString != null && !"".equals(resString)) {
                Map<String, String> map = XmlUtils.toMap(resString.getBytes(), "utf-8");
                String res = XmlUtils.toXml(map);
                String sign_type = map.get("sign_type");
                String reSign = map.get("sign");
                log.info("\u8bf7\u6c42\u7ed3\u679c{}", (Object)res);
                if (map.containsKey("sign")) {
                    if (!SignUtil.verifySign(reSign, sign_type, map)) {
                        res = "\u9a8c\u8bc1\u7b7e\u540d\u4e0d\u901a\u8fc7";
                        respString = "error";
                    } else {
                        String result_code;
                        String status = map.get("status");
                        if (status != null && "0".equals(status) && (result_code = map.get("result_code")) != null && "0".equals(result_code)) {
                            respString = "success";
                            String out_trade_no = map.get("out_trade_no");
                            log.info("\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0cout_trade_no:{}", (Object)out_trade_no);
                        }
                    }
                }
            }
            return respString;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
            return null;
        }
    }

    private void saveSettlList(final List<OcContractSettlDomain> settllist, final String contractBillcode, final String tenantCode, final PtePtradeReDomain ptePtradeReDomain, final String contractBlance) {
        pool.execute(new Runnable(){

            @Override
            public void run() {
                if ("2".equals(contractBlance) || "3".equals(contractBlance)) {
                    ArrayList<OcContractSublistDomain> ocContractSublistDomainList = new ArrayList<OcContractSublistDomain>();
                    OcContractSubReDomain ocContractSubReDomain = PayCon.this.payServiceRepository.getContractSub(tenantCode, contractBillcode);
                    if (null == ocContractSubReDomain) {
                        return;
                    }
                    for (OcContractSettlDomain ocContractSettlDomain : settllist) {
                        OcContractSublistDomain ocContractSublistDomain = new OcContractSublistDomain();
                        ocContractSublistDomain.setContractSublistGmoney(ocContractSettlDomain.getContractSettlGmoney());
                        ocContractSublistDomain.setContractSublistPmoney(ocContractSettlDomain.getContractSettlPmoney());
                        ocContractSublistDomain.setContractSublistOpemo(ocContractSettlDomain.getContractSettlOpemo());
                        ocContractSublistDomain.setContractSublistOpno(ocContractSettlDomain.getContractSettlOpno());
                        ocContractSublistDomain.setTenantCode(tenantCode);
                        ocContractSublistDomain.setContractBillcode(contractBillcode);
                        ocContractSublistDomain.setMemberName(ocContractSubReDomain.getMemberName());
                        ocContractSublistDomain.setMemberCode(ocContractSubReDomain.getMemberCode());
                        ocContractSublistDomain.setAppmanageIcode(ocContractSubReDomain.getAppmanageIcode());
                        ocContractSublistDomain.setContractSubCode(ocContractSubReDomain.getContractSubCode());
                        ocContractSublistDomainList.add(ocContractSublistDomain);
                    }
                    PayCon.this.payServiceRepository.saveContractSublistBatch(ocContractSublistDomainList);
                } else {
                    ArrayList<OcContractSettlDomain> newSettllist = new ArrayList<OcContractSettlDomain>();
                    if (ListUtil.isNotEmpty((Collection)settllist)) {
                        newSettllist.addAll(settllist);
                    }
                    Map<String, OcContractSettlDomain> settlmap = PayCon.this.payServiceRepository.queryContractSettl(contractBillcode, tenantCode);
                    for (OcContractSettlDomain ocContractSettlDomain : newSettllist) {
                        OcContractSettlDomain oldOcContractSettlDomain;
                        ocContractSettlDomain.setTenantCode(tenantCode);
                        ocContractSettlDomain.setContractBillcode(contractBillcode);
                        ocContractSettlDomain.setMemberBcode(ptePtradeReDomain.getOpuserCode());
                        ocContractSettlDomain.setMemberBname(ptePtradeReDomain.getOpuserName());
                        ocContractSettlDomain.setMemberCode(ptePtradeReDomain.getMerchantCode());
                        if (null == settlmap || settlmap.isEmpty() || null == (oldOcContractSettlDomain = settlmap.get(ocContractSettlDomain.getContractSettlBlance()))) continue;
                        ocContractSettlDomain.setContractSettlId(oldOcContractSettlDomain.getContractSettlId());
                        ocContractSettlDomain.setAppmanageIcode(oldOcContractSettlDomain.getAppmanageIcode());
                        ocContractSettlDomain.setContractSettlBillcode(oldOcContractSettlDomain.getContractSettlBillcode());
                    }
                    PayCon.this.payServiceRepository.saveContractSettlBatch(newSettllist);
                }
            }
        });
    }

    private OcContractSettlDomain make(PayCommit payCommit, String balance, String ptradeSeqno) {
        if (null == payCommit) {
            return null;
        }
        OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
        ocContractSettlDomain.setContractSettlBlance(balance);
        ocContractSettlDomain.setContractSettlType("0");
        ocContractSettlDomain.setContractPmode("0");
        ocContractSettlDomain.setContractSettlGmoney(payCommit.getOrderAmount());
        ocContractSettlDomain.setContractSettlPmoney(payCommit.getOrderAmount());
        ocContractSettlDomain.setContractSettlOpno(ptradeSeqno);
        ocContractSettlDomain.setContractSettlOpemo(payCommit.getFchannelCode() + (StringUtils.isNotBlank((String)payCommit.getFchannelName()) ? "(" + payCommit.getFchannelName() + ")" : ""));
        return ocContractSettlDomain;
    }

    @ResponseBody
    @RequestMapping(value={"mockQjNotify.json"}, name="\u652f\u4ed8mock\uff08\u5343\u5320\u652f\u4ed8\uff09\u5f02\u6b65\u901a\u77e5\u652f\u4ed8\u7ed3\u679c")
    public String mockQjNotify(HttpServletRequest request) {
        String result;
        Map map = this.getQueryMapParams(request);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("trade_status", map.get("trade_status").toString());
        params.put("trade_no", map.get("trade_no").toString());
        params.put("out_trade_no", map.get("out_trade_no").toString());
        params.put("tenantCode", map.get("tenantCode").toString());
        params.put("exterface", "trade_status_sync");
        String notifyUrl = (String)map.get("notify_url");
        try {
            result = WebUtils.doPost((String)notifyUrl, params, (int)100000, (int)100000);
        }
        catch (IOException e) {
            this.logger.error(CODE + ".mockQjNotify.ex", (Throwable)e);
            return "\u53d1\u9001\u5931\u8d25";
        }
        if ("null".equals(result)) {
            return "ok";
        }
        this.logger.info(CODE + ".mockQjNotify.post.failure", (Object)result);
        return result;
    }

    public WxPayApiConfig getApiConfig() {
        WxPayApiConfig apiConfig = WxPayApiConfig.builder().appId("wx9235763e5f3b180c").mchId("1526464211").partnerKey("e4ulflENkUqOKieCn3Qqq88NkGLP0X1P").domain("https://devmpb2b12020063000000001.xytest.qjclouds.com/web/pte/pay/payNotifyNew.json").build();
        return apiConfig;
    }

    @RequestMapping(value={"homePayNew.json"}, name="\u5c0f\u7a0b\u5e8f\u652f\u4ed8")
    @ResponseBody
    public AjaxResult miniAppPay(HttpServletRequest request) {
        HashMap<String, String> mapMSG = new HashMap<String, String>();
        String openId = (String)request.getSession().getAttribute("openId");
        String ip = IpKit.getRealIp((HttpServletRequest)request);
        if (StringUtils.isBlank((String)ip)) {
            ip = "127.0.0.1";
        }
        String out_trade_no = "";
        HashMap<String, Integer> mapJson = new HashMap<String, Integer>();
        Date data = new Date();
        out_trade_no = "SH" + DateUtil.dateFormatSSS.format(data);
        Integer orderId = this.DateToTimestamp(data);
        mapJson.put("orderId", orderId);
        WxPayApiConfig wxPayApiConfig = WxPayApiConfigKit.getWxPayApiConfig();
        String pastJson = JSONObject.toJSONString(mapJson);
        mapMSG.put(out_trade_no, pastJson);
        Map params = UnifiedOrderModel.builder().appid(wxPayApiConfig.getAppId()).mch_id("1526464211").nonce_str(WxPayKit.generateStr()).body("\u652f\u4ed8\u8bb0\u5f55").out_trade_no(out_trade_no).total_fee("100").spbill_create_ip(ip).notify_url("/web/pte/wxPay/payNotify.json").trade_type(TradeType.JSAPI.getTradeType()).openid(openId).build().createSign(wxPayApiConfig.getPartnerKey(), SignType.MD5);
        String xmlResult = WxPayApi.pushOrder((boolean)false, (Map)params);
        this.logger.error(xmlResult);
        Map result = WxPayKit.xmlToMap((String)xmlResult);
        String returnCode = (String)result.get("return_code");
        String returnMsg = (String)result.get("return_msg");
        if (!WxPayKit.codeIsOk((String)returnCode)) {
            return new AjaxResult().addError(returnMsg);
        }
        String resultCode = (String)result.get("result_code");
        if (!WxPayKit.codeIsOk((String)resultCode)) {
            return new AjaxResult().addError(returnMsg);
        }
        String prepayId = (String)result.get("prepay_id");
        Map packageParams = WxPayKit.miniAppPrepayIdCreateSign((String)wxPayApiConfig.getAppId(), (String)prepayId, (String)wxPayApiConfig.getPartnerKey(), (SignType)SignType.MD5);
        String jsonStr = JSON.toJSONString((Object)packageParams);
        this.logger.error("\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u7684\u53c2\u6570:" + jsonStr);
        return new AjaxResult().success(jsonStr);
    }

    @RequestMapping(value={"payNotifyNew.json"}, name="\u652f\u4ed8\u56de\u8c03")
    @ResponseBody
    public String payNotify(HttpServletRequest request) {
        HashMap mapMSG = new HashMap();
        String xmlMsg = HttpKit.readData((HttpServletRequest)request);
        this.logger.error("\u652f\u4ed8\u901a\u77e5=" + xmlMsg);
        Map params = WxPayKit.xmlToMap((String)xmlMsg);
        String returnCode = (String)params.get("return_code");
        if (WxPayKit.verifyNotify((Map)params, (String)this.getApiConfig().getPartnerKey(), (SignType)SignType.MD5) && WxPayKit.codeIsOk((String)returnCode)) {
            String out_trade_no = (String)params.get("out_trade_no");
            mapMSG.remove(out_trade_no);
            this.logger.error("\u652f\u4ed8\u56de\u8c03\u6210\u529f");
            HashMap<String, String> xml = new HashMap<String, String>(2);
            xml.put("return_code", "SUCCESS");
            xml.put("return_msg", "OK");
            return WxPayKit.toXml(xml);
        }
        return null;
    }

    public Integer DateToTimestamp(Date time) {
        Timestamp ts = new Timestamp(time.getTime());
        return (int)(ts.getTime() / 1000L);
    }
}

