/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pfs.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.pfs.domain.PfsMmodelDomain;
import com.qjsoft.laser.controller.facade.pfs.domain.PfsMmodelReDomain;
import com.qjsoft.laser.controller.facade.pfs.domain.PfsModelTagDomain;
import com.qjsoft.laser.controller.facade.pfs.repository.PfsMmodelServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pfs/pfsmmodel"}, name="\u6a21\u677f")
public class PfsMmodelCon
extends SpringmvcController {
    private static String CODE = "pfs.pfsmmodel.con";
    @Autowired
    private PfsMmodelServiceRepository pfsMmodelServiceRepository;

    protected String getContext() {
        return "pfsmmodel";
    }

    @RequestMapping(value={"savePfsMmodel.json"}, name="\u589e\u52a0\u6a21\u677f")
    @ResponseBody
    public HtmlJsonReBean savePfsMmodel(HttpServletRequest request, PfsMmodelDomain pfsmmodelDomain) {
        if (null == pfsmmodelDomain) {
            this.logger.error(CODE + ".savePfsMmodel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pfsmmodelDomain.setTenantCode(this.getTenantCode(request));
        return this.pfsMmodelServiceRepository.saveMmodel(pfsmmodelDomain);
    }

    @RequestMapping(value={"getPfsMmodel.json"}, name="\u83b7\u53d6\u6a21\u677f\u4fe1\u606f")
    @ResponseBody
    public PfsMmodelReDomain getPfsMmodel(Integer mmodelId) {
        if (StringUtils.isBlank((Integer)mmodelId)) {
            this.logger.error(CODE + ".getPfsMmodel", (Object)"param is null");
            return null;
        }
        return this.pfsMmodelServiceRepository.getMmodel(mmodelId);
    }

    @RequestMapping(value={"updatePfsMmodel.json"}, name="\u66f4\u65b0\u6a21\u677f")
    @ResponseBody
    public HtmlJsonReBean updatePfsMmodel(HttpServletRequest request, PfsMmodelDomain pfsmmodelDomain) {
        if (null == pfsmmodelDomain) {
            this.logger.error(CODE + ".updatePfsMmodel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pfsmmodelDomain.setTenantCode(this.getTenantCode(request));
        return this.pfsMmodelServiceRepository.updateMmodel(pfsmmodelDomain);
    }

    @RequestMapping(value={"deletePfsMmodel.json"}, name="\u5220\u9664\u6a21\u677f")
    @ResponseBody
    public HtmlJsonReBean deletePfsMmodel(Integer mmodelId) {
        if (StringUtils.isBlank((Integer)mmodelId)) {
            this.logger.error(CODE + ".deletePfsMmodel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pfsMmodelServiceRepository.deleteMmodel(mmodelId);
    }

    @RequestMapping(value={"queryPfsMmodelPage.json"}, name="\u67e5\u8be2\u6a21\u677f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PfsMmodelReDomain> queryPfsMmodelPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pfsMmodelServiceRepository.queryMmodelPage(param);
    }

    @RequestMapping(value={"updatePfsMmodelState.json"}, name="\u66f4\u65b0\u6a21\u677f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePfsMmodelState(String mmodelId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)mmodelId)) {
            this.logger.error(CODE + ".updatePfsMmodelState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pfsMmodelServiceRepository.updateMmodelState(Integer.valueOf(mmodelId), dataState, oldDataState);
    }

    @RequestMapping(value={"saveModelTagList.json"}, name="\u65b0\u589e\u6a21\u677f")
    @ResponseBody
    public HtmlJsonReBean saveModelTagList(HttpServletRequest request, String pfsModelTagListStr) {
        if (StringUtils.isBlank((String)pfsModelTagListStr)) {
            this.logger.error(CODE + ".saveModelTagList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List pfsModelTagDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(pfsModelTagListStr, PfsModelTagDomain.class);
        for (PfsModelTagDomain pfsModelTagDomain : pfsModelTagDomainList) {
            pfsModelTagDomain.setTenantCode(this.getTenantCode(request));
        }
        return this.pfsMmodelServiceRepository.saveModelTagList(pfsModelTagDomainList);
    }

    @RequestMapping(value={"savePfsMmodelForPlate.json"}, name="\u589e\u52a0\u6a21\u677f\u7ed9\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean savePfsMmodelForPlate(HttpServletRequest request, PfsMmodelDomain pfsmmodelDomain) {
        if (null == pfsmmodelDomain) {
            this.logger.error(CODE + ".savePfsMmodelForPlate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pfsmmodelDomain.setTenantCode(this.getTenantCode(request));
        return this.pfsMmodelServiceRepository.saveMmodel(pfsmmodelDomain);
    }

    @RequestMapping(value={"getPfsMmodelForPlate.json"}, name="\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u7ed9\u5e73\u53f0")
    @ResponseBody
    public PfsMmodelReDomain getPfsMmodelForPlate(Integer mmodelId) {
        if (StringUtils.isBlank((Integer)mmodelId)) {
            this.logger.error(CODE + ".getPfsMmodelForPlate", (Object)"param is null");
            return null;
        }
        return this.pfsMmodelServiceRepository.getMmodel(mmodelId);
    }

    @RequestMapping(value={"updatePfsMmodelForPlate.json"}, name="\u66f4\u65b0\u6a21\u677f\u7ed9\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean updatePfsMmodelForPlate(HttpServletRequest request, PfsMmodelDomain pfsmmodelDomain) {
        if (null == pfsmmodelDomain) {
            this.logger.error(CODE + ".updatePfsMmodelForPlate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pfsmmodelDomain.setTenantCode(this.getTenantCode(request));
        return this.pfsMmodelServiceRepository.updateMmodel(pfsmmodelDomain);
    }

    @RequestMapping(value={"deletePfsMmodelForPlate.json"}, name="\u5220\u9664\u6a21\u677f\u7ed9\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean deletePfsMmodelForPlate(Integer mmodelId) {
        if (StringUtils.isBlank((Integer)mmodelId)) {
            this.logger.error(CODE + ".deletePfsMmodelForPlate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pfsMmodelServiceRepository.deleteMmodel(mmodelId);
    }

    @RequestMapping(value={"queryPfsMmodelPageForPlate.json"}, name="\u67e5\u8be2\u6a21\u677f\u5206\u9875\u5217\u8868\u7ed9\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<PfsMmodelReDomain> queryPfsMmodelPageForPlate(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pfsMmodelServiceRepository.queryMmodelPage(param);
    }

    @RequestMapping(value={"updatePfsMmodelStateForPlate.json"}, name="\u66f4\u65b0\u6a21\u677f\u72b6\u6001\u7ed9\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean updatePfsMmodelStateForPlate(String mmodelId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)mmodelId)) {
            this.logger.error(CODE + ".updatePfsMmodelStateForPlate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pfsMmodelServiceRepository.updateMmodelState(Integer.valueOf(mmodelId), dataState, oldDataState);
    }

    @RequestMapping(value={"saveModelTagListForPlate.json"}, name="\u65b0\u589e\u6a21\u677f\u7ed9\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean saveModelTagListForPlate(HttpServletRequest request, String pfsModelTagListStr) {
        if (StringUtils.isBlank((String)pfsModelTagListStr)) {
            this.logger.error(CODE + ".saveModelTagListForPlate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List pfsModelTagDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(pfsModelTagListStr, PfsModelTagDomain.class);
        for (PfsModelTagDomain pfsModelTagDomain : pfsModelTagDomainList) {
            pfsModelTagDomain.setTenantCode(this.getTenantCode(request));
        }
        return this.pfsMmodelServiceRepository.saveModelTagList(pfsModelTagDomainList);
    }
}

