/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pfs.controller;

import com.qjsoft.laser.controller.common.bean.DisChannel;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.cms.domain.CmsTginfoMenuDomain;
import com.qjsoft.laser.controller.facade.cms.domain.CmsTginfoMenuReDomain;
import com.qjsoft.laser.controller.facade.cms.domain.CmsTginfoReDomain;
import com.qjsoft.laser.controller.facade.cms.repository.CmsTginfoMenuServiceRepository;
import com.qjsoft.laser.controller.facade.cms.repository.CmsTginfoServiceRepository;
import com.qjsoft.laser.controller.facade.pfs.domain.PfsModelTagvalueDomain;
import com.qjsoft.laser.controller.facade.pfs.domain.PfsModelTagvalueReDomain;
import com.qjsoft.laser.controller.facade.pfs.repository.PfsModelTagvalueServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pfs/pfsmodeltagvalue"}, name="\u6a21\u677f\u6807\u7b7e\u6570\u636e\u96c6\u5408")
public class PfsModelTagValueCon
extends SpringmvcController {
    private static String CODE = "pfs.pfsmodeltagvalue.con";
    @Autowired
    private PfsModelTagvalueServiceRepository pfsModelTagvalueServiceRepository;
    @Autowired
    private CmsTginfoServiceRepository cmsTginfoServiceRepository;
    @Autowired
    private CmsTginfoMenuServiceRepository cmsTginfoMenuService;

    protected String getContext() {
        return "pfsmodeltagvalue";
    }

    @RequestMapping(value={"savePfsModelTagValue.json"}, name="\u589e\u52a0\u6a21\u677f\u6807\u7b7e\u6570\u636e\u96c6\u5408")
    @ResponseBody
    public HtmlJsonReBean savePfsModelTagValue(HttpServletRequest request, PfsModelTagvalueDomain pfsmodeltagvalueDomain) {
        if (null == pfsmodeltagvalueDomain) {
            this.logger.error(CODE + ".savePfsModelTagValue", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pfsmodeltagvalueDomain.setTenantCode(this.getTenantCode(request));
        return this.pfsModelTagvalueServiceRepository.saveModelTagvalue(pfsmodeltagvalueDomain);
    }

    @RequestMapping(value={"savePfsModelTagValueDomain.json"}, name="\u589e\u52a0\u6a21\u677f\u6807\u7b7e\u6570\u636e\u96c6\u5408")
    @ResponseBody
    public HtmlJsonReBean savePfsModelTagValueDomain(HttpServletRequest request, PfsModelTagvalueDomain pfsmodeltagvalueDomain) {
        HtmlJsonReBean htmlJsonReBean = this.pfsModelTagvalueServiceRepository.saveModelTagvalue(pfsmodeltagvalueDomain);
        if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", pfsmodeltagvalueDomain.getTenantCode());
            map.put("modelTagvalueCode", htmlJsonReBean.getDataObj());
            PfsModelTagvalueReDomain modelTagvalue = this.pfsModelTagvalueServiceRepository.getModelTagvalueByCode(map);
            htmlJsonReBean.setDataObj((Object)JsonUtil.buildNormalBinder().toJson((Object)modelTagvalue));
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updatePfsModelTagValueDomain.json"}, name="\u66f4\u65b0\u6a21\u677f\u6807\u7b7e\u6570\u636e\u96c6\u5408")
    @ResponseBody
    public HtmlJsonReBean updatePfsModelTagValueDomain(HttpServletRequest request, PfsModelTagvalueDomain pfsmodeltagvalueDomain) {
        if (null == pfsmodeltagvalueDomain || null == pfsmodeltagvalueDomain.getModelTagvalueId()) {
            this.logger.error(CODE + ".updatePfsModelTagValue", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = this.pfsModelTagvalueServiceRepository.updateModelTagvalue(pfsmodeltagvalueDomain);
        if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) {
            PfsModelTagvalueReDomain modelTagvalue = this.pfsModelTagvalueServiceRepository.getModelTagvalue(pfsmodeltagvalueDomain.getModelTagvalueId());
            htmlJsonReBean.setDataObj((Object)JsonUtil.buildNormalBinder().toJson((Object)modelTagvalue));
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getPfsModelTagValue.json"}, name="\u83b7\u53d6\u6a21\u677f\u6807\u7b7e\u6570\u636e\u96c6\u5408\u4fe1\u606f")
    @ResponseBody
    public PfsModelTagvalueReDomain getPfsModelTagValue(HttpServletRequest request, Integer modelTagvalueId) {
        if (StringUtils.isBlank((Integer)modelTagvalueId)) {
            this.logger.error(CODE + ".getPfsModelTagValue", (Object)"param is null");
            return null;
        }
        PfsModelTagvalueReDomain pfsModelTagvalueReDomain = this.pfsModelTagvalueServiceRepository.getModelTagvalue(modelTagvalueId);
        if (null == pfsModelTagvalueReDomain) {
            return new PfsModelTagvalueReDomain();
        }
        if (this.getTenantCode(request).equals(pfsModelTagvalueReDomain.getTenantCode())) {
            return pfsModelTagvalueReDomain;
        }
        return new PfsModelTagvalueReDomain();
    }

    @RequestMapping(value={"getPfsModelTagValueForMenuOpcode.json"}, name="\u83b7\u53d6\u6a21\u677f\u6807\u7b7e\u6570\u636e\u96c6\u5408\u4fe1\u606f")
    @ResponseBody
    public PfsModelTagvalueReDomain getPfsModelTagValueForMenuOpcode(HttpServletRequest request, Integer modelTagvalueId) {
        if (null != modelTagvalueId) {
            return this.pfsModelTagvalueServiceRepository.getModelTagvalue(modelTagvalueId);
        }
        String tenantCode = this.getTenantCode(request);
        String tginfoCode = this.getTginfoMenuCode(request, tenantCode);
        this.logger.error(CODE + ".getPfsModelTagValueForMenuOpcode.tginfoCode", (Object)tginfoCode);
        if (StringUtils.isNotBlank((String)tginfoCode)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", tenantCode);
            map.put("modelTagvalueSv1", tginfoCode);
            map.put("modelTagvalueSv", "index1");
            map.put("order", true);
            SupQueryResult supQueryResult = this.pfsModelTagvalueServiceRepository.queryModelTagvaluePage(map);
            if (null != supQueryResult && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
                return (PfsModelTagvalueReDomain)supQueryResult.getList().get(0);
            }
        }
        return new PfsModelTagvalueReDomain();
    }

    private String getTginfoMenuCode(HttpServletRequest request, String tenantCode) {
        String tginfoCode = "";
        String proappCode = this.getProappCode(request);
        if ("032".equals(proappCode)) {
            UserSession userSession = this.getUserSession(request);
            String companyCode = "";
            if (null != userSession) {
                String userinfoQuality = userSession.getUserinfoQuality();
                if ("buy".equals(userinfoQuality)) {
                    companyCode = userSession.getUserinfoParentCode();
                }
                if ("company".equals(userinfoQuality)) {
                    companyCode = userSession.getUserPcode();
                }
                HashMap<String, String> param = new HashMap<String, String>();
                if (StringUtils.isBlank((String)companyCode)) {
                    companyCode = this.getTeananMemberCode(request);
                }
                param.put("memberCode", companyCode);
                param.put("tenantCode", tenantCode);
                param.put("proappCode", "032");
                SupQueryResult cmsTginfoReDomainSupQueryResult = this.cmsTginfoServiceRepository.queryTginfoPage(param);
                if (ListUtil.isNotEmpty((Collection)cmsTginfoReDomainSupQueryResult.getList())) {
                    tginfoCode = ((CmsTginfoReDomain)cmsTginfoReDomainSupQueryResult.getList().get(0)).getTginfoCode();
                }
                if (StringUtils.isBlank((String)tginfoCode)) {
                    this.logger.error(CODE + "tginfoCode is null");
                    return null;
                }
            }
        } else {
            tginfoCode = this.getTginfoCode(request);
            if (StringUtils.isBlank((String)tginfoCode)) {
                this.logger.error(CODE + "tginfoMenuCode!032 is null");
                return null;
            }
        }
        return tginfoCode;
    }

    @RequestMapping(value={"updatePfsModelTagValue.json"}, name="\u66f4\u65b0\u6a21\u677f\u6807\u7b7e\u6570\u636e\u96c6\u5408")
    @ResponseBody
    public HtmlJsonReBean updatePfsModelTagValue(HttpServletRequest request, PfsModelTagvalueDomain pfsmodeltagvalueDomain) {
        if (null == pfsmodeltagvalueDomain) {
            this.logger.error(CODE + ".updatePfsModelTagValue", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pfsmodeltagvalueDomain.setTenantCode(this.getTenantCode(request));
        return this.pfsModelTagvalueServiceRepository.updateModelTagvalue(pfsmodeltagvalueDomain);
    }

    @RequestMapping(value={"deletePfsModelTagValue.json"}, name="\u5220\u9664\u6a21\u677f\u6807\u7b7e\u6570\u636e\u96c6\u5408")
    @ResponseBody
    public HtmlJsonReBean deletePfsModelTagValue(Integer modelTagvalueId) {
        if (StringUtils.isBlank((Integer)modelTagvalueId)) {
            this.logger.error(CODE + ".deletePfsModelTagValue", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pfsModelTagvalueServiceRepository.deleteModelTagvalue(modelTagvalueId);
    }

    @RequestMapping(value={"queryPfsModelTagValuePage.json"}, name="\u67e5\u8be2\u6a21\u677f\u6807\u7b7e\u6570\u636e\u96c6\u5408\u5206\u9875\u5217\u8868")
    @ResponseBody
    public PfsModelTagvalueReDomain queryPfsModelTagValuePage(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        String tenantCode = this.getTenantCode(request);
        if (null == userSession) {
            return null;
        }
        String companyCode = userSession.getCompanyCode();
        String channelCode = this.getTginfoChannel(request);
        String userinfoCode = "";
        if (StringUtils.isNotBlank((String)companyCode)) {
            userinfoCode = SupDisUtil.getMap((String)"OrgCompany-companyCode", (String)(companyCode + "-" + tenantCode));
        }
        if (StringUtils.isNotBlank((String)channelCode)) {
            channelCode = userSession.getUserinfoParentCode();
        }
        PfsModelTagvalueReDomain pfsModelTagvalueReDomain = (PfsModelTagvalueReDomain)SupDisUtil.getMapJson((String)"PfsModelTagvalue-member", (String)(channelCode + "-" + userinfoCode + "-" + tenantCode), PfsModelTagvalueReDomain.class);
        return pfsModelTagvalueReDomain;
    }

    @RequestMapping(value={"queryPfsModelTagValuePageWrite.json"}, name="\u67e5\u8be2\u6a21\u677f\u6807\u7b7e\u6570\u636e\u96c6\u5408\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PfsModelTagvalueReDomain> queryPfsModelTagValuePageWrite(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
        }
        String channelCode = this.getTginfoChannel(request);
        param.put("channelCode", channelCode);
        return this.pfsModelTagvalueServiceRepository.queryModelTagvaluePage(param);
    }

    @RequestMapping(value={"queryPfsModelTagValueList.json"}, name="\u67e5\u8be2\u6a21\u677f\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PfsModelTagvalueReDomain> queryPfsModelTagValueList(HttpServletRequest request) {
        Map param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pfsModelTagvalueServiceRepository.queryModelTagvaluePage(param);
    }

    @RequestMapping(value={"updatePfsModelTagValueState.json"}, name="\u66f4\u65b0\u6a21\u677f\u6807\u7b7e\u6570\u636e\u96c6\u5408\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePfsModelTagValueState(String modelTagvalueId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)modelTagvalueId)) {
            this.logger.error(CODE + ".updatePfsModelTagValueState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pfsModelTagvalueServiceRepository.updateModelTagvalueState(Integer.valueOf(modelTagvalueId), dataState, oldDataState);
    }

    @RequestMapping(value={"savePfsModelTagValueDomainTwo.json"}, name="\u589e\u52a0\u6a21\u677f\u6807\u7b7e\u6570\u636e\u96c6\u5408")
    @ResponseBody
    public HtmlJsonReBean savePfsModelTagValueDomainTwo(HttpServletRequest request, PfsModelTagvalueDomain pfsmodeltagvalueDomain, String tginfoMenuCode) {
        CmsTginfoMenuReDomain tginfoMenuByCode;
        HtmlJsonReBean htmlJsonReBean;
        DisChannel channelByMemRe = this.getChannelByMemRe(this.getUserSession(request).getUserPcode(), request);
        if (null != channelByMemRe) {
            pfsmodeltagvalueDomain.setChannelCode(channelByMemRe.getChannelCode());
            pfsmodeltagvalueDomain.setChannelName(channelByMemRe.getChannelName());
        }
        if (null != (htmlJsonReBean = this.pfsModelTagvalueServiceRepository.saveModelTagvalue(pfsmodeltagvalueDomain)) && htmlJsonReBean.isSuccess() && StringUtils.isNotBlank((String)tginfoMenuCode) && null != (tginfoMenuByCode = this.cmsTginfoMenuService.getTginfoMenuByCode(pfsmodeltagvalueDomain.getTenantCode(), tginfoMenuCode))) {
            tginfoMenuByCode.setMenuIndexCode((String)htmlJsonReBean.getDataObj());
            this.cmsTginfoMenuService.updateTginfoMenu((CmsTginfoMenuDomain)tginfoMenuByCode);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryTginfoMenuTreeForTginfo.json"}, name="\u67e5\u8be2\u7ad9\u70b9\u83dc\u5355\u6811\u5f62\u7ed9\u661f\u4e91")
    @ResponseBody
    public List<CmsTginfoMenuReDomain> queryTginfoMenuTreeForTginfo(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("orderStr", "TGINFO_MENU_ORDER ASC");
        }
        SupQueryResult result = this.cmsTginfoMenuService.queryTginfoMenuPage(param);
        List list = result.getList();
        ArrayList<CmsTginfoMenuReDomain> newList = new ArrayList<CmsTginfoMenuReDomain>();
        for (CmsTginfoMenuReDomain cmsTginfoMenuReDomain : result.getList()) {
            if (!this.makePfsModelTagvalueReDomain(cmsTginfoMenuReDomain)) continue;
            boolean mark = false;
            for (CmsTginfoMenuReDomain menuReDomain : list) {
                if ("-1".equals(cmsTginfoMenuReDomain.getTginfoMenuPcode()) || !cmsTginfoMenuReDomain.getTginfoMenuPcode().equals(menuReDomain.getTginfoMenuCode())) continue;
                mark = true;
                if (menuReDomain.getChildren() == null) {
                    menuReDomain.setChildren(new ArrayList());
                }
                menuReDomain.getChildren().add(cmsTginfoMenuReDomain);
                break;
            }
            if (mark) continue;
            newList.add(cmsTginfoMenuReDomain);
        }
        return newList;
    }

    private boolean makePfsModelTagvalueReDomain(CmsTginfoMenuReDomain menuReDomain) {
        PfsModelTagvalueReDomain pfsModelTagvalueReDomain;
        if (StringUtils.isNotBlank((String)menuReDomain.getMenuIndexCode()) && null != (pfsModelTagvalueReDomain = this.pfsModelTagvalueServiceRepository.getModelTagvalueByCode(this.getQueryMapParam("modelTagvalueCode,tenantCode", new Object[]{menuReDomain.getMenuIndexCode(), menuReDomain.getTenantCode()})))) {
            menuReDomain.setPfsModelTagvalueReDomain(pfsModelTagvalueReDomain);
            return true;
        }
        return false;
    }
}

