/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.promotion.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionCalcListDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDiscountDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDiscountlistDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionRangelistDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionReDomain;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsBrandReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsClasstreeReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsPntreeReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsBrandServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsClasstreeServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsPntreeServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pm/promotion"}, name="\u8425\u9500\u670d\u52a1")
public class PromotionCon
extends SpringmvcController {
    private static String CODE = "pm.promotion.con";
    @Autowired
    private PmPromotionServiceRepository pmPromotionServiceRepository;
    @Autowired
    private RsBrandServiceRepository rsBrandServiceRepository;
    @Autowired
    private RsPntreeServiceRepository rsPntreeServiceRepository;
    @Autowired
    private RsClasstreeServiceRepository rsClasstreeServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;

    protected String getContext() {
        return "promotion";
    }

    @RequestMapping(value={"savePromotion.json"}, name="\u589e\u52a0\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotion(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".savePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".savePromotion", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(userSession.getUserPcode());
        promotionDomain.setMemberName(userSession.getUserName());
        return this.pmPromotionServiceRepository.savePromotion(promotionDomain);
    }

    @RequestMapping(value={"getPromotion.json"}, name="\u83b7\u53d6\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotion(Integer promotionId) {
        List pmPromotionDiscountDomainList;
        List pmPromotionRangelistDomainList;
        if (StringUtils.isBlank((Integer)promotionId)) {
            this.logger.error(CODE + ".getPromotion", (Object)"param is null");
            return null;
        }
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionServiceRepository.getPromotion(promotionId);
        String tenantCode = pmPromotionReDomain.getTenantCode();
        String memberCode = pmPromotionReDomain.getMemberCode();
        if (null != pmPromotionReDomain && null != (pmPromotionRangelistDomainList = pmPromotionReDomain.getPmPromotionRangeList()) && pmPromotionRangelistDomainList.size() > 0) {
            HashMap<String, String> map;
            String rangeCode;
            if (pmPromotionReDomain.getRangeType() == 2) {
                for (PmPromotionRangelistDomain pmPromotionRangelistDomain : pmPromotionRangelistDomainList) {
                    rangeCode = pmPromotionRangelistDomain.getRangeCode();
                    map = new HashMap<String, String>();
                    map.put("tenantCode", tenantCode);
                    map.put("memberCode", memberCode);
                    map.put("pntreeCode", rangeCode);
                    RsPntreeReDomain rsPntreeReDomain = this.rsPntreeServiceRepository.getPntreeByCode(map);
                    if (null == rsPntreeReDomain) continue;
                    pmPromotionRangelistDomain.setRangeName(rsPntreeReDomain.getPntreeName());
                }
            } else if (pmPromotionReDomain.getRangeType() == 3) {
                for (PmPromotionRangelistDomain pmPromotionRangelistDomain : pmPromotionRangelistDomainList) {
                    rangeCode = pmPromotionRangelistDomain.getRangeCode();
                    map = new HashMap();
                    map.put("tenantCode", tenantCode);
                    map.put("memberCode", memberCode);
                    map.put("brandCode", rangeCode);
                    RsBrandReDomain rsBrandReDomain = this.rsBrandServiceRepository.getBrandByCode(map);
                    if (null == rsBrandReDomain) continue;
                    pmPromotionRangelistDomain.setRangeName(rsBrandReDomain.getBrandName());
                }
            } else if (pmPromotionReDomain.getRangeType() == 4) {
                for (PmPromotionRangelistDomain pmPromotionRangelistDomain : pmPromotionRangelistDomainList) {
                    rangeCode = pmPromotionRangelistDomain.getRangeCode();
                    map = new HashMap();
                    map.put("tenantCode", tenantCode);
                    map.put("memberCode", memberCode);
                    map.put("classtreeCode", rangeCode);
                    RsClasstreeReDomain rsClasstreeReDomain = this.rsClasstreeServiceRepository.getClasstreeByCode(map);
                    String classtreeName = rsClasstreeReDomain.getClasstreeName();
                    if (null != rsClasstreeReDomain && !rsClasstreeReDomain.getClasstreeParentcode().equals("-1")) {
                        map.put("classtreeCode", rsClasstreeReDomain.getClasstreeParentcode());
                        rsClasstreeReDomain = this.rsClasstreeServiceRepository.getClasstreeByCode(map);
                        if (null != rsClasstreeReDomain) {
                            classtreeName = rsClasstreeReDomain.getClasstreeName() + "-" + classtreeName;
                            if (!rsClasstreeReDomain.getClasstreeParentcode().equals("-1")) {
                                map.put("classtreeCode", rsClasstreeReDomain.getClasstreeParentcode());
                                rsClasstreeReDomain = this.rsClasstreeServiceRepository.getClasstreeByCode(map);
                                if (null != rsClasstreeReDomain) {
                                    classtreeName = rsClasstreeReDomain.getClasstreeName() + "-" + classtreeName;
                                }
                            }
                        }
                    }
                    pmPromotionRangelistDomain.setRangeName(classtreeName);
                }
            } else if (pmPromotionReDomain.getRangeType() == 5) {
                for (PmPromotionRangelistDomain pmPromotionRangelistDomain : pmPromotionRangelistDomainList) {
                    rangeCode = pmPromotionRangelistDomain.getRangeCode();
                    map = new HashMap();
                    map.put("tenantCode", tenantCode);
                    map.put("memberCode", memberCode);
                    map.put("skuCode", rangeCode);
                    RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(map);
                    if (null == rsSkuReDomain) continue;
                    pmPromotionRangelistDomain.setDataPic(rsSkuReDomain.getDataPic());
                    HashMap<String, String> map1 = new HashMap<String, String>();
                    map1.put("tenantCode", tenantCode);
                    map1.put("memberCode", memberCode);
                    map1.put("goodsCode", rsSkuReDomain.getGoodsCode());
                    RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map1);
                    if (null == rsResourceGoodsReDomain) continue;
                    pmPromotionRangelistDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                    pmPromotionRangelistDomain.setGoodsNo(rsResourceGoodsReDomain.getGoodsNo());
                }
            }
        }
        if (null != (pmPromotionDiscountDomainList = pmPromotionReDomain.getPmPromotionDiscountList()) && pmPromotionDiscountDomainList.size() > 0) {
            for (PmPromotionDiscountDomain pmPromotionDiscountDomain : pmPromotionDiscountDomainList) {
                List pmPromotionDiscountlistDomainList;
                if (pmPromotionDiscountDomain.getDiscType() != 5 || null == (pmPromotionDiscountlistDomainList = pmPromotionDiscountDomain.getPmPromotionDiscountlistList()) || pmPromotionDiscountlistDomainList.size() <= 0) continue;
                for (PmPromotionDiscountlistDomain pmPromotionDiscountlistDomain : pmPromotionDiscountlistDomainList) {
                    String rangeCode = pmPromotionDiscountlistDomain.getDiscountCode();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("tenantCode", tenantCode);
                    map.put("memberCode", memberCode);
                    map.put("skuCode", rangeCode);
                    RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(map);
                    if (null == rsSkuReDomain) continue;
                    pmPromotionDiscountlistDomain.setDataPic(rsSkuReDomain.getDataPic());
                    HashMap<String, String> map1 = new HashMap<String, String>();
                    map1.put("tenantCode", tenantCode);
                    map1.put("memberCode", memberCode);
                    map1.put("goodsCode", rsSkuReDomain.getGoodsCode());
                    RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map1);
                    if (null == rsResourceGoodsReDomain) continue;
                    pmPromotionDiscountlistDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                    pmPromotionDiscountlistDomain.setGoodsNo(rsResourceGoodsReDomain.getGoodsNo());
                }
            }
        }
        return pmPromotionReDomain;
    }

    @RequestMapping(value={"updatePromotion.json"}, name="\u66f4\u65b0\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotion(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updatePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updatePromotion", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(userSession.getUserPcode());
        promotionDomain.setMemberName(userSession.getUserName());
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionServiceRepository.getPromotion(promotionDomain.getPromotionId());
        if (pmPromotionReDomain.getDataState() != 0) {
            this.logger.error(CODE + ".updatePromotion", (Object)" datastate canot update");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8425\u9500\u6d3b\u52a8\u5df2\u7ecf\u5f00\u59cb\u6216\u7ed3\u675f\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        return this.pmPromotionServiceRepository.updatePromotion(promotionDomain);
    }

    @RequestMapping(value={"deletePromotion.json"}, name="\u5220\u9664\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deletePromotion(String promotionId) {
        String[] pidStrArray;
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".deletePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String pidStr : pidStrArray = promotionId.split(",")) {
            this.pmPromotionServiceRepository.deletePromotion(Integer.valueOf(Integer.parseInt(pidStr)));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"queryPromotionPage.json"}, name="\u67e5\u8be2\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pmPromotionServiceRepository.queryPromotionPage(param);
    }

    @RequestMapping(value={"updatePromotionState.json"}, name="\u66f4\u65b0\u8425\u9500\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePromotionState(String promotionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), dataState, oldDataState);
    }

    @RequestMapping(value={"updatePromotionStateStop.json"}, name="\u8425\u9500\u670d\u52a1\u7ec8\u6b62")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateStop(String promotionId) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(3), Integer.valueOf(1));
    }

    @RequestMapping(value={"updatePromotionStateStart.json"}, name="\u8425\u9500\u670d\u52a1\u5f00\u59cb")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateStart(String promotionId) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(1), Integer.valueOf(3));
    }

    @RequestMapping(value={"queryPromotionListByGoodsCode.json"}, name="\u83b7\u53d6\u8425\u9500\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionListByGoodsCode(HttpServletRequest request, String skuCode, String userCode, Integer terminalType) {
        if (StringUtils.isBlank((String)skuCode)) {
            this.logger.error(CODE + ".queryPromotionListByGoodsCode", (Object)"param is null");
        }
        return this.pmPromotionServiceRepository.checkPromotionListByGoodsCode(this.getTenantCode(request), skuCode, userCode, this.getOauthEnvCode(request));
    }

    @RequestMapping(value={"queryCouponListBySkuCode.json"}, name="\u83b7\u53d6\u4f18\u60e0\u5238\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryCouponListBySkuCode(HttpServletRequest request, String skuCode) {
        if (StringUtils.isBlank((String)skuCode)) {
            this.logger.error(CODE + ".queryCouponListBySkuCode", (Object)"param is null");
        }
        return this.pmPromotionServiceRepository.checkCouponListBySkuCode(this.getTenantCode(request), skuCode, this.getUserInfo(request).getUserCode(), this.getOauthEnvCode(request));
    }

    @RequestMapping(value={"calcPromotionByOrder.json"}, name="\u4e0b\u8ba2\u5355\u65f6\u8ba1\u7b97\u8425\u9500\u6570\u503c")
    @ResponseBody
    public HtmlJsonReBean calcPromotionByOrder(HttpServletRequest request, String paramStr, String contractBillCode) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".calcPromotionByOrder", (Object)"param is null");
        }
        PmPromotionCalcListDomain pmPromotionCalcDomain = (PmPromotionCalcListDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionCalcListDomain.class);
        return this.pmPromotionServiceRepository.calcPromotionByOrder(pmPromotionCalcDomain.getPromotionCalcList(), contractBillCode, this.getTenantCode(request), this.getUserSession(request).getUserCode(), this.getOauthEnvCode(request));
    }

    @RequestMapping(value={"promotionByFinishOrder.json"}, name="\u8ba2\u5355\u5b8c\u6210\u540e\u7684\u8425\u9500")
    @ResponseBody
    public HtmlJsonReBean promotionByFinishOrder(HttpServletRequest request, String contractBillCode, String userCode) {
        if (StringUtils.isBlank((String)userCode)) {
            this.logger.error(CODE + ".promotionByFinishOrder", (Object)"param is null");
        }
        return this.pmPromotionServiceRepository.promotionByFinishOrder(contractBillCode, this.getTenantCode(request), userCode);
    }

    @RequestMapping(value={"getPromotionGoods.json"}, name="\u83b7\u53d6\u53c2\u4e0e\u8425\u9500\u7684\u5546\u54c1\u5217\u8868")
    @ResponseBody
    public HtmlJsonReBean getPromotionGoods(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        return this.pmPromotionServiceRepository.getPromotionGoods(param);
    }
}

