/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.promotion.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.pm.domain.PmActivityDiscountDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmActivityDiscountGoodsDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmActivityDiscountReDomain;
import com.qjsoft.laser.controller.facade.pm.repository.PmActivityDiscountGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.pm.repository.PmActivityDiscountServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pm/activityDiscount"}, name="\u5957\u9910\u6d3b\u52a8")
public class ActivityDiscountCon
extends SpringmvcController {
    private static String CODE = "pm.activityDiscount.con";
    @Autowired
    private PmActivityDiscountServiceRepository pmActivityDiscountServiceRepository;
    @Autowired
    private PmActivityDiscountGoodsServiceRepository pmActivityDiscountGoodsServiceRepository;

    protected String getContext() {
        return "activityDiscount";
    }

    @RequestMapping(value={"saveActivityDiscount.json"}, name="\u589e\u52a0\u5957\u9910\u6d3b\u52a8")
    @ResponseBody
    public HtmlJsonReBean saveActivityDiscount(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveActivityDiscount", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveActivityDiscount", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        PmActivityDiscountDomain pmActivityDiscountDomain = (PmActivityDiscountDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmActivityDiscountDomain.class);
        List pmActivityDiscountGoodsList = pmActivityDiscountDomain.getPmActivityDiscountGoodsList();
        if (ListUtil.isEmpty((Collection)pmActivityDiscountGoodsList)) {
            this.logger.error(CODE + ".saveActivityDiscount", (Object)"pmActivityDiscountGoodsList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u4e3a\u7a7a");
        }
        for (PmActivityDiscountGoodsDomain pmActivityDiscountGoodsDomain : pmActivityDiscountGoodsList) {
            if (pmActivityDiscountGoodsDomain.getGoodsOrdnum() != null) continue;
            this.logger.error(CODE + ".saveActivityDiscount", (Object)"pmActivityDiscountGoodsDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u8d77\u8ba2\u91cf\u6216\u8005\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a");
        }
        if (pmActivityDiscountDomain.getActivityDiscountType() != null && pmActivityDiscountDomain.getActivityDiscountType() == 1 && pmActivityDiscountDomain.getDiscountNum() == null) {
            this.logger.error(CODE + ".saveActivityDiscount", (Object)"getDiscountNum is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5957\u9910\u8d77\u8ba2\u91cf\u4e3a\u7a7a");
        }
        pmActivityDiscountDomain.setGmtCreatePer(userSession.getUserCode());
        pmActivityDiscountDomain.setTenantCode(this.getTenantCode(request));
        return this.pmActivityDiscountServiceRepository.saveActivityDiscount(pmActivityDiscountDomain);
    }

    @RequestMapping(value={"getActivityDiscount.json"}, name="\u83b7\u53d6\u5957\u9910\u6d3b\u52a8\u4fe1\u606f")
    @ResponseBody
    public PmActivityDiscountReDomain getActivityDiscount(Integer activityDiscountId) {
        if (StringUtils.isBlank((Integer)activityDiscountId)) {
            this.logger.error(CODE + ".getActivityDiscount", (Object)"param is null");
            return null;
        }
        PmActivityDiscountReDomain activityDiscount = this.pmActivityDiscountServiceRepository.getActivityDiscount(activityDiscountId);
        if (activityDiscount.getActivityDiscountType() == 0) {
            for (PmActivityDiscountGoodsDomain pmActivityDiscountGoodsDomain : activityDiscount.getPmActivityDiscountGoodsList()) {
                pmActivityDiscountGoodsDomain.setMinNum(pmActivityDiscountGoodsDomain.getGoodsOrdnum());
                pmActivityDiscountGoodsDomain.setMaxNum(this.getMin(pmActivityDiscountGoodsDomain.getGoodsOrdnumMax(), pmActivityDiscountGoodsDomain.getGoodsOrdnumRemainder()));
            }
        } else {
            activityDiscount.setMinNum(activityDiscount.getPurchaseDiscountNum());
            activityDiscount.setMaxNum(this.getMin(activityDiscount.getPurchaseDiscountNumOnce(), activityDiscount.getPurchaseDiscountNumRemainder()));
        }
        return activityDiscount;
    }

    private BigDecimal getMin(BigDecimal goodsOrdnumMax, BigDecimal goodsOrdnumRemainder) {
        if (goodsOrdnumMax == null) {
            return goodsOrdnumRemainder;
        }
        if (goodsOrdnumRemainder == null) {
            return goodsOrdnumMax;
        }
        return goodsOrdnumMax.compareTo(goodsOrdnumRemainder) == -1 ? goodsOrdnumMax : goodsOrdnumRemainder;
    }

    @RequestMapping(value={"updateActivityDiscount.json"}, name="\u66f4\u65b0\u5957\u9910\u6d3b\u52a8")
    @ResponseBody
    public HtmlJsonReBean updateActivityDiscount(HttpServletRequest request, PmActivityDiscountDomain pmActivityDiscountDomain) {
        if (null == pmActivityDiscountDomain) {
            this.logger.error(CODE + ".updateActivityDiscount", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pmActivityDiscountDomain.setTenantCode(this.getTenantCode(request));
        return this.pmActivityDiscountServiceRepository.updateActivityDiscount(pmActivityDiscountDomain);
    }

    @RequestMapping(value={"deleteActivityDiscount.json"}, name="\u5220\u9664\u5957\u9910\u6d3b\u52a8")
    @ResponseBody
    public HtmlJsonReBean deleteActivityDiscount(Integer activityDiscountId) {
        if (StringUtils.isBlank((Integer)activityDiscountId)) {
            this.logger.error(CODE + ".deleteActivityDiscount", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmActivityDiscountServiceRepository.deleteActivityDiscount(activityDiscountId);
    }

    @RequestMapping(value={"queryActivityDiscountPage.json"}, name="\u67e5\u8be2\u5957\u9910\u6d3b\u52a8\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmActivityDiscountReDomain> queryActivityDiscountPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pmActivityDiscountServiceRepository.queryActivityDiscountPage(param);
    }

    @RequestMapping(value={"updateActivityDiscountState.json"}, name="\u66f4\u65b0\u5957\u9910\u6d3b\u52a8\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateActivityDiscountState(String activityDiscountId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)activityDiscountId)) {
            this.logger.error(CODE + ".updateActivityDiscountState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmActivityDiscountServiceRepository.updateActivityDiscountState(Integer.valueOf(activityDiscountId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateActivityDiscountStateStop.json"}, name="\u505c\u7528\u5957\u9910\u6d3b\u52a8")
    @ResponseBody
    public HtmlJsonReBean updateActivityDiscountStateStop(String activityDiscountId) {
        if (StringUtils.isBlank((String)activityDiscountId)) {
            this.logger.error(CODE + ".updateActivityDiscountState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmActivityDiscountServiceRepository.updateActivityDiscountState(Integer.valueOf(activityDiscountId), Integer.valueOf(0), Integer.valueOf(1), null);
    }

    @RequestMapping(value={"useCoupon.json"}, name="\u5957\u9910\u6d3b\u52a8\u662f\u5426\u4f7f\u7528\u4f18\u60e0\u5238")
    @ResponseBody
    public HtmlJsonReBean useCoupon(Integer activityDiscountId) {
        if (StringUtils.isBlank((Integer)activityDiscountId)) {
            this.logger.error(CODE + ".useCoupon", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        PmActivityDiscountReDomain activityDiscount = this.pmActivityDiscountServiceRepository.getActivityDiscount(activityDiscountId);
        return new HtmlJsonReBean((Object)(activityDiscount.getUseCoupon() == 0 ? 1 : 0));
    }

    @RequestMapping(value={"queryActivityDiscountCur.json"}, name="\u67e5\u8be2\u5957\u9910\u6d3b\u52a8")
    @ResponseBody
    public SupQueryResult<PmActivityDiscountReDomain> queryActivityDiscountCur(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("dataState", 1);
        String dateString = null;
        dateString = param.containsKey("beginTime") && param.get("beginTime") != null && StringUtils.isNotBlank((String)((String)param.get("beginTime"))) ? param.get("beginTime").toString() : DateUtils.getDateString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        param.put("activityBeginTimeQend", dateString);
        param.put("activityEndTimeQstart", dateString);
        SupQueryResult pmActivityDiscountReDomainSupQueryResult = this.pmActivityDiscountServiceRepository.queryActivityDiscountPage(param);
        List list = pmActivityDiscountReDomainSupQueryResult.getList();
        if (ListUtil.isNotEmpty((Collection)list)) {
            for (PmActivityDiscountReDomain pmActivityDiscountReDomain : list) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("activityDiscountCode", pmActivityDiscountReDomain.getActivityDiscountCode());
                SupQueryResult pmActivityDiscountGoodsReDomainSupQueryResult = this.pmActivityDiscountGoodsServiceRepository.queryActivityDiscountGoodsPage(paramMap);
                pmActivityDiscountReDomain.setPmActivityDiscountGoodsList(pmActivityDiscountGoodsReDomainSupQueryResult.getList());
            }
        }
        return pmActivityDiscountReDomainSupQueryResult;
    }
}

