/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.promotion.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dis.domain.DisChannelReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisChannelServiceRepository;
import com.qjsoft.laser.controller.facade.es.domain.AccurateQueryDomain;
import com.qjsoft.laser.controller.facade.es.domain.ReturnBean;
import com.qjsoft.laser.controller.facade.es.domain.SearchDomain;
import com.qjsoft.laser.controller.facade.es.domain.SortDomain;
import com.qjsoft.laser.controller.facade.es.repository.SearchengineServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSettlDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.org.domain.OrgEmployeeReDomain;
import com.qjsoft.laser.controller.facade.org.repository.OrgDepartServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgEmployeeServiceRepository;
import com.qjsoft.laser.controller.facade.pm.domain.PmCheckBean;
import com.qjsoft.laser.controller.facade.pm.domain.PmOcUsageStatistics;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDisDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDisReDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDiscountDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDiscountlistDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionInDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionMemDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionRangelistDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionReDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionTargetlistDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PromotionConstants;
import com.qjsoft.laser.controller.facade.pm.domain.SkuBean;
import com.qjsoft.laser.controller.facade.pm.domain.UserBean;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionConditionServiceRepository;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionCouponServiceRepository;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionDisServiceRepository;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionDiscountServiceRepository;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionInServiceRepository;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionServiceRepository;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionTargetlistServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsBrandServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsClasstreeServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsOtherServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsPntreeServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pm/promotion"}, name="\u8425\u9500\u670d\u52a1")
public class PromotionCon
extends SpringmvcController {
    private static String CODE = "pm.promotion.con";
    @Autowired
    private PmPromotionServiceRepository pmPromotionServiceRepository;
    @Autowired
    private RsBrandServiceRepository rsBrandServiceRepository;
    @Autowired
    private RsPntreeServiceRepository rsPntreeServiceRepository;
    @Autowired
    private RsClasstreeServiceRepository rsClasstreeServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private PmPromotionCouponServiceRepository pmPromotionCouponServiceRepository;
    @Autowired
    private PmPromotionConditionServiceRepository pmPromotionConditionServiceRepository;
    @Autowired
    private PmPromotionDiscountServiceRepository pmPromotionDiscountServiceRepository;
    @Autowired
    private SearchengineServiceRepository searchengineServiceRepository;
    @Autowired
    private PmPromotionInServiceRepository pmPromotionInServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private RsGoodsOtherServiceRepository goodsOtherServiceRepository;
    @Autowired
    private PmPromotionDisServiceRepository pmPromotionDisServiceRepository;
    @Autowired
    private OrgEmployeeServiceRepository orgEmployeeServiceRepository;
    @Autowired
    private OrgDepartServiceRepository orgDepartServiceRepository;
    @Autowired
    private DisChannelServiceRepository disChannelServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private PmPromotionTargetlistServiceRepository pmPromotionTargetlistServiceRepository;
    public static final Integer ORGIN_0 = 0;
    public static final Integer ORGIN_1 = 1;
    public static final Integer ORGIN_2 = 2;

    protected String getContext() {
        return "promotion";
    }

    @RequestMapping(value={"updatePromotionStateAudit.json"}, name="\u5ba1\u6838\u6ee1\u51cf\u8425\u9500\u670d\u52a1\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateAudit(String promotionId, String memo) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionStateAudit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(4), Integer.valueOf(0));
    }

    @RequestMapping(value={"updatePromotionStateNoAudit.json"}, name="\u5ba1\u6838\u6ee1\u51cf\u8425\u9500\u670d\u52a1\u62d2\u7edd")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateNoAudit(String promotionId, String memo) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionStateNoAudit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(5), Integer.valueOf(0));
    }

    @RequestMapping(value={"savePromotion.json"}, name="\u589e\u52a0\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotion(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, null, null);
    }

    @RequestMapping(value={"savePromotionFullGift.json"}, name="\u589e\u52a0\u6ee1\u8d60\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionFullGift(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, null, null);
    }

    @RequestMapping(value={"savePromotionFullReduction.json"}, name="\u589e\u52a0\u6ee1\u51cf\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionFullReduction(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, null, null);
    }

    @RequestMapping(value={"savePromotionFullDiscount.json"}, name="\u589e\u52a0\u6ee1\u6298\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionFullDiscount(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, null, null);
    }

    @RequestMapping(value={"savePromotionDiscount.json"}, name="\u589e\u52a0\u6298\u6263\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionDiscount(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, null, null);
    }

    @RequestMapping(value={"savePromotionCasheQuivalent.json"}, name="\u589e\u52a0\u4ee3\u91d1\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionCasheQuivalent(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, null, null);
    }

    @RequestMapping(value={"savePromotionYunying.json"}, name="\u8fd0\u8425\u589e\u52a0\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionYunying(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, "channelCode", null);
    }

    @RequestMapping(value={"savePromotionMem.json"}, name="\u5546\u5bb6\u589e\u52a0\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionMem(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, null, "memberCode");
    }

    private HtmlJsonReBean savePromotionPlus(HttpServletRequest request, String paramStr, String channelCode, String memberCode) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".savePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".savePromotion", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (StringUtils.isNotBlank((String)channelCode)) {
            ArrayList<PmPromotionDisDomain> pmPromotionDisLists = new ArrayList<PmPromotionDisDomain>();
            PmPromotionDisDomain pmPromotionDisDomain = new PmPromotionDisDomain();
            pmPromotionDisDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            pmPromotionDisDomain.setChannelName(userSession.getUserName());
            pmPromotionDisDomain.setMemberCode(userSession.getUserPcode());
            pmPromotionDisDomain.setMemberName(userSession.getUserName());
            pmPromotionDisLists.add(pmPromotionDisDomain);
            promotionDomain.setPmPromotionDisList(pmPromotionDisLists);
        }
        if (StringUtils.isNotBlank((String)memberCode)) {
            ArrayList<PmPromotionMemDomain> pmPromotionMemlists = new ArrayList<PmPromotionMemDomain>();
            PmPromotionMemDomain pmPromotionMemDomain = new PmPromotionMemDomain();
            pmPromotionMemDomain.setMemberCode(userSession.getUserPcode());
            pmPromotionMemDomain.setMemberName(userSession.getUserName());
            pmPromotionMemlists.add(pmPromotionMemDomain);
            promotionDomain.setPmPromotionMemList(pmPromotionMemlists);
        }
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(userSession.getUserPcode());
        promotionDomain.setMemberName(userSession.getMerberCompname());
        promotionDomain.setAppmanageIcode(this.getProappCode(request));
        return this.pmPromotionServiceRepository.savePromotion(promotionDomain);
    }

    @RequestMapping(value={"getPromotion.json"}, name="\u83b7\u53d6\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotion(Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    @RequestMapping(value={"getPromotionFullGift.json"}, name="\u83b7\u53d6\u6ee1\u8d60\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotionFullGift(Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    @RequestMapping(value={"getPromotionFullReduction.json"}, name="\u83b7\u53d6\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotionFullReduction(Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    @RequestMapping(value={"getPromotionFullReduct.json"}, name="\u83b7\u53d6\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u4fe1\u606f\u63a5\u53e32")
    @ResponseBody
    public PmPromotionReDomain getPromotionFullReduct(Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    @RequestMapping(value={"getPromotionFullDiscount.json"}, name="\u83b7\u53d6\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotionFullDiscount(Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    @RequestMapping(value={"getPromotionDiscount.json"}, name="\u83b7\u53d6\u6298\u6263\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotionDiscount(Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    @RequestMapping(value={"getPromotionCasheQuivalent.json"}, name="\u83b7\u53d6\u4ee3\u91d1\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotionCasheQuivalent(Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    @RequestMapping(value={"getPromotionCasheQuival.json"}, name="\u83b7\u53d6\u4ee3\u91d1\u8425\u9500\u670d\u52a1\u4fe1\u606f\u63a5\u53e32")
    @ResponseBody
    public PmPromotionReDomain getPromotionCasheQuival(Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    @RequestMapping(value={"getPromotionByCode.json"}, name="\u83b7\u53d6\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotionByCode(HttpServletRequest request, String promotionCode) {
        if (StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".getPromotionByCode", (Object)"param is null");
            return null;
        }
        return this.pmPromotionServiceRepository.getPromotionByCode(this.getTenantCode(request), promotionCode);
    }

    private PmPromotionReDomain getPromotionplus(Integer promotionId) {
        if (StringUtils.isBlank((Integer)promotionId)) {
            this.logger.error(CODE + ".getPromotion", (Object)"param is null");
            return null;
        }
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionServiceRepository.getPromotion(promotionId);
        return pmPromotionReDomain;
    }

    @RequestMapping(value={"updatePromotion.json"}, name="\u66f4\u65b0\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotion(HttpServletRequest request, String paramStr) {
        return this.updatePromotionPlus(request, paramStr);
    }

    @RequestMapping(value={"updatePromotionFullDiscount.json"}, name="\u66f4\u65b0\u6ee1\u6298\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotionFullDiscount(HttpServletRequest request, String paramStr) {
        return this.updatePromotionPlus(request, paramStr);
    }

    @RequestMapping(value={"updatePromotionFullGift.json"}, name="\u66f4\u65b0\u6ee1\u8d60\u6d3b\u52a8\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotionFullGift(HttpServletRequest request, String paramStr) {
        return this.updatePromotionPlus(request, paramStr);
    }

    @RequestMapping(value={"updatePromotionFullReduction.json"}, name="\u66f4\u65b0\u6ee1\u51cf\u6298\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotionFullReduction(HttpServletRequest request, String paramStr) {
        return this.updatePromotionPlus(request, paramStr);
    }

    @RequestMapping(value={"updatePromotionDiscount.json"}, name="\u66f4\u65b0\u6298\u6263\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotionDiscount(HttpServletRequest request, String paramStr) {
        return this.updatePromotionPlus(request, paramStr);
    }

    @RequestMapping(value={"updatePromotionCasheQuivalent.json"}, name="\u66f4\u65b0\u4ee3\u91d1\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotionCasheQuivalent(HttpServletRequest request, String paramStr) {
        return this.updatePromotionPlus(request, paramStr);
    }

    private HtmlJsonReBean updatePromotionPlus(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updatePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updatePromotion", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (null == promotionDomain.getPromotionId()) {
            this.logger.error(CODE + ".updatePromotion.PromotionId", (Object)"promotionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(userSession.getUserPcode());
        promotionDomain.setMemberName(userSession.getUserName());
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionServiceRepository.getPromotion(promotionDomain.getPromotionId());
        if (null == pmPromotionReDomain || pmPromotionReDomain.getDataState() == 1 || pmPromotionReDomain.getDataState() == 2 || pmPromotionReDomain.getDataState() == 3) {
            this.logger.error(CODE + ".updatePromotion", (Object)" datastate canot update");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8425\u9500\u6d3b\u52a8\u5df2\u7ecf\u5f00\u59cb\u6216\u7ed3\u675f\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        return this.pmPromotionServiceRepository.updatePromotion(promotionDomain);
    }

    @RequestMapping(value={"deletePromotion.json"}, name="\u5220\u9664\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deletePromotion(String promotionId) {
        return this.deletePromotionPlus(promotionId);
    }

    @RequestMapping(value={"deletePromotionFullGift.json"}, name="\u5220\u9664\u6ee1\u8d60\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deletePromotionFullGift(String promotionId) {
        return this.deletePromotionPlus(promotionId);
    }

    @RequestMapping(value={"deletePromotionFullDiscount.json"}, name="\u5220\u9664\u6ee1\u6298\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deletePromotionFullDiscount(String promotionId) {
        return this.deletePromotionPlus(promotionId);
    }

    private HtmlJsonReBean deletePromotionPlus(String promotionId) {
        String[] pidStrArray;
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".deletePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String pidStr : pidStrArray = promotionId.split(",")) {
            PmPromotionReDomain promotion = this.pmPromotionServiceRepository.getPromotion(Integer.valueOf(Integer.parseInt(pidStr)));
            if (null == promotion || promotion.getDataState() == 1 || promotion.getDataState() == 2 || promotion.getDataState() == 3) {
                this.logger.error(CODE + ".updatePromotion", (Object)" datastate canot update");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8425\u9500\u6d3b\u52a8\u5df2\u7ecf\u5f00\u59cb\u6216\u7ed3\u675f\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539");
            }
            this.pmPromotionServiceRepository.deletePromotion(Integer.valueOf(Integer.parseInt(pidStr)));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"queryPromotionAllPage.json"}, name="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u53d1\u5e03\u6240\u6709\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionAllPage(HttpServletRequest request) {
        return this.promotionPage(request, null, null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionChannelPage.json"}, name="\u67e5\u8be2\u6240\u6709\u6e20\u9053\u63a8\u9001\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionChannelPage(HttpServletRequest request) {
        return this.promotionPage(request, null, null, null, ORGIN_1);
    }

    @RequestMapping(value={"queryPromotionCenterPage.json"}, name="\u67e5\u8be2\u6240\u6709\u4e2d\u95f4\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionCenterPage(HttpServletRequest request) {
        return this.promotionPage(request, null, null, null, ORGIN_2);
    }

    @RequestMapping(value={"queryPromotioPage.json"}, name="\u67e5\u8be2\u6240\u6709\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotioPage(HttpServletRequest request) {
        return this.promotionPage(request, null, null, null, null);
    }

    @RequestMapping(value={"queryPromotionPage.json"}, name="\u67e5\u8be2\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPage(HttpServletRequest request) {
        return this.promotionPage(request, "0002", null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageFullDiscount.json"}, name="\u67e5\u8be2\u6ee1\u6298\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageFulldiscount(HttpServletRequest request) {
        return this.promotionPage(request, "0006", null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageCasheQuivalent.json"}, name="\u67e5\u8be2\u4ee3\u91d1\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageCasheQuivalent(HttpServletRequest request) {
        return this.promotionPage(request, "0003", null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageFullGift.json"}, name="\u67e5\u8be2\u6ee1\u8d60\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageFullGift(HttpServletRequest request) {
        return this.promotionPage(request, "0001", null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageFullReduction.json"}, name="\u67e5\u8be2\u6ee1\u51cf\u5377\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageFullReduction(HttpServletRequest request) {
        return this.promotionPage(request, "0004", null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageDiscount.json"}, name="\u67e5\u8be2\u6298\u6263\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageDiscount(HttpServletRequest request) {
        return this.promotionPage(request, "0005", null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageFreeShipping.json"}, name="\u67e5\u8be2\u5305\u90ae\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageFreeShipping(HttpServletRequest request) {
        return this.promotionPage(request, null, null, null, ORGIN_0);
    }

    private SupQueryResult<PmPromotionReDomain> promotionPage(HttpServletRequest request, String pbCode, String promotionType, String promotionPcode, Integer promotionOrgin) {
        Map param = this.assemMapMemberParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updatePromotion", (Object)"userSession is null");
            return null;
        }
        if (null != param) {
            param.put("memberCode", userSession.getUserPcode());
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
            if (StringUtils.isNotBlank((String)promotionType)) {
                param.put("promotionType", promotionType);
            }
            if (StringUtils.isNotBlank((String)promotionPcode)) {
                param.put("promotionPcode", promotionPcode);
            }
            if (null != promotionOrgin) {
                param.put("promotionOrgin", promotionOrgin);
            }
        }
        return this.pmPromotionServiceRepository.queryPromotionPage(param);
    }

    @RequestMapping(value={"updatePromotionState.json"}, name="\u66f4\u65b0\u8425\u9500\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePromotionState(String promotionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), dataState, oldDataState);
    }

    @RequestMapping(value={"updatePromotionStateStop.json"}, name="\u6ee1\u51cf\u8425\u9500\u670d\u52a1\u7ec8\u6b62")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateStop(String promotionId) {
        return this.promotionStateStop(promotionId);
    }

    @RequestMapping(value={"updatePromotionStateStopDiscount.json"}, name="\u6298\u6263\u8425\u9500\u670d\u52a1\u7ec8\u6b62")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateStopDiscount(String promotionId) {
        return this.promotionStateStop(promotionId);
    }

    @RequestMapping(value={"updatePromotionStateStopDiscountion.json"}, name="\u6298\u6263\u8425\u9500\u670d\u52a1\u7ec8\u6b62")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateStopDiscountion(String promotionId) {
        return this.promotionStateStop(promotionId);
    }

    @RequestMapping(value={"updatePromotionStateStopCasheQuivalent.json"}, name="\u4ee3\u91d1\u8425\u9500\u670d\u52a1\u7ec8\u6b62")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateStopCasheQuivalent(String promotionId) {
        return this.promotionStateStop(promotionId);
    }

    @RequestMapping(value={"updatePromotionStateStopCasheQuivalentCopy.json"}, name="\u4ee3\u91d1\u8425\u9500\u670d\u52a1\u7ec8\u6b62")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateStopCasheQuivalentCopy(String promotionId) {
        return this.promotionStateStop(promotionId);
    }

    private HtmlJsonReBean promotionStateStop(String promotionId) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(3), Integer.valueOf(1));
    }

    @RequestMapping(value={"updatePromotionStateStart.json"}, name="\u6ee1\u51cf\u8425\u9500\u670d\u52a1\u5f00\u59cb")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateStart(String promotionId) {
        return this.promotionStateStart(promotionId);
    }

    @RequestMapping(value={"updatePromotionStateStartDiscount.json"}, name="\u6298\u6263\u8425\u9500\u670d\u52a1\u5f00\u59cb")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateStartDiscount(String promotionId) {
        return this.promotionStateStart(promotionId);
    }

    @RequestMapping(value={"updatePromotionStateStartCasheQuivalent.json"}, name="\u4ee3\u91d1\u8425\u9500\u670d\u52a1\u5f00\u59cb")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateStartCasheQuivalent(String promotionId) {
        return this.promotionStateStart(promotionId);
    }

    private HtmlJsonReBean promotionStateStart(String promotionId) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(1), Integer.valueOf(3));
    }

    @RequestMapping(value={"queryPromotionListByGoodsCode.json"}, name="\u83b7\u53d6\u8425\u9500\u6d3b\u52a8\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public List<PmPromotionInDomain> queryPromotionListByGoodsCode(HttpServletRequest request, SkuBean skuBean) {
        if (null == (skuBean = this.makeSkuBean(request, skuBean))) {
            return null;
        }
        List oldPmPromotionInDomains = this.pmPromotionServiceRepository.queryPromotionPmBySku(skuBean);
        ArrayList pmPromotionInDomains = new ArrayList();
        return oldPmPromotionInDomains;
    }

    @RequestMapping(value={"queryPromotionSoBySku.json"}, name="\u83b7\u53d6\u7279\u4ef7\u8425\u9500\u6d3b\u52a8\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public List<PmPromotionInDomain> queryPromotionSoBySku(HttpServletRequest request, SkuBean skuBean) {
        if (null == (skuBean = this.makeSkuBean(request, skuBean))) {
            return null;
        }
        List oldPmPromotionInDomains = this.pmPromotionServiceRepository.queryPromotionSoBySku(skuBean);
        return oldPmPromotionInDomains;
    }

    private SkuBean makeSkuBean(HttpServletRequest request, SkuBean skuBean) {
        if (null == skuBean) {
            this.logger.error(CODE + ".queryPromotionListByGoodsCode.param", (Object)"param is null");
            return null;
        }
        skuBean.setTenantCode(this.getTenantCode(request));
        skuBean.setMemberCcode(this.getMemberCcode(request));
        PmCheckBean pmCheckBean = new PmCheckBean();
        pmCheckBean.setChannelCode(this.getNowChannel(request));
        pmCheckBean.setProappCode(this.getProappCode(request));
        pmCheckBean.setTenantCode(skuBean.getTenantCode());
        UserSession userSession = this.getUserSession(request);
        if (null != userSession) {
            UserBean userBean = new UserBean();
            userBean.setMemberCode(userSession.getUserPcode());
            userBean.setMemberName(userSession.getMerberCompname());
            userBean.setProappCode(userSession.getProappCode());
            userBean.setTenantCode(userSession.getTenantCode());
            userBean.setUserCode(userSession.getUserCode());
            userBean.setUserName(userSession.getUserName());
            Map userMap = new HashMap();
            String jsonUserSession = JsonUtil.buildNonDefaultBinder().toJson((Object)userSession);
            userMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonUserSession, String.class, Object.class);
            userBean.setUserMap(userMap);
            pmCheckBean.setUserBean(userBean);
        }
        skuBean.setPmCheckBean(pmCheckBean);
        return skuBean;
    }

    @RequestMapping(value={"queryCouponListBySkuCode.json"}, name="\u83b7\u53d6\u4f18\u60e0\u5238\u5217\u8868(\u53ef\u4ee5\u4e0d\u7528\u4f20skuCode\u548c\u767b\u5f55)")
    @ResponseBody
    public List<PmPromotionInDomain> queryCouponListBySkuCode(HttpServletRequest request, SkuBean skuBean) {
        if (null == (skuBean = this.makeSkuBean(request, skuBean))) {
            return null;
        }
        List oldPmPromotionInDomains = this.pmPromotionServiceRepository.queryPromotionConBySku(skuBean);
        ArrayList<PmPromotionInDomain> pmPromotionInDomains = new ArrayList<PmPromotionInDomain>();
        if (ListUtil.isNotEmpty((Collection)oldPmPromotionInDomains)) {
            for (PmPromotionInDomain pmPromotionInDomain : oldPmPromotionInDomains) {
                if (1 != pmPromotionInDomain.getActivationMode()) continue;
                pmPromotionInDomains.add(pmPromotionInDomain);
            }
        }
        return pmPromotionInDomains;
    }

    private List<String> getStr(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        str = str.substring(1, str.length() - 1);
        List<String> strsToList1 = Arrays.asList(str.split("\\|"));
        return strsToList1;
    }

    public static void main(String[] args) {
        String str = "|2a|b2|c3|";
        str = str.substring(1, str.length() - 1);
        List<String> strsToList1 = Arrays.asList(str.split("\\|"));
        System.out.println(strsToList1);
    }

    @RequestMapping(value={"getPmPromotionInfo.json"}, name="\u83b7\u53d6\u8425\u9500\u4fe1\u606f")
    @ResponseBody
    public PmPromotionInDomain getPmPromotionInfo(HttpServletRequest request, String promotionCode) {
        if (StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".getPmPromotionInfo", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        String cacheKey = promotionCode + "-" + tenantCode;
        PmPromotionInDomain pmPromotionInDomain = (PmPromotionInDomain)SupDisUtil.getMapJson((String)"pm-promotion", (String)cacheKey, PmPromotionInDomain.class);
        return pmPromotionInDomain;
    }

    @RequestMapping(value={"getPromotionGoods.json"}, name="\u83b7\u53d6\u53c2\u4e0e\u8425\u9500\u7684\u5546\u54c1\u5217\u8868")
    @ResponseBody
    public SupQueryResult<Map<String, Object>> getPromotionGoods(HttpServletRequest request, String promotionCode) {
        AccurateQueryDomain accurateQueryDomain;
        String str;
        List<String> strList;
        String memberCcode;
        String str2;
        List<String> strList2;
        String searchParam;
        if (StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".getPromotionGoods", (Object)"param is null");
            return null;
        }
        Map map = this.assemMapParam(request);
        String tenantCode = this.getTenantCode(request);
        String cacheKey = promotionCode + "-" + tenantCode;
        PmPromotionInDomain pmPromotionInDomain = (PmPromotionInDomain)SupDisUtil.getMapJson((String)"pm-promotion", (String)cacheKey, PmPromotionInDomain.class);
        if (null == pmPromotionInDomain) {
            this.logger.error(CODE + ".promotionCode.pmPromotionInDomain", (Object)cacheKey);
            return null;
        }
        ArrayList<AccurateQueryDomain> accurateQueryList = new ArrayList<AccurateQueryDomain>();
        String proappCode = this.getProappCode(request);
        if (null != pmPromotionInDomain.getPromotionTer() && pmPromotionInDomain.getPromotionTer() == 1) {
            String promotionTerstr = pmPromotionInDomain.getPromotionTerstr();
            if (StringUtils.isBlank((String)promotionTerstr)) {
                this.logger.error(CODE + ".promotionCode.promotionTerstr", (Object)"param is null");
                return null;
            }
            if (promotionTerstr.indexOf("|" + proappCode + "|") < 0) {
                this.logger.error(CODE + ".promotionCode.proappCode", (Object)(proappCode + ":" + promotionTerstr));
                return null;
            }
        }
        if (StringUtils.isNotBlank((String)(searchParam = (String)map.get("searchParam")))) {
            try {
                searchParam = URLDecoder.decode(searchParam, "UTF-8");
            }
            catch (Exception e) {
                this.logger.error(CODE + ".find.searchParam", (Throwable)e);
            }
        }
        if (null != pmPromotionInDomain.getPromotionDis() && pmPromotionInDomain.getPromotionDis() == 1 && ListUtil.isNotEmpty(strList2 = this.getStr(str2 = pmPromotionInDomain.getChannelCode()))) {
            AccurateQueryDomain accurateQueryDomain2 = new AccurateQueryDomain();
            accurateQueryDomain2.setAccurateField("channelCode.keyword");
            accurateQueryDomain2.setAccurateFieldValues(strList2);
            accurateQueryList.add(accurateQueryDomain2);
        }
        if (StringUtils.isNotBlank((String)(memberCcode = this.getMemberCcode(request)))) {
            AccurateQueryDomain accurateQueryDomain3 = new AccurateQueryDomain();
            accurateQueryDomain3.setAccurateField("memberCcode.keyword");
            accurateQueryDomain3.setAccurateFieldValue(memberCcode);
            accurateQueryList.add(accurateQueryDomain3);
        }
        if (null != pmPromotionInDomain.getPromotionMem() && pmPromotionInDomain.getPromotionMem() == 1 && ListUtil.isNotEmpty(strList = this.getStr(str = pmPromotionInDomain.getPpmemMemcode()))) {
            accurateQueryDomain = new AccurateQueryDomain();
            accurateQueryDomain.setAccurateField("memberCode.keyword");
            accurateQueryDomain.setAccurateFieldValues(strList);
            accurateQueryList.add(accurateQueryDomain);
        }
        if (null != pmPromotionInDomain.getRangeType() && pmPromotionInDomain.getRangeType().intValue() != PromotionConstants.RANGE_TYPE_0.intValue()) {
            str = pmPromotionInDomain.getRangeCode();
            if (StringUtils.isNotBlank((String)str)) {
                Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(str, String.class, Object.class);
                str = String.valueOf(jsonToMap.get("0-="));
            }
            strList = this.getStr(str);
            String codeName = "";
            if (pmPromotionInDomain.getRangeType().intValue() != PromotionConstants.RANGE_TYPE_1.intValue()) {
                if (pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_2.intValue()) {
                    codeName = "pntreeCode";
                } else if (pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_3.intValue()) {
                    codeName = "brandCode";
                } else if (pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_4.intValue()) {
                    codeName = "classtreeCode";
                } else if (pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_5.intValue()) {
                    codeName = "skuNo";
                }
            }
            if (ListUtil.isNotEmpty(strList)) {
                AccurateQueryDomain accurateQueryDomain4 = new AccurateQueryDomain();
                accurateQueryDomain4.setAccurateField(codeName);
                accurateQueryDomain4.setAccurateFieldValues(strList);
                accurateQueryList.add(accurateQueryDomain4);
            }
        }
        String channelCodeVaule = (String)map.get("channelCode");
        String channelCode = null;
        if (StringUtils.isNotBlank((String)channelCodeVaule) && "channelCode".equals(channelCodeVaule) && StringUtils.isNotBlank((String)(channelCode = this.getNowChannel(request)))) {
            accurateQueryDomain = new AccurateQueryDomain();
            accurateQueryDomain.setAccurateField("channelCode.keyword");
            accurateQueryDomain.setAccurateFieldValue(channelCode);
            accurateQueryList.add(accurateQueryDomain);
        }
        if (StringUtils.isNotBlank((String)channelCodeVaule) && "delearchannelCode".equals(channelCodeVaule) && StringUtils.isNotBlank((String)(channelCode = this.getChannelByMemCc(this.getMerchantCode(request), request)))) {
            accurateQueryDomain = new AccurateQueryDomain();
            accurateQueryDomain.setAccurateField("channelCode.keyword");
            accurateQueryDomain.setAccurateFieldValue(channelCode);
            accurateQueryList.add(accurateQueryDomain);
        }
        if (StringUtils.isBlank((String)channelCodeVaule) && StringUtils.isNotBlank((String)(channelCode = this.getNowChannel(request)))) {
            accurateQueryDomain = new AccurateQueryDomain();
            accurateQueryDomain.setAccurateField("channelCode.keyword");
            accurateQueryDomain.setAccurateFieldValue(channelCode);
            accurateQueryList.add(accurateQueryDomain);
        }
        SearchDomain searchDomain = new SearchDomain();
        HashMap<String, String> smap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)searchParam)) {
            smap.put("skuName", searchParam);
            smap.put("goodsName", searchParam);
            smap.put("brandName", searchParam);
            smap.put("goodsProperty", searchParam);
        }
        searchDomain.setBoolMap(smap);
        searchDomain.setBoolMap(smap);
        searchDomain.setBizType("sku");
        if (StringUtils.isNotBlank((String)((String)map.get("bizType"))) && map.get("bizType").equals("goods")) {
            searchDomain.setBizType("goods");
        }
        searchDomain.setTenantCode(this.getTenantCode(request));
        HashMap<String, Integer> pageMap = new HashMap<String, Integer>();
        Integer page = (Integer)map.get("page");
        Integer rows = (Integer)map.get("rows");
        int page1 = StringUtils.isBlank((Integer)page) ? 1 : page;
        int rows1 = StringUtils.isBlank((Integer)rows) ? 10 : rows;
        pageMap.put("page", page1);
        pageMap.put("rows", rows1);
        searchDomain.setPageMap(pageMap);
        searchDomain.setAccurateQueryList(accurateQueryList);
        if (null != map.get("minPrice") && StringUtils.isNotBlank((String)((String)map.get("minPrice")))) {
            searchDomain.setMinPrice(Double.valueOf((String)map.get("minPrice")));
        }
        if (null != map.get("maxPrice") && StringUtils.isNotBlank((String)((String)map.get("maxPrice")))) {
            searchDomain.setMaxPrice(Double.valueOf((String)map.get("maxPrice")));
        }
        String sortField = (String)map.get("sortField");
        String order = (String)map.get("order");
        if (StringUtils.isNotBlank((String)sortField)) {
            SortDomain sortDomain = new SortDomain();
            sortDomain.setSortField(sortField);
            if (StringUtils.isBlank((String)order)) {
                order = "desc";
            }
            sortDomain.setOrder(order);
            searchDomain.setSortDomain(sortDomain);
        }
        SupQueryResult queryResult = new SupQueryResult();
        ReturnBean returnBean = this.searchengineServiceRepository.find(searchDomain);
        if (null == returnBean) {
            this.logger.error(CODE + ".promotionCode.searchDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)searchDomain));
            return queryResult;
        }
        queryResult.setList(returnBean.getSourcelist());
        SupPageTools supPageTools = new SupPageTools();
        supPageTools.setRecordCount(returnBean.getCount());
        supPageTools.setPageSize(rows1);
        supPageTools.setPageNo(page1);
        queryResult.setPageTools(supPageTools);
        queryResult.setTotal((long)returnBean.getCount());
        return queryResult;
    }

    @RequestMapping(value={"queryCouponList.json"}, name="\u83b7\u53d6\u6240\u6709\u4f18\u60e0\u5238")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryCouponList(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("dataState", 1);
            param.put("promotionInType", "1");
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pmPromotionServiceRepository.queryPromotionPage(param);
    }

    @RequestMapping(value={"querySkuByPromotionRange.json"}, name="\u67e5\u8be2\u4f18\u60e0\u5238\u5bf9\u5e94\u7684\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuByPromotionRange(String tenantCode, String promotionCode, String orderStr) {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".querySkuByPromotionRange", (Object)"tenantCode is null");
            return null;
        }
        if (StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".querySkuByPromotionRange", (Object)"promotionCode is null");
            return null;
        }
        PmPromotionInDomain pmPromotionIn = (PmPromotionInDomain)SupDisUtil.getMapJson((String)"pm-promotion", (String)(promotionCode + "-" + tenantCode), PmPromotionInDomain.class);
        if (null == pmPromotionIn) {
            this.logger.error(CODE + "querySkuByPromotionRange.pmPromotionIn", (Object)(promotionCode + "-" + tenantCode));
            return null;
        }
        if (StringUtils.isBlank((String)pmPromotionIn.getRangeCode())) {
            this.logger.error(CODE + "querySkuByPromotionRange.rangeCode", (Object)(promotionCode + "-" + tenantCode));
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("fuzzy", false);
        map.put("order", true);
        map.put("orderStr", orderStr);
        String[] codeStr = pmPromotionIn.getRangeCode().split("\\,");
        if (5 == pmPromotionIn.getRangeType()) {
            map.put("skuCodeStr", Arrays.asList(codeStr));
        } else {
            map.put("goodsCodeStr", Arrays.asList(codeStr));
        }
        SupQueryResult rsSkuReDomainSupQueryResult = this.rsSkuServiceRepository.querySkuPage(map);
        if (null == rsSkuReDomainSupQueryResult) {
            this.logger.error(CODE + "querySkuByPromotionRange.RsSkuReDomain", map);
            return null;
        }
        return rsSkuReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryPromotionPageGroupBuying.json"}, name="\u67e5\u8be2\u56e2\u8d2d\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageGroupBuying(HttpServletRequest request) {
        return this.promotionPage(request, "0008", null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageSeckill.json"}, name="\u67e5\u8be2\u79d2\u6740\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageSeckill(HttpServletRequest request) {
        return this.promotionPage(request, "0007", null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageAssemble.json"}, name="\u67e5\u8be2\u62fc\u56e2\u6bcd\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageAssemble(HttpServletRequest request) {
        return this.promotionPage(request, "0011", "0", null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageAssembles.json"}, name="\u67e5\u8be2\u62fc\u56e2\u5b50\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageAssembles(HttpServletRequest request) {
        return this.promotionPage(request, "0011", "1", null, ORGIN_0);
    }

    @RequestMapping(value={"getPromotions.json"}, name="\u83b7\u53d6\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotions(Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    @RequestMapping(value={"queryPromotionPageAssembleForPc.json"}, name="\u67e5\u8be2\u62fc\u56e2\u5b50\u670d\u52a1\u5206\u9875\u5217\u8868-pc")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageAssembleForPc(HttpServletRequest request, String promotionPcode) {
        if (StringUtils.isBlank((String)promotionPcode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("pbCode", "0011");
            param.put("promotionType", "1");
            param.put("promotionPcode", promotionPcode);
        }
        return this.pmPromotionServiceRepository.queryPromotionPage(param);
    }

    @RequestMapping(value={"loadPromotionIn.json"}, name="\u751f\u6548\u6d3b\u52a8\u52a0\u8f7d\u7f13\u5b58")
    @ResponseBody
    public HtmlJsonReBean loadPromotionIn() {
        return this.pmPromotionServiceRepository.loadPromotionIn();
    }

    @RequestMapping(value={"deletePromotionStr.json"}, name="\u5220\u9664\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deletePromotionStr(String promotionId) {
        return this.deletePromotionPlus(promotionId);
    }

    @RequestMapping(value={"savePromotionFullGiftStr.json"}, name="\u589e\u52a0\u6ee1\u8d60\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionFullGiftStr(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, null, null);
    }

    @RequestMapping(value={"queryPromotionPageForRet.json"}, name="\u67e5\u8be2\u6240\u6709\u53ef\u53c2\u4e0e\u8425\u9500")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageForRet(HttpServletRequest request) {
        String channelCode = this.getNowChannel(request);
        String dataState = "0";
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("dataState", dataState);
            param.put("channelCode", channelCode);
        }
        return this.pmPromotionServiceRepository.queryPromotionPage(param);
    }

    @RequestMapping(value={"updateCommitState.json"}, name="\u5206\u9500\u5546\u53c2\u52a0\u6d3b\u52a8")
    @ResponseBody
    public HtmlJsonReBean updateCommitState(String promotionId) {
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(1), Integer.valueOf(0));
    }

    @RequestMapping(value={"updateRefuseState.json"}, name="\u5206\u9500\u5546\u62d2\u7edd\u6d3b\u52a8")
    @ResponseBody
    public HtmlJsonReBean updateRefuseState(String promotionId) {
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(-1), Integer.valueOf(0));
    }

    @RequestMapping(value={"queryPmOcUsageStatistics.json"}, name="\u8ba2\u5355\u8425\u9500\u4f7f\u7528\u7edf\u8ba1")
    @ResponseBody
    public SupQueryResult<PmOcUsageStatistics> queryPmOcUsageStatistics(HttpServletRequest request, String contractSettlOpno) {
        if (StringUtils.isBlank((String)contractSettlOpno)) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        PmPromotionReDomain promotionByCode = this.pmPromotionServiceRepository.getPromotionByCode(tenantCode, contractSettlOpno);
        if (null == promotionByCode) {
            return null;
        }
        Map paramMap = this.assemMapParam(request);
        paramMap.put("contractSettlOpno", contractSettlOpno);
        SupQueryResult ocContractSettlDomainSupQueryResult = this.ocContractServiceRepository.queryContractSettlPage(paramMap);
        if (null == ocContractSettlDomainSupQueryResult || ListUtil.isEmpty((Collection)ocContractSettlDomainSupQueryResult.getList())) {
            return null;
        }
        ArrayList<PmOcUsageStatistics> pmOcUsageStatisticsList = new ArrayList<PmOcUsageStatistics>();
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlDomainSupQueryResult.getList()) {
            Map getContractMap = this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{ocContractSettlDomain.getContractBillcode(), tenantCode});
            OcContractReDomain contractByCode = this.ocContractServiceRepository.getContractByCode(getContractMap);
            PmOcUsageStatistics pmOcUsageStatistics = new PmOcUsageStatistics();
            try {
                BeanUtils.copyAllPropertys((Object)pmOcUsageStatistics, (Object)ocContractSettlDomain);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pmOcUsageStatistics.setPromotionName(promotionByCode.getPromotionName());
            pmOcUsageStatistics.setContractMoney(contractByCode.getContractMoney());
            pmOcUsageStatisticsList.add(pmOcUsageStatistics);
        }
        SupQueryResult pmOcUsageStatisticsSupQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)pmOcUsageStatisticsSupQueryResult, (Object)ocContractSettlDomainSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pmOcUsageStatisticsSupQueryResult.setList(pmOcUsageStatisticsList);
        pmOcUsageStatisticsSupQueryResult.setRows(pmOcUsageStatisticsList);
        return pmOcUsageStatisticsSupQueryResult;
    }

    @RequestMapping(value={"activitiesReviewed.json"}, name="\u6d3b\u52a8\u5f85\u5ba1\u6838\u6570\u91cf")
    @ResponseBody
    public SupQueryResult activitiesReviewed(HttpServletRequest request) {
        SupQueryResult<PmPromotionReDomain> pmPromotionReDomainSupQueryResult = this.promotionPage(request, null, null, null, ORGIN_0);
        SupQueryResult supQueryResult = new SupQueryResult();
        supQueryResult.setTotal((long)pmPromotionReDomainSupQueryResult.getList().size());
        return supQueryResult;
    }

    @RequestMapping(value={"getPromotionByGroupCode.json"}, name="\u83b7\u53d6\u6307\u5b9a\u56e2\u957f\u7684\u6298\u6263\u5377")
    @ResponseBody
    public PmPromotionReDomain getPromotionByGroupCode(HttpServletRequest request, String groupCode) {
        if (StringUtils.isBlank((String)groupCode)) {
            return null;
        }
        HashedMap parMap = new HashedMap();
        parMap.put("tenantCode", this.getTenantCode(request));
        parMap.put("dataState", 1);
        parMap.put("pbCode", "0005");
        parMap.put("activationMode", 0);
        SupQueryResult pmPromotionReDomainSupQueryResult = this.pmPromotionServiceRepository.queryPromotionPage((Map)parMap);
        if (null == pmPromotionReDomainSupQueryResult || ListUtil.isEmpty((Collection)pmPromotionReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".savePromotionMem.pmPromotionReDomainSupQueryResult.null", (Object)parMap);
            return null;
        }
        for (PmPromotionReDomain pmPromotionReDomain : pmPromotionReDomainSupQueryResult.getList()) {
            if (0 == pmPromotionReDomain.getPromotionMem()) {
                return pmPromotionReDomain;
            }
            for (PmPromotionMemDomain pmPromotionMemDomain : pmPromotionReDomain.getPmPromotionMemList()) {
                if (!groupCode.equals(pmPromotionMemDomain.getPpmemMemcode())) continue;
                return pmPromotionReDomain;
            }
        }
        return null;
    }

    @RequestMapping(value={"savePromotionStr.json"}, name="\u589e\u52a0\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionStr(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlusStr(request, paramStr, null, null);
    }

    private HtmlJsonReBean savePromotionPlusStr(HttpServletRequest request, String paramStr, String channelCode, String memberCode) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".savePromotionStr", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".savePromotionStr", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = this.makeRangeList(request, paramStr);
        if (null == promotionDomain) {
            this.logger.error(CODE + ".savePromotionPlusStr.promotionDomain", (Object)"promotionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u589e\u52a0\u6d3b\u52a8\u6570\u636e\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((String)channelCode)) {
            ArrayList<PmPromotionDisDomain> pmPromotionDisLists = new ArrayList<PmPromotionDisDomain>();
            PmPromotionDisDomain pmPromotionDisDomain = new PmPromotionDisDomain();
            pmPromotionDisDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            pmPromotionDisDomain.setChannelName(userSession.getUserName());
            pmPromotionDisDomain.setMemberCode(userSession.getUserPcode());
            pmPromotionDisDomain.setMemberName(userSession.getUserName());
            pmPromotionDisLists.add(pmPromotionDisDomain);
            promotionDomain.setPmPromotionDisList(pmPromotionDisLists);
        }
        if (StringUtils.isNotBlank((String)memberCode)) {
            ArrayList<PmPromotionMemDomain> pmPromotionMemlists = new ArrayList<PmPromotionMemDomain>();
            PmPromotionMemDomain pmPromotionMemDomain = new PmPromotionMemDomain();
            pmPromotionMemDomain.setMemberCode(userSession.getUserPcode());
            pmPromotionMemDomain.setMemberName(userSession.getUserName());
            pmPromotionMemlists.add(pmPromotionMemDomain);
            promotionDomain.setPmPromotionMemList(pmPromotionMemlists);
        }
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(userSession.getUserPcode());
        promotionDomain.setMemberName(userSession.getMerberCompname());
        promotionDomain.setAppmanageIcode(this.getProappCode(request));
        return this.pmPromotionServiceRepository.savePromotion(promotionDomain);
    }

    @RequestMapping(value={"updatePromotionStr.json"}, name="\u66f4\u65b0\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStr(HttpServletRequest request, String paramStr) {
        return this.updatePromotionPlusStr(request, paramStr);
    }

    private HtmlJsonReBean updatePromotionPlusStr(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updatePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updatePromotion", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = this.makeRangeList(request, paramStr);
        if (null == promotionDomain) {
            this.logger.error(CODE + ".updatePromotionPlusStr.promotionDomain", (Object)"promotionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4fee\u6539\u6570\u636e\u4e3a\u7a7a");
        }
        if (null == promotionDomain.getPromotionId()) {
            this.logger.error(CODE + ".updatePromotion.PromotionId", (Object)"promotionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(userSession.getUserPcode());
        promotionDomain.setMemberName(userSession.getUserName());
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionServiceRepository.getPromotion(promotionDomain.getPromotionId());
        if (null == pmPromotionReDomain || pmPromotionReDomain.getDataState() == 1 || pmPromotionReDomain.getDataState() == 2 || pmPromotionReDomain.getDataState() == 3) {
            this.logger.error(CODE + ".updatePromotion", (Object)" datastate canot update");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8425\u9500\u6d3b\u52a8\u5df2\u7ecf\u5f00\u59cb\u6216\u7ed3\u675f\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        HtmlJsonReBean htmlJsonReBean = this.pmPromotionServiceRepository.updatePromotion(promotionDomain);
        if (!"success".equals(htmlJsonReBean.getSysRecode())) {
            this.logger.error(CODE + ".updatePromotion", (Object)"htmlJsonReBean.getSysRecode() is error");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4fee\u6539\u5931\u8d25");
        }
        PmPromotionReDomain pmPromotionReDo = this.pmPromotionServiceRepository.getPromotion(Integer.valueOf(promotionDomain.getPromotionId()));
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionDomain.getPromotionId()), Integer.valueOf(0), pmPromotionReDo.getDataState());
    }

    public PmPromotionDomain makeRangeList(HttpServletRequest request, String paramStr) {
        SupQueryResult skuPage;
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (null == promotionDomain) {
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        promotionDomain.setClasstreeShopcode(userSession.getUserCode());
        List pmPromotionRangelistDomains = promotionDomain.getPmPromotionRangeList();
        List pmPromotionDiscountList = promotionDomain.getPmPromotionDiscountList();
        if (ListUtil.isNotEmpty((Collection)pmPromotionDiscountList) && ListUtil.isNotEmpty((Collection)((PmPromotionDiscountDomain)pmPromotionDiscountList.get(0)).getPmPromotionDiscountlistList())) {
            HashMap<String, String> para = new HashMap<String, String>();
            para.put("tenantCode", this.getTenantCode(request));
            ArrayList<PmPromotionDiscountlistDomain> Discountlist = new ArrayList<PmPromotionDiscountlistDomain>();
            ArrayList<PmPromotionDiscountlistDomain> removeDiscountlist = new ArrayList<PmPromotionDiscountlistDomain>();
            for (PmPromotionDiscountlistDomain pmDiscountlistDomain : ((PmPromotionDiscountDomain)pmPromotionDiscountList.get(0)).getPmPromotionDiscountlistList()) {
                para.put("goodsCode", pmDiscountlistDomain.getGoodsCode());
                para.put("spuCode", pmDiscountlistDomain.getPpdlOpurl3());
                skuPage = this.rsSkuServiceRepository.querySkuPage(para);
                pmDiscountlistDomain.setPpdlOpurl3(null);
                if (ListUtil.isNotEmpty((Collection)skuPage.getList())) {
                    for (RsSkuReDomain skuReDomain : skuPage.getList()) {
                        PmPromotionDiscountlistDomain promotionDiscountlistDomain = new PmPromotionDiscountlistDomain();
                        if (!StringUtils.isNotBlank((String)skuReDomain.getSkuCode())) continue;
                        try {
                            BeanUtils.copyAllPropertys((Object)promotionDiscountlistDomain, (Object)pmDiscountlistDomain);
                            BeanUtils.copyAllPropertys((Object)promotionDiscountlistDomain, (Object)skuReDomain);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        promotionDiscountlistDomain.setPpdlOpurl(skuReDomain.getDataPic());
                        promotionDiscountlistDomain.setPpdlOpname(skuReDomain.getSkuName());
                        promotionDiscountlistDomain.setSkuNo(skuReDomain.getSkuNo());
                        promotionDiscountlistDomain.setSkuShowno(skuReDomain.getSkuShowno());
                        promotionDiscountlistDomain.setGoodsCode(skuReDomain.getGoodsCode());
                        Discountlist.add(promotionDiscountlistDomain);
                    }
                }
                removeDiscountlist.add(pmDiscountlistDomain);
            }
            ((PmPromotionDiscountDomain)promotionDomain.getPmPromotionDiscountList().get(0)).getPmPromotionDiscountlistList().removeAll(removeDiscountlist);
            ((PmPromotionDiscountDomain)promotionDomain.getPmPromotionDiscountList().get(0)).setPmPromotionDiscountlistList(Discountlist);
        }
        if (ListUtil.isNotEmpty((Collection)pmPromotionRangelistDomains)) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("tenantCode", this.getTenantCode(request));
            ArrayList<PmPromotionRangelistDomain> rengelist = new ArrayList<PmPromotionRangelistDomain>();
            ArrayList<PmPromotionRangelistDomain> removeRengelist = new ArrayList<PmPromotionRangelistDomain>();
            for (PmPromotionRangelistDomain pmProRangelist : pmPromotionRangelistDomains) {
                param.put("goodsCode", pmProRangelist.getGoodsCode());
                param.put("spuCode", pmProRangelist.getPprlOpurl3());
                skuPage = this.rsSkuServiceRepository.querySkuPage(param);
                pmProRangelist.setPprlOpurl3(null);
                if (ListUtil.isNotEmpty((Collection)skuPage.getList())) {
                    for (RsSkuReDomain skuReDomain : skuPage.getList()) {
                        PmPromotionRangelistDomain pmProRangelistDomain = new PmPromotionRangelistDomain();
                        if (!StringUtils.isNotBlank((String)skuReDomain.getSkuCode())) continue;
                        try {
                            BeanUtils.copyAllPropertys((Object)pmProRangelistDomain, (Object)pmProRangelist);
                            BeanUtils.copyAllPropertys((Object)pmProRangelistDomain, (Object)skuReDomain);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        pmProRangelistDomain.setPprlOpurl(skuReDomain.getDataPic());
                        pmProRangelistDomain.setPprlOpname(skuReDomain.getSkuName());
                        pmProRangelistDomain.setSkuCode(skuReDomain.getSkuCode());
                        pmProRangelistDomain.setSkuNo(skuReDomain.getSkuNo());
                        pmProRangelistDomain.setSkuShowno(skuReDomain.getSkuShowno());
                        rengelist.add(pmProRangelistDomain);
                    }
                }
                removeRengelist.add(pmProRangelist);
            }
            this.logger.error("removeRengelist:" + JsonUtil.buildNonEmptyBinder().jsonObject(removeRengelist));
            this.logger.error("rengelist:" + JsonUtil.buildNonEmptyBinder().jsonObject(rengelist));
            promotionDomain.getPmPromotionRangeList().removeAll(removeRengelist);
            promotionDomain.setPmPromotionRangeList(rengelist);
            this.logger.error("promotionDomain:" + JsonUtil.buildNonEmptyBinder().toJson((Object)promotionDomain));
        }
        return promotionDomain;
    }

    @RequestMapping(value={"savePromotionFullGiftToStr.json"}, name="\u589e\u52a0\u6ee1\u8d60\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionFullGiftToStr(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlusStr(request, paramStr, null, null);
    }

    @RequestMapping(value={"updatePromotionFullGiftToStr.json"}, name="\u66f4\u65b0\u6ee1\u8d60\u6d3b\u52a8\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotionFullGiftToStr(HttpServletRequest request, String paramStr) {
        return this.updatePromotionPlusStr(request, paramStr);
    }

    @RequestMapping(value={"savePromotionCasheQuivalentToStr.json"}, name="\u589e\u52a0\u4ee3\u91d1\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionCasheQuivalentToStr(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlusStr(request, paramStr, null, null);
    }

    @RequestMapping(value={"updatePromotionDisState.json"}, name="\u66f4\u65b0\u8425\u9500\u6e20\u9053\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePromotionDisState(HttpServletRequest request, String promotionCode, String pmTargetListStr) {
        if (StringUtils.isBlank((String)promotionCode) && StringUtils.isBlank((String)pmTargetListStr)) {
            this.logger.error(CODE + ".updatePromotionDisState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List promotionTargetlistDoList = (List)JsonUtil.buildNormalBinder().getJsonToList(pmTargetListStr, PmPromotionTargetlistDomain.class);
        if (ListUtil.isEmpty((Collection)promotionTargetlistDoList)) {
            this.logger.error(CODE + ".updatePromotionDisState", (Object)"promotionTargetlistDoList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        HashMap<String, CharSequence> param = new HashMap<String, CharSequence>();
        param.put("tenantCode", this.getTenantCode(request));
        param.put("promotionCode", promotionCode);
        param.put("userCode", userSession.getUserCode());
        for (PmPromotionTargetlistDomain pmPromotionTar : promotionTargetlistDoList) {
            param.put("targetCode", pmPromotionTar.getTargetCode());
            SupQueryResult pmTargetList = this.pmPromotionTargetlistServiceRepository.queryPromotionTargetlistPage(param);
            if (!ListUtil.isNotEmpty((Collection)pmTargetList.getList())) continue;
            this.logger.error(CODE + ".updatePromotionDisState", (Object)"\u8be5\u7528\u6237\u5df2\u53c2\u4e0e");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u7528\u6237\u5df2\u53c2\u4e0e");
        }
        param.remove("targetCode");
        param.remove("userCode");
        HtmlJsonReBean htmlJsonReBean = this.pmPromotionTargetlistServiceRepository.savePromotionTargetlistBatch(promotionTargetlistDoList);
        if (!"success".equals(htmlJsonReBean.getSysRecode())) {
            this.logger.error(CODE + ".updatePromotionDisState", (Object)"\u6dfb\u52a0\u5ba2\u6237\u5931\u8d25");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6dfb\u52a0\u5ba2\u6237\u5931\u8d25");
        }
        SupQueryResult pmPromotionDisReDoma = this.pmPromotionDisServiceRepository.queryPromotionDisPage(param);
        if (ListUtil.isEmpty((Collection)pmPromotionDisReDoma.getList())) {
            this.logger.error(CODE + ".updatePromotionDisState", (Object)"pmPromotionDisReDoma");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u4e0e\u6e20\u9053\u4e3a\u7a7a");
        }
        SupQueryResult<DisChannelReDomain> disChannelReDomainSupQueryResult = this.getDisChannelList(request);
        if (ListUtil.isEmpty((Collection)disChannelReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".updatePromotionDisState", (Object)"disChannelReDomainSupQueryResult");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u4e0e\u6e20\u9053\u4e3a\u7a7a");
        }
        StringBuilder builder = new StringBuilder();
        for (DisChannelReDomain disChannelReDomain : disChannelReDomainSupQueryResult.getList()) {
            builder.append(disChannelReDomain.getChannelCode() + ",");
        }
        param.put("channelCode", builder);
        param.put("promotionCode", promotionCode);
        SupQueryResult pmPromotionDisReDomainSupQueryResult = this.pmPromotionDisServiceRepository.queryPromotionDisPage(param);
        if (ListUtil.isEmpty((Collection)pmPromotionDisReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".updatePromotionDisState", (Object)"pmPromotionDisReDomainSupQueryResult");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8425\u9500\u6e20\u9053\u4e3a\u7a7a");
        }
        for (PmPromotionDisReDomain pmPromotionDisReDomainSup : pmPromotionDisReDomainSupQueryResult.getList()) {
            this.pmPromotionDisServiceRepository.updatePromotionDisStateByCode(this.getTenantCode(request), pmPromotionDisReDomainSup.getPpdisCode(), Integer.valueOf(1), Integer.valueOf(0), null);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"queryPromotionPageFullReductionToStr.json"}, name="\u67e5\u8be2\u6ee1\u51cf\u6ee1\u8d60\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageFullReductionToStr(HttpServletRequest request) {
        Map para = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updatePromotion", (Object)"userSession is null");
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult<DisChannelReDomain> disChannelReDomainSupQueryResult = this.getDisChannelList(request);
        if (ListUtil.isEmpty((Collection)disChannelReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryPromotionPageFullReductionToStr", (Object)"disChannelReDomainSupQueryResult is null");
            return null;
        }
        ArrayList<String> disList = new ArrayList<String>();
        for (Object disChannelReDomain : disChannelReDomainSupQueryResult.getList()) {
            param.put("channelCode", disChannelReDomain.getChannelCode());
            SupQueryResult supQueryResult = this.pmPromotionDisServiceRepository.queryPromotionDisPage(param);
            if (!ListUtil.isNotEmpty((Collection)supQueryResult.getList())) continue;
            for (PmPromotionDisReDomain dis : supQueryResult.getList()) {
                disList.add(dis.getPromotionCode());
            }
        }
        param.remove("channelCode");
        if (ListUtil.isEmpty(disList)) {
            this.logger.error(CODE + ".queryPromotionPageFullReductionToStr", (Object)"disList is null");
            return null;
        }
        ArrayList<String> stringPmProCodes = new ArrayList<String>();
        for (String string : disList) {
            if (stringPmProCodes.contains(string)) continue;
            stringPmProCodes.add(string);
        }
        if (ListUtil.isEmpty(stringPmProCodes)) {
            this.logger.error(CODE + ".queryPromotionPageFullReductionToStr", (Object)"stringPmProCodes is null");
            return null;
        }
        this.logger.error("stringPmProCode:" + JsonUtil.buildNormalBinder().toJson(stringPmProCodes));
        StringBuilder builder = new StringBuilder();
        for (String pmProCodes : stringPmProCodes) {
            builder.append(pmProCodes + ",");
        }
        para.put("promotionCode", builder);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0002,");
        stringBuilder.append("0001,");
        para.put("pbCode", stringBuilder);
        StringBuilder builder1 = new StringBuilder();
        builder1.append("1,");
        builder1.append("2,");
        builder1.append("4,");
        para.put("dataStateStr", builder1);
        SupQueryResult pmPromotionReDomainSupQu = this.pmPromotionServiceRepository.queryPromotionPage(para);
        if (ListUtil.isEmpty((Collection)pmPromotionReDomainSupQu.getList())) {
            this.logger.error(CODE + ".queryPromotionPageFullReductionToStr", (Object)"pmPromotionReDomainSupQu is null");
            return null;
        }
        HashMap<String, String> par = new HashMap<String, String>();
        par.put("tenantCode", this.getTenantCode(request));
        par.put("userCode", userSession.getUserCode());
        for (PmPromotionReDomain promotionReDomain : pmPromotionReDomainSupQu.getList()) {
            par.put("promotionCode", promotionReDomain.getPromotionCode());
            SupQueryResult pmTargetList = this.pmPromotionTargetlistServiceRepository.queryPromotionTargetlistPage(par);
            if (!ListUtil.isEmpty((Collection)pmTargetList.getList())) continue;
            promotionReDomain.setDataState(Integer.valueOf(10));
        }
        return pmPromotionReDomainSupQu;
    }

    public SupQueryResult<DisChannelReDomain> getDisChannelList(HttpServletRequest request) {
        HashMap<String, CharSequence> param = new HashMap<String, CharSequence>();
        param.put("tenantCode", this.getTenantCode(request));
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updatePromotion", (Object)"userSession is null");
            return null;
        }
        param.put("userCode", userSession.getUserCode());
        SupQueryResult domainSupQueryResult = this.orgEmployeeServiceRepository.queryEmployeePage(param);
        if (ListUtil.isEmpty((Collection)domainSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryPromotionPageFullReductionToStr", (Object)"domainSupQueryResult is null");
            return null;
        }
        param.remove("userCode");
        param.put("employeeCode", ((OrgEmployeeReDomain)domainSupQueryResult.getList().get(0)).getEmployeeCode());
        SupQueryResult departempReDomainSupQueryResult = this.orgDepartServiceRepository.queryDepartempPage(param);
        if (ListUtil.isEmpty((Collection)departempReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryPromotionPageFullReductionToStr", (Object)"departempReDomainSupQueryResult is null");
            return null;
        }
        param.remove("employeeCode");
        ArrayList list = new ArrayList();
        param.put("userinfoQuality", "depart");
        StringBuilder build = new StringBuilder();
        for (Object orgDepartempReDomain : departempReDomainSupQueryResult.getList()) {
            build.append(orgDepartempReDomain.getDepartCode() + ",");
        }
        param.put("departCode", build);
        SupQueryResult umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(param);
        this.logger.error("umUserinfoReDomainBeanSupQueryResult:" + JsonUtil.buildNormalBinder().toJson((Object)umUserinfoReDomainBeanSupQueryResult.getList()));
        if (ListUtil.isEmpty((Collection)umUserinfoReDomainBeanSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryPromotionPageFullReductionToStr", (Object)"umUserinfoReDomainBeanSupQueryResult is null");
            return null;
        }
        param.remove("departCode");
        param.remove("userinfoQuality");
        build.delete(0, build.length());
        for (UmUserinfoReDomainBean userinfoDomain : umUserinfoReDomainBeanSupQueryResult.getList()) {
            build.append(userinfoDomain.getUserinfoCode() + ",");
        }
        build.append(userSession.getUserPcode() + ",");
        param.put("memberCode", build);
        SupQueryResult disChannelReDomainSupQueryResult = this.disChannelServiceRepository.queryChannelPage(param);
        this.logger.error("disChannelReDomainSupQueryResult:" + JsonUtil.buildNormalBinder().toJson((Object)disChannelReDomainSupQueryResult.getList()));
        if (ListUtil.isEmpty((Collection)disChannelReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryPromotionPageFullReductionToStr", (Object)"disChannelReDomainSupQueryResult is null");
            return null;
        }
        return disChannelReDomainSupQueryResult;
    }
}

