/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pro.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectDomain;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectReDomain;
import com.qjsoft.laser.controller.facade.pro.repository.ProProjectServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pro/project"}, name="\u9879\u76ee")
public class ProjectCon
extends SpringmvcController {
    private static String CODE = "pro.project.con";
    @Autowired
    private ProProjectServiceRepository proProjectServiceRepository;

    protected String getContext() {
        return "project";
    }

    @RequestMapping(value={"saveProject.json"}, name="\u589e\u52a0\u9879\u76ee")
    @ResponseBody
    public HtmlJsonReBean saveProject(HttpServletRequest request, ProProjectDomain proProjectDomain) {
        if (null == proProjectDomain) {
            this.logger.error(CODE + ".saveProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        proProjectDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectServiceRepository.saveProject(proProjectDomain);
    }

    @RequestMapping(value={"getProject.json"}, name="\u83b7\u53d6\u9879\u76ee\u4fe1\u606f")
    @ResponseBody
    public ProProjectReDomain getProject(Integer projectId) {
        if (StringUtils.isBlank((Integer)projectId)) {
            this.logger.error(CODE + ".getProject", (Object)"param is null");
            return null;
        }
        return this.proProjectServiceRepository.getProject(projectId);
    }

    @RequestMapping(value={"updateProject.json"}, name="\u66f4\u65b0\u9879\u76ee")
    @ResponseBody
    public HtmlJsonReBean updateProject(HttpServletRequest request, ProProjectDomain proProjectDomain) {
        if (null == proProjectDomain) {
            this.logger.error(CODE + ".updateProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        proProjectDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectServiceRepository.updateProject(proProjectDomain);
    }

    @RequestMapping(value={"deleteProject.json"}, name="\u5220\u9664\u9879\u76ee")
    @ResponseBody
    public HtmlJsonReBean deleteProject(Integer projectId) {
        if (StringUtils.isBlank((Integer)projectId)) {
            this.logger.error(CODE + ".deleteProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.proProjectServiceRepository.deleteProject(projectId);
    }

    @RequestMapping(value={"queryProjectPage.json"}, name="\u67e5\u8be2\u9879\u76ee\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectReDomain> queryProjectPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectServiceRepository.queryProjectPage(param);
    }

    @RequestMapping(value={"updateProjectState.json"}, name="\u66f4\u65b0\u9879\u76ee\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateProjectState(String projectId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)projectId)) {
            this.logger.error(CODE + ".updateProjectState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.proProjectServiceRepository.updateProjectState(Integer.valueOf(projectId), dataState, oldDataState);
    }
}

