/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pro.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectTaskDomain;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectTaskReDomain;
import com.qjsoft.laser.controller.facade.pro.repository.ProProjectTaskServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pro/projectTask"}, name="\u9879\u76ee\u4efb\u52a1")
public class ProjectTaskCon
extends SpringmvcController {
    private static String CODE = "pro.projectTask.con";
    @Autowired
    private ProProjectTaskServiceRepository proProjectTaskServiceRepository;

    protected String getContext() {
        return "projectTask";
    }

    @RequestMapping(value={"saveProjectTask.json"}, name="\u589e\u52a0\u9879\u76ee\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveProjectTask(HttpServletRequest request, ProProjectTaskDomain proProjectTaskDomain) {
        if (null == proProjectTaskDomain) {
            this.logger.error(CODE + ".saveProjectTask", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        proProjectTaskDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectTaskServiceRepository.saveProjectTask(proProjectTaskDomain);
    }

    @RequestMapping(value={"getProjectTask.json"}, name="\u83b7\u53d6\u9879\u76ee\u4efb\u52a1\u4fe1\u606f")
    @ResponseBody
    public ProProjectTaskReDomain getProjectTask(Integer projectTaskId) {
        if (StringUtils.isBlank((Integer)projectTaskId)) {
            this.logger.error(CODE + ".getProjectTask", (Object)"param is null");
            return null;
        }
        return this.proProjectTaskServiceRepository.getProjectTask(projectTaskId);
    }

    @RequestMapping(value={"updateProjectTask.json"}, name="\u66f4\u65b0\u9879\u76ee\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateProjectTask(HttpServletRequest request, ProProjectTaskDomain proProjectTaskDomain) {
        if (null == proProjectTaskDomain) {
            this.logger.error(CODE + ".updateProjectTask", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        proProjectTaskDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectTaskServiceRepository.updateProjectTask(proProjectTaskDomain);
    }

    @RequestMapping(value={"deleteProjectTask.json"}, name="\u5220\u9664\u9879\u76ee\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteProjectTask(Integer projectTaskId) {
        if (StringUtils.isBlank((Integer)projectTaskId)) {
            this.logger.error(CODE + ".deleteProjectTask", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.proProjectTaskServiceRepository.deleteProjectTask(projectTaskId);
    }

    @RequestMapping(value={"queryProjectTaskPage.json"}, name="\u67e5\u8be2\u9879\u76ee\u4efb\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectTaskReDomain> queryProjectTaskPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectTaskServiceRepository.queryProjectTaskPage(param);
    }

    @RequestMapping(value={"updateProjectTaskState.json"}, name="\u66f4\u65b0\u9879\u76ee\u4efb\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateProjectTaskState(String projectTaskId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)projectTaskId)) {
            this.logger.error(CODE + ".updateProjectTaskState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.proProjectTaskServiceRepository.updateProjectTaskState(Integer.valueOf(projectTaskId), dataState, oldDataState);
    }
}

