/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pro.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectDomain;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectFileDomain;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectFileReDomain;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectReDomain;
import com.qjsoft.laser.controller.facade.pro.repository.ProProjectServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pro/project"}, name="\u9879\u76ee")
public class ProjectCon
extends SpringmvcController {
    private static String CODE = "pro.project.con";
    @Autowired
    private ProProjectServiceRepository proProjectServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;

    protected String getContext() {
        return "project";
    }

    @RequestMapping(value={"saveProject.json"}, name="\u589e\u52a0\u9879\u76ee")
    @ResponseBody
    public HtmlJsonReBean saveProject(HttpServletRequest request, ProProjectDomain proProjectDomain) {
        if (null == proProjectDomain) {
            this.logger.error(CODE + ".saveProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        proProjectDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectServiceRepository.saveProject(proProjectDomain);
    }

    @RequestMapping(value={"getProject.json"}, name="\u83b7\u53d6\u9879\u76ee\u4fe1\u606f")
    @ResponseBody
    public ProProjectReDomain getProject(Integer projectId) {
        if (StringUtils.isBlank((Integer)projectId)) {
            this.logger.error(CODE + ".getProject", (Object)"param is null");
            return null;
        }
        return this.proProjectServiceRepository.getProject(projectId);
    }

    @RequestMapping(value={"updateProject.json"}, name="\u66f4\u65b0\u9879\u76ee")
    @ResponseBody
    public HtmlJsonReBean updateProject(HttpServletRequest request, ProProjectDomain proProjectDomain) {
        if (null == proProjectDomain) {
            this.logger.error(CODE + ".updateProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        proProjectDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectServiceRepository.updateProject(proProjectDomain);
    }

    @RequestMapping(value={"deleteProject.json"}, name="\u5220\u9664\u9879\u76ee")
    @ResponseBody
    public HtmlJsonReBean deleteProject(Integer projectId) {
        if (StringUtils.isBlank((Integer)projectId)) {
            this.logger.error(CODE + ".deleteProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.proProjectServiceRepository.deleteProject(projectId);
    }

    @RequestMapping(value={"queryProjectPage.json"}, name="\u67e5\u8be2\u9879\u76ee\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectReDomain> queryProjectPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectServiceRepository.queryProjectPage(param);
    }

    @RequestMapping(value={"updateProjectState.json"}, name="\u66f4\u65b0\u9879\u76ee\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateProjectState(String projectId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)projectId)) {
            this.logger.error(CODE + ".updateProjectState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.proProjectServiceRepository.updateProjectState(Integer.valueOf(projectId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryProjectFilePage.json"}, name="\u9879\u76ee\u9644\u4ef6\u5206\u9875\u67e5\u8be2")
    @ResponseBody
    public SupQueryResult<ProProjectFileReDomain> queryProjectFilePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectServiceRepository.queryProjectFilePage(param);
    }

    @RequestMapping(value={"saveProjectFile.json"}, name="\u9879\u76ee\u9644\u4ef6\u65b0\u589e")
    @ResponseBody
    public HtmlJsonReBean saveProjectFile(HttpServletRequest request, ProProjectFileDomain proProjectFileDomain) {
        if (null == proProjectFileDomain) {
            this.logger.error(CODE + ".saveProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        proProjectFileDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectServiceRepository.saveProjectFile(proProjectFileDomain);
    }

    private void makeChannel(RsResourceGoodsDomain rsResourceGoodsDomain, HttpServletRequest request) {
        String[] s;
        if (null == rsResourceGoodsDomain || null == request) {
            return;
        }
        String channelInfo = this.getChannel(request);
        if (StringUtils.isNotBlank((String)channelInfo) && null != (s = channelInfo.split(",")) && s.length > 1) {
            rsResourceGoodsDomain.setChannelCode(s[0]);
            rsResourceGoodsDomain.setChannelName(s[1]);
        }
    }

    @RequestMapping(value={"updateProjectShelfState.json"}, name="\u9879\u76ee\u4e0a\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateProjectShelfState(HttpServletRequest request, String projectId) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)projectId)) {
            this.logger.error(CODE + ".updateProjectShelfState", (Object)"param is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        ProProjectReDomain proProjectReDomain = this.proProjectServiceRepository.getProjectReDomain(Integer.valueOf(projectId));
        if (null == proProjectReDomain) {
            this.logger.error(CODE + ".updateProjectShelfState", (Object)"proProjectReDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "proProjectReDomain");
        }
        map.put("goodsOrigin", "4");
        map.put("goodsNo", proProjectReDomain.getProjectCode());
        map.put("tenantCode", proProjectReDomain.getTenantCode());
        SupQueryResult rsList = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(map);
        if (null == rsList || null == rsList.getRows() || rsList.getRows().isEmpty()) {
            RsResourceGoodsDomain rsResourceGoodsDomain = this.make(request, proProjectReDomain);
            this.rsResourceGoodsServiceRepository.saveResourceGoods(rsResourceGoodsDomain);
        }
        return this.proProjectServiceRepository.updateProjectReleaseByCode(proProjectReDomain.getTenantCode(), proProjectReDomain.getProjectCode(), Integer.valueOf(1), Integer.valueOf(0));
    }

    private RsResourceGoodsDomain make(HttpServletRequest request, ProProjectReDomain proProjectReDomain) {
        if (null == proProjectReDomain || null == request) {
            return null;
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        rsResourceGoodsDomain.setGoodsName(proProjectReDomain.getProjectName());
        rsResourceGoodsDomain.setGoodsCode(proProjectReDomain.getProjectCode());
        rsResourceGoodsDomain.setClasstreeCode(proProjectReDomain.getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(proProjectReDomain.getClasstreeName());
        rsResourceGoodsDomain.setMemberCode(proProjectReDomain.getCompanyCode());
        rsResourceGoodsDomain.setGoodsType(proProjectReDomain.getProjectType());
        rsResourceGoodsDomain.setPricesetNprice(proProjectReDomain.getProjectMinprice());
        rsResourceGoodsDomain.setPricesetBaseprice(proProjectReDomain.getProjectMaxprice());
        rsResourceGoodsDomain.setDataOpbillstate(Integer.valueOf(1));
        this.makeChannel(rsResourceGoodsDomain, request);
        return rsResourceGoodsDomain;
    }

    @RequestMapping(value={"updateProjectLowerState.json"}, name="\u9879\u76ee\u4e0b\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateProjectLowerState(HttpServletRequest request, String projectCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)projectCode)) {
            this.logger.error(CODE + ".updateProjectState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        map.put("goodsOrigin", "4");
        map.put("goodsNo", projectCode);
        map.put("tenantCode", tenantCode);
        this.rsResourceGoodsServiceRepository.delResourceGoodsByCode(map);
        return this.proProjectServiceRepository.updateProjectReleaseByCode(tenantCode, projectCode, Integer.valueOf(0), Integer.valueOf(1));
    }

    @RequestMapping(value={"queryProjectPageByUserCodeForC.json"}, name="C\u7aef\u67e5\u8be2\u9879\u76ee\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectReDomain> queryProjectPageByUserCodeForC(HttpServletRequest request, String custrelCode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("custrelCode", custrelCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectServiceRepository.queryProjectPage(param);
    }

    @RequestMapping(value={"queryProjectFilePageByProjectCodeForC.json"}, name="C\u7aef\u9879\u76ee\u9644\u4ef6\u5206\u9875\u67e5\u8be2")
    @ResponseBody
    public SupQueryResult<ProProjectFileReDomain> queryProjectFilePage(HttpServletRequest request, String projectCode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("projectCode", projectCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectServiceRepository.queryProjectFilePage(param);
    }

    @RequestMapping(value={"saveProjectFileForB.json"}, name="B\u7aef\u9879\u76ee\u9644\u4ef6\u65b0\u589e")
    @ResponseBody
    public HtmlJsonReBean saveProjectFileForB(HttpServletRequest request, ProProjectFileDomain proProjectFileDomain) {
        if (null == proProjectFileDomain) {
            this.logger.error(CODE + ".saveProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        proProjectFileDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectServiceRepository.saveProjectFile(proProjectFileDomain);
    }
}

