/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pte.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.pte.domain.PteBalancelistDomain;
import com.qjsoft.laser.controller.facade.pte.domain.PteBalancelistReDomain;
import com.qjsoft.laser.controller.facade.pte.repository.PteBalancelistServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pte/balancelist"}, name="\u7ed3\u7b97\u6d41\u6c34")
public class PteBalancelistCon
extends SpringmvcController {
    private static String CODE = "pte.balancelist.con";
    @Autowired
    private PteBalancelistServiceRepository pteBalancelistServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;

    protected String getContext() {
        return "balancelist";
    }

    @RequestMapping(value={"saveBalancelist.json"}, name="\u589e\u52a0\u7ed3\u7b97\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean saveBalancelist(HttpServletRequest request, PteBalancelistDomain pteBalancelistDomain) {
        if (null == pteBalancelistDomain) {
            this.logger.error(CODE + ".saveBalancelist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pteBalancelistDomain.setTenantCode(this.getTenantCode(request));
        return this.pteBalancelistServiceRepository.saveBalancelist(pteBalancelistDomain);
    }

    @RequestMapping(value={"getBalancelist.json"}, name="\u83b7\u53d6\u7ed3\u7b97\u6d41\u6c34\u4fe1\u606f")
    @ResponseBody
    public PteBalancelistReDomain getBalancelist(Integer pteBalancelistId) {
        if (StringUtils.isBlank((Integer)pteBalancelistId)) {
            this.logger.error(CODE + ".getBalancelist", (Object)"param is null");
            return null;
        }
        return this.pteBalancelistServiceRepository.getBalancelist(pteBalancelistId);
    }

    @RequestMapping(value={"updateBalancelist.json"}, name="\u66f4\u65b0\u7ed3\u7b97\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean updateBalancelist(HttpServletRequest request, PteBalancelistDomain pteBalancelistDomain) {
        if (null == pteBalancelistDomain) {
            this.logger.error(CODE + ".updateBalancelist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pteBalancelistDomain.setTenantCode(this.getTenantCode(request));
        return this.pteBalancelistServiceRepository.updateBalancelist(pteBalancelistDomain);
    }

    @RequestMapping(value={"deleteBalancelist.json"}, name="\u5220\u9664\u7ed3\u7b97\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean deleteBalancelist(Integer pteBalancelistId) {
        if (StringUtils.isBlank((Integer)pteBalancelistId)) {
            this.logger.error(CODE + ".deleteBalancelist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pteBalancelistServiceRepository.deleteBalancelist(pteBalancelistId);
    }

    @RequestMapping(value={"queryBalancelistPage.json"}, name="\u67e5\u8be2\u7ed3\u7b97\u6d41\u6c34\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PteBalancelistReDomain> queryBalancelistPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pteBalancelistServiceRepository.queryBalancelistPage(param);
    }

    @RequestMapping(value={"queryBalancelistPageByBcode.json"}, name="\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\uff08\u5356\u5bb6\uff09")
    @ResponseBody
    public SupQueryResult<PteBalancelistReDomain> queryBalancelistPageByBcode(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("memberBcode", userSession.getUserPcode());
            param.put("dataStateStr", "1,-1,2");
        }
        return this.pteBalancelistServiceRepository.queryBalancelistPage(param);
    }

    @RequestMapping(value={"queryBalancelistPageByMemberBcode.json"}, name="\u67e5\u8be2\u7ed3\u7b97\u6c47\u603b\uff08\u5356\u5bb6\uff09")
    @ResponseBody
    public SupQueryResult<PteBalancelistReDomain> queryBalancelistPageBymemberBcode(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("memberBcode", userSession.getUserPcode());
            param.put("dataStateStr", "1,-1,2");
        }
        return this.pteBalancelistServiceRepository.queryBalancelistPage(param);
    }

    @RequestMapping(value={"queryBalancelistPageByState.json"}, name="\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\uff08\u5e73\u53f0\uff09")
    @ResponseBody
    public SupQueryResult<PteBalancelistReDomain> queryBalancelistPageByState(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("dataStateStr", "1,-1,2");
        }
        return this.pteBalancelistServiceRepository.queryBalancelistPage(param);
    }

    @RequestMapping(value={"queryBalancelistPageByUser.json"}, name="\u67e5\u8be2\u5206\u9500\u7ed3\u7b97\u6d41\u6c34\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PteBalancelistReDomain> queryBalancelistPageByUser(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("balanceType", "shsettl");
            param.put("memberCode", userSession.getUserPcode());
        }
        return this.pteBalancelistServiceRepository.queryBalancelistPage(param);
    }

    @RequestMapping(value={"queryBalancelistPageByPlat.json"}, name="\u67e5\u8be2\u5206\u9500\u7ed3\u7b97\u6d41\u6c34\u5206\u9875\u5217\u8868(\u5e73\u53f0)")
    @ResponseBody
    public SupQueryResult<PteBalancelistReDomain> queryBalancelistPageByPlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("balanceType", "shsettl");
        }
        Object memberCode = param.get("memberCode");
        String reStr = "";
        if (null != memberCode) {
            List<String> result = Arrays.asList(memberCode.toString().split(","));
            for (String code : result) {
                HashMap<String, Object> uMap = new HashMap<String, Object>();
                uMap.put("userinfoParentCode", code);
                uMap.put("tenantCode", this.getTenantCode(request));
                uMap.put("fuzzy", true);
                List umUserinfoReDomainBeans = this.userServiceRepository.queryUserinfoList(uMap);
                if (ListUtil.isEmpty((Collection)umUserinfoReDomainBeans)) continue;
                for (UmUserinfoReDomainBean umUserinfoReDomainBean : umUserinfoReDomainBeans) {
                    reStr = reStr + umUserinfoReDomainBean.getUserinfoCode() + ",";
                }
            }
        }
        if (StringUtils.isNotBlank((String)reStr)) {
            reStr = reStr.substring(0, reStr.length() - 1);
            param.put("memberCode", memberCode.toString() + "," + reStr);
        }
        return this.pteBalancelistServiceRepository.queryBalancelistPage(param);
    }

    @RequestMapping(value={"queryBalancelistPageByMemberCcode.json"}, name="\u67e5\u8be2\u5206\u9500\u7ed3\u7b97\u6d41\u6c34\u5206\u9875\u5217\u8868(\u5206\u9500\u5546)")
    @ResponseBody
    public SupQueryResult<PteBalancelistReDomain> queryBalancelistPageByMemberCcode(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("balanceType", "shsettl");
            param.put("memberBcode", userSession.getUserPcode());
        }
        return this.pteBalancelistServiceRepository.queryBalancelistPage(param);
    }

    @RequestMapping(value={"queryBalancelistPageByMemberCcodeOnlyMy.json"}, name="\u67e5\u8be2\u5206\u9500\u7ed3\u7b97\u6d41\u6c34\u5206\u9875\u5217\u8868(\u5206\u9500\u5546)")
    @ResponseBody
    public SupQueryResult<PteBalancelistReDomain> queryBalancelistPageByMemberCcodeOnlyMy(HttpServletRequest request) {
        this.logger.error(CODE + ".queryBalancelistPageByMemberCcodeOnlyMy", (Object)"================================\u67e5\u8be2\u5206\u9500\u7ed3\u7b97\u6d41\u6c34\u5206\u9875\u5217\u8868(\u5206\u9500\u5546)================================");
        Map param = this.assemMapParam(request);
        this.logger.error(CODE + ".queryBalancelistPageByMemberCcodeOnlyMy", (Object)("================================param" + JsonUtil.buildNonEmptyBinder().toJson((Object)param) + "================================"));
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession session = this.getUserSession(request);
        UmUserinfoReDomainBean userInfoByUserinfoCode = this.userServiceRepository.getUserInfoByUserinfoCode(session.getUserPcode(), this.getTenantCode(request));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoParentCode", session.getUserPcode());
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(map);
        ArrayList AllList = new ArrayList();
        List userinfoList = new ArrayList<UmUserinfoReDomainBean>();
        if (umUserinfoReDomainBeanSupQueryResult != null && umUserinfoReDomainBeanSupQueryResult.getList() != null) {
            userinfoList = umUserinfoReDomainBeanSupQueryResult.getList();
        }
        userinfoList.add(userInfoByUserinfoCode);
        for (int i = 0; i < userinfoList.size(); ++i) {
            param.put("memberCode", ((UmUserinfoReDomainBean)userinfoList.get(i)).getUserinfoCode());
            param.put("balanceType", "shsettl");
            param.put("memberBcode", userSession.getUserPcode());
            SupQueryResult pteBalancelistReDomainSupQueryResult = this.pteBalancelistServiceRepository.queryBalancelistPage(param);
            if (pteBalancelistReDomainSupQueryResult == null) continue;
            List list = pteBalancelistReDomainSupQueryResult.getList();
            AllList.addAll(list);
        }
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, (Object)umUserinfoReDomainBeanSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(AllList);
        supQueryResult.setRows(AllList);
        return supQueryResult;
    }

    @RequestMapping(value={"queryBalancelistPagebyMemberCode.json"}, name="\u67e5\u8be2\u5df2\u62bd\u4f63\u5546\u5bb6")
    @ResponseBody
    public SupQueryResult<PteBalancelistReDomain> queryBalancelistPagebyMemberCode(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        HashSet<String> Set2 = new HashSet<String>();
        SupQueryResult supQueryResult = this.pteBalancelistServiceRepository.queryBalancelistPage(param);
        if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            return new SupQueryResult();
        }
        List list2 = supQueryResult.getList();
        for (PteBalancelistReDomain balancelist : list2) {
            String memberCode = balancelist.getMemberCode();
            if (!Set2.contains(memberCode)) {
                Set2.add(memberCode);
                continue;
            }
            list2.remove(balancelist);
        }
        return supQueryResult;
    }

    @RequestMapping(value={"updateBalancelistState.json"}, name="\u66f4\u65b0\u7ed3\u7b97\u6d41\u6c34\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateBalancelistState(String pteBalancelistId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)pteBalancelistId)) {
            this.logger.error(CODE + ".updateBalancelistState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pteBalancelistServiceRepository.updateBalancelistState(Integer.valueOf(pteBalancelistId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateBalancelistStateByStay.json"}, name="\u66f4\u65b0\u7ed3\u7b97\u6d41\u6c34\u72b6\u6001\uff08\u5f85\u786e\u5b9a\uff09")
    @ResponseBody
    public HtmlJsonReBean updateBalancelistStateByStay(HttpServletRequest request, String pteBalancelistCodes) {
        if (StringUtils.isBlank((String)pteBalancelistCodes)) {
            this.logger.error(CODE + ".updateBalancelistState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        String[] codes = pteBalancelistCodes.split(",");
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        for (String pteBalancelistCode : codes) {
            htmlJsonReBean = this.pteBalancelistServiceRepository.updateBalancelistStateByCode(tenantCode, pteBalancelistCode, Integer.valueOf(2), Integer.valueOf(0), null);
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) continue;
            return htmlJsonReBean;
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateBalancelistStateByCancel.json"}, name="\u66f4\u65b0\u7ed3\u7b97\u6d41\u6c34\u72b6\u6001\uff08\u53d6\u6d88\uff09")
    @ResponseBody
    public HtmlJsonReBean updateBalancelistStateByCancel(HttpServletRequest request, String balancelistCode) {
        if (StringUtils.isBlank((String)balancelistCode)) {
            this.logger.error(CODE + ".updateBalancelistState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        return this.pteBalancelistServiceRepository.updateBalancelistStateByCode(tenantCode, balancelistCode, Integer.valueOf(-1), Integer.valueOf(2), null);
    }

    @RequestMapping(value={"updateBalancelistStateByAlready.json"}, name="\u66f4\u65b0\u7ed3\u7b97\u6d41\u6c34\u72b6\u6001\uff08\u5df2\u786e\u5b9a \u5df2\u7ed3\u7b97\uff09")
    @ResponseBody
    public HtmlJsonReBean updateBalancelistStateByAlready(HttpServletRequest request, String balancelistCode) {
        if (StringUtils.isBlank((String)balancelistCode)) {
            this.logger.error(CODE + ".updateBalancelistState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        return this.pteBalancelistServiceRepository.updateBalancelistStateByCode(tenantCode, balancelistCode, Integer.valueOf(1), Integer.valueOf(2), null);
    }
}

