/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.reb.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.reb.domain.RebUpointsDomain;
import com.qjsoft.laser.controller.facade.reb.domain.RebUpointsListReDomain;
import com.qjsoft.laser.controller.facade.reb.domain.RebUpointsReDomain;
import com.qjsoft.laser.controller.facade.reb.repository.RebUpointsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/reb/upoints"}, name="\u7528\u6237\u8fd4\u5229")
public class RebUpointsCon
extends SpringmvcController {
    private static String CODE = "reb.upoints.con";
    @Autowired
    private RebUpointsServiceRepository rebUpointsServiceRepository;

    protected String getContext() {
        return "upoints";
    }

    @RequestMapping(value={"saveUpoints.json"}, name="\u589e\u52a0\u7528\u6237\u8fd4\u5229")
    @ResponseBody
    public HtmlJsonReBean saveUpoints(HttpServletRequest request, String rebUpointsDomainStr) {
        if (StringUtils.isBlank((String)rebUpointsDomainStr)) {
            this.logger.error(CODE + ".saveUpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebUpointsDomain rebUpointsDomain = (RebUpointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebUpointsDomainStr, RebUpointsDomain.class);
        rebUpointsDomain.setTenantCode(this.getTenantCode(request));
        return this.rebUpointsServiceRepository.saveUpoints(rebUpointsDomain);
    }

    @RequestMapping(value={"deductible.json"}, name="\u8fd4\u5229\u62b5\u6263")
    @ResponseBody
    public HtmlJsonReBean deductible(HttpServletRequest request, BigDecimal goodsPmoney) {
        if (null == goodsPmoney || goodsPmoney.compareTo(BigDecimal.ZERO) < 0) {
            this.logger.error(CODE + ".updateUpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        return this.rebUpointsServiceRepository.deductible(goodsPmoney, this.getProappCode(request), userSession.getUserPcode(), "1");
    }

    @RequestMapping(value={"deductibleByUserinfoCode.json"}, name="\u8fd4\u5229\u62b5\u6263(\u901a\u8fc7\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean deductible(HttpServletRequest request, BigDecimal goodsPmoney, String userinfoCode) {
        if (null == goodsPmoney || goodsPmoney.compareTo(BigDecimal.ZERO) < 0 || StringUtils.isBlank((String)userinfoCode)) {
            this.logger.error(CODE + ".updateUpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rebUpointsServiceRepository.deductible(goodsPmoney, this.getProappCode(request), userinfoCode, "1");
    }

    @RequestMapping(value={"getUpoints.json"}, name="\u83b7\u53d6\u7528\u6237\u8fd4\u5229\u4fe1\u606f")
    @ResponseBody
    public RebUpointsReDomain getUpoints(Integer upointsId) {
        if (StringUtils.isBlank((Integer)upointsId)) {
            this.logger.error(CODE + ".getUpoints", (Object)"param is null");
            return null;
        }
        return this.rebUpointsServiceRepository.getUpoints(upointsId);
    }

    @RequestMapping(value={"updateUpoints.json"}, name="\u66f4\u65b0\u7528\u6237\u8fd4\u5229")
    @ResponseBody
    public HtmlJsonReBean updateUpoints(HttpServletRequest request, String rebUpointsDomainStr) {
        if (StringUtils.isBlank((String)rebUpointsDomainStr)) {
            this.logger.error(CODE + ".updateUpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebUpointsDomain rebUpointsDomain = (RebUpointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebUpointsDomainStr, RebUpointsDomain.class);
        rebUpointsDomain.setTenantCode(this.getTenantCode(request));
        return this.rebUpointsServiceRepository.updateUpoints(rebUpointsDomain);
    }

    @RequestMapping(value={"deleteUpoints.json"}, name="\u5220\u9664\u7528\u6237\u8fd4\u5229")
    @ResponseBody
    public HtmlJsonReBean deleteUpoints(Integer upointsId) {
        if (StringUtils.isBlank((Integer)upointsId)) {
            this.logger.error(CODE + ".deleteUpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rebUpointsServiceRepository.deleteUpoints(upointsId);
    }

    @RequestMapping(value={"queryUpointsPage.json"}, name="\u67e5\u8be2\u7528\u6237\u8fd4\u5229\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebUpointsReDomain> queryUpointsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebUpointsServiceRepository.queryUpointsPage(param);
    }

    @RequestMapping(value={"queryUsReBalPage.json"}, name="\u67e5\u8be2\u7528\u6237\u8fd4\u5229\u4f59\u989d\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebUpointsReDomain> queryUsReBalPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebUpointsServiceRepository.queryUpointsPage(param);
    }

    @RequestMapping(value={"queryUsRebateTur.json"}, name="\u67e5\u8be2\u7528\u6237\u8fd4\u5229\u6d41\u6c34")
    @ResponseBody
    public SupQueryResult<RebUpointsListReDomain> queryUsRebateTur(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebUpointsServiceRepository.queryUpointsListPage(param);
    }

    @RequestMapping(value={"updateUpointsState.json"}, name="\u66f4\u65b0\u7528\u6237\u8fd4\u5229\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateUpointsState(String upointsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)upointsId)) {
            this.logger.error(CODE + ".updateUpointsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rebUpointsServiceRepository.updateUpointsState(Integer.valueOf(upointsId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryUpointsPageStr.json"}, name="\u67e5\u8be2\u7528\u6237\u8fd4\u5229\u4f59\u989d\u5206\u9875\u5217\u8868")
    @ResponseBody
    public RebUpointsReDomain queryUpointsPageStr(HttpServletRequest request) {
        SupQueryResult supQueryResult;
        UserSession userSession = this.getUserSession(request);
        String userPcode = userSession.getUserPcode();
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".queryUpointsPageStr", (Object)"userSession is null");
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("memberCode", userPcode);
        param.put("tenantCode", this.getTenantCode(request));
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (supQueryResult = this.rebUpointsServiceRepository.queryUpointsPage(param)) || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            RebUpointsReDomain rebUpointsReDomain = new RebUpointsReDomain();
            rebUpointsReDomain.setUpointsLnum(BigDecimal.ZERO);
            rebUpointsReDomain.setUpointsNum(BigDecimal.ZERO);
            rebUpointsReDomain.setUpointsOnum(BigDecimal.ZERO);
            return rebUpointsReDomain;
        }
        return (RebUpointsReDomain)supQueryResult.getList().get(0);
    }

    @RequestMapping(value={"queryUpointsListPage.json"}, name="\u67e5\u8be2\u7528\u6237\u8fd4\u5229\u6d41\u6c34\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebUpointsListReDomain> queryUpointsListPage(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        String userPcode = userSession.getUserPcode();
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".queryUpointsListPage", (Object)"userSession is null");
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("memberCode", userPcode);
        param.put("tenantCode", this.getTenantCode(request));
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebUpointsServiceRepository.queryUpointsListPage(param);
    }
}

