/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.rs.domain.RsBrandDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsBrandReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsBrandServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/brand"}, name="\u5546\u54c1\u54c1\u724c")
public class RsBrandCon
extends SpringmvcController {
    private static String CODE = "rs.brand.con";
    @Autowired
    private RsBrandServiceRepository rsBrandServiceRepository;

    protected String getContext() {
        return "brand";
    }

    @RequestMapping(value={"saveBrand.json"}, name="\u589e\u52a0\u5546\u54c1\u54c1\u724c")
    @ResponseBody
    public HtmlJsonReBean saveBrand(RsBrandDomain rsBrandDomain) {
        if (null == rsBrandDomain) {
            this.logger.error(CODE + ".saveBrand", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsBrandServiceRepository.saveBrand(rsBrandDomain);
    }

    @RequestMapping(value={"getBrand.json"}, name="\u83b7\u53d6\u5546\u54c1\u54c1\u724c\u4fe1\u606f")
    @ResponseBody
    public RsBrandDomain getBrand(String brandId) {
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.error(CODE + ".getBrand", (Object)"param is null");
            return null;
        }
        return this.rsBrandServiceRepository.getBrand(Integer.valueOf(brandId));
    }

    @RequestMapping(value={"updateBrand.json"}, name="\u7f16\u8f91\u5546\u54c1\u54c1\u724c")
    @ResponseBody
    public HtmlJsonReBean updateBrand(RsBrandDomain rsBrandDomain) {
        if (null == rsBrandDomain) {
            this.logger.error(CODE + ".updateBrand", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsBrandServiceRepository.updateBrand(rsBrandDomain);
    }

    @RequestMapping(value={"deleteBrand.json"}, name="\u5220\u9664\u5546\u54c1\u54c1\u724c")
    @ResponseBody
    public HtmlJsonReBean deleteBrand(String brandId) {
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.error(CODE + ".deleteBrand", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsBrandServiceRepository.deleteBrand(Integer.valueOf(brandId));
    }

    @RequestMapping(value={"queryBrandPage.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPage(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsBrandServiceRepository.queryBrandPage(param);
    }

    @RequestMapping(value={"updateBrandState.json"}, name="\u7f16\u8f91\u5546\u54c1\u54c1\u724c\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateBrandState(String brandId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.error(CODE + ".updateBrandState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsBrandServiceRepository.updateBrandState(Integer.valueOf(brandId), dataState, oldDataState);
    }
}

