/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/sku"}, name="\u5546\u54c1SKU")
public class RsSkuCon
extends SpringmvcController {
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    private static String CODE = "rs.sku.con";

    protected String getContext() {
        return "sku";
    }

    @RequestMapping(value={"saveSku.json"}, name="\u589e\u52a0\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean saveSku(RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".saveSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuServiceRepository.saveSku((RsSkuDomain)rsSkuReDomain);
    }

    @RequestMapping(value={"getBrand.json"}, name="\u83b7\u53d6\u5546\u54c1SKU\u4fe1\u606f")
    @ResponseBody
    public RsSkuReDomain getBrand(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".getBrand", (Object)"param is null");
            return null;
        }
        return this.rsSkuServiceRepository.getSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"updateSku.json"}, name="\u7f16\u8f91\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean updateSku(RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".updateSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuServiceRepository.updateSku((RsSkuDomain)rsSkuReDomain);
    }

    @RequestMapping(value={"deleteSku.json"}, name="\u5220\u9664\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean deleteSku(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".deleteSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuServiceRepository.deleteSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"querySkuPage.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPage(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuServiceRepository.querySkuPage(param);
    }

    @RequestMapping(value={"updateSkuState.json"}, name="\u7f16\u8f91\u5546\u54c1SKU\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateSkuState(String skuId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".updateSkuState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuServiceRepository.updateSkuState(Integer.valueOf(skuId), dataState, oldDataState);
    }
}

